/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.valgrind.ui.editor;

import java.util.Arrays;
import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.IWordDetector;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.rules.WordRule;
import org.eclipse.linuxtools.internal.valgrind.ui.editor.SuppressionsElementScanner;

public class SuppressionToolRule
implements IRule {
    private String[] toolList;
    private IToken token;
    private WordRule subrule;
    private static final IToken DUMMY_TOKEN = new Token(null);
    private static final char[] COLON = new char[]{':'};

    public SuppressionToolRule(String[] tools, IToken successToken) {
        this.toolList = tools;
        this.token = successToken;
        this.subrule = new WordRule(new IWordDetector(){

            public boolean isWordStart(char c) {
                String[] stringArray = SuppressionToolRule.this.toolList;
                int n = SuppressionToolRule.this.toolList.length;
                int n2 = 0;
                while (n2 < n) {
                    String tool = stringArray[n2];
                    if (c == tool.charAt(0)) {
                        return true;
                    }
                    ++n2;
                }
                return false;
            }

            public boolean isWordPart(char c) {
                return c != ':';
            }
        });
        String[] stringArray = this.toolList;
        int n = this.toolList.length;
        int n2 = 0;
        while (n2 < n) {
            String tool = stringArray[n2];
            this.subrule.addWord(tool, DUMMY_TOKEN);
            ++n2;
        }
    }

    public IToken evaluate(ICharacterScanner scanner) {
        IToken result = this.subrule.evaluate(scanner);
        if (!result.isUndefined()) {
            boolean match = true;
            int tokenLength = ((SuppressionsElementScanner)scanner).getTokenLength();
            match = this.checkColon(scanner);
            if (match) {
                int i = 0;
                while (i < tokenLength) {
                    scanner.unread();
                    ++i;
                }
                int indentLength = 0;
                while (scanner.getColumn() > 0) {
                    scanner.unread();
                    ++indentLength;
                }
                while (indentLength-- > 0) {
                    int ch = scanner.read();
                    if (Character.isWhitespace(ch)) continue;
                    match = false;
                }
                int i2 = 0;
                while (i2 < tokenLength) {
                    scanner.read();
                    ++i2;
                }
            }
            if (!match) {
                this.unreadBuffer(scanner, tokenLength);
                result = Token.UNDEFINED;
            } else {
                result = this.token;
            }
        }
        return result;
    }

    private boolean checkColon(ICharacterScanner scanner) {
        int ch = scanner.read();
        if (ch == -1) {
            return false;
        }
        scanner.unread();
        return Arrays.equals(Character.toChars(ch), COLON);
    }

    private void unreadBuffer(ICharacterScanner scanner, int length) {
        int i = 0;
        while (i < length) {
            scanner.unread();
            ++i;
        }
    }
}

