/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.collect;

import java.io.Serializable;
import java.util.NoSuchElementException;
import org.eclipse.mat.collect.IteratorInt;
import org.eclipse.mat.collect.PrimeFinder;

public final class SetInt
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final int BIG_CAPACITY = PrimeFinder.findPrevPrime(0x7FFFFFF8) - 1;
    private int capacity;
    private int step;
    private int limit;
    private int size;
    private boolean[] used;
    private int[] keys;

    public SetInt() {
        this(10);
    }

    public SetInt(int initialCapacity) {
        this.init(initialCapacity);
    }

    public boolean add(int key) {
        if (this.size == this.limit) {
            this.resize(this.capacity <= BIG_CAPACITY >> 1 ? this.capacity << 1 : (this.capacity < BIG_CAPACITY ? BIG_CAPACITY : this.capacity + 1));
        }
        int hash = (key & Integer.MAX_VALUE) % this.capacity;
        while (this.used[hash]) {
            if (this.keys[hash] == key) {
                return false;
            }
            hash = (hash + this.step) % this.capacity;
        }
        this.used[hash] = true;
        this.keys[hash] = key;
        ++this.size;
        return true;
    }

    public boolean remove(int key) {
        int hash = (key & Integer.MAX_VALUE) % this.capacity;
        while (this.used[hash]) {
            if (this.keys[hash] == key) {
                this.used[hash] = false;
                --this.size;
                hash = (hash + this.step) % this.capacity;
                while (this.used[hash]) {
                    key = this.keys[hash];
                    this.used[hash] = false;
                    int newHash = (key & Integer.MAX_VALUE) % this.capacity;
                    while (this.used[newHash]) {
                        newHash = (newHash + this.step) % this.capacity;
                    }
                    this.used[newHash] = true;
                    this.keys[newHash] = key;
                    hash = (hash + this.step) % this.capacity;
                }
                return true;
            }
            hash = (hash + this.step) % this.capacity;
        }
        return false;
    }

    public boolean contains(int key) {
        int hash = (key & Integer.MAX_VALUE) % this.capacity;
        while (this.used[hash]) {
            if (this.keys[hash] == key) {
                return true;
            }
            hash = (hash + this.step) % this.capacity;
        }
        return false;
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public void clear() {
        this.size = 0;
        this.used = new boolean[this.capacity];
    }

    public IteratorInt iterator() {
        return new IteratorInt(){
            int n = 0;
            int i = -1;

            @Override
            public boolean hasNext() {
                return this.n < SetInt.this.size;
            }

            @Override
            public int next() throws NoSuchElementException {
                while (++this.i < SetInt.this.used.length) {
                    if (!SetInt.this.used[this.i]) continue;
                    ++this.n;
                    return SetInt.this.keys[this.i];
                }
                throw new NoSuchElementException();
            }
        };
    }

    public int[] toArray() {
        int[] array = new int[this.size];
        int j = 0;
        int i = 0;
        while (i < this.used.length) {
            if (this.used[i]) {
                array[j++] = this.keys[i];
            }
            ++i;
        }
        return array;
    }

    private void init(int initialCapacity) {
        this.capacity = PrimeFinder.findNextPrime(initialCapacity);
        this.step = Math.max(1, PrimeFinder.findPrevPrime(initialCapacity / 3));
        this.limit = (int)((double)this.capacity * 0.75);
        this.clear();
        this.keys = new int[this.capacity];
    }

    private void resize(int newCapacity) {
        int oldSize = this.size;
        boolean[] oldUsed = this.used;
        int[] oldKeys = this.keys;
        this.keys = null;
        this.capacity = 0;
        this.init(newCapacity);
        int i = 0;
        while (i < oldUsed.length) {
            if (oldUsed[i]) {
                int key = oldKeys[i];
                int hash = (key & Integer.MAX_VALUE) % this.capacity;
                while (this.used[hash]) {
                    hash = (hash + this.step) % this.capacity;
                }
                this.used[hash] = true;
                this.keys[hash] = key;
            }
            ++i;
        }
        this.size = oldSize;
    }
}

