/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.gerrit.ui.factories;

import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.egit.ui.internal.commit.CommitEditor;
import org.eclipse.egit.ui.internal.commit.RepositoryCommit;
import org.eclipse.mylyn.internal.gerrit.core.client.compat.ChangeDetailX;
import org.eclipse.mylyn.internal.gerrit.core.egit.GerritToGitMapping;
import org.eclipse.mylyn.internal.gerrit.ui.editor.FetchPatchSetJob;
import org.eclipse.mylyn.internal.gerrit.ui.factories.AbstractPatchSetUiFactory;
import org.eclipse.mylyn.internal.gerrit.ui.factories.Messages;
import org.eclipse.mylyn.reviews.core.model.IReviewItemSet;
import org.eclipse.mylyn.reviews.ui.spi.factories.IUiContext;
import org.eclipse.swt.widgets.Display;

public class OpenCommitUiFactory
extends AbstractPatchSetUiFactory {
    public OpenCommitUiFactory(IUiContext context, IReviewItemSet set) {
        super(Messages.OpenCommitUiFactory_Open_Commit, context, set);
    }

    public void execute() {
        GerritToGitMapping mapping = this.getGitRepository(true);
        if (mapping != null) {
            final FetchPatchSetJob job = new FetchPatchSetJob(Messages.OpenCommitUiFactory_Opening_Commit_Viewer, mapping.getRepository(), mapping.getRemote(), this.getPatchSetDetail().getPatchSet());
            job.schedule();
            job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                public void done(IJobChangeEvent event) {
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            CommitEditor.openQuiet((RepositoryCommit)job.getCommit());
                        }
                    });
                }
            });
        }
    }

    public boolean isExecutable() {
        ChangeDetailX changeDetail = this.getChange().getChangeDetail();
        return changeDetail != null && changeDetail.getPatchSets().size() > 1;
    }
}

