/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.layer.event;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.eclipse.nebula.widgets.nattable.coordinate.Range;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.event.ColumnStructuralChangeEvent;
import org.eclipse.nebula.widgets.nattable.layer.event.StructuralDiff;

public class ColumnInsertEvent
extends ColumnStructuralChangeEvent {
    public ColumnInsertEvent(ILayer layer, int columnPosition) {
        this(layer, new Range(columnPosition, columnPosition + 1));
    }

    public ColumnInsertEvent(ILayer layer, Range ... columnPositionRanges) {
        this(layer, Arrays.asList(columnPositionRanges));
    }

    public ColumnInsertEvent(ILayer layer, Collection<Range> columnPositionRanges) {
        super(layer, columnPositionRanges);
    }

    protected ColumnInsertEvent(ColumnStructuralChangeEvent event) {
        super(event);
    }

    @Override
    public Collection<StructuralDiff> getColumnDiffs() {
        ArrayList<StructuralDiff> columnDiffs = new ArrayList<StructuralDiff>();
        for (Range range : this.getColumnPositionRanges()) {
            columnDiffs.add(new StructuralDiff(StructuralDiff.DiffTypeEnum.ADD, new Range(range.start, range.start), range));
        }
        return columnDiffs;
    }

    @Override
    public ColumnInsertEvent cloneEvent() {
        return new ColumnInsertEvent(this);
    }
}

