/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.library.string;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.library.AbstractSimpleTernaryOperation;
import org.eclipse.ocl.pivot.messages.PivotMessages;
import org.eclipse.ocl.pivot.utilities.StringUtil;
import org.eclipse.ocl.pivot.values.InvalidValueException;

public class StringSubstringOperation
extends AbstractSimpleTernaryOperation {
    public static final @NonNull StringSubstringOperation INSTANCE = new StringSubstringOperation();

    @Override
    public @NonNull String evaluate(@Nullable Object sourceValue, @Nullable Object firstArgumentValue, @Nullable Object secondArgumentValue) {
        String sourceString = StringSubstringOperation.asString(sourceValue);
        Integer startInteger = StringSubstringOperation.asInteger(firstArgumentValue);
        Integer endInteger = StringSubstringOperation.asInteger(secondArgumentValue);
        int size = sourceString.length();
        int lower = startInteger;
        int upper = endInteger;
        if (lower > 0 && lower <= upper && upper <= size) {
            @NonNull String result = sourceString.substring(lower - 1, upper);
            return result;
        }
        throw new InvalidValueException(StringUtil.bind(PivotMessages.IndexesOutOfRange, lower, upper, size), new Object[0]);
    }
}

