/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core.util;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.xml.parsers.FactoryConfigurationError;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.text.Document;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.HostSpecification;
import org.eclipse.pde.core.plugin.IPluginLibrary;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.pde.internal.core.FeatureModelManager;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.ibundle.IBundle;
import org.eclipse.pde.internal.core.ibundle.IBundleModel;
import org.eclipse.pde.internal.core.ibundle.IBundlePluginModelBase;
import org.eclipse.pde.internal.core.ifeature.IFeatureModel;
import org.eclipse.pde.internal.core.ifeature.IFeaturePlugin;

public class CoreUtility {
    public static void readFile(InputStream in, File file) throws IOException {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (FileOutputStream fos = new FileOutputStream(file);){
                byte[] buffer = new byte[1024];
                try {
                    int count;
                    while ((count = in.read(buffer, 0, buffer.length)) > 0) {
                        fos.write(buffer, 0, count);
                    }
                }
                finally {
                    in.close();
                    in = null;
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            PDECore.logException(e);
            throw e;
        }
    }

    public static void addNatureToProject(IProject proj, String natureId, IProgressMonitor monitor) throws CoreException {
        IProjectDescription description = proj.getDescription();
        String[] prevNatures = description.getNatureIds();
        String[] newNatures = new String[prevNatures.length + 1];
        System.arraycopy(prevNatures, 0, newNatures, 0, prevNatures.length);
        newNatures[prevNatures.length] = natureId;
        description.setNatureIds(newNatures);
        proj.setDescription(description, monitor);
    }

    public static void createFolder(IFolder folder) throws CoreException {
        if (!folder.exists()) {
            IContainer parent = folder.getParent();
            if (parent instanceof IFolder) {
                CoreUtility.createFolder((IFolder)parent);
            }
            folder.create(true, true, null);
        }
    }

    public static void createProject(IProject project, IPath location, IProgressMonitor monitor) throws CoreException {
        if (!Platform.getLocation().equals((Object)location)) {
            IProjectDescription desc = project.getWorkspace().newProjectDescription(project.getName());
            desc.setLocation(location);
            project.create(desc, monitor);
        } else {
            project.create(monitor);
        }
    }

    public static String normalize(String text) {
        if (text == null || text.trim().length() == 0) {
            return "";
        }
        text = text.replaceAll("\\r|\\n|\\f|\\t", " ");
        return text;
    }

    public static void deleteContent(File fileToDelete) {
        CoreUtility.deleteContent(fileToDelete, null);
    }

    public static void deleteContent(File fileToDelete, IProgressMonitor monitor) {
        if (fileToDelete.exists()) {
            File[] children;
            SubMonitor subMon = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
            if (fileToDelete.isDirectory() && (children = fileToDelete.listFiles()) != null && children.length > 0) {
                SubMonitor childMon = SubMonitor.convert((IProgressMonitor)subMon.split(90), (int)children.length);
                File[] fileArray = children;
                int n = children.length;
                int n2 = 0;
                while (n2 < n) {
                    File element = fileArray[n2];
                    CoreUtility.deleteContent(element, (IProgressMonitor)childMon.split(1));
                    ++n2;
                }
            }
            fileToDelete.delete();
            subMon.done();
        }
    }

    public static boolean guessUnpack(BundleDescription bundle) {
        IFeatureModel[] models;
        IBundle b;
        String header;
        IBundleModel bundleModel;
        IPluginModelBase model;
        if (bundle == null) {
            return true;
        }
        if (new File(bundle.getLocation()).isFile()) {
            return false;
        }
        HostSpecification host = bundle.getHost();
        if (host != null && host.getName().equals("org.eclipse.equinox.launcher")) {
            return true;
        }
        IWorkspaceRoot root = PDECore.getWorkspace().getRoot();
        IContainer container = root.getContainerForLocation((IPath)new Path(bundle.getLocation()));
        if (container == null) {
            return true;
        }
        if (container instanceof IProject) {
            try {
                if (!((IProject)container).hasNature("org.eclipse.jdt.core.javanature")) {
                    return true;
                }
            }
            catch (CoreException e) {
                PDECore.logException(e);
            }
        }
        if ((model = PluginRegistry.findModel(bundle)) == null) {
            return true;
        }
        if (model instanceof IBundlePluginModelBase && (bundleModel = ((IBundlePluginModelBase)model).getBundleModel()) != null && (header = (b = bundleModel.getBundle()).getHeader("Eclipse-BundleShape")) != null) {
            return "dir".equals(header);
        }
        FeatureModelManager manager = PDECore.getDefault().getFeatureModelManager();
        IFeatureModel[] iFeatureModelArray = models = manager.getModels();
        int n = models.length;
        int n2 = 0;
        while (n2 < n) {
            IFeaturePlugin[] plugins;
            IFeatureModel featureModel = iFeatureModelArray[n2];
            IFeaturePlugin[] iFeaturePluginArray = plugins = featureModel.getFeature().getPlugins();
            int n3 = plugins.length;
            int n4 = 0;
            while (n4 < n3) {
                IFeaturePlugin featurePlugin = iFeaturePluginArray[n4];
                if (featurePlugin.getId().equals(bundle.getSymbolicName())) {
                    return featurePlugin.isUnpack();
                }
                ++n4;
            }
            ++n2;
        }
        IPluginLibrary[] libraries = model.getPluginBase().getLibraries();
        if (libraries.length == 0) {
            return false;
        }
        IPluginLibrary[] iPluginLibraryArray = libraries;
        int n5 = libraries.length;
        n = 0;
        while (n < n5) {
            IPluginLibrary library = iPluginLibraryArray[n];
            if (library.getName().equals(".")) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public static boolean jarContainsResource(File file, String resource, boolean directory) {
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (ZipFile jarFile = new ZipFile(file, 1);){
                ZipEntry resourceEntry = jarFile.getEntry(resource);
                if (resourceEntry != null) {
                    boolean bl = directory ? resourceEntry.isDirectory() : true;
                    return bl;
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException | FactoryConfigurationError e) {
            PDECore.logException(e);
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void copyFile(IPath originPath, String name, File target) {
        File source = new File(originPath.toFile(), name);
        if (!source.exists()) {
            return;
        }
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try {
                FileInputStream is = new FileInputStream(source);
                try {
                    try (FileOutputStream os = new FileOutputStream(target);){
                        byte[] buf = new byte[1024];
                        int len = is.read(buf);
                        while (len != -1) {
                            os.write(buf, 0, len);
                            len = is.read(buf);
                        }
                    }
                    if (is == null) return;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (is == null) throw throwable;
                    is.close();
                    throw throwable;
                }
                is.close();
                return;
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                } else {
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            PDECore.logException(e);
        }
    }

    public static Document getTextDocument(File bundleLocation, String path) {
        ZipFile jarFile = null;
        InputStream stream = null;
        try {
            String extension = new Path(bundleLocation.getName()).getFileExtension();
            if ("jar".equals(extension) && bundleLocation.isFile()) {
                jarFile = new ZipFile(bundleLocation, 1);
                ZipEntry manifestEntry = jarFile.getEntry(path);
                if (manifestEntry != null) {
                    stream = jarFile.getInputStream(manifestEntry);
                }
            } else {
                File file = new File(bundleLocation, path);
                if (file.exists()) {
                    stream = new FileInputStream(file);
                }
            }
            Document document = CoreUtility.getTextDocument(stream);
            return document;
        }
        catch (IOException e) {
            PDECore.logException(e);
        }
        finally {
            try {
                if (jarFile != null) {
                    jarFile.close();
                }
                if (stream != null) {
                    stream.close();
                }
            }
            catch (IOException e) {
                PDECore.logException(e);
            }
        }
        return null;
    }

    public static Document getTextDocument(InputStream in) {
        String result = null;
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (ByteArrayOutputStream output = new ByteArrayOutputStream();){
                int count;
                byte[] buffer = new byte[1024];
                while ((count = in.read(buffer, 0, buffer.length)) > 0) {
                    output.write(buffer, 0, count);
                }
                result = output.toString("UTF-8");
                in.close();
                in = null;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException iOException) {
            try {
                in.close();
            }
            catch (IOException ee) {
                PDECore.logException(ee);
            }
        }
        return result == null ? null : new Document(result);
    }
}

