/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.photran.internal.core.analysis.loops;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.photran.internal.core.analysis.binding.ScopingNode;
import org.eclipse.photran.internal.core.analysis.loops.ASTProperLoopConstructNode;
import org.eclipse.photran.internal.core.analysis.loops.ASTVisitorWithLoops;
import org.eclipse.photran.internal.core.parser.ASTDoConstructNode;
import org.eclipse.photran.internal.core.parser.ASTEndDoStmtNode;
import org.eclipse.photran.internal.core.parser.ASTLabelDoStmtNode;
import org.eclipse.photran.internal.core.parser.ASTVisitor;
import org.eclipse.photran.internal.core.parser.IASTNode;
import org.eclipse.photran.internal.core.parser.IActionStmt;
import org.eclipse.photran.internal.core.parser.IExecutableConstruct;
import org.eclipse.photran.internal.core.parser.IExecutionPartConstruct;
import org.eclipse.photran.internal.core.parser.IObsoleteActionStmt;

public class LoopReplacer {
    private List<ASTDoConstructNode> queue = new LinkedList<ASTDoConstructNode>();

    public static void replaceAllLoopsIn(ScopingNode scope) {
        new LoopReplacer().replaceLoopsFromLastToFirstIn(scope);
    }

    private void replaceLoopsFromLastToFirstIn(ScopingNode scope) {
        this.collectLoopsIn(scope);
        while (!this.queue.isEmpty()) {
            this.replaceLoop(this.queue.remove(0));
        }
    }

    private void collectLoopsIn(ScopingNode scope) {
        scope.accept(new ASTVisitor(){

            @Override
            public void visitASTDoConstructNode(ASTDoConstructNode node) {
                LoopReplacer.this.queue.add(0, node);
            }
        });
    }

    private void replaceLoop(ASTDoConstructNode loopToReplace) {
        IASTNode oldParent = loopToReplace.getParent();
        ScopingNode scope = loopToReplace.findNearestAncestor(ScopingNode.class);
        ASTProperLoopConstructNode newLoop = this.buildASTProperLoopConstructNode(loopToReplace, scope);
        loopToReplace.replaceWith(newLoop);
        newLoop.setParent(oldParent);
    }

    private ASTProperLoopConstructNode buildASTProperLoopConstructNode(ASTDoConstructNode loopToReplace, ScopingNode scope) {
        ASTLabelDoStmtNode lastLoopHeader = loopToReplace.getLabelDoStmt();
        ASTProperLoopConstructBuilder nodeBuilder = new ASTProperLoopConstructBuilder(lastLoopHeader);
        scope.accept(nodeBuilder);
        lastLoopHeader.removeFromTree();
        nodeBuilder.result.setLoopHeader(lastLoopHeader);
        return nodeBuilder.result;
    }

    private class ASTProperLoopConstructBuilder
    extends ASTVisitorWithLoops {
        private final ASTProperLoopConstructNode result = new ASTProperLoopConstructNode();
        private final ASTLabelDoStmtNode loopHeader;
        private final IASTNode doConstructNode;
        private final IASTNode listEnclosingDoConstructNode;
        private boolean loopHeaderFound = false;
        private IASTNode oldStyleEndLoopRef = null;

        public ASTProperLoopConstructBuilder(ASTLabelDoStmtNode loopHeader) {
            this.loopHeader = loopHeader;
            this.doConstructNode = loopHeader.getParent();
            this.listEnclosingDoConstructNode = this.doConstructNode.getParent();
            this.oldStyleEndLoopRef = null;
        }

        @Override
        public void visitASTLabelDoStmtNode(ASTLabelDoStmtNode node) {
            if (node == this.loopHeader) {
                this.loopHeaderFound = true;
            }
            this.traverseChildren(node);
        }

        @Override
        public void visitIExecutionPartConstruct(IExecutionPartConstruct node) {
            if (this.shouldBeInLoopBody(node)) {
                node.removeFromTree();
                this.result.getBody().add(node);
            }
        }

        @Override
        public void visitIExecutableConstruct(IExecutableConstruct node) {
            this.visitIExecutionPartConstruct(node);
        }

        @Override
        public void visitIActionStmt(IActionStmt node) {
            this.visitIExecutionPartConstruct(node);
            if (this.isOldStyleDoLoopEnd(node)) {
                this.result.setEndDoStmt(null);
                this.oldStyleEndLoopRef = node;
            }
        }

        @Override
        public void visitIObsoleteActionStmt(IObsoleteActionStmt node) {
            this.visitIExecutionPartConstruct(node);
        }

        private boolean shouldBeInLoopBody(IExecutionPartConstruct node) {
            return this.loopHeaderFound && !this.endDoStmtFound() && !this.oldStyleEndLoopFound() && !this.isLoopHeader(node) && this.isCurrentlySiblingOfLoopHeader(node);
        }

        private boolean isOldStyleDoLoopEnd(IActionStmt node) {
            if (node.getLabel() != null && this.loopHeader.getLblRef() != null) {
                return this.loopHeaderFound && !this.endDoStmtFound() && node.getParent() != this.listEnclosingDoConstructNode && this.loopHeader.getLblRef().getLabel().getText().equals(node.getLabel().getText());
            }
            return false;
        }

        private boolean isCurrentlySiblingOfLoopHeader(IExecutionPartConstruct node) {
            return node.getParent() == this.listEnclosingDoConstructNode;
        }

        private boolean isLoopHeader(IExecutionPartConstruct node) {
            return node == this.loopHeader || node == this.doConstructNode;
        }

        @Override
        public void visitASTEndDoStmtNode(ASTEndDoStmtNode node) {
            if (this.loopHeaderFound && !this.endDoStmtFound() && node.getParent() == this.listEnclosingDoConstructNode && !this.oldStyleEndLoopFound()) {
                node.removeFromTree();
                this.result.setEndDoStmt(node);
            }
            this.traverseChildren(node);
        }

        private boolean endDoStmtFound() {
            return this.result.getEndDoStmt() != null;
        }

        private boolean oldStyleEndLoopFound() {
            return this.oldStyleEndLoopRef != null;
        }

        @Override
        public void visitASTProperLoopConstructNode(ASTProperLoopConstructNode node) {
            if (node.getLoopHeader().getLblRef() == null) {
                return;
            }
            if (this.loopHeader.getLblRef() == null) {
                return;
            }
            String nodeLabel = node.getLoopHeader().getLblRef().getLabel().getText();
            String headerLabel = this.loopHeader.getLblRef().getLabel().getText();
            if (!this.endDoStmtFound() && !this.oldStyleEndLoopFound() && nodeLabel.equals(headerLabel)) {
                this.visitIExecutionPartConstruct(node);
                this.oldStyleEndLoopRef = node.getLoopHeader().getLblRef();
            }
        }
    }
}

