/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.photran.internal.core.refactoring;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.photran.internal.core.analysis.loops.ASTProperLoopConstructNode;
import org.eclipse.photran.internal.core.analysis.loops.LoopReplacer;
import org.eclipse.photran.internal.core.lexer.Token;
import org.eclipse.photran.internal.core.parser.ASTIntConstNode;
import org.eclipse.photran.internal.core.parser.ASTLoopControlNode;
import org.eclipse.photran.internal.core.parser.IExpr;
import org.eclipse.photran.internal.core.refactoring.Messages;
import org.eclipse.photran.internal.core.refactoring.infrastructure.FortranEditorRefactoring;
import org.eclipse.photran.internal.core.reindenter.Reindenter;
import org.eclipse.photran.internal.core.vpg.PhotranVPG;
import org.eclipse.photran.internal.core.vpg.refactoring.VPGRefactoring;

public class ReverseLoopRefactoring
extends FortranEditorRefactoring {
    private ASTProperLoopConstructNode doLoop = null;

    @Override
    protected void doCheckInitialConditions(RefactoringStatus status, IProgressMonitor pm) throws VPGRefactoring.PreconditionFailure {
        this.ensureProjectHasRefactoringEnabled(status);
        LoopReplacer.replaceAllLoopsIn(this.astOfFileInEditor.getRoot());
        this.doLoop = ReverseLoopRefactoring.getLoopNode(this.astOfFileInEditor, this.selectedRegionInEditor);
        if (this.doLoop == null) {
            this.fail(Messages.ReverseLoopRefactoring_SelectDoLoop);
        }
    }

    @Override
    protected void doCheckFinalConditions(RefactoringStatus status, IProgressMonitor pm) throws VPGRefactoring.PreconditionFailure {
    }

    @Override
    protected void doCreateChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        this.changeDoLoopHeader();
        Reindenter.reindent(this.doLoop, this.astOfFileInEditor, Reindenter.Strategy.REINDENT_EACH_LINE);
        this.addChangeFromModifiedAST(this.fileInEditor, pm);
        ((PhotranVPG)this.vpg).releaseAST(this.fileInEditor);
    }

    private void changeDoLoopHeader() {
        ASTLoopControlNode doLoopControlNode = this.doLoop.getLoopHeader().getLoopControl();
        IExpr low = doLoopControlNode.getLb();
        IExpr high = doLoopControlNode.getUb();
        IExpr step = doLoopControlNode.getStep();
        doLoopControlNode.setUb(low);
        doLoopControlNode.setLb(high);
        doLoopControlNode.setStep(this.updateStep(step));
    }

    protected ASTIntConstNode updateStep(IExpr step) {
        if (step == null) {
            ASTIntConstNode i = new ASTIntConstNode();
            i.setIntConst(new Token(null, ",-1"));
            return i;
        }
        ASTIntConstNode j = new ASTIntConstNode();
        j.setIntConst(new Token(null, "-(" + step.toString() + ")"));
        return j;
    }

    @Override
    public String getName() {
        return Messages.ReverseLoopRefactoring_Name;
    }
}

