/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.eclipse.condition;

import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.reddeer.common.condition.AbstractWaitCondition;
import org.eclipse.reddeer.common.exception.RedDeerException;
import org.eclipse.reddeer.eclipse.rse.ui.view.System;
import org.eclipse.reddeer.eclipse.rse.ui.view.SystemViewPart;

public class RemoteSystemExists
extends AbstractWaitCondition {
    private String name;
    private SystemViewPart view;
    private System resultSystem;

    public RemoteSystemExists(String name) {
        this.name = name;
        this.view = new SystemViewPart();
    }

    public boolean test() {
        try {
            this.resultSystem = this.view.getSystem(this.name);
            return true;
        }
        catch (RedDeerException redDeerException) {
            return false;
        }
    }

    public String description() {
        return "there is remote system with name: " + this.name;
    }

    public String errorMessageWhile() {
        return "system with name: '" + this.name + "' has been found.";
    }

    public String errorMessageUntil() {
        List systems = this.view.getSystems().stream().map(it -> it.getLabel()).collect(Collectors.toList());
        return "system with name: '" + this.name + "' has not been found. Existing systems: " + systems.toString();
    }

    public System getResult() {
        return this.resultSystem;
    }
}

