/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.search.internal.ui.util;

import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.search.internal.ui.SearchMessages;
import org.eclipse.search.internal.ui.SearchPlugin;
import org.eclipse.swt.widgets.Shell;

public class ExceptionHandler {
    private static ExceptionHandler fgInstance = new ExceptionHandler();

    public static void log(Throwable t, String message) {
        SearchPlugin.log((IStatus)new Status(4, "org.eclipse.search", 4, message, t));
    }

    public static void handle(CoreException e, String title, String message) {
        ExceptionHandler.handle(e, SearchPlugin.getActiveWorkbenchShell(), title, message);
    }

    public static void handle(CoreException e, Shell parent, String title, String message) {
        fgInstance.perform(e, parent, title, message);
    }

    public static void handle(InvocationTargetException e, String title, String message) {
        ExceptionHandler.handle(e, SearchPlugin.getActiveWorkbenchShell(), title, message);
    }

    public static void handle(InvocationTargetException e, Shell parent, String title, String message) {
        fgInstance.perform(e, parent, title, message);
    }

    protected void perform(CoreException e, Shell shell, String title, String message) {
        SearchPlugin.log((Throwable)e);
        IStatus status = e.getStatus();
        if (status != null) {
            ErrorDialog.openError((Shell)shell, (String)title, (String)message, (IStatus)status);
        } else {
            this.displayMessageDialog(e.getMessage(), shell, title, message);
        }
    }

    protected void perform(InvocationTargetException e, Shell shell, String title, String message) {
        Throwable target = e.getTargetException();
        if (target instanceof CoreException) {
            this.perform((CoreException)target, shell, title, message);
        } else {
            SearchPlugin.log(e);
            if (e.getMessage() != null && !e.getMessage().isEmpty()) {
                this.displayMessageDialog(e.getMessage(), shell, title, message);
            } else {
                this.displayMessageDialog(target.getMessage(), shell, title, message);
            }
        }
    }

    public static void displayMessageDialog(Throwable t, Shell shell, String title, String message) {
        fgInstance.displayMessageDialog(t.getMessage(), shell, title, message);
    }

    public static void displayMessageDialog(Throwable t, String title, String message) {
        ExceptionHandler.displayMessageDialog(t, SearchPlugin.getActiveWorkbenchShell(), title, message);
    }

    private void displayMessageDialog(String exceptionMessage, Shell shell, String title, String message) {
        StringWriter msg = new StringWriter();
        if (message != null) {
            msg.write(message);
            msg.write("\n\n");
        }
        if (exceptionMessage == null || exceptionMessage.isEmpty()) {
            msg.write(SearchMessages.ExceptionDialog_seeErrorLogMessage);
        } else {
            msg.write(exceptionMessage);
        }
        MessageDialog.openError((Shell)shell, (String)title, (String)msg.toString());
    }
}

