/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.sequence.business.internal.operation;

import com.google.common.collect.Iterables;
import java.util.ArrayList;
import org.eclipse.gmf.runtime.notation.Anchor;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.IdentityAnchor;
import org.eclipse.gmf.runtime.notation.NotationFactory;
import org.eclipse.gmf.runtime.notation.RelativeBendpoints;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.gmf.runtime.notation.datatype.RelativeBendpoint;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.ISequenceElementAccessor;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.Message;
import org.eclipse.sirius.diagram.sequence.util.Range;
import org.eclipse.sirius.ext.base.Option;

public class SequenceMessageRangeHelper {
    private static final String TOP_CENTER_TERMINAL = "(0.5, 0.0)";

    public void setMessageRangeForNormalMessage(Edge edge, Range range, int sourceTop, int targetTop) {
        this.resetAnchors(edge);
        RelativeBendpoints bendpoints = (RelativeBendpoints)edge.getBendpoints();
        int[] sourceX = this.getSourceX(bendpoints);
        int[] targetX = this.getTargetX(bendpoints);
        assert (sourceX != null && sourceX.length == 2);
        assert (targetX != null && targetX.length == 2);
        int sourceDeltaY = range.getLowerBound() - sourceTop;
        int targetDeltaY = range.getLowerBound() - targetTop;
        ArrayList<RelativeBendpoint> newBendpoints = new ArrayList<RelativeBendpoint>();
        newBendpoints.add(new RelativeBendpoint(sourceX[0], sourceDeltaY, targetX[0], targetDeltaY));
        newBendpoints.add(new RelativeBendpoint(sourceX[1], sourceDeltaY, targetX[1], targetDeltaY));
        bendpoints.setPoints(newBendpoints);
    }

    public void setMessageRangeForMessageToSelf(Edge edge, Range range, int sourceTop, int targetTop) {
        this.resetAnchors(edge);
        RelativeBendpoints bendpoints = (RelativeBendpoints)edge.getBendpoints();
        if (bendpoints.getPoints().size() == 2) {
            ArrayList<RelativeBendpoint> newBendpoints = new ArrayList<RelativeBendpoint>();
            RelativeBendpoint firstRB = (RelativeBendpoint)bendpoints.getPoints().get(0);
            RelativeBendpoint secondRB = (RelativeBendpoint)bendpoints.getPoints().get(1);
            newBendpoints.add(firstRB);
            int hGap = 30;
            Option<Message> msg = ISequenceElementAccessor.getMessage((View)edge);
            if (msg.some()) {
                hGap = ((Message)msg.get()).getReflexiveMessageWidth();
            }
            newBendpoints.add(new RelativeBendpoint(firstRB.getSourceX() + hGap, firstRB.getSourceY(), firstRB.getTargetX() + hGap, firstRB.getTargetY()));
            newBendpoints.add(new RelativeBendpoint(firstRB.getSourceX() + hGap, secondRB.getSourceY(), firstRB.getTargetX() + hGap, secondRB.getTargetY()));
            newBendpoints.add(secondRB);
            bendpoints.setPoints(newBendpoints);
        }
        int[] sourceX = this.getSourceX(bendpoints);
        int[] targetX = this.getTargetX(bendpoints);
        assert (sourceX != null && sourceX.length == 4);
        assert (targetX != null && targetX.length == 4);
        int topSourceDeltaY = range.getLowerBound() - sourceTop;
        int topTargetDeltaY = range.getLowerBound() - targetTop;
        int bottomSourceDeltaY = range.getUpperBound() - sourceTop;
        int bottomTargetDeltaY = range.getUpperBound() - targetTop;
        ArrayList<RelativeBendpoint> newBendpoints = new ArrayList<RelativeBendpoint>();
        newBendpoints.add(new RelativeBendpoint(sourceX[0], topSourceDeltaY, targetX[0], topTargetDeltaY));
        newBendpoints.add(new RelativeBendpoint(sourceX[1], topSourceDeltaY, targetX[0], topTargetDeltaY));
        newBendpoints.add(new RelativeBendpoint(sourceX[2], bottomSourceDeltaY, targetX[0], bottomTargetDeltaY));
        newBendpoints.add(new RelativeBendpoint(sourceX[3], bottomSourceDeltaY, targetX[0], bottomTargetDeltaY));
        bendpoints.setPoints(newBendpoints);
    }

    private int[] getSourceX(RelativeBendpoints bendpoints) {
        int[] sourceXs = new int[bendpoints.getPoints().size()];
        int i = 0;
        for (RelativeBendpoint rb : Iterables.filter((Iterable)bendpoints.getPoints(), RelativeBendpoint.class)) {
            sourceXs[i] = rb.getSourceX();
            ++i;
        }
        return sourceXs;
    }

    private int[] getTargetX(RelativeBendpoints bendpoints) {
        int[] targetXs = new int[bendpoints.getPoints().size()];
        int i = 0;
        for (RelativeBendpoint rb : Iterables.filter((Iterable)bendpoints.getPoints(), RelativeBendpoint.class)) {
            targetXs[i] = rb.getTargetX();
            ++i;
        }
        return targetXs;
    }

    private void resetAnchors(Edge edge) {
        edge.setSourceAnchor((Anchor)this.createCanonicalAnchor());
        edge.setTargetAnchor((Anchor)this.createCanonicalAnchor());
    }

    private IdentityAnchor createCanonicalAnchor() {
        IdentityAnchor anchor = NotationFactory.eINSTANCE.createIdentityAnchor();
        anchor.setId(TOP_CENTER_TERMINAL);
        return anchor;
    }
}

