/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.business.api.query;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.Collection;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.sirius.diagram.description.DiagramElementMapping;
import org.eclipse.sirius.diagram.description.filter.CompositeFilterDescription;
import org.eclipse.sirius.diagram.description.filter.Filter;
import org.eclipse.sirius.diagram.description.filter.FilterKind;
import org.eclipse.sirius.diagram.description.filter.MappingFilter;

public class CompositeFilterDescriptionQuery {
    private CompositeFilterDescription composite;

    public CompositeFilterDescriptionQuery(CompositeFilterDescription filterDescription) {
        this.composite = filterDescription;
    }

    public boolean isCollapseCompositeFilter() {
        return this.hasFilter(FilterKind.COLLAPSE_LITERAL);
    }

    public boolean isHideCompositeFilter() {
        return this.hasFilter(FilterKind.HIDE_LITERAL);
    }

    public Collection<Filter> getCollapseFilters() {
        return this.getFilters(FilterKind.COLLAPSE_LITERAL);
    }

    public Collection<Filter> getHideFilters() {
        return this.getFilters(FilterKind.HIDE_LITERAL);
    }

    private boolean hasFilter(FilterKind filterKind) {
        return Iterables.any(this.composite.getFilters(), (Predicate)new FilterKindPredicate(filterKind));
    }

    private Collection<Filter> getFilters(FilterKind filterKind) {
        return Lists.newArrayList((Iterable)Iterables.filter(this.composite.getFilters(), (Predicate)new FilterKindPredicate(filterKind)));
    }

    public EList<DiagramElementMapping> getHiddenMappings() {
        BasicEList result = new BasicEList();
        for (Filter filter : this.getHideFilters()) {
            if (!(filter instanceof MappingFilter)) continue;
            result.addAll(((MappingFilter)filter).getMappings());
        }
        return result;
    }

    private static class FilterKindPredicate
    implements Predicate<Filter> {
        private FilterKind filterKind;

        FilterKindPredicate(FilterKind filterKind) {
            this.filterKind = filterKind;
        }

        public boolean apply(Filter input) {
            return input.getFilterKind() == this.filterKind;
        }
    }
}

