/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.processes.core.model.steps;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.tcf.protocol.IChannel;
import org.eclipse.tcf.protocol.IToken;
import org.eclipse.tcf.protocol.Protocol;
import org.eclipse.tcf.services.IProcesses;
import org.eclipse.tcf.te.runtime.callback.AsyncCallbackCollector;
import org.eclipse.tcf.te.runtime.callback.Callback;
import org.eclipse.tcf.te.runtime.interfaces.callback.ICallback;
import org.eclipse.tcf.te.runtime.interfaces.properties.IPropertiesContainer;
import org.eclipse.tcf.te.runtime.model.interfaces.IModelNode;
import org.eclipse.tcf.te.runtime.properties.PropertiesContainer;
import org.eclipse.tcf.te.runtime.services.ServiceManager;
import org.eclipse.tcf.te.runtime.services.interfaces.IDebugService;
import org.eclipse.tcf.te.runtime.statushandler.StatusHandlerManager;
import org.eclipse.tcf.te.runtime.statushandler.interfaces.IStatusHandler;
import org.eclipse.tcf.te.tcf.core.Tcf;
import org.eclipse.tcf.te.tcf.core.async.CallbackInvocationDelegate;
import org.eclipse.tcf.te.tcf.core.interfaces.IChannelManager;
import org.eclipse.tcf.te.tcf.core.model.interfaces.IModel;
import org.eclipse.tcf.te.tcf.core.model.interfaces.services.IModelRefreshService;
import org.eclipse.tcf.te.tcf.locator.interfaces.nodes.IPeerNode;
import org.eclipse.tcf.te.tcf.processes.core.activator.CoreBundleActivator;
import org.eclipse.tcf.te.tcf.processes.core.interfaces.IContextHelpIds;
import org.eclipse.tcf.te.tcf.processes.core.model.interfaces.IProcessContextNode;
import org.eclipse.tcf.te.tcf.processes.core.nls.Messages;

public class AttachStep {
    public void executeAttach(final IPeerNode peerNode, IProcessContextNode[] nodes, final ICallback callback) {
        Assert.isTrue((boolean)Protocol.isDispatchThread(), (String)"Illegal Thread Access");
        Assert.isNotNull((Object)peerNode);
        Assert.isNotNull((Object)nodes);
        final ArrayList<IProcessContextNode> nodesToAttach = new ArrayList<IProcessContextNode>();
        IProcessContextNode[] iProcessContextNodeArray = nodes;
        int n = nodes.length;
        int n2 = 0;
        while (n2 < n) {
            IProcessContextNode node = iProcessContextNodeArray[n2];
            IPeerNode parentPeerModel = (IPeerNode)node.getAdapter(IPeerNode.class);
            if (peerNode.equals(parentPeerModel) && node.getProcessContext() != null && !node.getProcessContext().isAttached() && !nodesToAttach.contains(node)) {
                nodesToAttach.add(node);
            }
            ++n2;
        }
        if (!nodesToAttach.isEmpty()) {
            IDebugService dbgService = (IDebugService)ServiceManager.getInstance().getService((Object)peerNode, IDebugService.class, false);
            if (dbgService != null) {
                dbgService.attach((Object)peerNode, (IPropertiesContainer)new PropertiesContainer(), null, (ICallback)new Callback(){

                    protected void internalDone(Object caller, IStatus status) {
                        callback.setProperty("launch", this.getProperty("launch"));
                        Runnable runnable = new Runnable(){

                            @Override
                            public void run() {
                                AttachStep.this.doAttach(peerNode, Collections.unmodifiableList(nodesToAttach), callback);
                            }
                        };
                        if (Protocol.isDispatchThread()) {
                            runnable.run();
                        } else {
                            Protocol.invokeLater((Runnable)runnable);
                        }
                    }
                });
            } else {
                this.doAttach(peerNode, Collections.unmodifiableList(nodesToAttach), callback);
            }
        } else {
            this.onDone(callback);
        }
    }

    protected void doAttach(final IPeerNode peerNode, final List<IProcessContextNode> nodes, final ICallback callback) {
        Assert.isTrue((boolean)Protocol.isDispatchThread(), (String)"Illegal Thread Access");
        Assert.isNotNull((Object)peerNode);
        Assert.isNotNull(nodes);
        if (!nodes.isEmpty()) {
            Tcf.getChannelManager().openChannel(peerNode.getPeer(), null, new IChannelManager.DoneOpenChannel(){

                public void doneOpenChannel(Throwable error, IChannel channel) {
                    if (error == null) {
                        IProcesses service = (IProcesses)channel.getRemoteService(IProcesses.class);
                        if (service != null) {
                            AsyncCallbackCollector collector = new AsyncCallbackCollector((ICallback)new Callback(){

                                protected void internalDone(Object caller, IStatus status) {
                                    if (status.getSeverity() == 4) {
                                        AttachStep.this.onError(peerNode, status.getMessage(), status.getException(), callback);
                                    } else {
                                        AttachStep.this.onDone(callback);
                                    }
                                }
                            }, (AsyncCallbackCollector.ICallbackInvocationDelegate)new CallbackInvocationDelegate());
                            for (final IProcessContextNode node : nodes) {
                                AsyncCallbackCollector.SimpleCollectorCallback callback2 = new AsyncCallbackCollector.SimpleCollectorCallback(collector);
                                service.getContext(node.getStringProperty("id"), new IProcesses.DoneGetContext((ICallback)callback2){
                                    private final /* synthetic */ ICallback val$callback2;
                                    {
                                        this.val$callback2 = iCallback;
                                    }

                                    public void doneGetContext(IToken token, Exception error, IProcesses.ProcessContext context) {
                                        if (error == null && context != null) {
                                            context.attach(new IProcesses.DoneCommand(){

                                                public void doneCommand(IToken token, Exception error) {
                                                    if (error == null) {
                                                        IModel model = (IModel)node.getParent(IModel.class);
                                                        Assert.isNotNull((Object)model);
                                                        ((IModelRefreshService)model.getService(IModelRefreshService.class)).refresh((IModelNode)node, (ICallback)new Callback(){

                                                            protected void internalDone(Object caller, IStatus status) {
                                                                val$callback2.done((Object)AttachStep.this, Status.OK_STATUS);
                                                            }
                                                        });
                                                    } else {
                                                        Status status = new Status(4, CoreBundleActivator.getUniqueIdentifier(), NLS.bind((String)Messages.AttachStep_error_attach, (Object)node.getName()), (Throwable)error);
                                                        val$callback2.done((Object)AttachStep.this, (IStatus)status);
                                                    }
                                                }
                                            });
                                        } else {
                                            Status status = new Status(4, CoreBundleActivator.getUniqueIdentifier(), NLS.bind((String)Messages.AttachStep_error_getContext, (Object)node.getName()), (Throwable)error);
                                            this.val$callback2.done((Object)AttachStep.this, (IStatus)status);
                                        }
                                    }
                                });
                            }
                            collector.initDone();
                        } else {
                            AttachStep.this.onError(peerNode, NLS.bind((String)Messages.AttachStep_error_missingService, (Object)peerNode.getName()), null, callback);
                        }
                    } else {
                        AttachStep.this.onError(peerNode, NLS.bind((String)Messages.AttachStep_error_openChannel, (Object)peerNode.getName()), error, callback);
                    }
                }
            });
        } else {
            this.onDone(callback);
        }
    }

    protected void onError(Object context, String message, Throwable error, ICallback callback) {
        String fullMessage;
        String detailMessage;
        Assert.isTrue((boolean)Protocol.isDispatchThread(), (String)"Illegal Thread Access");
        String string = detailMessage = error != null ? error.getMessage() : null;
        if (detailMessage != null && detailMessage.contains("\n")) {
            detailMessage = detailMessage.replaceAll("\n", ", ");
            detailMessage = detailMessage.replaceAll(":, ", ": ");
        }
        if ((fullMessage = message) != null && detailMessage != null) {
            fullMessage = String.valueOf(fullMessage) + NLS.bind((String)Messages.AttachStep_error_possibleCause, (Object)detailMessage);
        } else if (fullMessage == null) {
            fullMessage = detailMessage;
        }
        if (fullMessage != null) {
            Status status = new Status(4, CoreBundleActivator.getUniqueIdentifier(), fullMessage, error);
            if (callback == null) {
                IStatusHandler[] handlers = StatusHandlerManager.getInstance().getHandler(context);
                if (handlers.length > 0) {
                    PropertiesContainer data = new PropertiesContainer();
                    data.setProperty("title", (Object)Messages.AttachStep_error_title);
                    data.setProperty("contextHelpId", (Object)IContextHelpIds.MESSAGE_ATTACH_FAILED);
                    data.setProperty("caller", (Object)this);
                    handlers[0].handleStatus((IStatus)status, (IPropertiesContainer)data, null);
                } else {
                    CoreBundleActivator.getDefault().getLog().log((IStatus)status);
                }
            } else {
                callback.done((Object)this, (IStatus)status);
            }
        }
    }

    protected void onDone(ICallback callback) {
        Assert.isTrue((boolean)Protocol.isDispatchThread(), (String)"Illegal Thread Access");
        if (callback != null) {
            callback.done((Object)this, Status.OK_STATUS);
        }
    }
}

