/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.ui.views.handler;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.tcf.te.ui.views.ViewsUtil;
import org.eclipse.tcf.te.ui.views.handler.MRUList;
import org.eclipse.tcf.te.ui.views.handler.UpdateActiveFiltersOperation;
import org.eclipse.ui.actions.CompoundContributionItem;
import org.eclipse.ui.internal.navigator.NavigatorFilterService;
import org.eclipse.ui.navigator.CommonNavigator;
import org.eclipse.ui.navigator.CommonViewer;
import org.eclipse.ui.navigator.ICommonFilterDescriptor;
import org.eclipse.ui.navigator.INavigatorContentService;

public class FilterMRUContribution
extends CompoundContributionItem {
    protected IContributionItem[] getContributionItems() {
        ICommonFilterDescriptor[] visibleFilterDescriptors;
        CommonNavigator navigator = (CommonNavigator)ViewsUtil.getPart("org.eclipse.tcf.te.ui.views.View");
        if (navigator == null) {
            return new IContributionItem[0];
        }
        INavigatorContentService contentService = navigator.getNavigatorContentService();
        NavigatorFilterService filterService = (NavigatorFilterService)contentService.getFilterService();
        HashMap<String, ICommonFilterDescriptor> fdMap = new HashMap<String, ICommonFilterDescriptor>();
        ICommonFilterDescriptor[] iCommonFilterDescriptorArray = visibleFilterDescriptors = filterService.getVisibleFilterDescriptorsForUI();
        int n = visibleFilterDescriptors.length;
        int n2 = 0;
        while (n2 < n) {
            ICommonFilterDescriptor filterDescriptor = iCommonFilterDescriptorArray[n2];
            fdMap.put(filterDescriptor.getId(), filterDescriptor);
            ++n2;
        }
        ArrayList<ActionContributionItem> items = new ArrayList<ActionContributionItem>();
        MRUList filterSet = new MRUList("te.ui.PrefFilterMRUs");
        CommonViewer commonViewer = navigator.getCommonViewer();
        int i = 0;
        while (i < filterSet.size()) {
            String filterId = (String)filterSet.get(i);
            ICommonFilterDescriptor filterDescriptor = (ICommonFilterDescriptor)fdMap.get(filterId);
            if (filterDescriptor != null) {
                items.add(new ActionContributionItem((IAction)new FilterMRUAction(i + 1, filterDescriptor, filterService, commonViewer)));
            }
            ++i;
        }
        return items.toArray(new IContributionItem[items.size()]);
    }

    static class FilterMRUAction
    extends Action {
        private NavigatorFilterService filterService;
        private ICommonFilterDescriptor filterDescriptor;
        private CommonViewer commonViewer;

        public FilterMRUAction(int order, ICommonFilterDescriptor filterDescriptor, NavigatorFilterService filterService, CommonViewer commonViewer) {
            super(order + " " + filterDescriptor.getName(), 2);
            this.filterDescriptor = filterDescriptor;
            this.filterService = filterService;
            this.commonViewer = commonViewer;
            this.setChecked(filterService.isActive(filterDescriptor.getId()));
        }

        public void run() {
            ICommonFilterDescriptor[] visibleFilters = this.filterService.getVisibleFilterDescriptorsForUI();
            HashSet<String> activeIds = new HashSet<String>();
            if (visibleFilters != null && visibleFilters.length > 0) {
                ICommonFilterDescriptor[] iCommonFilterDescriptorArray = visibleFilters;
                int n = visibleFilters.length;
                int n2 = 0;
                while (n2 < n) {
                    ICommonFilterDescriptor filter = iCommonFilterDescriptorArray[n2];
                    if (this.filterService.isActive(filter.getId())) {
                        activeIds.add(filter.getId());
                    }
                    ++n2;
                }
            }
            if (this.isChecked()) {
                activeIds.add(this.filterDescriptor.getId());
            } else {
                activeIds.remove(this.filterDescriptor.getId());
            }
            UpdateActiveFiltersOperation updateFilters = new UpdateActiveFiltersOperation(this.commonViewer, activeIds.toArray(new String[activeIds.size()]));
            updateFilters.execute(null, null);
        }
    }
}

