/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.core.resources;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSProviderPlugin;
import org.eclipse.team.internal.ccvs.core.ICVSFile;
import org.eclipse.team.internal.ccvs.core.resources.CVSWorkspaceRoot;
import org.eclipse.team.internal.ccvs.core.resources.EclipseFile;
import org.eclipse.team.internal.ccvs.core.resources.EclipseResource;
import org.eclipse.team.internal.ccvs.core.resources.EclipseSynchronizer;
import org.eclipse.team.internal.ccvs.core.util.ResourceStateChangeListeners;

public class FileModificationManager
implements IResourceChangeListener {
    private static final QualifiedName UPDATE_TIMESTAMP = new QualifiedName("org.eclipse.team.cvs.core", "update-timestamp");
    Set<IResource> modifiedResources = new HashSet<IResource>();
    protected int INTERESTING_CHANGES = 323840;

    public void resourceChanged(IResourceChangeEvent event) {
        try {
            event.getDelta().accept(new IResourceDeltaVisitor(){

                public boolean visit(IResourceDelta delta) {
                    IResource resource = delta.getResource();
                    if (resource.getType() == 4) {
                        IProject project = (IProject)resource;
                        if (!project.isAccessible()) {
                            return false;
                        }
                        if ((delta.getFlags() & 0x4000) != 0) {
                            return false;
                        }
                        if (RepositoryProvider.getProvider((IProject)project, (String)CVSProviderPlugin.getTypeId()) == null) {
                            return false;
                        }
                    }
                    if (resource.getType() == 1 && delta.getKind() == 4 && resource.exists()) {
                        int flags = delta.getFlags();
                        if ((flags & FileModificationManager.this.INTERESTING_CHANGES) != 0) {
                            FileModificationManager.this.resourceChanged(resource, false);
                        }
                    } else if (delta.getKind() == 1) {
                        try {
                            EclipseSynchronizer.getInstance().handleAdded(resource);
                        }
                        catch (CVSException e) {
                            CVSProviderPlugin.log((CoreException)((Object)e));
                        }
                        FileModificationManager.this.resourceChanged(resource, true);
                    } else if (delta.getKind() == 2) {
                        try {
                            EclipseSynchronizer.getInstance().handleDeleted(resource);
                        }
                        catch (CVSException e) {
                            CVSProviderPlugin.log((CoreException)((Object)e));
                        }
                        FileModificationManager.this.modifiedResources.add(resource);
                    }
                    return true;
                }
            });
            if (!this.modifiedResources.isEmpty()) {
                ResourceStateChangeListeners.getListener().resourceModified(this.modifiedResources.toArray(new IResource[this.modifiedResources.size()]));
                this.modifiedResources.clear();
            }
        }
        catch (CoreException e) {
            CVSProviderPlugin.log(e);
        }
    }

    public void updated(ICVSFile mFile) {
        try {
            if (mFile instanceof EclipseFile) {
                IFile file = (IFile)mFile.getIResource();
                file.setSessionProperty(UPDATE_TIMESTAMP, (Object)file.getModificationStamp());
            }
        }
        catch (CoreException e) {
            CVSProviderPlugin.log(e);
        }
    }

    void resourceChanged(IResource resource, boolean addition) {
        if (this.isCleanUpdate(resource)) {
            return;
        }
        try {
            EclipseResource cvsResource = (EclipseResource)CVSWorkspaceRoot.getCVSResourceFor(resource);
            if (!cvsResource.isIgnored()) {
                cvsResource.handleModification(addition);
                this.modifiedResources.add(resource);
            }
            if (cvsResource.getName().equals(".cvsignore") && cvsResource.isIgnored()) {
                EclipseSynchronizer.getInstance().setModified((EclipseFile)cvsResource, 1);
                this.modifiedResources.add(resource);
            }
        }
        catch (CVSException e) {
            CVSProviderPlugin.log((CoreException)((Object)e));
        }
    }

    private boolean isCleanUpdate(IResource resource) {
        Long whenWeWrote;
        if (resource.getType() != 1) {
            return false;
        }
        long modStamp = resource.getModificationStamp();
        try {
            whenWeWrote = (Long)resource.getSessionProperty(UPDATE_TIMESTAMP);
            resource.setSessionProperty(UPDATE_TIMESTAMP, null);
        }
        catch (CoreException e) {
            CVSProviderPlugin.log(e);
            whenWeWrote = null;
        }
        return whenWeWrote != null && whenWeWrote == modStamp;
    }
}

