/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.provisional.tmf.core.model;

import com.google.common.base.Objects;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.tmf.core.model.ITableColumnDescriptor;

public class TableColumnDescriptor
implements ITableColumnDescriptor {
    private String fText = "";
    private String fTooltipText = "";

    private TableColumnDescriptor(Builder builder) {
        this.fText = builder.fText;
        this.fTooltipText = builder.fTooltipText;
    }

    @Override
    public String getText() {
        return this.fText;
    }

    @Override
    public String getTooltip() {
        return this.fTooltipText;
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ITableColumnDescriptor)) {
            return false;
        }
        ITableColumnDescriptor other = (ITableColumnDescriptor)obj;
        return Objects.equal((Object)this.fText, (Object)other.getText()) && Objects.equal((Object)this.fTooltipText, (Object)other.getTooltip());
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.fText, this.fTooltipText});
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("[text=").append(this.fText).append(" tooltip=").append(this.fTooltipText).append("]");
        return builder.toString();
    }

    /* synthetic */ TableColumnDescriptor(Builder builder, TableColumnDescriptor tableColumnDescriptor) {
        this(builder);
    }

    public static class Builder {
        private String fText = "";
        private String fTooltipText = "";

        public Builder setText(String text) {
            this.fText = text;
            return this;
        }

        public Builder setTooltip(String tooltip) {
            this.fTooltipText = tooltip;
            return this;
        }

        public TableColumnDescriptor build() {
            return new TableColumnDescriptor(this, null);
        }
    }
}

