/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.ui.internal.nsedit;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wst.xml.core.internal.XMLCorePlugin;
import org.eclipse.wst.xml.core.internal.catalog.provisional.ICatalog;
import org.eclipse.wst.xml.core.internal.catalog.provisional.ICatalogEntry;
import org.eclipse.wst.xml.core.internal.catalog.provisional.INextCatalog;
import org.eclipse.wst.xml.core.internal.contentmodel.util.NamespaceInfo;
import org.eclipse.wst.xml.ui.internal.nsedit.CommonAddNamespacesControl;

public class CommonAddNamespacesDialog
extends Dialog {
    protected CommonAddNamespacesControl addNamespacesControl;
    protected List existingNamespaces;
    protected List namespaceInfoList;
    protected Button okButton;
    protected HashMap preferredPrefixTable = new HashMap();
    protected IPath resourceLocation;
    protected String title;

    public CommonAddNamespacesDialog(Shell parentShell, String title, IPath resourceLocation, List existingNamespaces) {
        super(parentShell);
        this.resourceLocation = resourceLocation;
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.title = title;
        this.existingNamespaces = existingNamespaces;
        this.preferredPrefixTable.put("http://schemas.xmlsoap.org/wsdl/", "wsdl");
        this.preferredPrefixTable.put("http://schemas.xmlsoap.org/wsdl/soap/", "soap");
        this.preferredPrefixTable.put("http://schemas.xmlsoap.org/wsdl/http/", "http");
        this.preferredPrefixTable.put("http://schemas.xmlsoap.org/wsdl/mime/", "mime");
        this.preferredPrefixTable.put("http://schemas.xmlsoap.org/soap/encoding/", "soapenc");
        this.preferredPrefixTable.put("http://schemas.xmlsoap.org/soap/envelope/", "soapenv");
        this.preferredPrefixTable.put("http://www.w3.org/2001/XMLSchema-instance", "xsi");
        this.preferredPrefixTable.put("http://www.w3.org/2001/XMLSchema", "xsd");
    }

    protected void addBuiltInNamespaces(List list) {
        String xsiNamespace = "http://www.w3.org/2001/XMLSchema-instance";
        String xsdNamespace = "http://www.w3.org/2001/XMLSchema";
        if (!this.isAlreadyDeclared(xsiNamespace)) {
            list.add(new NamespaceInfo("http://www.w3.org/2001/XMLSchema-instance", "xsi", null));
        }
        if (!this.isAlreadyDeclared(xsdNamespace)) {
            list.add(new NamespaceInfo("http://www.w3.org/2001/XMLSchema", "xsd", null));
        }
    }

    protected void addCatalogMapToList(ICatalog catalog, List list) {
        ICatalogEntry[] entries = catalog.getCatalogEntries();
        int i = 0;
        while (i < entries.length) {
            ICatalogEntry entry = entries[i];
            if (entry.getEntryType() == 2 && entry.getURI().endsWith(".xsd") && !this.isAlreadyDeclared(entry.getKey())) {
                NamespaceInfo namespaceInfo = new NamespaceInfo(entry.getKey(), "xx", null);
                list.add(namespaceInfo);
            }
            ++i;
        }
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 0) {
            this.namespaceInfoList = this.addNamespacesControl.getNamespaceInfoList();
        }
        super.buttonPressed(buttonId);
    }

    public void computeAddablePrefixes(List addableList, List exisitingList) {
        HashMap<String, NamespaceInfo> map = new HashMap<String, NamespaceInfo>();
        for (NamespaceInfo info : exisitingList) {
            if (info.prefix == null) continue;
            map.put(info.prefix, info);
        }
        for (NamespaceInfo info : addableList) {
            if (info.uri == null) continue;
            String prefix = (String)this.preferredPrefixTable.get(info.uri);
            info.prefix = this.getUniquePrefix(map, prefix, info.uri);
            map.put(info.prefix, info);
        }
    }

    public int createAndOpen() {
        this.create();
        this.getShell().setText(this.title);
        Rectangle r = this.getShell().getBounds();
        this.getShell().setBounds(r.x + 80, r.y + 80, r.width, r.height);
        this.setBlockOnOpen(true);
        return this.open();
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.okButton = this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected Control createContents(Composite parent) {
        Control control = super.createContents(parent);
        return control;
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        this.addNamespacesControl = new CommonAddNamespacesControl(dialogArea, 0, this.resourceLocation);
        ArrayList list = new ArrayList();
        this.addBuiltInNamespaces(list);
        ICatalog defaultCatalog = XMLCorePlugin.getDefault().getDefaultXMLCatalog();
        INextCatalog[] nextCatalogs = defaultCatalog.getNextCatalogs();
        int i = 0;
        while (i < nextCatalogs.length) {
            INextCatalog catalog = nextCatalogs[i];
            ICatalog referencedCatalog = catalog.getReferencedCatalog();
            if (referencedCatalog != null) {
                if ("user_catalog".equals(referencedCatalog.getId())) {
                    ICatalog userCatalog = referencedCatalog;
                    this.addCatalogMapToList(userCatalog, list);
                } else if ("system_catalog".equals(referencedCatalog.getId())) {
                    ICatalog systemCatalog = referencedCatalog;
                    this.addCatalogMapToList(systemCatalog, list);
                }
            }
            ++i;
        }
        this.computeAddablePrefixes(list, this.existingNamespaces);
        this.addNamespacesControl.setNamespaceInfoList(list);
        return dialogArea;
    }

    public List getNamespaceInfoList() {
        return this.namespaceInfoList;
    }

    protected String getPreferredPrefix(String namespaceURI) {
        return (String)this.preferredPrefixTable.get(namespaceURI);
    }

    private String getUniquePrefix(HashMap prefixMap, String prefix, String uri) {
        if (prefix == null) {
            int lastIndex = uri.lastIndexOf(47);
            if (lastIndex == uri.length() - 1) {
                uri = uri.substring(0, lastIndex);
                lastIndex = uri.lastIndexOf(47);
            }
            if ((prefix = uri.substring(lastIndex + 1)).length() > 20 || prefix.indexOf(58) != -1) {
                prefix = null;
            }
        }
        if (prefix == null) {
            prefix = "p";
        }
        if (prefixMap.get(prefix) != null) {
            String base = prefix;
            int count = 0;
            while (prefixMap.get(prefix) != null) {
                prefix = String.valueOf(base) + count;
                ++count;
            }
        }
        return prefix;
    }

    protected boolean isAlreadyDeclared(String namespaceURI) {
        boolean result = false;
        for (NamespaceInfo namespaceInfo : this.existingNamespaces) {
            if (!namespaceURI.equals(namespaceInfo.uri)) continue;
            result = true;
            break;
        }
        return result;
    }
}

