/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.shared.ui;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.internal.xtend.xtend.parser.ErrorHandler;
import org.eclipse.internal.xtend.xtend.parser.XtendError;
import org.eclipse.xtend.expression.Resource;
import org.eclipse.xtend.shared.ui.ResourceContributor2;
import org.eclipse.xtend.shared.ui.core.IXtendXpandResource;
import org.eclipse.xtend.shared.ui.core.builder.XtendXpandMarkerManager;

public abstract class ResourceContributorBase
implements ResourceContributor2 {
    protected ErrorHandler getErrorHandler(final IStorage source) {
        boolean cfr_ignored_0 = source instanceof IFile;
        return new ErrorHandler(){

            public void handleError(XtendError e) {
                int start = e.getStart();
                int end = e.getEnd();
                if (source instanceof IFile) {
                    IFile f = (IFile)source;
                    if (start == 0 && end == 1 && e.getMessage().contains("<EOF>")) {
                        try {
                            Reader reader = ResourceContributorBase.this.createReader(source);
                            while (reader.read() != -1) {
                                ++start;
                                ++end;
                            }
                            --start;
                            --end;
                        }
                        catch (IOException e2) {
                            ResourceContributorBase.this.logError(e2.getMessage(), e2);
                        }
                    }
                    if (start > 0) {
                        XtendXpandMarkerManager.addErrorMarker(f, e.getMessage(), 2, start, end);
                    }
                }
            }
        };
    }

    protected abstract void logInfo(String var1);

    protected abstract void logError(String var1, Throwable var2);

    @Deprecated
    public final IXtendXpandResource create(IStorage file, String fqn) {
        return this.create(null, file, fqn);
    }

    public IXtendXpandResource create(IProject project, IStorage storage, String fqn) {
        Resource res = this.parse(project, storage, fqn);
        if (res != null) {
            return this.createExtXptResource(res, project, storage);
        }
        return null;
    }

    protected Reader createReader(IStorage resource) {
        try {
            InputStream in = resource.getContents();
            return new InputStreamReader(in);
        }
        catch (CoreException e1) {
            this.logInfo(e1.getMessage());
            return null;
        }
    }

    @Deprecated
    public Resource parse(IStorage source, String fqn) {
        return this.parse(null, source, fqn);
    }

    protected abstract Resource parse(IProject var1, IStorage var2, String var3);

    @Deprecated
    protected IXtendXpandResource createExtXptResource(Resource resource, IStorage source) {
        return this.createExtXptResource(resource, null, source);
    }

    protected abstract IXtendXpandResource createExtXptResource(Resource var1, IProject var2, IStorage var3);
}

