/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.fnmeta;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.bpel.fnmeta.FunctionRegistry;
import org.eclipse.bpel.fnmeta.IFunctionRegistryLoader;

public class FunctionLibrary {
    public static FunctionLibrary INSTANCE = new FunctionLibrary();
    Map<String, FunctionRegistry> fRegistries = new HashMap<String, FunctionRegistry>();
    List<IFunctionRegistryLoader> fLoaders = new ArrayList<IFunctionRegistryLoader>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FunctionRegistry getRegistryForLanguage(String language) {
        FunctionRegistry registry = this.fRegistries.get(language);
        if (registry != null) {
            return registry;
        }
        Map<String, FunctionRegistry> map = this.fRegistries;
        synchronized (map) {
            registry = this.fRegistries.get(language);
            if (registry != null) {
                return registry;
            }
            registry = new FunctionRegistry(language);
            for (IFunctionRegistryLoader loader : this.fLoaders) {
                loader.load(registry);
            }
            this.fRegistries.put(language, registry);
        }
        return registry;
    }

    public void add(FunctionRegistry registry) {
        this.fRegistries.put(registry.getLanguageNS(), registry);
    }

    public void registerLoader(IFunctionRegistryLoader loader) {
        if (this.fLoaders.contains(loader)) {
            return;
        }
        this.fLoaders.add(loader);
    }

    public void unregisterLoader(IFunctionRegistryLoader loader) {
        this.fLoaders.remove(loader);
    }
}

