/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.ui.properties;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.xml.namespace.QName;
import org.eclipse.bpel.common.ui.details.IOngoingChange;
import org.eclipse.bpel.common.ui.flatui.FlatFormAttachment;
import org.eclipse.bpel.common.ui.flatui.FlatFormData;
import org.eclipse.bpel.model.Activity;
import org.eclipse.bpel.model.BPELFactory;
import org.eclipse.bpel.model.BPELPackage;
import org.eclipse.bpel.model.Catch;
import org.eclipse.bpel.model.CatchAll;
import org.eclipse.bpel.model.ElseIf;
import org.eclipse.bpel.model.FaultHandler;
import org.eclipse.bpel.model.Flow;
import org.eclipse.bpel.model.If;
import org.eclipse.bpel.model.Import;
import org.eclipse.bpel.model.Invoke;
import org.eclipse.bpel.model.OnAlarm;
import org.eclipse.bpel.model.OnMessage;
import org.eclipse.bpel.model.PartnerLink;
import org.eclipse.bpel.model.Pick;
import org.eclipse.bpel.model.Process;
import org.eclipse.bpel.model.RepeatUntil;
import org.eclipse.bpel.model.Scope;
import org.eclipse.bpel.model.Sequence;
import org.eclipse.bpel.model.Throw;
import org.eclipse.bpel.model.Variable;
import org.eclipse.bpel.model.While;
import org.eclipse.bpel.model.partnerlinktype.Role;
import org.eclipse.bpel.model.util.BPELConstants;
import org.eclipse.bpel.model.util.BPELUtils;
import org.eclipse.bpel.ui.IBPELUIConstants;
import org.eclipse.bpel.ui.Messages;
import org.eclipse.bpel.ui.commands.CompoundCommand;
import org.eclipse.bpel.ui.commands.SetCommand;
import org.eclipse.bpel.ui.commands.SetFaultNameCommand;
import org.eclipse.bpel.ui.commands.SetFaultNamespaceCommand;
import org.eclipse.bpel.ui.commands.SetNameCommand;
import org.eclipse.bpel.ui.commands.SetVariableCommand;
import org.eclipse.bpel.ui.commands.SetVariableKindCommand;
import org.eclipse.bpel.ui.commands.util.AutoUndoCommand;
import org.eclipse.bpel.ui.properties.BPELPropertySection;
import org.eclipse.bpel.ui.properties.ChangeTracker;
import org.eclipse.bpel.ui.properties.VariableTypeSelector;
import org.eclipse.bpel.ui.uiextensionmodel.VariableExtension;
import org.eclipse.bpel.ui.util.BPELUtil;
import org.eclipse.bpel.ui.util.BatchedMultiObjectAdapter;
import org.eclipse.bpel.ui.util.ModelHelper;
import org.eclipse.bpel.ui.util.MultiObjectAdapter;
import org.eclipse.bpel.ui.util.NamespaceUtils;
import org.eclipse.bpel.ui.util.WSDLImportHelper;
import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.commands.Command;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.wsdl.Definition;
import org.eclipse.wst.wsdl.Fault;
import org.eclipse.wst.wsdl.Message;
import org.eclipse.wst.wsdl.Operation;
import org.eclipse.wst.wsdl.PortType;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDTypeDefinition;

public class FaultCatchNameSection
extends BPELPropertySection {
    protected static final int NAME_BUILTIN_CONTEXT = 0;
    protected static final int NAMESPACE_CONTEXT = 1;
    protected static final int VARIABLE_CONTEXT = 2;
    protected static final int BUILTINRADIO_CONTEXT = 3;
    protected static final int USERDEFRADIO_CONTEXT = 4;
    protected static final int NAME_USERDEF_CONTEXT = 5;
    protected static final int FAULT_VARIABLE_NAME_CONTEXT = 6;
    protected static final int FAULT_VARIABLE_TYPE_CONTEXT = 7;
    protected int lastChangeContext = -1;
    protected VariableTypeSelector variableTypeSelector;
    protected boolean isCatch;
    protected boolean isFaultTypeEnabled;
    protected Composite parentComposite;
    protected Composite faultTypeComposite;
    protected Composite namespaceComposite;
    protected Composite faultNameComposite;
    protected Composite faultUserDefNameComposite;
    protected Composite faultVariableNameComposite;
    protected Button builtinRadio;
    protected Button userdefRadio;
    protected Text variableNameText;
    protected CCombo faultNameCombo;
    protected CCombo faultUserDefCombo;
    protected CCombo faultNamespaceCombo;
    protected ChangeTracker faultNameTracker;
    protected ChangeTracker faultNamespaceTracker;
    protected ChangeTracker faultUserDefNameTracker;
    protected ChangeTracker variableNameTracker;
    protected Vector<QName> faultNameQNames;

    @Override
    protected MultiObjectAdapter[] createAdapters() {
        return new BatchedMultiObjectAdapter[]{new BatchedMultiObjectAdapter(){
            boolean refreshFaultName = false;
            boolean refreshUserDefFaultName = false;
            boolean refreshFaultNamespace = false;
            boolean refreshVariable = false;

            @Override
            public void notify(Notification n) {
                if (ModelHelper.isFaultNameAffected(FaultCatchNameSection.this.getInput(), n) && FaultCatchNameSection.this.builtinRadio.getSelection()) {
                    this.refreshFaultName = true;
                }
                if (ModelHelper.isFaultNameAffected(FaultCatchNameSection.this.getInput(), n) && FaultCatchNameSection.this.userdefRadio.getSelection()) {
                    this.refreshUserDefFaultName = true;
                }
                if (FaultCatchNameSection.this.isFaultTypeEnabled && ModelHelper.isFaultNamespaceAffected(FaultCatchNameSection.this.getInput(), n)) {
                    this.refreshFaultNamespace = true;
                }
                if (ModelHelper.isVariableAffected(FaultCatchNameSection.this.getInput(), n, 1)) {
                    this.refreshVariable = true;
                } else if (n.getFeatureID(Catch.class) == 7) {
                    this.refreshVariable = true;
                }
            }

            @Override
            public void finish() {
                if (this.refreshFaultName) {
                    FaultCatchNameSection.this.updateFaultNameWidgets();
                }
                if (this.refreshFaultNamespace) {
                    FaultCatchNameSection.this.updateFaultNamespaceWidgets();
                }
                if (this.refreshUserDefFaultName) {
                    FaultCatchNameSection.this.updateUserDefFaultNameWidgets();
                }
                if (this.refreshVariable) {
                    FaultCatchNameSection.this.updateVariableWidgets();
                }
                this.refreshFaultName = false;
                this.refreshUserDefFaultName = false;
                this.refreshFaultNamespace = false;
                this.refreshVariable = false;
            }
        }};
    }

    protected boolean isNamespaceUserDef() {
        return !this.isFaultTypeEnabled || this.userdefRadio.getSelection();
    }

    protected void doChildLayout() {
        FlatFormData data = null;
        FlatFormData data1 = null;
        boolean isNamespaceUserDef = this.isNamespaceUserDef();
        if (this.isFaultTypeEnabled) {
            data = (FlatFormData)this.namespaceComposite.getLayoutData();
            data.top = new FlatFormAttachment((Control)this.faultTypeComposite, 4);
            if (isNamespaceUserDef) {
                data = (FlatFormData)this.faultUserDefNameComposite.getLayoutData();
                data.top = new FlatFormAttachment((Control)this.namespaceComposite, 4);
                data1 = (FlatFormData)this.faultVariableNameComposite.getLayoutData();
                data1.top = new FlatFormAttachment((Control)this.faultUserDefNameComposite, 4);
            } else {
                data = (FlatFormData)this.faultNameComposite.getLayoutData();
                data.top = new FlatFormAttachment((Control)this.faultTypeComposite, 4);
                data1 = (FlatFormData)this.faultVariableNameComposite.getLayoutData();
                data1.top = new FlatFormAttachment((Control)this.faultNameComposite, 4);
            }
        } else {
            data = (FlatFormData)this.namespaceComposite.getLayoutData();
            data.top = new FlatFormAttachment(0, 0);
            data = (FlatFormData)this.faultUserDefNameComposite.getLayoutData();
            data.top = new FlatFormAttachment((Control)this.namespaceComposite, 4);
            data1 = (FlatFormData)this.faultVariableNameComposite.getLayoutData();
            data1.top = new FlatFormAttachment((Control)this.faultUserDefNameComposite, 4);
        }
        this.faultTypeComposite.setVisible(this.isFaultTypeEnabled);
        this.namespaceComposite.setVisible(isNamespaceUserDef);
        this.faultNameComposite.setVisible(!isNamespaceUserDef);
        this.faultUserDefNameComposite.setVisible(isNamespaceUserDef);
        this.parentComposite.layout(true);
        this.parentComposite.getParent().layout(true);
    }

    public boolean shouldUseExtraSpace() {
        return true;
    }

    @Override
    protected void basicSetInput(EObject input) {
        super.basicSetInput(input);
        this.rearrangeWidgets();
    }

    protected void rearrangeWidgets() {
        EObject maybeInvoke;
        FaultHandler faultHandler;
        this.isCatch = this.getInput() instanceof Catch;
        this.isFaultTypeEnabled = true;
        if (this.isCatch && (faultHandler = (FaultHandler)this.getInput().eContainer()) != null && (maybeInvoke = faultHandler.eContainer()) instanceof Invoke) {
            this.isFaultTypeEnabled = false;
        }
        this.doChildLayout();
    }

    protected void createFaultTypeWidgets(Composite parent) {
        Composite composite = this.faultTypeComposite = this.createFlatFormComposite(parent);
        FlatFormData data = new FlatFormData();
        data.left = new FlatFormAttachment(0, 0);
        data.right = new FlatFormAttachment(100, 0);
        data.top = new FlatFormAttachment(0, 0);
        composite.setLayoutData((Object)data);
        Label faultTypeLabel = this.fWidgetFactory.createLabel(composite, Messages.FaultCatchNameDetails_Fault_Type__13);
        this.builtinRadio = this.fWidgetFactory.createButton(composite, Messages.FaultCatchNameDetails_Built_in_14, 16);
        data = new FlatFormData();
        data.left = new FlatFormAttachment(0, BPELUtil.calculateLabelWidth((Widget)faultTypeLabel, 105));
        data.top = new FlatFormAttachment(0, 2);
        this.builtinRadio.setLayoutData((Object)data);
        this.builtinRadio.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (!FaultCatchNameSection.this.builtinRadio.getSelection()) {
                    return;
                }
                FaultCatchNameSection.this.doChildLayout();
                FaultCatchNameSection.this.updateFaultNameWidgets();
                FaultCatchNameSection.this.updateUserDefFaultNameWidgets();
                CompoundCommand command = new CompoundCommand();
                String newName = FaultCatchNameSection.this.faultNameCombo.getText();
                SetCommand cmd = new SetFaultNameCommand((EObject)FaultCatchNameSection.this.getInput(), FaultCatchNameSection.this.isEmptyMessageType(newName) ? "" : newName);
                if (cmd.canExecute()) {
                    command.add((Command)cmd);
                }
                if ((cmd = new SetFaultNamespaceCommand((EObject)FaultCatchNameSection.this.getInput(), BPELConstants.NAMESPACE)).canExecute()) {
                    command.add((Command)cmd);
                }
                command.setLabel(cmd.getLabel());
                if (command.canExecute()) {
                    FaultCatchNameSection.this.lastChangeContext = 3;
                    FaultCatchNameSection.this.getCommandFramework().execute(FaultCatchNameSection.this.wrapInShowContextCommand((Command)command));
                }
                FaultCatchNameSection.this.updateUserDefFaultNameWidgets();
                FaultCatchNameSection.this.updateFaultNameWidgets();
                FaultCatchNameSection.this.updateFaultNamespaceWidgets();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.userdefRadio = this.fWidgetFactory.createButton(composite, Messages.FaultCatchNameDetails_User_defined_15, 16);
        data = new FlatFormData();
        data.left = new FlatFormAttachment((Control)this.builtinRadio, 5);
        data.top = new FlatFormAttachment(0, 2);
        this.userdefRadio.setLayoutData((Object)data);
        this.userdefRadio.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (!FaultCatchNameSection.this.userdefRadio.getSelection()) {
                    return;
                }
                FaultCatchNameSection.this.doChildLayout();
                String s = "";
                Vector<QName> names = FaultCatchNameSection.this.getFaultNames(FaultCatchNameSection.this.getProcess().getTargetNamespace());
                if (!names.isEmpty()) {
                    s = names.get(0).getLocalPart();
                }
                CompoundCommand command = new CompoundCommand();
                SetCommand cmd = new SetFaultNameCommand((EObject)FaultCatchNameSection.this.getInput(), s == null ? "" : s);
                if (cmd.canExecute()) {
                    command.add((Command)cmd);
                }
                if ((cmd = new SetFaultNamespaceCommand((EObject)FaultCatchNameSection.this.getInput(), FaultCatchNameSection.this.getProcess().getTargetNamespace())).canExecute()) {
                    command.add((Command)cmd);
                }
                if (command.canExecute()) {
                    FaultCatchNameSection.this.lastChangeContext = 4;
                    FaultCatchNameSection.this.getCommandFramework().execute(FaultCatchNameSection.this.wrapInShowContextCommand((Command)command));
                }
                FaultCatchNameSection.this.updateUserDefFaultNameWidgets();
                FaultCatchNameSection.this.updateFaultNameWidgets();
                FaultCatchNameSection.this.updateFaultNamespaceWidgets();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        data = new FlatFormData();
        data.left = new FlatFormAttachment(0, 0);
        data.right = new FlatFormAttachment((Control)this.builtinRadio, -5);
        data.top = new FlatFormAttachment((Control)this.builtinRadio, 0, 0x1000000);
        faultTypeLabel.setLayoutData((Object)data);
    }

    protected void createChangeTrackers() {
        Object change = new IOngoingChange(){

            public String getLabel() {
                return IBPELUIConstants.CMD_EDIT_FAULTNAME;
            }

            public Command createApplyCommand() {
                SetFaultNamespaceCommand c2;
                String name = FaultCatchNameSection.this.faultNameCombo.getText();
                CompoundCommand command = new CompoundCommand();
                String newName = "".equals(name) ? null : name;
                SetFaultNameCommand newNameCommand = new SetFaultNameCommand((EObject)FaultCatchNameSection.this.getInput(), FaultCatchNameSection.this.isEmptyMessageType(newName) ? "" : newName);
                if (newNameCommand.canExecute()) {
                    command.add((Command)newNameCommand);
                }
                if ((c2 = new SetFaultNamespaceCommand((EObject)FaultCatchNameSection.this.getInput(), BPELConstants.NAMESPACE)).canExecute()) {
                    command.add((Command)c2);
                }
                FaultCatchNameSection.this.lastChangeContext = 0;
                return FaultCatchNameSection.this.wrapInShowContextCommand((Command)command);
            }

            public void restoreOldState() {
                FaultCatchNameSection.this.updateFaultNameWidgets();
            }
        };
        this.faultNameTracker = new ChangeTracker((Control)this.faultNameCombo, (IOngoingChange)change, this.getCommandFramework());
        change = new IOngoingChange(){

            public String getLabel() {
                return IBPELUIConstants.CMD_EDIT_FAULTNAME;
            }

            public Command createApplyCommand() {
                String s = NamespaceUtils.convertNamespaceToUri(FaultCatchNameSection.this.faultNamespaceCombo.getText());
                FaultCatchNameSection.this.lastChangeContext = 1;
                CompoundCommand command = new CompoundCommand();
                command.add((Command)new SetFaultNamespaceCommand((EObject)FaultCatchNameSection.this.getInput(), "".equals(s) ? null : s));
                Vector<QName> faultNames = FaultCatchNameSection.this.getFaultNames(s);
                String name = null;
                if (!faultNames.isEmpty()) {
                    name = faultNames.get(0).getLocalPart();
                }
                command.add((Command)new SetFaultNameCommand((EObject)FaultCatchNameSection.this.getInput(), FaultCatchNameSection.this.isEmptyMessageType(name) ? "" : name));
                return FaultCatchNameSection.this.wrapInShowContextCommand((Command)command);
            }

            public void restoreOldState() {
                FaultCatchNameSection.this.updateFaultNamespaceWidgets();
            }
        };
        this.faultNamespaceTracker = new ChangeTracker((Control)this.faultNamespaceCombo, (IOngoingChange)change, this.getCommandFramework());
        change = new IOngoingChange(){

            public String getLabel() {
                return IBPELUIConstants.CMD_EDIT_FAULTNAME;
            }

            public Command createApplyCommand() {
                FaultCatchNameSection.this.lastChangeContext = 5;
                String faultName = FaultCatchNameSection.this.faultUserDefCombo.getText();
                String namespace = NamespaceUtils.convertNamespaceToUri(FaultCatchNameSection.this.faultNamespaceCombo.getText());
                if (!FaultCatchNameSection.this.validNamespaceFaultNameCombination(namespace, faultName) && (namespace = NamespaceUtils.convertUriToNamespace(FaultCatchNameSection.this.getNamespaceByFaultName(faultName))) == null) {
                    namespace = "";
                }
                FaultCatchNameSection.this.faultNamespaceCombo.setText(NamespaceUtils.convertUriToNamespace(namespace));
                CompoundCommand command = new CompoundCommand(IBPELUIConstants.CMD_EDIT_FAULTNAME);
                command.add((Command)new SetFaultNamespaceCommand((EObject)FaultCatchNameSection.this.getInput(), "".equals(namespace) ? null : namespace));
                String newName = "".equals(faultName) ? null : faultName;
                command.add((Command)new SetFaultNameCommand((EObject)FaultCatchNameSection.this.getInput(), FaultCatchNameSection.this.isEmptyMessageType(newName) ? "" : newName));
                return FaultCatchNameSection.this.wrapInShowContextCommand((Command)command);
            }

            public void restoreOldState() {
                FaultCatchNameSection.this.updateUserDefFaultNameWidgets();
            }
        };
        this.faultUserDefNameTracker = new ChangeTracker((Control)this.faultUserDefCombo, (IOngoingChange)change, this.getCommandFramework());
        change = new IOngoingChange(){

            public String getLabel() {
                return IBPELUIConstants.CMD_SELECT_VARIABLE;
            }

            public Command createApplyCommand() {
                Catch _catch = (Catch)FaultCatchNameSection.this.getInput();
                String s = FaultCatchNameSection.this.variableNameText.getText();
                if ("".equals(s)) {
                    s = null;
                }
                CompoundCommand result = new CompoundCommand();
                Variable variable = _catch.getFaultVariable();
                if (s != null) {
                    if (variable == null) {
                        variable = BPELFactory.eINSTANCE.createVariable();
                        result.add((Command)new SetVariableCommand((EObject)_catch, variable, 1));
                    }
                    result.add((Command)new SetNameCommand((EObject)variable, s));
                } else if (variable != null) {
                    result.add((Command)new SetVariableCommand((EObject)_catch, null, 1));
                }
                FaultCatchNameSection.this.lastChangeContext = 6;
                return FaultCatchNameSection.this.wrapInShowContextCommand((Command)result);
            }

            public void restoreOldState() {
                FaultCatchNameSection.this.updateVariableWidgets();
            }
        };
        this.variableNameTracker = new ChangeTracker((Control)this.variableNameText, (IOngoingChange)change, this.getCommandFramework());
    }

    protected void createFaultNameWidgets(Composite parent) {
        Composite composite = this.faultNameComposite = this.createFlatFormComposite(parent);
        FlatFormData data = new FlatFormData();
        data.left = new FlatFormAttachment(0, 0);
        data.right = new FlatFormAttachment(100, 0);
        data.top = new FlatFormAttachment((Control)this.namespaceComposite, 4);
        composite.setLayoutData((Object)data);
        this.faultNameCombo = this.fWidgetFactory.createCCombo(composite);
        Label faultNameLabel = this.fWidgetFactory.createLabel(composite, Messages.FaultCatchNameDetails_Fault_Name__16);
        data = new FlatFormData();
        data.left = new FlatFormAttachment(0, BPELUtil.calculateLabelWidth((Widget)faultNameLabel, 105));
        data.right = new FlatFormAttachment(50, -60);
        data.top = new FlatFormAttachment(0, 0);
        List<String> faultNames = this.getBuiltinFaultNames();
        String[] result = faultNames.toArray(new String[faultNames.size()]);
        this.faultNameCombo.setItems(result);
        this.faultNameCombo.setLayoutData((Object)data);
        data = new FlatFormData();
        data.left = new FlatFormAttachment(0, 0);
        data.right = new FlatFormAttachment((Control)this.faultNameCombo, -5);
        data.top = new FlatFormAttachment((Control)this.faultNameCombo, 0, 0x1000000);
        faultNameLabel.setLayoutData((Object)data);
    }

    protected void createNamespaceWidgets(Composite parent) {
        Composite composite = this.namespaceComposite = this.createFlatFormComposite(parent);
        FlatFormData data = new FlatFormData();
        data.left = new FlatFormAttachment(0, 0);
        data.right = new FlatFormAttachment(100, 0);
        data.top = new FlatFormAttachment((Control)this.faultTypeComposite, 4);
        composite.setLayoutData((Object)data);
        this.faultNamespaceCombo = this.fWidgetFactory.createCCombo(composite);
        Label faultNamespaceLabel = this.fWidgetFactory.createLabel(composite, Messages.FaultCatchNameDetails_Namespace__21);
        data = new FlatFormData();
        data.left = new FlatFormAttachment(0, BPELUtil.calculateLabelWidth((Widget)faultNamespaceLabel, 105));
        data.right = new FlatFormAttachment(50, -60);
        data.top = new FlatFormAttachment(0, 1);
        this.faultNamespaceCombo.setLayoutData((Object)data);
        data = new FlatFormData();
        data.left = new FlatFormAttachment(0, 0);
        data.right = new FlatFormAttachment((Control)this.faultNamespaceCombo, -5);
        data.top = new FlatFormAttachment((Control)this.faultNamespaceCombo, 0, 0x1000000);
        faultNamespaceLabel.setLayoutData((Object)data);
        data = new FlatFormData();
        data.right = new FlatFormAttachment(100, 0);
        data.left = new FlatFormAttachment(100, -60);
        data.top = new FlatFormAttachment((Control)this.faultNamespaceCombo, -1, 128);
        data.bottom = new FlatFormAttachment((Control)this.faultNamespaceCombo, 1, 1024);
    }

    protected void createUserDefFaultNameWidgets(Composite parent) {
        Composite composite = this.faultUserDefNameComposite = this.createFlatFormComposite(parent);
        FlatFormData data = new FlatFormData();
        data.left = new FlatFormAttachment(0, 0);
        data.right = new FlatFormAttachment(100, 0);
        data.top = new FlatFormAttachment((Control)this.namespaceComposite, 4);
        composite.setLayoutData((Object)data);
        Label faultUserDefNameLabel = this.fWidgetFactory.createLabel(composite, Messages.FaultCatchNameDetails_Fault_Name__24);
        this.faultUserDefCombo = this.fWidgetFactory.createCCombo(composite, 0x800008);
        data = new FlatFormData();
        data.left = new FlatFormAttachment(0, BPELUtil.calculateLabelWidth((Widget)faultUserDefNameLabel, 105));
        data.right = new FlatFormAttachment(50, -60);
        data.top = new FlatFormAttachment(0, 1);
        this.faultUserDefCombo.setLayoutData((Object)data);
        data = new FlatFormData();
        data.left = new FlatFormAttachment(0, 0);
        data.right = new FlatFormAttachment((Control)this.faultUserDefCombo, -5);
        data.top = new FlatFormAttachment((Control)this.faultUserDefCombo, 0, 0x1000000);
        faultUserDefNameLabel.setLayoutData((Object)data);
    }

    protected void createVariableWidgets(Composite parent) {
        Composite composite = this.faultVariableNameComposite = this.createFlatFormComposite(parent);
        FlatFormData data = new FlatFormData();
        data.left = new FlatFormAttachment(0, 0);
        data.right = new FlatFormAttachment(100, 0);
        data.top = new FlatFormAttachment((Control)this.faultNameComposite, 4);
        composite.setLayoutData((Object)data);
        Label variableLabel = this.fWidgetFactory.createLabel(composite, Messages.FaultCatchNameSection_Variable_Name_3);
        data = new FlatFormData();
        data.left = new FlatFormAttachment(0, 0);
        data.top = new FlatFormAttachment(0, 0);
        variableLabel.setLayoutData((Object)data);
        this.variableNameText = this.fWidgetFactory.createText(composite, "");
        data = new FlatFormData();
        data.left = new FlatFormAttachment(0, BPELUtil.calculateLabelWidth((Widget)variableLabel, 105));
        data.right = new FlatFormAttachment(50, 0);
        data.top = new FlatFormAttachment(0, 0);
        this.variableNameText.setLayoutData((Object)data);
        this.variableNameText.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                FaultCatchNameSection.this.updateVariableTypeSelector();
            }
        });
        this.variableTypeSelector = new VariableTypeSelector(composite, 0, this.getBPELEditor(), this.fWidgetFactory, new FaultVariableTypeCallback(), false, 20);
        data = new FlatFormData();
        data.top = new FlatFormAttachment((Control)this.variableNameText, 8);
        data.left = new FlatFormAttachment(0, 0);
        data.right = new FlatFormAttachment(100, 0);
        data.bottom = new FlatFormAttachment(100, 0);
        this.variableTypeSelector.setLayoutData(data);
    }

    @Override
    protected void createClient(Composite parent) {
        this.parentComposite = this.createFlatFormComposite(parent);
        this.createFaultTypeWidgets(this.parentComposite);
        this.createUserDefFaultNameWidgets(this.parentComposite);
        this.createNamespaceWidgets(this.parentComposite);
        this.createFaultNameWidgets(this.parentComposite);
        this.createVariableWidgets(this.parentComposite);
        this.createChangeTrackers();
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.parentComposite, "org.eclipse.bpel.ui.property_fault");
    }

    protected void updateFaultNameWidgets() {
        Assert.isNotNull(this.getInput());
        this.faultNameTracker.stopTracking();
        try {
            String s = ModelHelper.getFaultName(this.getInput());
            if (s == null || "".equals(s)) {
                this.faultNameCombo.setText(Messages.FaultCatchNameSection_None_0);
            } else if (!s.equals(this.faultNameCombo.getText())) {
                if (this.faultNameCombo.indexOf(s) == -1) {
                    s = "";
                }
                this.faultNameCombo.setText(s);
            }
        }
        finally {
            this.faultNameTracker.startTracking();
        }
    }

    protected void updateUserDefFaultNameWidgets() {
        Assert.isNotNull(this.getInput());
        this.faultUserDefNameTracker.stopTracking();
        try {
            String namespace = ModelHelper.getFaultNamespace(this.getInput());
            Vector<QName> faultNames = namespace == null ? this.getFaultNames() : this.getFaultNames(namespace);
            this.faultUserDefCombo.removeAll();
            for (QName faultName : faultNames) {
                if (this.faultUserDefCombo.indexOf(faultName.getLocalPart()) != -1) continue;
                this.faultUserDefCombo.add(faultName.getLocalPart());
            }
            String s = ModelHelper.getFaultName(this.getInput());
            if (s == null) {
                s = "";
            }
            if (!s.equals(this.faultUserDefCombo.getText())) {
                if (this.faultUserDefCombo.indexOf(s) == -1) {
                    this.faultUserDefCombo.setText("");
                } else {
                    this.faultUserDefCombo.setText(s);
                }
            }
        }
        finally {
            this.faultUserDefNameTracker.startTracking();
        }
    }

    protected void updateFaultNamespaceWidgets() {
        Assert.isNotNull(this.getInput());
        this.faultNamespaceTracker.stopTracking();
        try {
            Vector<QName> namespaces = this.getFaultNames();
            this.faultNamespaceCombo.removeAll();
            for (QName qname : namespaces) {
                String uri = NamespaceUtils.convertUriToNamespace(qname.getNamespaceURI());
                if (this.faultNamespaceCombo.indexOf(uri) != -1) continue;
                this.faultNamespaceCombo.add(uri);
            }
            String s = ModelHelper.getFaultNamespace(this.getInput());
            if ((s = NamespaceUtils.convertUriToNamespace(s)) == null) {
                s = "";
            }
            if (!s.equals(this.faultNamespaceCombo.getText())) {
                if (this.faultNamespaceCombo.indexOf(s) == -1) {
                    s = "";
                }
                this.faultNamespaceCombo.setText(s);
            }
        }
        finally {
            this.faultNamespaceTracker.startTracking();
        }
    }

    protected void updateFaultTypeWidgets() {
        Assert.isNotNull(this.getInput());
        String faultNamespace = ModelHelper.getFaultNamespace(this.getInput());
        boolean isBuiltin = this.isBuiltinFault(faultNamespace);
        this.builtinRadio.setSelection(isBuiltin);
        this.userdefRadio.setSelection(!isBuiltin);
        this.doChildLayout();
    }

    protected void updateVariableTypeSelector() {
        Catch _catch = (Catch)this.getInput();
        if (_catch.getFaultVariable() == null) {
            this.variableTypeSelector.setVariableType(null);
            String name = this.variableNameText.getText();
            this.variableTypeSelector.setEnabled(name != null && !"".equals(name));
        } else {
            this.variableTypeSelector.setEnabled(true);
        }
        if (_catch.getFaultMessageType() != null) {
            this.variableTypeSelector.setVariableType((EObject)_catch.getFaultMessageType());
        }
        if (_catch.getFaultElement() != null) {
            this.variableTypeSelector.setVariableType((EObject)_catch.getFaultElement());
        }
    }

    @Override
    public void refresh() {
        super.refresh();
        this.updateFaultTypeWidgets();
        this.updateFaultNamespaceWidgets();
        this.updateUserDefFaultNameWidgets();
        this.updateFaultNameWidgets();
        this.updateVariableWidgets();
    }

    protected void updateVariableWidgets() {
        this.variableNameTracker.stopTracking();
        try {
            Catch _catch = (Catch)this.getInput();
            Variable variable = _catch.getFaultVariable();
            if (variable == null) {
                this.variableNameText.setText("");
            } else {
                this.variableNameText.setText(variable.getName() == null ? "" : variable.getName());
            }
            this.updateVariableTypeSelector();
        }
        finally {
            this.variableNameTracker.startTracking();
        }
    }

    protected String getFaultNameByNamespace(String namespace) {
        Vector<QName> faultNames = this.getFaultNames();
        Assert.isNotNull(faultNames);
        for (QName qname : faultNames) {
            if (!qname.getNamespaceURI().equals(namespace)) continue;
            return qname.getLocalPart();
        }
        return null;
    }

    protected String getNamespaceByFaultName(String faultname) {
        Vector<QName> faultNames = this.getFaultNames();
        Assert.isNotNull(faultNames);
        for (QName qname : faultNames) {
            if (!qname.getLocalPart().equals(faultname)) continue;
            return qname.getNamespaceURI();
        }
        return null;
    }

    protected boolean validNamespaceFaultNameCombination(String namespace, String faultname) {
        Vector<QName> faultNames = this.getFaultNames();
        Assert.isNotNull(faultNames);
        for (QName qname : faultNames) {
            if (!qname.getLocalPart().equals(faultname) || !qname.getNamespaceURI().equals(namespace)) continue;
            return true;
        }
        return false;
    }

    protected void getFaultNames(Object activity) {
        QName name;
        EList activities = null;
        if (activity instanceof Sequence) {
            activities = ((Sequence)activity).getActivities();
        }
        if (activity instanceof Flow) {
            activities = ((Flow)activity).getActivities();
        }
        if (activity instanceof While) {
            this.getFaultNames(((While)activity).getActivity());
        }
        if (activity instanceof RepeatUntil) {
            this.getFaultNames(((RepeatUntil)activity).getActivity());
        }
        if (activity instanceof If) {
            for (ElseIf elif : ((If)activity).getElseIf()) {
                this.getFaultNames(elif.getActivity());
            }
        }
        if (activity instanceof Pick) {
            for (OnMessage onMessage : ((Pick)activity).getMessages()) {
                this.getFaultNames(onMessage.getActivity());
            }
            for (OnAlarm onAlarm : ((Pick)activity).getAlarm()) {
                this.getFaultNames(onAlarm.getActivity());
            }
        }
        if (activity instanceof Scope) {
            Scope scope = (Scope)activity;
            FaultHandler faultHandler = scope.getFaultHandlers();
            if (faultHandler != null) {
                for (Catch c : faultHandler.getCatch()) {
                    this.getFaultNames(c.getActivity());
                }
                CatchAll catchAll = faultHandler.getCatchAll();
                if (catchAll != null) {
                    this.getFaultNames(catchAll.getActivity());
                }
            }
            this.getFaultNames(scope.getActivity());
        }
        if (activities != null) {
            for (Activity subActivity : activities) {
                this.getFaultNames(subActivity);
            }
        }
        if (activity instanceof Throw && (name = ((Throw)activity).getFaultName()) != null) {
            this.faultNameQNames.add(name);
        }
    }

    protected Vector<QName> getFaultNames(String namespace) {
        Vector<QName> result = new Vector<QName>();
        for (QName qname : this.getFaultNames()) {
            if (!qname.getNamespaceURI().equals(namespace)) continue;
            result.add(qname);
        }
        return result;
    }

    protected Vector<QName> getFaultNames() {
        this.faultNameQNames = new Vector();
        if (this.getInput() == null) {
            throw new IllegalStateException();
        }
        Process p = BPELUtils.getProcess(this.getInput());
        this.getFaultNames(p.getActivity());
        for (PartnerLink partnerLink : p.getPartnerLinks().getChildren()) {
            PortType portType;
            Role role = partnerLink.getMyRole();
            if (role == null) {
                role = partnerLink.getPartnerRole();
            }
            if (role == null || (portType = (PortType)role.getPortType()) == null || portType.eIsProxy()) continue;
            for (Operation operation : portType.getEOperations()) {
                Map faults = operation.getFaults();
                if (faults == null || faults.size() <= 0) continue;
                for (Fault fault : faults.values()) {
                    this.faultNameQNames.add(new QName(portType.getQName().getNamespaceURI(), fault.getName()));
                }
            }
        }
        return this.faultNameQNames;
    }

    @Override
    public Object getUserContext() {
        FaultCatchContext result = new FaultCatchContext(this.lastChangeContext);
        if (this.lastChangeContext == 7) {
            result.innerContext = this.variableTypeSelector.getUserContext();
        }
        return result;
    }

    @Override
    public void restoreUserContext(Object userContext) {
        FaultCatchContext c = (FaultCatchContext)userContext;
        switch (c.context) {
            case 0: {
                this.faultNameCombo.setFocus();
                return;
            }
            case 1: {
                this.faultNamespaceCombo.setFocus();
                return;
            }
            case 3: {
                this.builtinRadio.setFocus();
                return;
            }
            case 4: {
                this.userdefRadio.setFocus();
                return;
            }
            case 5: {
                this.faultUserDefCombo.setFocus();
                return;
            }
            case 6: {
                this.variableNameText.setFocus();
                return;
            }
            case 7: {
                this.variableTypeSelector.restoreUserContext(c.innerContext);
                return;
            }
        }
        throw new IllegalStateException();
    }

    private Command getCreateNewVariableCommand() {
        return new AutoUndoCommand((EObject)this.getProcess()){

            @Override
            public void doExecute() {
                CompoundCommand result = new CompoundCommand();
                Catch _catch = (Catch)FaultCatchNameSection.this.getInput();
                Variable variable = _catch.getFaultVariable();
                QName faultQName = ModelHelper.getFaultQName(FaultCatchNameSection.this.getInput());
                Message type = FaultCatchNameSection.this.getFaultMessage(faultQName);
                variable = BPELFactory.eINSTANCE.createVariable();
                variable.setMessageType(type);
                result.add((Command)new SetVariableCommand((EObject)_catch, variable, 1));
                String name = FaultCatchNameSection.this.variableNameText.getText();
                if (name == null || "".equals(name)) {
                    String hint = BPELPackage.eINSTANCE.getVariable().getName();
                    name = BPELUtil.getUniqueModelName((EObject)FaultCatchNameSection.this.getProcess(), hint, null);
                }
                result.add((Command)new SetNameCommand((EObject)variable, name));
                result.execute();
            }
        };
    }

    protected Message getFaultMessage(QName faultQName) {
        if (faultQName == null || faultQName.getNamespaceURI() == null || faultQName.getLocalPart() == null) {
            return null;
        }
        Definition[] definitions = this.getDefinitions(faultQName.getNamespaceURI());
        int i = 0;
        while (i < definitions.length) {
            Definition definition = definitions[i];
            for (PortType portType : definition.getEPortTypes()) {
                for (Operation operation : portType.getOperations()) {
                    Fault fault = (Fault)operation.getFault(faultQName.getLocalPart());
                    if (fault == null) continue;
                    return fault.getEMessage();
                }
            }
            ++i;
        }
        return this.getMessageFromThrow(faultQName);
    }

    protected Definition[] getDefinitions(String namespace) {
        ArrayList<Definition> result = new ArrayList<Definition>();
        EList imports = this.getProcess().getImports();
        if (imports != null) {
            for (Import _import : imports) {
                if (!"http://schemas.xmlsoap.org/wsdl/".equals(_import.getImportType()) || !namespace.equals(_import.getNamespace())) continue;
                result.add(WSDLImportHelper.getDefinition(_import));
            }
        }
        return result.toArray(new Definition[result.size()]);
    }

    protected Message getMessageFromThrow(QName faultQName) {
        EObject container = this.getInput().eContainer().eContainer();
        if (!(container instanceof Scope)) {
            return null;
        }
        Scope scope = (Scope)container;
        TreeIterator iter = scope.eAllContents();
        while (iter.hasNext()) {
            Throw t;
            Object element = iter.next();
            if (!(element instanceof Throw) || !faultQName.equals((t = (Throw)element).getFaultName()) || t.getFaultVariable() == null) continue;
            return t.getFaultVariable().getMessageType();
        }
        return null;
    }

    protected boolean isEmptyMessageType(String newName) {
        return Messages.FaultCatchNameSection_None_0.equals(newName) && this.builtinRadio.getSelection();
    }

    protected List<String> getBuiltinFaultNames() {
        ArrayList<String> faultNames = new ArrayList<String>();
        faultNames.add(Messages.FaultCatchNameSection_None_0);
        faultNames.addAll(Arrays.asList(BPELConstants.standardFaults));
        return faultNames;
    }

    protected boolean isBuiltinFault(String faultNamespace) {
        boolean isBuiltin = BPELConstants.NAMESPACE.equals(faultNamespace);
        if (faultNamespace == null && ModelHelper.getFaultName(this.getInput()) == null) {
            isBuiltin = true;
        }
        return isBuiltin;
    }

    public static class FaultCatchContext {
        public int context;
        public Object innerContext;

        FaultCatchContext(int context) {
            this.context = context;
        }
    }

    public class FaultVariableTypeCallback
    implements VariableTypeSelector.Callback {
        protected void store(final EObject type) {
            final Catch _catch = (Catch)FaultCatchNameSection.this.getInput();
            CompoundCommand command = new CompoundCommand();
            command.add((Command)new AutoUndoCommand((EObject)FaultCatchNameSection.this.getProcess()){

                @Override
                public void doExecute() {
                    Variable variable = _catch.getFaultVariable();
                    if (variable == null) {
                        variable = BPELFactory.eINSTANCE.createVariable();
                        _catch.setFaultVariable(variable);
                    }
                    if (type instanceof Message) {
                        _catch.setFaultMessageType((Message)type);
                        _catch.setFaultElement(null);
                    } else if (type instanceof XSDElementDeclaration) {
                        _catch.setFaultMessageType(null);
                        _catch.setFaultElement((XSDElementDeclaration)type);
                    }
                }
            });
            FaultCatchNameSection.this.getCommandFramework().execute(FaultCatchNameSection.this.wrapInShowContextCommand((Command)command));
        }

        @Override
        public void selectRadioButton(final int index) {
            final Catch _catch = (Catch)FaultCatchNameSection.this.getInput();
            Variable variable = _catch.getFaultVariable();
            if (variable == null) {
                variable = BPELFactory.eINSTANCE.createVariable();
            }
            final Variable variable2 = variable;
            CompoundCommand command = new CompoundCommand();
            command.add((Command)new AutoUndoCommand((EObject)FaultCatchNameSection.this.getProcess()){

                @Override
                public void doExecute() {
                    if (_catch.getFaultVariable() != variable2) {
                        _catch.setFaultVariable(variable2);
                    }
                    ModelHelper.createExtensionIfNecessary(FaultCatchNameSection.this.getBPELEditor().getExtensionMap(), (EObject)variable2);
                    _catch.setFaultMessageType(null);
                    VariableExtension varExt = (VariableExtension)ModelHelper.getExtension((EObject)variable2);
                    if (varExt.getVariableKind() != index) {
                        new SetVariableKindCommand(varExt, index).execute();
                    }
                }
            });
            if (!command.isEmpty()) {
                FaultCatchNameSection.this.getCommandFramework().execute(FaultCatchNameSection.this.wrapInShowContextCommand((Command)command));
            }
        }

        @Override
        public void selectXSDType(XSDTypeDefinition xsdType) {
            MessageDialog.openError(null, (String)Messages.SelectionAndCreationDialog_Error_2, (String)Messages.FaultCatchNameSection_Error_Invalid_Type);
        }

        @Override
        public void selectXSDElement(XSDElementDeclaration xsdElement) {
            this.store((EObject)xsdElement);
        }

        @Override
        public void selectMessageType(Message message) {
            this.store((EObject)message);
        }
    }
}

