/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.cmake.is.core.participant.builtins;

import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.cdt.cmake.is.core.participant.IRawIndexerInfoCollector;
import org.eclipse.cdt.cmake.is.core.participant.builtins.IBuiltinsOutputProcessor;
import org.eclipse.cdt.core.settings.model.ICLanguageSettingEntry;
import org.eclipse.cdt.core.settings.model.util.CDataUtil;

public final class GccOutputProcessor
implements IBuiltinsOutputProcessor {
    private static final OutputLineProcessor[] macros = new OutputLineProcessor[]{new OutputLineProcessor("#define\\s+(\\S+)\\s*(.*)", 1, 2, false, 0), new OutputLineProcessor("#define\\s+(\\S+)\\(.*?\\)\\s*(.*)", 1, 2, false, 0)};
    private static final OutputLineProcessor[] localIncludes = new OutputLineProcessor[]{new OutputLineProcessor(" *(\\S.*)", 1, -1, true, 4)};
    private static final OutputLineProcessor[] systemIncludes = new OutputLineProcessor[]{new OutputLineProcessor(" *(\\S.*)", 1, -1, true, 0)};
    private static final OutputLineProcessor[] frameworks = new OutputLineProcessor[]{new OutputLineProcessor(" *(\\S.*)", 1, -1, true, 64)};
    private State state = State.NONE;

    @Override
    public void processLine(String line, IRawIndexerInfoCollector infoCollector) {
        if (line.equals("#include \"...\" search starts here:")) {
            this.state = State.EXPECTING_LOCAL_INCLUDE;
            return;
        }
        if (line.equals("#include <...> search starts here:")) {
            this.state = State.EXPECTING_SYSTEM_INCLUDE;
            return;
        }
        if (line.startsWith("End of search list.")) {
            this.state = State.NONE;
            return;
        }
        if (line.equals("Framework search starts here:")) {
            this.state = State.EXPECTING_FRAMEWORK;
            return;
        }
        if (line.startsWith("End of framework search list.")) {
            this.state = State.NONE;
            return;
        }
        if (this.state == State.EXPECTING_LOCAL_INCLUDE) {
            OutputLineProcessor[] outputLineProcessorArray = localIncludes;
            int n = localIncludes.length;
            int n2 = 0;
            while (n2 < n) {
                OutputLineProcessor processor = outputLineProcessorArray[n2];
                Optional<ICLanguageSettingEntry> result = processor.process(line);
                if (result.isPresent()) {
                    infoCollector.addIncludePath(result.get().getName());
                    return;
                }
                ++n2;
            }
        } else if (this.state == State.EXPECTING_SYSTEM_INCLUDE) {
            OutputLineProcessor[] outputLineProcessorArray = systemIncludes;
            int n = systemIncludes.length;
            int n3 = 0;
            while (n3 < n) {
                OutputLineProcessor processor = outputLineProcessorArray[n3];
                Optional<ICLanguageSettingEntry> result = processor.process(line);
                if (result.isPresent()) {
                    infoCollector.addSystemIncludePath(result.get().getName());
                    return;
                }
                ++n3;
            }
        } else if (this.state == State.EXPECTING_FRAMEWORK) {
            OutputLineProcessor[] outputLineProcessorArray = frameworks;
            int n = frameworks.length;
            int n4 = 0;
            while (n4 < n) {
                OutputLineProcessor processor = outputLineProcessorArray[n4];
                Optional<ICLanguageSettingEntry> result = processor.process(line);
                if (result.isPresent()) {
                    return;
                }
                ++n4;
            }
        } else {
            OutputLineProcessor[] outputLineProcessorArray = macros;
            int n = macros.length;
            int n5 = 0;
            while (n5 < n) {
                OutputLineProcessor processor = outputLineProcessorArray[n5];
                Optional<ICLanguageSettingEntry> result = processor.process(line);
                if (result.isPresent()) {
                    ICLanguageSettingEntry settingEntry = result.get();
                    infoCollector.addDefine(settingEntry.getName(), settingEntry.getValue());
                    return;
                }
                ++n5;
            }
        }
    }

    private static class OutputLineProcessor {
        private final Pattern pattern;
        private final int nameGroup;
        private final int valueGroup;
        private final int kind;
        private final int extraFlag;

        public OutputLineProcessor(String pattern, int nameGroup, int valueGroup, boolean isIncludePath, int extraFlag) {
            this.pattern = Pattern.compile(pattern);
            this.nameGroup = nameGroup;
            this.valueGroup = valueGroup;
            this.kind = isIncludePath ? 1 : 4;
            this.extraFlag = extraFlag;
        }

        protected Optional<ICLanguageSettingEntry> process(String line) {
            Matcher matcher = this.pattern.matcher(line);
            if (matcher.matches()) {
                String name = matcher.group(this.nameGroup);
                String value = this.valueGroup == -1 ? null : matcher.group(this.valueGroup);
                return Optional.of((ICLanguageSettingEntry)CDataUtil.createEntry((int)this.kind, (String)name, (String)value, null, (int)(3 | this.extraFlag)));
            }
            return Optional.empty();
        }
    }

    private static enum State {
        NONE,
        EXPECTING_LOCAL_INCLUDE,
        EXPECTING_SYSTEM_INCLUDE,
        EXPECTING_FRAMEWORK;

    }
}

