/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.qt.ui.editor;

import java.io.File;
import java.util.List;
import javax.script.Bindings;
import javax.script.ScriptException;
import org.eclipse.cdt.internal.qt.core.Activator;
import org.eclipse.cdt.qt.core.IQMLAnalyzer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.texteditor.ITextEditor;

public class QMLHyperlink
implements IHyperlink {
    private final IRegion region;
    private final ITextViewer viewer;
    private final ITextEditor editor;

    public QMLHyperlink(IRegion region, ITextViewer viewer, ITextEditor editor) {
        this.region = region;
        this.viewer = viewer;
        this.editor = editor;
    }

    public IRegion getHyperlinkRegion() {
        return this.region;
    }

    public String getTypeLabel() {
        return null;
    }

    public String getHyperlinkText() {
        return "Open Declaration";
    }

    public void open() {
        IQMLAnalyzer analyzer = (IQMLAnalyzer)Activator.getService(IQMLAnalyzer.class);
        if (analyzer == null || !analyzer.isSupported()) {
            return;
        }
        try {
            IDocument document = this.viewer.getDocument();
            String selected = document.get(this.region.getOffset(), this.region.getLength());
            IFileEditorInput fileInput = (IFileEditorInput)this.editor.getEditorInput();
            String fileName = new File(fileInput.getFile().getLocationURI()).getAbsolutePath().substring(1);
            List definitions = analyzer.getDefinition(selected, fileName, document.get(), this.region.getOffset() + this.region.getLength());
            if (!definitions.isEmpty()) {
                Bindings definition = (Bindings)definitions.iterator().next();
                Bindings start = (Bindings)definition.get("start");
                if (start == null) {
                    return;
                }
                int startLine = (int)((Double)start.get("line")).doubleValue();
                int startChar = (int)((Double)start.get("ch")).doubleValue();
                int startOffset = document.getLineOffset(startLine) + startChar;
                Bindings end = (Bindings)definition.get("end");
                int endLine = (int)((Double)end.get("line")).doubleValue();
                int endChar = (int)((Double)end.get("ch")).doubleValue();
                int endOffset = document.getLineOffset(endLine) + endChar;
                String target = (String)definition.get("file");
                if (fileName.equals(target)) {
                    this.editor.selectAndReveal(startOffset, endOffset - startOffset);
                } else {
                    IEditorPart part;
                    IFile[] targetFiles = ResourcesPlugin.getWorkspace().getRoot().findFilesForLocationURI(new File("/" + target).toURI());
                    if (targetFiles.length > 0 && (part = IDE.openEditor((IWorkbenchPage)this.editor.getEditorSite().getPage(), (IFile)targetFiles[0])) instanceof ITextEditor) {
                        ((ITextEditor)part).selectAndReveal(startOffset, endOffset - startOffset);
                    }
                }
            }
        }
        catch (NoSuchMethodException | ScriptException | BadLocationException | PartInitException e) {
            Activator.log((Throwable)e);
        }
    }
}

