/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.debug.ui;

import java.util.HashMap;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IElementLabelProvider;
import org.eclipse.debug.ui.actions.IWatchExpressionFactoryAdapter;
import org.eclipse.dltk.debug.core.model.IScriptDebugTarget;
import org.eclipse.dltk.debug.core.model.IScriptVariable;
import org.eclipse.dltk.debug.ui.ScriptWatchExpressionFilter;
import org.eclipse.dltk.internal.debug.ui.variables.ScriptVariableLabelProvider;
import org.eclipse.dltk.ui.DLTKUILanguageManager;
import org.eclipse.jface.preference.IPreferenceStore;

public class ScriptDebugElementAdapterFactory
implements IAdapterFactory {
    private static ScriptDebugElementAdapterFactory instance;
    private final HashMap<String, ScriptVariableLabelProvider> variableLabelProviders = new HashMap(1, 1.0f);
    private static final IWatchExpressionFactoryAdapter watchExpressionFactory;

    static {
        watchExpressionFactory = new ScriptWatchExpressionFilter();
    }

    public static synchronized ScriptDebugElementAdapterFactory getInstance() {
        if (instance == null) {
            instance = new ScriptDebugElementAdapterFactory();
        }
        return instance;
    }

    private ScriptDebugElementAdapterFactory() {
    }

    public <T> T getAdapter(Object adaptableObject, Class<T> adapterType) {
        if (IElementLabelProvider.class.equals(adapterType) && adaptableObject instanceof IScriptVariable) {
            return (T)((Object)this.getVariableLabelProvider((IDebugElement)adaptableObject));
        }
        if (IWatchExpressionFactoryAdapter.class.equals(adapterType) && adaptableObject instanceof IScriptVariable) {
            return (T)watchExpressionFactory;
        }
        return null;
    }

    public Class<?>[] getAdapterList() {
        return new Class[]{IElementLabelProvider.class, IWatchExpressionFactoryAdapter.class};
    }

    public void dispose() {
        this.disposeVariableLabelProviders();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void disposeVariableLabelProviders() {
        HashMap<String, ScriptVariableLabelProvider> hashMap = this.variableLabelProviders;
        synchronized (hashMap) {
            for (ScriptVariableLabelProvider provider : this.variableLabelProviders.values()) {
                provider.dispose();
            }
            this.variableLabelProviders.clear();
        }
    }

    private IPreferenceStore getPreferenceStore(IDebugElement element) {
        String natureId = ((IScriptDebugTarget)element.getDebugTarget()).getLanguageToolkit().getNatureId();
        return DLTKUILanguageManager.getLanguageToolkit((String)natureId).getPreferenceStore();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ScriptVariableLabelProvider getVariableLabelProvider(IDebugElement toAdapt) {
        ScriptVariableLabelProvider provider;
        String id = toAdapt.getModelIdentifier();
        HashMap<String, ScriptVariableLabelProvider> hashMap = this.variableLabelProviders;
        synchronized (hashMap) {
            provider = this.variableLabelProviders.get(id);
            if (provider == null) {
                provider = new ScriptVariableLabelProvider(this.getPreferenceStore(toAdapt));
                this.variableLabelProviders.put(id, provider);
            }
        }
        return provider;
    }
}

