/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.tools.emf.editor3x.refactorparticipants;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.e4.tools.emf.editor3x.Messages;
import org.eclipse.e4.tools.emf.editor3x.RefactorModel;
import org.eclipse.e4.tools.emf.editor3x.extension.Util;
import org.eclipse.e4.tools.emf.editor3x.refactorparticipants.RefactorParticipantDelegate;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.MoveParticipant;
import org.eclipse.ltk.core.refactoring.participants.RefactoringParticipant;

public class ModelMoveParticipant
extends MoveParticipant {
    private IType fType;
    private IPackageFragment fPckage;
    private IFile fFile;
    private RefactorModel fModel;

    protected boolean initialize(Object pElement) {
        this.fModel = RefactorModel.getModel((RefactoringParticipant)this);
        if (pElement instanceof IType) {
            this.fType = (IType)pElement;
            return true;
        }
        if (pElement instanceof IPackageFragment) {
            this.fPckage = (IPackageFragment)pElement;
            return true;
        }
        if (pElement instanceof IFile) {
            this.fFile = (IFile)pElement;
            return true;
        }
        return false;
    }

    public String getName() {
        return "Workbench Model Contribution Participant";
    }

    public RefactoringStatus checkConditions(IProgressMonitor pMonitor, CheckConditionsContext pContext) throws OperationCanceledException {
        return new RefactoringStatus();
    }

    public Change createChange(IProgressMonitor pMonitor) throws CoreException, OperationCanceledException {
        pMonitor.beginTask(Messages.ModelMoveParticipant_CreatingChange, -1);
        Change change = null;
        if (this.fType != null) {
            change = this.createClassChange(pMonitor, this.fType);
        } else if (this.fPckage != null) {
            change = this.createPackageChange(pMonitor, this.fPckage);
        } else if (this.fFile != null) {
            change = this.createFileChange(pMonitor, this.fFile);
        }
        pMonitor.done();
        return change;
    }

    private Change createFileChange(IProgressMonitor pMonitor, IFile file) throws CoreException {
        String newUrl = "platform:/plugin/";
        if (this.getArguments().getDestination() instanceof IFolder) {
            IFolder folder = (IFolder)this.getArguments().getDestination();
            newUrl = String.valueOf(newUrl) + folder.getProject().getName() + "/" + folder.getProjectRelativePath().toString() + "/" + file.getName();
        } else {
            IProject project = (IProject)this.getArguments().getDestination();
            newUrl = String.valueOf(newUrl) + project.getName() + "/" + file.getName();
        }
        String oldUrl = "platform:/plugin" + file.getFullPath();
        this.fModel.addTextRename(oldUrl, newUrl);
        return RefactorParticipantDelegate.createChange(pMonitor, this.fModel);
    }

    private Change createPackageChange(IProgressMonitor pMonitor, IPackageFragment pPckage) throws CoreException, OperationCanceledException {
        String fromBundle = Util.getBundleSymbolicName(pPckage.getJavaProject().getProject());
        IPackageFragmentRoot fragmentRoot = (IPackageFragmentRoot)this.getArguments().getDestination();
        String toBundle = Util.getBundleSymbolicName(fragmentRoot.getJavaProject().getProject());
        String newUrl = "bundleclass://" + toBundle + "/" + pPckage.getElementName();
        String oldUrl = "bundleclass://" + fromBundle + "/" + pPckage.getElementName();
        this.fModel.addTextRename(oldUrl, newUrl);
        return RefactorParticipantDelegate.createChange(pMonitor, this.fModel);
    }

    private Change createClassChange(IProgressMonitor pMonitor, IType pType) throws CoreException, OperationCanceledException {
        String fromBundle = Util.getBundleSymbolicName(this.fType.getJavaProject().getProject());
        String fromClassname = pType.getFullyQualifiedName();
        IPackageFragment fragment = (IPackageFragment)this.getArguments().getDestination();
        String toBundle = Util.getBundleSymbolicName(fragment.getJavaProject().getProject());
        String toClassName = fragment.getElementName().length() == 0 ? pType.getElementName() : String.valueOf(fragment.getElementName()) + "." + pType.getElementName();
        return RefactorParticipantDelegate.createChange(pMonitor, this.fModel.addTextRename("bundleclass://" + fromBundle + "/" + fromClassname, "bundleclass://" + toBundle + "/" + toClassName));
    }
}

