/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.core.synchronize;

import java.io.UnsupportedEncodingException;
import java.util.Date;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.core.variants.IResourceVariant;

class GitLocalResourceVariant
implements IResourceVariant {
    private final IResource resource;

    GitLocalResourceVariant(IResource resource) {
        this.resource = resource;
    }

    public byte[] asBytes() {
        try {
            return this.getContentIdentifier().getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public String getContentIdentifier() {
        return new Date(this.resource.getLocalTimeStamp()).toString();
    }

    public IStorage getStorage(IProgressMonitor monitor) throws TeamException {
        if (this.resource.getType() == 1) {
            return (IFile)this.resource;
        }
        return null;
    }

    public boolean isContainer() {
        return this.resource.getType() != 1;
    }

    public String getName() {
        return this.resource.getName();
    }

    IResource getResource() {
        return this.resource;
    }
}

