/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.mvc.fx.gestures;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.scene.Scene;
import org.eclipse.gef.common.activate.ActivatableSupport;
import org.eclipse.gef.common.activate.IActivatable;
import org.eclipse.gef.mvc.fx.domain.IDomain;
import org.eclipse.gef.mvc.fx.gestures.IGesture;
import org.eclipse.gef.mvc.fx.gestures.IHandlerResolver;
import org.eclipse.gef.mvc.fx.handlers.IHandler;
import org.eclipse.gef.mvc.fx.viewer.IViewer;

public abstract class AbstractGesture
implements IGesture {
    private ActivatableSupport acs = new ActivatableSupport((IActivatable)this);
    private ReadOnlyObjectWrapper<IDomain> domainProperty = new ReadOnlyObjectWrapper();
    private Map<IViewer, List<IHandler>> activeHandlers = new IdentityHashMap<IViewer, List<IHandler>>();
    private final Map<IViewer, ChangeListener<Boolean>> viewerFocusChangeListeners = new IdentityHashMap<IViewer, ChangeListener<Boolean>>();
    private final Map<ObservableValue<Scene>, ChangeListener<? super Scene>> sceneChangeListeners = new IdentityHashMap<ObservableValue<Scene>, ChangeListener<? super Scene>>();
    private final Set<Scene> hookedScenes = Collections.newSetFromMap(new IdentityHashMap());

    protected void abortPolicies(IViewer viewer) {
        this.doAbortPolicies(viewer);
        this.clearActiveHandlers(viewer);
        this.getDomain().closeExecutionTransaction(this);
    }

    public final void activate() {
        this.acs.activate(null, this::doActivate);
    }

    public final ReadOnlyBooleanProperty activeProperty() {
        return this.acs.activeProperty();
    }

    public ReadOnlyObjectProperty<IDomain> adaptableProperty() {
        return this.domainProperty.getReadOnlyProperty();
    }

    protected void clearActiveHandlers(IViewer viewer) {
        if (viewer == null) {
            throw new IllegalArgumentException("The given viewer may not be null.");
        }
        this.activeHandlers.remove(viewer);
    }

    protected ChangeListener<Boolean> createFocusChangeListener(final IViewer viewer) {
        ChangeListener<Boolean> viewerFocusChangeListener = new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                if (newValue == null || !newValue.booleanValue()) {
                    AbstractGesture.this.abortPolicies(viewer);
                }
            }
        };
        return viewerFocusChangeListener;
    }

    public final void deactivate() {
        this.acs.deactivate(this::doDeactivate, null);
    }

    protected void doAbortPolicies(IViewer viewer) {
    }

    protected void doActivate() {
        ChangeListener sceneListener = (exp, oldScene, newScene) -> {
            if (oldScene != null && this.getDomain().getViewers().values().stream().noneMatch(v -> v.getCanvas().getScene() == oldScene)) {
                this.unhookScene((Scene)oldScene);
            }
            if (newScene != null) {
                this.hookScene((Scene)newScene);
            }
        };
        for (IViewer viewer : this.getDomain().getViewers().values()) {
            ChangeListener<Boolean> viewerFocusChangeListener = this.createFocusChangeListener(viewer);
            viewer.viewerFocusedProperty().addListener(viewerFocusChangeListener);
            this.viewerFocusChangeListeners.put(viewer, viewerFocusChangeListener);
            ReadOnlyObjectProperty sceneProperty = viewer.getCanvas().sceneProperty();
            sceneProperty.addListener(sceneListener);
            this.sceneChangeListeners.put((ObservableValue<Scene>)sceneProperty, (ChangeListener<? super Scene>)sceneListener);
            if (sceneProperty.get() == null) continue;
            sceneListener.changed((ObservableValue)sceneProperty, null, sceneProperty.get());
        }
    }

    protected void doDeactivate() {
        for (Map.Entry<ObservableValue<Scene>, ChangeListener<? super Scene>> entry : this.sceneChangeListeners.entrySet()) {
            ObservableValue<Scene> sceneProperty = entry.getKey();
            sceneProperty.removeListener(entry.getValue());
        }
        this.sceneChangeListeners.clear();
        for (IViewer viewer : new ArrayList<IViewer>(this.viewerFocusChangeListeners.keySet())) {
            viewer.viewerFocusedProperty().removeListener(this.viewerFocusChangeListeners.remove(viewer));
        }
        this.viewerFocusChangeListeners.clear();
        for (Scene scene : this.hookedScenes) {
            this.unhookScene(scene);
        }
    }

    protected void doHookScene(Scene scene) {
    }

    protected void doUnhookScene(Scene scene) {
    }

    @Override
    public List<? extends IHandler> getActiveHandlers(IViewer viewer) {
        if (this.activeHandlers.containsKey(viewer)) {
            return Collections.unmodifiableList(this.activeHandlers.get(viewer));
        }
        return Collections.emptyList();
    }

    public IDomain getAdaptable() {
        return (IDomain)this.domainProperty.get();
    }

    @Override
    public IDomain getDomain() {
        return this.getAdaptable();
    }

    protected IHandlerResolver getHandlerResolver() {
        return (IHandlerResolver)this.getDomain().getAdapter(IHandlerResolver.class);
    }

    protected void hookScene(Scene newScene) {
        if (this.hookedScenes.contains(newScene)) {
            return;
        }
        this.hookedScenes.add(newScene);
        this.doHookScene(newScene);
    }

    public final boolean isActive() {
        return this.acs.isActive();
    }

    protected void setActiveHandlers(IViewer viewer, Collection<? extends IHandler> activeHandlers) {
        if (viewer == null) {
            throw new IllegalArgumentException("The given viewer may not be null.");
        }
        if (activeHandlers == null) {
            throw new IllegalArgumentException("The given activePolicies may not be null.");
        }
        for (IHandler iHandler : activeHandlers) {
            if (iHandler.getHost().getViewer() == viewer) continue;
            throw new IllegalArgumentException("Resolved handler is not hosted within viewer.");
        }
        this.clearActiveHandlers(viewer);
        this.activeHandlers.put(viewer, new ArrayList<IHandler>(activeHandlers));
    }

    public void setAdaptable(IDomain adaptable) {
        if (this.isActive()) {
            throw new IllegalStateException("The reference to the IDomain may not be changed while the gesture is active. Please deactivate the gesture before setting the IEditDomain and re-activate it afterwards.");
        }
        this.domainProperty.set((Object)adaptable);
    }

    protected void unhookScene(Scene oldScene) {
        if (this.hookedScenes.contains(oldScene)) {
            this.doUnhookScene(oldScene);
            this.hookedScenes.remove(oldScene);
        }
    }
}

