/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.mvc.fx.gestures;

import com.google.common.reflect.TypeToken;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javafx.scene.Node;
import org.eclipse.gef.common.adapt.IAdaptable;
import org.eclipse.gef.mvc.fx.domain.IDomain;
import org.eclipse.gef.mvc.fx.gestures.IGesture;
import org.eclipse.gef.mvc.fx.gestures.IHandlerResolver;
import org.eclipse.gef.mvc.fx.handlers.IHandler;
import org.eclipse.gef.mvc.fx.parts.IVisualPart;
import org.eclipse.gef.mvc.fx.parts.PartUtils;
import org.eclipse.gef.mvc.fx.viewer.IViewer;

public class DefaultHandlerResolver
extends IAdaptable.Bound.Impl<IDomain>
implements IHandlerResolver {
    @Override
    public <T extends IHandler> List<? extends T> resolve(IGesture gesture, Node target, IViewer viewer, Class<T> handlerType) {
        IVisualPart<? extends Node> targetPart;
        ArrayList<IHandler> outerTargetHandlers = new ArrayList<IHandler>();
        Collection gestures = viewer.getDomain().getAdapters((TypeToken)new TypeToken<IGesture>(){}).values();
        for (IGesture g : gestures) {
            if (g == gesture) continue;
            for (IHandler iHandler : g.getActiveHandlers(viewer)) {
                if (!iHandler.getClass().isAssignableFrom(handlerType)) continue;
                try {
                    outerTargetHandlers.add(iHandler);
                }
                catch (ClassCastException classCastException) {
                    // empty catch block
                }
            }
        }
        if (!outerTargetHandlers.isEmpty()) {
            return outerTargetHandlers;
        }
        IVisualPart<? extends Node> part = targetPart = PartUtils.retrieveVisualPart(viewer, target);
        ArrayList arrayList = new ArrayList();
        while (part != null && arrayList.isEmpty()) {
            arrayList.addAll(part.getAdapters(handlerType).values());
            part = part.getParent();
        }
        return arrayList;
    }
}

