/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.dom;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.core.dom.ASTMatcher;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.AssertStatement;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.BreakStatement;
import org.eclipse.jdt.core.dom.ConditionalExpression;
import org.eclipse.jdt.core.dom.ConstructorInvocation;
import org.eclipse.jdt.core.dom.ContinueStatement;
import org.eclipse.jdt.core.dom.DoStatement;
import org.eclipse.jdt.core.dom.EmptyStatement;
import org.eclipse.jdt.core.dom.EnhancedForStatement;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ExpressionStatement;
import org.eclipse.jdt.core.dom.ForStatement;
import org.eclipse.jdt.core.dom.IfStatement;
import org.eclipse.jdt.core.dom.InfixExpression;
import org.eclipse.jdt.core.dom.LabeledStatement;
import org.eclipse.jdt.core.dom.ParenthesizedExpression;
import org.eclipse.jdt.core.dom.PostfixExpression;
import org.eclipse.jdt.core.dom.PrefixExpression;
import org.eclipse.jdt.core.dom.ReturnStatement;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.SuperConstructorInvocation;
import org.eclipse.jdt.core.dom.SwitchStatement;
import org.eclipse.jdt.core.dom.SynchronizedStatement;
import org.eclipse.jdt.core.dom.ThrowStatement;
import org.eclipse.jdt.core.dom.TryStatement;
import org.eclipse.jdt.core.dom.TypeDeclarationStatement;
import org.eclipse.jdt.core.dom.VariableDeclarationStatement;
import org.eclipse.jdt.core.dom.WhileStatement;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;

public class ASTSemanticMatcher
extends ASTMatcher {
    public static final ASTSemanticMatcher INSTANCE = new ASTSemanticMatcher();
    private static final Map<PrefixExpression.Operator, InfixExpression.Operator> PREFIX_TO_INFIX_OPERATOR = new HashMap<PrefixExpression.Operator, InfixExpression.Operator>(){
        private static final long serialVersionUID = -8949107654517355855L;
        {
            this.put(PrefixExpression.Operator.INCREMENT, InfixExpression.Operator.PLUS);
            this.put(PrefixExpression.Operator.DECREMENT, InfixExpression.Operator.MINUS);
        }
    };
    private static final Map<PrefixExpression.Operator, Assignment.Operator> PREFIX_TO_ASSIGN_OPERATOR = new HashMap<PrefixExpression.Operator, Assignment.Operator>(){
        private static final long serialVersionUID = -8949107654517355856L;
        {
            this.put(PrefixExpression.Operator.INCREMENT, Assignment.Operator.PLUS_ASSIGN);
            this.put(PrefixExpression.Operator.DECREMENT, Assignment.Operator.MINUS_ASSIGN);
        }
    };
    private static final Map<PostfixExpression.Operator, InfixExpression.Operator> POSTFIX_TO_INFIX_OPERATOR = new HashMap<PostfixExpression.Operator, InfixExpression.Operator>(){
        private static final long serialVersionUID = -8949107654517355857L;
        {
            this.put(PostfixExpression.Operator.INCREMENT, InfixExpression.Operator.PLUS);
            this.put(PostfixExpression.Operator.DECREMENT, InfixExpression.Operator.MINUS);
        }
    };
    private static final Map<PostfixExpression.Operator, Assignment.Operator> POSTFIX_TO_ASSIGN_OPERATOR = new HashMap<PostfixExpression.Operator, Assignment.Operator>(){
        private static final long serialVersionUID = -8949107654517355858L;
        {
            this.put(PostfixExpression.Operator.INCREMENT, Assignment.Operator.PLUS_ASSIGN);
            this.put(PostfixExpression.Operator.DECREMENT, Assignment.Operator.MINUS_ASSIGN);
        }
    };
    private static final Map<PrefixExpression.Operator, PostfixExpression.Operator> PREFIX_TO_POSTFIX_OPERATOR = new HashMap<PrefixExpression.Operator, PostfixExpression.Operator>(){
        private static final long serialVersionUID = -8949107654517355859L;
        {
            this.put(PrefixExpression.Operator.INCREMENT, PostfixExpression.Operator.INCREMENT);
            this.put(PrefixExpression.Operator.DECREMENT, PostfixExpression.Operator.DECREMENT);
        }
    };
    private static final Map<Assignment.Operator, InfixExpression.Operator> ASSIGN_TO_INFIX_OPERATOR = new HashMap<Assignment.Operator, InfixExpression.Operator>(){
        private static final long serialVersionUID = -8949107654517355859L;
        {
            this.put(Assignment.Operator.PLUS_ASSIGN, InfixExpression.Operator.PLUS);
            this.put(Assignment.Operator.MINUS_ASSIGN, InfixExpression.Operator.MINUS);
            this.put(Assignment.Operator.TIMES_ASSIGN, InfixExpression.Operator.TIMES);
            this.put(Assignment.Operator.DIVIDE_ASSIGN, InfixExpression.Operator.DIVIDE);
            this.put(Assignment.Operator.BIT_AND_ASSIGN, InfixExpression.Operator.AND);
            this.put(Assignment.Operator.BIT_OR_ASSIGN, InfixExpression.Operator.OR);
            this.put(Assignment.Operator.BIT_XOR_ASSIGN, InfixExpression.Operator.XOR);
            this.put(Assignment.Operator.REMAINDER_ASSIGN, InfixExpression.Operator.REMAINDER);
            this.put(Assignment.Operator.LEFT_SHIFT_ASSIGN, InfixExpression.Operator.LEFT_SHIFT);
            this.put(Assignment.Operator.RIGHT_SHIFT_SIGNED_ASSIGN, InfixExpression.Operator.RIGHT_SHIFT_SIGNED);
            this.put(Assignment.Operator.RIGHT_SHIFT_UNSIGNED_ASSIGN, InfixExpression.Operator.RIGHT_SHIFT_UNSIGNED);
        }
    };
    private static final Map<InfixExpression.Operator, InfixExpression.Operator> INFIX_TO_MIRROR_OPERATOR = new HashMap<InfixExpression.Operator, InfixExpression.Operator>(){
        private static final long serialVersionUID = -8949107654517355857L;
        {
            this.put(InfixExpression.Operator.EQUALS, InfixExpression.Operator.EQUALS);
            this.put(InfixExpression.Operator.NOT_EQUALS, InfixExpression.Operator.NOT_EQUALS);
            this.put(InfixExpression.Operator.CONDITIONAL_AND, InfixExpression.Operator.CONDITIONAL_AND);
            this.put(InfixExpression.Operator.CONDITIONAL_OR, InfixExpression.Operator.CONDITIONAL_OR);
            this.put(InfixExpression.Operator.AND, InfixExpression.Operator.AND);
            this.put(InfixExpression.Operator.OR, InfixExpression.Operator.OR);
            this.put(InfixExpression.Operator.XOR, InfixExpression.Operator.XOR);
            this.put(InfixExpression.Operator.PLUS, InfixExpression.Operator.PLUS);
            this.put(InfixExpression.Operator.TIMES, InfixExpression.Operator.TIMES);
            this.put(InfixExpression.Operator.GREATER, InfixExpression.Operator.LESS);
            this.put(InfixExpression.Operator.LESS, InfixExpression.Operator.GREATER);
            this.put(InfixExpression.Operator.LESS_EQUALS, InfixExpression.Operator.GREATER_EQUALS);
            this.put(InfixExpression.Operator.GREATER_EQUALS, InfixExpression.Operator.LESS_EQUALS);
        }
    };

    public boolean match(InfixExpression node, Object otherObject) {
        InfixExpression infixExpression;
        PrefixExpression pe;
        Object other = this.unbracket(otherObject);
        if (other instanceof PrefixExpression && ASTNodes.hasOperator(pe = (PrefixExpression)other, PrefixExpression.Operator.NOT, new PrefixExpression.Operator[0])) {
            return this.matchNegative((ASTNode)node, pe.getOperand());
        }
        if (other instanceof InfixExpression && (!ASTNodes.hasOperator(infixExpression = (InfixExpression)other, InfixExpression.Operator.PLUS, new InfixExpression.Operator[0]) || ASTNodes.hasType(node.getLeftOperand(), Short.TYPE.getSimpleName(), Integer.TYPE.getSimpleName(), Long.TYPE.getSimpleName(), Float.TYPE.getSimpleName(), Double.TYPE.getSimpleName(), Short.class.getCanonicalName(), Integer.class.getCanonicalName(), Long.class.getCanonicalName(), Float.class.getCanonicalName(), Double.class.getCanonicalName()) && ASTNodes.hasType(node.getRightOperand(), Short.TYPE.getSimpleName(), Integer.TYPE.getSimpleName(), Long.TYPE.getSimpleName(), Float.TYPE.getSimpleName(), Double.TYPE.getSimpleName(), Short.class.getCanonicalName(), Integer.class.getCanonicalName(), Long.class.getCanonicalName(), Float.class.getCanonicalName(), Double.class.getCanonicalName()))) {
            if (!node.hasExtendedOperands() && !infixExpression.hasExtendedOperands() && node.getOperator().equals(INFIX_TO_MIRROR_OPERATOR.get(infixExpression.getOperator())) && ASTNodes.isPassiveWithoutFallingThrough((ASTNode)node.getLeftOperand()) && ASTNodes.isPassiveWithoutFallingThrough((ASTNode)node.getRightOperand()) && this.safeSubtreeMatch(node.getLeftOperand(), infixExpression.getRightOperand()) && this.safeSubtreeMatch(node.getRightOperand(), infixExpression.getLeftOperand())) {
                return true;
            }
            if (node.getOperator().equals(infixExpression.getOperator()) && ASTNodes.hasOperator(infixExpression, InfixExpression.Operator.PLUS, InfixExpression.Operator.TIMES, InfixExpression.Operator.AND, InfixExpression.Operator.CONDITIONAL_AND, InfixExpression.Operator.OR, InfixExpression.Operator.CONDITIONAL_OR, InfixExpression.Operator.XOR) && this.isOperandsMatching(node, infixExpression, true)) {
                return true;
            }
        }
        return super.match(node, other);
    }

    public boolean match(ParenthesizedExpression node, Object otherObject) {
        Object other = this.unbracket(otherObject);
        return this.safeSubtreeMatch(node.getExpression(), other);
    }

    private Object unbracket(Object otherObject) {
        if (otherObject instanceof ParenthesizedExpression) {
            return ((ParenthesizedExpression)otherObject).getExpression();
        }
        return otherObject;
    }

    public boolean match(PrefixExpression node, Object otherObject) {
        Object other = this.unbracket(otherObject);
        if (!(other instanceof PrefixExpression) && ASTNodes.hasOperator(node, PrefixExpression.Operator.NOT, new PrefixExpression.Operator[0])) {
            return this.matchNegative((ASTNode)node.getOperand(), other);
        }
        if (node.getParent() instanceof Statement) {
            if (other instanceof Assignment) {
                return this.match0(node, (Assignment)other);
            }
            if (other instanceof PostfixExpression) {
                return this.match0(node, (PostfixExpression)other);
            }
        }
        return super.match(node, other);
    }

    public boolean match(PostfixExpression node, Object otherObject) {
        Object other = this.unbracket(otherObject);
        if (node.getParent() instanceof Statement) {
            if (other instanceof Assignment) {
                return this.match0(node, (Assignment)other);
            }
            if (other instanceof PrefixExpression) {
                return this.match0((PrefixExpression)other, node);
            }
        }
        return super.match(node, other);
    }

    public boolean match(Assignment node, Object otherObject) {
        Object other = this.unbracket(otherObject);
        if (other instanceof PrefixExpression && ((PrefixExpression)other).getParent() instanceof Statement) {
            return this.match0((PrefixExpression)other, node);
        }
        if (other instanceof PostfixExpression && ((PostfixExpression)other).getParent() instanceof Statement) {
            return this.match0((PostfixExpression)other, node);
        }
        if (other instanceof Assignment) {
            return this.matchAssignmentWithAndWithoutEqual(node, (Assignment)other) || this.matchAssignmentWithAndWithoutEqual((Assignment)other, node) || super.match(node, other);
        }
        return super.match(node, other);
    }

    private boolean matchAssignmentWithAndWithoutEqual(Assignment node, Assignment assignment) {
        InfixExpression infixExpression;
        if (ASTNodes.hasOperator(node, Assignment.Operator.ASSIGN, new Assignment.Operator[0]) && node.getRightHandSide() instanceof InfixExpression && !(infixExpression = (InfixExpression)node.getRightHandSide()).hasExtendedOperands() && ASTNodes.hasOperator(assignment, Assignment.Operator.PLUS_ASSIGN, Assignment.Operator.MINUS_ASSIGN, Assignment.Operator.TIMES_ASSIGN, Assignment.Operator.DIVIDE_ASSIGN, Assignment.Operator.BIT_AND_ASSIGN, Assignment.Operator.BIT_OR_ASSIGN, Assignment.Operator.BIT_XOR_ASSIGN, Assignment.Operator.REMAINDER_ASSIGN, Assignment.Operator.LEFT_SHIFT_ASSIGN, Assignment.Operator.RIGHT_SHIFT_SIGNED_ASSIGN, Assignment.Operator.RIGHT_SHIFT_UNSIGNED_ASSIGN) && ASSIGN_TO_INFIX_OPERATOR.get(assignment.getOperator()).equals(infixExpression.getOperator())) {
            return this.safeSubtreeMatch(node.getLeftHandSide(), assignment.getLeftHandSide()) && this.safeSubtreeMatch(infixExpression.getLeftOperand(), assignment.getLeftHandSide()) && this.safeSubtreeMatch(infixExpression.getRightOperand(), assignment.getRightHandSide());
        }
        return false;
    }

    private boolean match0(PrefixExpression prefixExpression, PostfixExpression postfixExpression) {
        return postfixExpression.getOperator().equals(PREFIX_TO_POSTFIX_OPERATOR.get(prefixExpression.getOperator())) && this.safeSubtreeMatch(prefixExpression.getOperand(), postfixExpression.getOperand());
    }

    private boolean match0(PrefixExpression prefixExpression, Assignment assignment) {
        return this.match0(assignment, prefixExpression.getOperand(), PREFIX_TO_INFIX_OPERATOR.get(prefixExpression.getOperator()), PREFIX_TO_ASSIGN_OPERATOR.get(prefixExpression.getOperator()));
    }

    private boolean match0(PostfixExpression postfixExpression, Assignment assignment) {
        return this.match0(assignment, postfixExpression.getOperand(), POSTFIX_TO_INFIX_OPERATOR.get(postfixExpression.getOperator()), POSTFIX_TO_ASSIGN_OPERATOR.get(postfixExpression.getOperator()));
    }

    private boolean match0(Assignment assignment, Expression prefixOrPostfixOperand, InfixExpression.Operator infixAssociatedOperator, Assignment.Operator assignmentAssociatedOperator) {
        if (ASTNodes.hasOperator(assignment, Assignment.Operator.ASSIGN, new Assignment.Operator[0]) && assignment.getRightHandSide() instanceof InfixExpression) {
            InfixExpression infixExpression = (InfixExpression)assignment.getRightHandSide();
            if (!infixExpression.hasExtendedOperands() && infixAssociatedOperator.equals(infixExpression.getOperator())) {
                if (this.isOneLiteral(infixExpression.getRightOperand())) {
                    return this.safeSubtreeMatch(prefixOrPostfixOperand, assignment.getLeftHandSide()) && this.safeSubtreeMatch(prefixOrPostfixOperand, infixExpression.getLeftOperand());
                }
                if (ASTNodes.hasOperator(infixExpression, InfixExpression.Operator.PLUS, new InfixExpression.Operator[0]) && this.isOneLiteral(infixExpression.getLeftOperand())) {
                    return this.safeSubtreeMatch(prefixOrPostfixOperand, assignment.getLeftHandSide()) && this.safeSubtreeMatch(prefixOrPostfixOperand, infixExpression.getRightOperand());
                }
            }
        } else if (ASTNodes.hasOperator(assignment, Assignment.Operator.PLUS_ASSIGN, Assignment.Operator.MINUS_ASSIGN) && assignmentAssociatedOperator.equals(assignment.getOperator()) && this.isOneLiteral((Expression)assignment)) {
            return this.safeSubtreeMatch(prefixOrPostfixOperand, assignment.getLeftHandSide());
        }
        return false;
    }

    private boolean isOneLiteral(Expression operand) {
        return Long.valueOf(1L).equals(ASTNodes.getIntegerLiteral(operand));
    }

    public boolean match(Block node, Object otherObject) {
        Object other = this.unbracket(otherObject);
        if (other instanceof AssertStatement || other instanceof BreakStatement || other instanceof ConstructorInvocation || other instanceof ContinueStatement || other instanceof DoStatement || other instanceof EmptyStatement || other instanceof EnhancedForStatement || other instanceof ExpressionStatement || other instanceof ForStatement || other instanceof IfStatement || other instanceof LabeledStatement || other instanceof ReturnStatement || other instanceof SuperConstructorInvocation || other instanceof SwitchStatement || other instanceof SynchronizedStatement || other instanceof ThrowStatement || other instanceof TryStatement || other instanceof TypeDeclarationStatement || other instanceof VariableDeclarationStatement || other instanceof WhileStatement) {
            return this.match0(node, (Statement)other);
        }
        return super.match(node, other);
    }

    public boolean match(AssertStatement node, Object otherObject) {
        Object other = this.unbracket(otherObject);
        if (other instanceof Block) {
            return this.match0((Block)other, (Statement)node);
        }
        return super.match(node, other);
    }

    public boolean match(BreakStatement node, Object otherObject) {
        Object other = this.unbracket(otherObject);
        if (other instanceof Block) {
            return this.match0((Block)other, (Statement)node);
        }
        return super.match(node, other);
    }

    public boolean match(ConstructorInvocation node, Object otherObject) {
        Object other = this.unbracket(otherObject);
        if (other instanceof Block) {
            return this.match0((Block)other, (Statement)node);
        }
        return super.match(node, other);
    }

    public boolean match(ContinueStatement node, Object otherObject) {
        Object other = this.unbracket(otherObject);
        if (other instanceof Block) {
            return this.match0((Block)other, (Statement)node);
        }
        return super.match(node, other);
    }

    public boolean match(DoStatement node, Object otherObject) {
        Object other = this.unbracket(otherObject);
        if (other instanceof Block) {
            return this.match0((Block)other, (Statement)node);
        }
        return super.match(node, other);
    }

    public boolean match(EmptyStatement node, Object otherObject) {
        Object other = this.unbracket(otherObject);
        if (other instanceof Block) {
            return this.match0((Block)other, (Statement)node);
        }
        return super.match(node, other);
    }

    public boolean match(EnhancedForStatement node, Object otherObject) {
        Object other = this.unbracket(otherObject);
        if (other instanceof Block) {
            return this.match0((Block)other, (Statement)node);
        }
        return super.match(node, other);
    }

    public boolean match(ExpressionStatement node, Object otherObject) {
        Object other = this.unbracket(otherObject);
        if (other instanceof Block) {
            return this.match0((Block)other, (Statement)node);
        }
        return super.match(node, other);
    }

    public boolean match(ConditionalExpression node, Object otherObject) {
        Object other = this.unbracket(otherObject);
        if (super.match(node, other)) {
            return true;
        }
        if (other instanceof ConditionalExpression) {
            ConditionalExpression ce = (ConditionalExpression)other;
            if (node.getElseExpression() != null && ce.getElseExpression() != null) {
                return this.matchNegative((ASTNode)node.getExpression(), ce.getExpression()) && this.safeSubtreeMatch(node.getThenExpression(), ce.getElseExpression()) && this.safeSubtreeMatch(node.getElseExpression(), ce.getThenExpression());
            }
        }
        return false;
    }

    public boolean match(ForStatement node, Object otherObject) {
        Object other = this.unbracket(otherObject);
        if (other instanceof Block) {
            return this.match0((Block)other, (Statement)node);
        }
        return super.match(node, other);
    }

    public boolean match(IfStatement node, Object otherObject) {
        Object other = this.unbracket(otherObject);
        if (other instanceof Block) {
            return this.match0((Block)other, (Statement)node);
        }
        if (super.match(node, other)) {
            return true;
        }
        if (other instanceof IfStatement) {
            IfStatement is = (IfStatement)other;
            if (node.getElseStatement() != null && is.getElseStatement() != null) {
                return this.matchNegative((ASTNode)node.getExpression(), is.getExpression()) && this.safeSubtreeMatch(node.getThenStatement(), is.getElseStatement()) && this.safeSubtreeMatch(node.getElseStatement(), is.getThenStatement());
            }
        }
        return false;
    }

    public boolean match(LabeledStatement node, Object otherObject) {
        Object other = this.unbracket(otherObject);
        if (other instanceof Block) {
            return this.match0((Block)other, (Statement)node);
        }
        return super.match(node, other);
    }

    public boolean match(ReturnStatement node, Object otherObject) {
        Object other = this.unbracket(otherObject);
        if (other instanceof Block) {
            return this.match0((Block)other, (Statement)node);
        }
        return super.match(node, other);
    }

    public boolean match(SuperConstructorInvocation node, Object otherObject) {
        Object other = this.unbracket(otherObject);
        if (other instanceof Block) {
            return this.match0((Block)other, (Statement)node);
        }
        return super.match(node, other);
    }

    public boolean match(SwitchStatement node, Object otherObject) {
        Object other = this.unbracket(otherObject);
        if (other instanceof Block) {
            return this.match0((Block)other, (Statement)node);
        }
        return super.match(node, other);
    }

    public boolean match(SynchronizedStatement node, Object otherObject) {
        Object other = this.unbracket(otherObject);
        if (other instanceof Block) {
            return this.match0((Block)other, (Statement)node);
        }
        return super.match(node, other);
    }

    public boolean match(ThrowStatement node, Object otherObject) {
        Object other = this.unbracket(otherObject);
        if (other instanceof Block) {
            return this.match0((Block)other, (Statement)node);
        }
        return super.match(node, other);
    }

    public boolean match(TryStatement node, Object otherObject) {
        Object other = this.unbracket(otherObject);
        if (other instanceof Block) {
            return this.match0((Block)other, (Statement)node);
        }
        return super.match(node, other);
    }

    public boolean match(TypeDeclarationStatement node, Object otherObject) {
        Object other = this.unbracket(otherObject);
        if (other instanceof Block) {
            return this.match0((Block)other, (Statement)node);
        }
        return super.match(node, other);
    }

    public boolean match(VariableDeclarationStatement node, Object otherObject) {
        Object other = this.unbracket(otherObject);
        if (other instanceof Block) {
            return this.match0((Block)other, (Statement)node);
        }
        return super.match(node, other);
    }

    public boolean match(WhileStatement node, Object otherObject) {
        Object other = this.unbracket(otherObject);
        if (other instanceof Block) {
            return this.match0((Block)other, (Statement)node);
        }
        return super.match(node, other);
    }

    private boolean match0(Block node, Statement other) {
        if ((node.getParent() instanceof IfStatement || node.getParent() instanceof ForStatement || node.getParent() instanceof EnhancedForStatement || node.getParent() instanceof WhileStatement || node.getParent() instanceof DoStatement) && node.statements().size() == 1) {
            return this.safeSubtreeMatch(node.statements().get(0), other) || super.match(node, (Object)other);
        }
        return super.match(node, (Object)other);
    }

    public boolean matchNegative(ASTNode node, Object otherObject) {
        Object other = this.unbracket(otherObject);
        if (node instanceof ParenthesizedExpression) {
            return this.matchNegative((ASTNode)((ParenthesizedExpression)node).getExpression(), other);
        }
        if (node instanceof PrefixExpression) {
            PrefixExpression prefixExpression = (PrefixExpression)node;
            if (ASTNodes.hasOperator(prefixExpression, PrefixExpression.Operator.NOT, new PrefixExpression.Operator[0])) {
                if (other instanceof PrefixExpression && ASTNodes.hasOperator((PrefixExpression)other, PrefixExpression.Operator.NOT, new PrefixExpression.Operator[0])) {
                    return this.matchNegative((ASTNode)prefixExpression.getOperand(), ((PrefixExpression)other).getOperand());
                }
                return this.safeSubtreeMatch(prefixExpression.getOperand(), other);
            }
        } else if (other instanceof PrefixExpression && ASTNodes.hasOperator((PrefixExpression)other, PrefixExpression.Operator.NOT, new PrefixExpression.Operator[0])) {
            return this.safeSubtreeMatch(node, ((PrefixExpression)other).getOperand());
        }
        if (other instanceof ASTNode) {
            Boolean value = ASTNodes.getBooleanLiteral(node);
            Boolean otherValue = ASTNodes.getBooleanLiteral((ASTNode)other);
            if (value != null && otherValue != null) {
                return value ^ otherValue;
            }
        }
        if (!(node instanceof InfixExpression) || !(other instanceof InfixExpression)) {
            return false;
        }
        InfixExpression infixExpression1 = (InfixExpression)node;
        InfixExpression infixExpression2 = (InfixExpression)other;
        Expression leftOperand1 = infixExpression1.getLeftOperand();
        Expression rightOperand1 = infixExpression1.getRightOperand();
        Expression leftOperand2 = infixExpression2.getLeftOperand();
        Expression rightOperand2 = infixExpression2.getRightOperand();
        if (infixExpression1.getOperator().equals(infixExpression2.getOperator())) {
            if (infixExpression1.hasExtendedOperands() || infixExpression2.hasExtendedOperands()) {
                return false;
            }
            if (ASTNodes.hasOperator(infixExpression1, InfixExpression.Operator.EQUALS, InfixExpression.Operator.NOT_EQUALS) && (!ASTNodes.hasType(leftOperand1, Boolean.TYPE.getCanonicalName()) && !ASTNodes.hasType(rightOperand1, Boolean.TYPE.getCanonicalName()) || !ASTNodes.hasType(leftOperand2, Boolean.TYPE.getCanonicalName()) && !ASTNodes.hasType(rightOperand2, Boolean.TYPE.getCanonicalName()))) {
                return false;
            }
            if (ASTNodes.hasOperator(infixExpression1, InfixExpression.Operator.EQUALS, InfixExpression.Operator.NOT_EQUALS, InfixExpression.Operator.XOR)) {
                return this.matchOneNegativeOther(leftOperand1, leftOperand2, rightOperand2, rightOperand1) || this.matchOneNegativeOther(rightOperand2, rightOperand1, leftOperand1, leftOperand2) || ASTNodes.isPassiveWithoutFallingThrough((ASTNode)leftOperand1) && ASTNodes.isPassiveWithoutFallingThrough((ASTNode)rightOperand1) && ASTNodes.isPassiveWithoutFallingThrough((ASTNode)leftOperand2) && ASTNodes.isPassiveWithoutFallingThrough((ASTNode)rightOperand2) && (this.matchOneNegativeOther(leftOperand1, leftOperand2, rightOperand2, rightOperand1) || this.matchOneNegativeOther(rightOperand2, rightOperand1, leftOperand1, leftOperand2));
            }
            return false;
        }
        InfixExpression.Operator negatedOperator = ASTNodes.negatedInfixOperator(infixExpression1.getOperator());
        if (infixExpression2.getOperator().equals(negatedOperator)) {
            if (ASTNodes.hasOperator(infixExpression1, InfixExpression.Operator.CONDITIONAL_AND, InfixExpression.Operator.CONDITIONAL_OR, InfixExpression.Operator.AND, InfixExpression.Operator.OR)) {
                return this.isOperandsMatching(infixExpression1, infixExpression2, false);
            }
            if (infixExpression1.hasExtendedOperands() || infixExpression2.hasExtendedOperands()) {
                return false;
            }
            if (ASTNodes.hasOperator(infixExpression1, InfixExpression.Operator.EQUALS, InfixExpression.Operator.NOT_EQUALS)) {
                return this.isOperandsMatching(infixExpression1, infixExpression2, true) || this.isOperandsMatching(infixExpression1, infixExpression2, false);
            }
            if (ASTNodes.hasOperator(infixExpression1, InfixExpression.Operator.GREATER, InfixExpression.Operator.GREATER_EQUALS, InfixExpression.Operator.LESS, InfixExpression.Operator.LESS_EQUALS) && ASTNodes.isPassiveWithoutFallingThrough((ASTNode)leftOperand1) && ASTNodes.isPassiveWithoutFallingThrough((ASTNode)rightOperand1) && ASTNodes.isPassiveWithoutFallingThrough((ASTNode)leftOperand2) && ASTNodes.isPassiveWithoutFallingThrough((ASTNode)rightOperand2)) {
                return this.safeSubtreeMatch(leftOperand1, leftOperand2) && this.safeSubtreeMatch(rightOperand1, rightOperand2);
            }
            return false;
        }
        if (ASTNodes.hasOperator(infixExpression1, InfixExpression.Operator.GREATER, new InfixExpression.Operator[0]) && ASTNodes.hasOperator(infixExpression2, InfixExpression.Operator.GREATER_EQUALS, new InfixExpression.Operator[0]) || ASTNodes.hasOperator(infixExpression1, InfixExpression.Operator.GREATER_EQUALS, new InfixExpression.Operator[0]) && ASTNodes.hasOperator(infixExpression2, InfixExpression.Operator.GREATER, new InfixExpression.Operator[0]) || ASTNodes.hasOperator(infixExpression1, InfixExpression.Operator.LESS, new InfixExpression.Operator[0]) && ASTNodes.hasOperator(infixExpression2, InfixExpression.Operator.LESS_EQUALS, new InfixExpression.Operator[0]) || ASTNodes.hasOperator(infixExpression1, InfixExpression.Operator.LESS_EQUALS, new InfixExpression.Operator[0]) && ASTNodes.hasOperator(infixExpression2, InfixExpression.Operator.LESS, new InfixExpression.Operator[0])) {
            return !infixExpression1.hasExtendedOperands() && !infixExpression2.hasExtendedOperands() && ASTNodes.isPassiveWithoutFallingThrough((ASTNode)leftOperand1) && ASTNodes.isPassiveWithoutFallingThrough((ASTNode)rightOperand1) && ASTNodes.isPassiveWithoutFallingThrough((ASTNode)leftOperand2) && ASTNodes.isPassiveWithoutFallingThrough((ASTNode)rightOperand2) && this.safeSubtreeMatch(leftOperand1, rightOperand2) && this.safeSubtreeMatch(rightOperand1, leftOperand2);
        }
        return false;
    }

    private boolean matchOneNegativeOther(Expression equalOperand1, Expression equalOperand2, Expression negativeOperand1, Expression negativeOperand2) {
        return this.safeSubtreeMatch(equalOperand1, equalOperand2) && this.matchNegative((ASTNode)negativeOperand1, negativeOperand2);
    }

    private boolean isOperandsMatching(InfixExpression infixExpression1, InfixExpression infixExpression2, boolean equal) {
        List<Expression> operands1 = this.getConsistentOperands(infixExpression1);
        List<Expression> operands2 = this.getConsistentOperands(infixExpression2);
        if (operands1.size() != operands2.size()) {
            return false;
        }
        boolean isMatching = true;
        Iterator<Expression> iterator1 = operands1.iterator();
        Iterator<Expression> iterator2 = operands2.iterator();
        while (iterator1.hasNext() && iterator2.hasNext()) {
            Expression expression = iterator1.next();
            Expression otherExpression = iterator2.next();
            if (!(equal ? !this.safeSubtreeMatch(expression, otherExpression) : !this.matchNegative((ASTNode)expression, otherExpression))) continue;
            isMatching = false;
            break;
        }
        if (isMatching) {
            return true;
        }
        for (Expression expression : operands1) {
            if (ASTNodes.isPassiveWithoutFallingThrough((ASTNode)expression)) continue;
            return false;
        }
        for (Expression expression : operands2) {
            if (ASTNodes.isPassiveWithoutFallingThrough((ASTNode)expression)) continue;
            return false;
        }
        Iterator<Expression> iterator3 = operands1.iterator();
        block3: while (iterator3.hasNext()) {
            Expression expression = iterator3.next();
            Iterator<Expression> iterator4 = operands2.iterator();
            while (iterator4.hasNext()) {
                Expression otherExpression = iterator4.next();
                if (!(equal ? this.safeSubtreeMatch(expression, otherExpression) : this.matchNegative((ASTNode)expression, otherExpression))) continue;
                iterator3.remove();
                iterator4.remove();
                continue block3;
            }
        }
        return operands1.isEmpty() && operands2.isEmpty();
    }

    private List<Expression> getConsistentOperands(InfixExpression infixExpression) {
        List<Expression> operands = ASTNodes.allOperands(infixExpression);
        Iterator<Expression> iterator = operands.iterator();
        while (iterator.hasNext() && operands.size() > 1) {
            Expression operand = iterator.next();
            Long numberLiteral = ASTNodes.getIntegerLiteral(operand);
            Boolean booleanValue = ASTNodes.getBooleanLiteral((ASTNode)operand);
            if (ASTNodes.hasOperator(infixExpression, InfixExpression.Operator.CONDITIONAL_AND, new InfixExpression.Operator[0])) {
                if (!Boolean.TRUE.equals(booleanValue)) continue;
                iterator.remove();
                continue;
            }
            if (ASTNodes.hasOperator(infixExpression, InfixExpression.Operator.CONDITIONAL_OR, new InfixExpression.Operator[0])) {
                if (!Boolean.FALSE.equals(booleanValue)) continue;
                iterator.remove();
                continue;
            }
            if (ASTNodes.hasOperator(infixExpression, InfixExpression.Operator.PLUS, new InfixExpression.Operator[0])) {
                if (!Long.valueOf(0L).equals(numberLiteral)) continue;
                iterator.remove();
                continue;
            }
            if (!ASTNodes.hasOperator(infixExpression, InfixExpression.Operator.TIMES, new InfixExpression.Operator[0]) || !Long.valueOf(1L).equals(numberLiteral)) continue;
            iterator.remove();
        }
        return operands;
    }
}

