/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.jsf.ui.actions;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jst.jsf.core.jsfappconfig.internal.IJSFAppConfigManager;
import org.eclipse.jst.jsf.core.jsfappconfig.internal.JSFAppConfigManagerFactory;
import org.eclipse.jst.jsf.facesconfig.emf.ConverterIdType;
import org.eclipse.jst.jsf.facesconfig.emf.ConverterType;
import org.eclipse.jst.jsf.facesconfig.emf.ValidatorIdType;
import org.eclipse.jst.jsf.facesconfig.emf.ValidatorType;
import org.eclipse.jst.pagedesigner.jsf.ui.actions.ActionsResources;
import org.eclipse.jst.pagedesigner.jsf.ui.actions.AddActionListenerAction;
import org.eclipse.jst.pagedesigner.jsf.ui.actions.AddAttributeAction;
import org.eclipse.jst.pagedesigner.jsf.ui.actions.AddConvertDateTimeAction;
import org.eclipse.jst.pagedesigner.jsf.ui.actions.AddConvertNumberAction;
import org.eclipse.jst.pagedesigner.jsf.ui.actions.AddConverterAction;
import org.eclipse.jst.pagedesigner.jsf.ui.actions.AddParamAction;
import org.eclipse.jst.pagedesigner.jsf.ui.actions.AddSelectItemAction;
import org.eclipse.jst.pagedesigner.jsf.ui.actions.AddSelectItemsAction;
import org.eclipse.jst.pagedesigner.jsf.ui.actions.AddValidateDoubleRangeAction;
import org.eclipse.jst.pagedesigner.jsf.ui.actions.AddValidateLengthAction;
import org.eclipse.jst.pagedesigner.jsf.ui.actions.AddValidateLongRangeAction;
import org.eclipse.jst.pagedesigner.jsf.ui.actions.AddValidatorAction;
import org.eclipse.jst.pagedesigner.jsf.ui.actions.AddValueChangeListenerAction;
import org.eclipse.jst.pagedesigner.jsf.ui.actions.IJSFCoreSupport;
import org.eclipse.jst.pagedesigner.utils.StructuredModelUtil;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;

public class JSFAddActionGroup {
    private static final Action EMPTY_ACTION = new Action(){};

    public void fillContextMenu(IMenuManager menu, final IDOMElement element, final IJSFCoreSupport support) {
        IContributionItem item = menu.find("org.eclipse.jst.pagedesigner.context.submenu.insert");
        if (item instanceof IMenuManager) {
            final IMenuManager submenu = (IMenuManager)item;
            submenu.add((IAction)EMPTY_ACTION);
            submenu.addMenuListener(new IMenuListener(){

                public void menuAboutToShow(IMenuManager manager) {
                    submenu.removeAll();
                    JSFAddActionGroup.this.addJSFAddItems(submenu, element, support);
                }
            });
        }
    }

    private void addJSFAddItems(IMenuManager submenu, IDOMElement element, IJSFCoreSupport support) {
        AddActionListenerAction actionListenerAction = new AddActionListenerAction(element);
        actionListenerAction.setEnabled(support.isActionSource());
        submenu.add((IAction)actionListenerAction);
        AddAttributeAction attrAction = new AddAttributeAction(element);
        attrAction.setEnabled(support.isUIComponent());
        submenu.add((IAction)attrAction);
        IProject prj = null;
        IFile file = StructuredModelUtil.getFileFor((IStructuredModel)element.getModel());
        if (file != null) {
            prj = file.getProject();
        }
        MenuManager converterMenu = new MenuManager(ActionsResources.getString("Submenu.JSFAdd.Converter"));
        boolean supportConverter = support.isValueHolder();
        String[] converterIds = this.getRegisteredConverterIds(prj);
        if (converterIds != null && converterIds.length > 0) {
            int i = 0;
            while (i < converterIds.length) {
                AddConverterAction action = new AddConverterAction(converterIds[i], element);
                action.setEnabled(supportConverter);
                converterMenu.add((IAction)action);
                ++i;
            }
            converterMenu.add((IContributionItem)new Separator());
        }
        AddConvertDateTimeAction dateTimeAction = new AddConvertDateTimeAction(element);
        dateTimeAction.setEnabled(supportConverter);
        converterMenu.add((IAction)dateTimeAction);
        AddConvertNumberAction numberAction = new AddConvertNumberAction(element);
        numberAction.setEnabled(supportConverter);
        converterMenu.add((IAction)numberAction);
        submenu.add((IContributionItem)converterMenu);
        AddParamAction addParamAction = new AddParamAction(element);
        addParamAction.setEnabled(support.isUIComponent());
        submenu.add((IAction)addParamAction);
        AddSelectItemAction selectItemAction = new AddSelectItemAction(element);
        selectItemAction.setEnabled(support.supportSelectItems());
        submenu.add((IAction)selectItemAction);
        AddSelectItemsAction selectItemsAction = new AddSelectItemsAction(element);
        selectItemsAction.setEnabled(support.supportSelectItems());
        submenu.add((IAction)selectItemsAction);
        MenuManager validatorMenu = new MenuManager(ActionsResources.getString("Submenu.JSFAdd.Validators"));
        boolean supportValidator = support.isEditableValueHolder();
        String[] validatorIds = this.getRegisteredValidatorIds(prj);
        if (validatorIds != null && validatorIds.length > 0) {
            int i = 0;
            while (i < validatorIds.length) {
                AddValidatorAction action = new AddValidatorAction(validatorIds[i], element);
                action.setEnabled(supportValidator);
                validatorMenu.add((IAction)action);
                ++i;
            }
            validatorMenu.add((IContributionItem)new Separator());
        }
        AddValidateDoubleRangeAction doubleRangeAction = new AddValidateDoubleRangeAction(element);
        doubleRangeAction.setEnabled(supportValidator);
        validatorMenu.add((IAction)doubleRangeAction);
        AddValidateLengthAction lengthAction = new AddValidateLengthAction(element);
        lengthAction.setEnabled(supportValidator);
        validatorMenu.add((IAction)lengthAction);
        AddValidateLongRangeAction longRangeAction = new AddValidateLongRangeAction(element);
        longRangeAction.setEnabled(supportValidator);
        validatorMenu.add((IAction)longRangeAction);
        submenu.add((IContributionItem)validatorMenu);
        AddValueChangeListenerAction valueChangeAction = new AddValueChangeListenerAction(element);
        valueChangeAction.setEnabled(support.isEditableValueHolder());
        submenu.add((IAction)valueChangeAction);
    }

    private String[] getRegisteredValidatorIds(IProject project) {
        String[] result = null;
        IJSFAppConfigManager appConfigMgr = JSFAppConfigManagerFactory.getJSFAppConfigManagerInstance((IProject)project);
        if (appConfigMgr != null) {
            List list = appConfigMgr.getValidators();
            result = new String[list.size()];
            int i = 0;
            for (ValidatorType validator : list) {
                ValidatorIdType validatorId = validator.getValidatorId();
                if (validatorId == null) continue;
                String string = result[i++] = validatorId.getTextContent() != null ? validatorId.getTextContent().trim() : "";
            }
        }
        return result;
    }

    private String[] getRegisteredConverterIds(IProject project) {
        String[] result = null;
        IJSFAppConfigManager appConfigMgr = JSFAppConfigManagerFactory.getJSFAppConfigManagerInstance((IProject)project);
        if (appConfigMgr != null) {
            List list = appConfigMgr.getConverters();
            ArrayList<String> converterIdList = new ArrayList<String>();
            for (ConverterType converter : list) {
                ConverterIdType converterId = converter.getConverterId();
                if (converterId == null) continue;
                converterIdList.add(converterId.getTextContent() != null ? converterId.getTextContent().trim() : "");
            }
            result = new String[converterIdList.size()];
            result = converterIdList.toArray(result);
        }
        return result;
    }
}

