/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.teststyle.analyze;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.jubula.client.teststyle.analyze.Analyzer;
import org.eclipse.jubula.client.teststyle.checks.contexts.BaseContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnalyzerContainer {
    private static Map<BaseContext, Set<Analyzer>> relation = new HashMap<BaseContext, Set<Analyzer>>();
    private static Map<Object, Set<Analyzer>> analyzed = new HashMap<Object, Set<Analyzer>>();

    private AnalyzerContainer() {
    }

    public static Set<Analyzer> getIntersections(Set<BaseContext> contexts) {
        HashSet<Analyzer> tmp = new HashSet<Analyzer>();
        Iterator<BaseContext> iter = contexts.iterator();
        if (iter.hasNext()) {
            BaseContext context = iter.next();
            Set<Object> analyzers = relation.get(context);
            analyzers = analyzers != null ? analyzers : new HashSet();
            tmp.addAll(analyzers);
            while (iter.hasNext()) {
                context = iter.next();
                analyzers = relation.get(context);
                analyzers = analyzers != null ? analyzers : new HashSet();
                tmp.retainAll(analyzers);
            }
        }
        return tmp;
    }

    public static void add(BaseContext context, Analyzer analyzer) {
        if (!relation.containsKey(context)) {
            relation.put(context, new HashSet());
        }
        relation.get(context).add(analyzer);
    }

    public static Set<Analyzer> getAll() {
        HashSet<Analyzer> tmp = new HashSet<Analyzer>();
        for (Set<Analyzer> analyzers : relation.values()) {
            tmp.addAll(analyzers);
        }
        return tmp;
    }

    public static Set<Analyzer> getAnalyzerFor(Object obj) {
        return analyzed.get(obj);
    }

    public static void addAnalyzed(Object obj, Analyzer analyzer) {
        if (!analyzed.containsKey(obj)) {
            analyzed.put(obj, new HashSet());
        }
        analyzed.get(obj).add(analyzer);
    }
}

