/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.internal.discovery.markers;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.IDocument;
import org.eclipse.m2e.core.ui.internal.markers.MavenProblemResolution;
import org.eclipse.m2e.core.ui.internal.wizards.MappingDiscoveryJob;
import org.eclipse.m2e.internal.discovery.MavenDiscoveryIcons;
import org.eclipse.m2e.internal.discovery.Messages;
import org.eclipse.m2e.internal.discovery.markers.MavenDiscoveryMarkerResolutionGenerator;
import org.eclipse.swt.graphics.Image;

public class DiscoveryWizardResolution
extends MavenProblemResolution {
    public DiscoveryWizardResolution(IMarker marker) {
        super(marker);
    }

    public int getOrder() {
        return 10;
    }

    public String getDescription() {
        return Messages.DiscoveryWizardProposal_description;
    }

    public String getLabel() {
        return Messages.DiscoveryWizardProposal_Label;
    }

    public Image getImage() {
        return MavenDiscoveryIcons.getImage(MavenDiscoveryIcons.QUICK_FIX_ICON);
    }

    public boolean isSingleton() {
        return true;
    }

    public boolean canFix(IMarker marker) {
        return MavenDiscoveryMarkerResolutionGenerator.canResolve(marker);
    }

    public void fix(IMarker[] markers, IDocument document, IProgressMonitor monitor) {
        Set projects = Stream.of(markers).map(m -> m.getResource().getProject()).collect(Collectors.toSet());
        MappingDiscoveryJob discoveryJob = new MappingDiscoveryJob(projects);
        discoveryJob.schedule();
    }
}

