/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.shared.target;

import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.Adapters;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.core.target.ITargetDefinition;
import org.eclipse.pde.core.target.ITargetLocation;
import org.eclipse.pde.internal.core.target.IUBundleContainer;
import org.eclipse.pde.internal.ui.shared.target.Messages;
import org.eclipse.pde.ui.target.ITargetLocationUpdater;

public class UpdateTargetJob
extends Job {
    public static final String JOB_FAMILY_ID = "UpdateTargetJob";
    private Map<ITargetLocation, Set<Object>> toUpdate;
    private ITargetDefinition fTarget;

    public static void update(ITargetDefinition target, Map<ITargetLocation, Set<Object>> toUpdate, IJobChangeListener listener) {
        Job.getJobManager().cancel((Object)JOB_FAMILY_ID);
        UpdateTargetJob job = new UpdateTargetJob(toUpdate, target);
        job.setUser(true);
        if (listener != null) {
            job.addJobChangeListener(listener);
        }
        job.schedule();
    }

    private UpdateTargetJob(Map<ITargetLocation, Set<Object>> toUpdate, ITargetDefinition target) {
        super(Messages.UpdateTargetJob_UpdateJobName);
        this.toUpdate = toUpdate;
        this.fTarget = target;
    }

    protected IStatus run(IProgressMonitor monitor) {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.UpdateTargetJob_UpdatingTarget, (int)(this.toUpdate.size() * 100));
        MultiStatus errors = new MultiStatus("org.eclipse.pde.core", 0, Messages.UpdateTargetJob_TargetUpdateFailedStatus, null);
        boolean noChange = true;
        for (Map.Entry<ITargetLocation, Set<Object>> entry : this.toUpdate.entrySet()) {
            ITargetLocation location = entry.getKey();
            Set<Object> children = entry.getValue();
            String path = null;
            try {
                path = location.getLocation(false);
            }
            catch (CoreException coreException) {}
            progress.subTask(NLS.bind((String)Messages.UpdateTargetJob_UpdatingContainer, (Object)path));
            if (location instanceof IUBundleContainer && !children.isEmpty()) {
                try {
                    boolean result = ((IUBundleContainer)location).update(children, (IProgressMonitor)progress.split(100));
                    if (!result) continue;
                    noChange = false;
                }
                catch (CoreException e) {
                    errors.add(e.getStatus());
                }
                continue;
            }
            ITargetLocationUpdater provider = (ITargetLocationUpdater)Adapters.adapt((Object)location, ITargetLocationUpdater.class);
            if (provider != null) {
                if (!provider.canUpdate(this.fTarget, location)) continue;
                IStatus result = provider.update(this.fTarget, location, (IProgressMonitor)progress.split(100));
                if (result.isOK() && result.getCode() != 101) {
                    noChange = false;
                    continue;
                }
                if (result.isOK()) continue;
                noChange = false;
                errors.add(result);
                continue;
            }
            progress.worked(100);
        }
        progress.done();
        if (noChange) {
            return new Status(0, "org.eclipse.pde.core", 101, Messages.UpdateTargetJob_TargetUpdateSuccessStatus, null);
        }
        if (!errors.isOK()) {
            return errors;
        }
        return Status.OK_STATUS;
    }
}

