/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.ui.launching;

import java.security.MessageDigest;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.internal.ui.SWTFactory;
import org.eclipse.equinox.security.storage.StorageException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.php.internal.debug.core.PHPDebugPlugin;
import org.eclipse.php.internal.debug.core.launching.PHPLaunchUtilities;
import org.eclipse.php.internal.debug.ui.Logger;
import org.eclipse.php.internal.debug.ui.launching.AbstractPHPLaunchConfigurationDebuggerTab;
import org.eclipse.php.internal.debug.ui.launching.IDebuggerLaunchSettingsSection;
import org.eclipse.php.internal.debug.ui.launching.Messages;
import org.eclipse.php.internal.server.core.tunneling.TunnelTester;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.UIJob;

public abstract class AbstractDebugWebLaunchSettingsSection
implements IDebuggerLaunchSettingsSection {
    protected Group breakpointGroup;
    protected Button breakOnFirstLine;
    protected AbstractPHPLaunchConfigurationDebuggerTab.WidgetListener widgetListener;
    protected Group tunnelGroup;
    protected Button debugThroughTunnel;
    protected Label nameLabel;
    protected Text userName;
    protected Label passwordLabel;
    protected Text password;
    protected Button testButton;
    protected CLabel testResultLabel;
    private ILaunchConfiguration configuration;
    private boolean isSSHCredentialsChange;

    @Override
    public void createSection(Composite parent, AbstractPHPLaunchConfigurationDebuggerTab.WidgetListener widgetListener) {
        this.widgetListener = widgetListener;
        this.createBreakpointGroup(parent);
        this.createTunnelGroup(parent);
    }

    @Override
    public void initialize(ILaunchConfiguration configuration) {
        this.configuration = configuration;
        try {
            boolean isUsingTunnel = configuration.getAttribute("org.eclipse.php.debug.core.UseSSHTunnel", false);
            this.debugThroughTunnel.setSelection(isUsingTunnel);
            this.updateTunnelComponents(isUsingTunnel);
            if (isUsingTunnel && this.tunnelGroup != null) {
                this.userName.setText(configuration.getAttribute("org.eclipse.php.debug.core.SSHTunnelUserName", ""));
                if (this.userName.getText().length() > 0) {
                    try {
                        this.password.setText(PHPLaunchUtilities.getSecurePreferences((String)PHPLaunchUtilities.getDebugHost((ILaunchConfiguration)this.getConfiguration())).get(this.userName.getText(), ""));
                    }
                    catch (StorageException e) {
                        Logger.logException("Error accessing the secured storage", e);
                        this.password.setText("");
                    }
                } else {
                    this.password.setText("");
                }
            }
            if (this.breakpointGroup != null) {
                this.breakOnFirstLine.setSelection(configuration.getAttribute("firstLineBreakpoint", PHPDebugPlugin.getStopAtFirstLine()));
            }
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        this.isValid(configuration);
    }

    @Override
    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        if (this.breakpointGroup != null) {
            configuration.setAttribute("firstLineBreakpoint", this.breakOnFirstLine.getSelection());
        }
        if (this.tunnelGroup != null) {
            configuration.setAttribute("org.eclipse.php.debug.core.UseSSHTunnel", this.debugThroughTunnel.getSelection());
            if (this.debugThroughTunnel.getSelection()) {
                configuration.setAttribute("org.eclipse.php.debug.core.SSHTunnelUserName", this.userName.getText().trim());
                String passwordDigest = Digester.digest(this.password.getText().trim());
                if (passwordDigest == null) {
                    passwordDigest = String.valueOf(this.password.getText().trim().hashCode());
                }
                configuration.setAttribute("org.eclipse.php.debug.core.SSHTunnelPassword", passwordDigest);
                try {
                    if (!this.isSSHCredentialsChange) {
                        PHPLaunchUtilities.getSecurePreferences((String)PHPLaunchUtilities.getDebugHost((ILaunchConfiguration)this.getConfiguration())).put(this.userName.getText(), this.password.getText().trim(), true);
                    }
                }
                catch (StorageException e) {
                    Logger.logException("Error saving to the secured storage", e);
                }
            } else {
                configuration.setAttribute("org.eclipse.php.debug.core.SSHTunnelUserName", "");
                configuration.setAttribute("org.eclipse.php.debug.core.SSHTunnelPassword", "");
            }
        }
        this.isSSHCredentialsChange = false;
    }

    @Override
    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        this.configuration = configuration;
    }

    @Override
    public AbstractPHPLaunchConfigurationDebuggerTab.StatusMessage isValid(ILaunchConfiguration configuration) {
        if (this.debugThroughTunnel.getSelection()) {
            boolean valid = this.userName.getText().trim().length() > 0;
            this.testButton.setEnabled(valid);
            if (!valid) {
                return new AbstractPHPLaunchConfigurationDebuggerTab.StatusMessage(3, Messages.AbstractDebugWebLaunchSettingsSection_Missing_SSH_user_name);
            }
        }
        return new AbstractPHPLaunchConfigurationDebuggerTab.StatusMessage(0, "");
    }

    protected void createBreakpointGroup(Composite parent) {
        this.breakpointGroup = new Group(parent, 0);
        this.breakpointGroup.setText(Messages.AbstractDebugWebLaunchSettingsSection_Breakpoint);
        this.breakpointGroup.setLayout((Layout)new GridLayout(1, false));
        this.breakpointGroup.setLayoutData((Object)new GridData(768));
        this.breakOnFirstLine = SWTFactory.createCheckButton((Composite)this.breakpointGroup, (String)Messages.AbstractDebugWebLaunchSettingsSection_Break_at_first_line, null, (boolean)false, (int)1);
        this.breakOnFirstLine.addSelectionListener((SelectionListener)this.widgetListener);
    }

    protected void createTunnelGroup(Composite composite) {
        this.tunnelGroup = new Group(composite, 0);
        this.tunnelGroup.setLayout((Layout)new GridLayout(1, false));
        this.tunnelGroup.setLayoutData((Object)new GridData(768));
        this.tunnelGroup.setText(Messages.AbstractDebugWebLaunchSettingsSection_SSH_tunnel);
        this.debugThroughTunnel = new Button((Composite)this.tunnelGroup, 32);
        this.debugThroughTunnel.setText(Messages.AbstractDebugWebLaunchSettingsSection_Debug_through_SSH);
        Composite credentialsComposite = new Composite((Composite)this.tunnelGroup, 0);
        credentialsComposite.setLayout((Layout)new GridLayout(2, false));
        GridData data = new GridData(768);
        data.horizontalIndent = 20;
        credentialsComposite.setLayoutData((Object)data);
        this.nameLabel = new Label(credentialsComposite, 0);
        this.nameLabel.setText(Messages.AbstractDebugWebLaunchSettingsSection_User_name);
        this.userName = new Text(credentialsComposite, 2052);
        data = new GridData(768);
        data.widthHint = 200;
        this.userName.setLayoutData((Object)data);
        this.userName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AbstractDebugWebLaunchSettingsSection.this.isSSHCredentialsChange = true;
                AbstractDebugWebLaunchSettingsSection.this.updateTunnelComponents(true);
            }
        });
        this.passwordLabel = new Label(credentialsComposite, 0);
        this.passwordLabel.setText(Messages.AbstractDebugWebLaunchSettingsSection_Password);
        this.password = new Text(credentialsComposite, 0x400804);
        data = new GridData(768);
        data.widthHint = 200;
        this.password.setLayoutData((Object)data);
        this.password.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AbstractDebugWebLaunchSettingsSection.this.isSSHCredentialsChange = true;
                AbstractDebugWebLaunchSettingsSection.this.updateTunnelComponents(true);
            }
        });
        Composite testConnectionComposite = new Composite(credentialsComposite, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        testConnectionComposite.setLayout((Layout)layout);
        data = new GridData(768);
        data.horizontalSpan = 2;
        testConnectionComposite.setLayoutData((Object)data);
        this.testButton = new Button(testConnectionComposite, 8);
        this.testButton.setText(Messages.AbstractDebugWebLaunchSettingsSection_Test_connection);
        this.testResultLabel = new CLabel(testConnectionComposite, 0);
        this.testResultLabel.setLayoutData((Object)new GridData(768));
        this.testButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AbstractDebugWebLaunchSettingsSection.this.testTunnelConnection();
            }
        });
        this.testResultLabel.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                Object messageData = AbstractDebugWebLaunchSettingsSection.this.testResultLabel.getData("info");
                if (messageData != null) {
                    MessageDialog.openInformation((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)Messages.AbstractDebugWebLaunchSettingsSection_SSH_tunnel_test, (String)messageData.toString());
                }
            }
        });
        this.debugThroughTunnel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent se) {
                Button b = (Button)se.getSource();
                boolean selection = b.getSelection();
                AbstractDebugWebLaunchSettingsSection.this.updateTunnelComponents(selection);
            }
        });
        this.userName.addModifyListener((ModifyListener)this.widgetListener);
        this.password.addModifyListener((ModifyListener)this.widgetListener);
        this.debugThroughTunnel.addSelectionListener((SelectionListener)this.widgetListener);
    }

    protected ILaunchConfiguration getConfiguration() {
        return this.configuration;
    }

    protected void updateTunnelComponents(boolean enabled) {
        this.testResultLabel.setText("");
        this.setEnabled(enabled, new Control[]{this.userName, this.password, this.nameLabel, this.passwordLabel, this.testResultLabel});
        this.testButton.setEnabled(enabled && this.userName.getText().trim().length() > 0);
    }

    protected void setEnabled(boolean enabled, Control ... controls) {
        Control[] controlArray = controls;
        int n = controls.length;
        int n2 = 0;
        while (n2 < n) {
            Control c = controlArray[n2];
            c.setEnabled(enabled);
            ++n2;
        }
    }

    protected void testTunnelConnection() {
        this.testButton.setEnabled(false);
        this.testResultLabel.setForeground(Display.getDefault().getSystemColor(9));
        this.testResultLabel.setText(Messages.AbstractDebugWebLaunchSettingsSection_Testing_connection);
        this.testResultLabel.setCursor(Display.getDefault().getSystemCursor(1));
        this.testResultLabel.setData("info", null);
        UIJob connectionTest = new UIJob(Messages.AbstractDebugWebLaunchSettingsSection_SSH_tunnel_test){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                block15: {
                    try {
                        String remoteHost = PHPLaunchUtilities.getDebugHost((ILaunchConfiguration)AbstractDebugWebLaunchSettingsSection.this.getConfiguration());
                        int port = PHPLaunchUtilities.getDebugPort((ILaunchConfiguration)AbstractDebugWebLaunchSettingsSection.this.getConfiguration());
                        if (remoteHost == null || remoteHost.length() == 0 || port < 0) {
                            AbstractDebugWebLaunchSettingsSection.this.testButton.setEnabled(true);
                            AbstractDebugWebLaunchSettingsSection.this.testResultLabel.setCursor(Display.getDefault().getSystemCursor(21));
                            AbstractDebugWebLaunchSettingsSection.this.testResultLabel.setForeground(Display.getDefault().getSystemColor(4));
                            if (port > -1) {
                                AbstractDebugWebLaunchSettingsSection.this.testResultLabel.setText(Messages.AbstractDebugWebLaunchSettingsSection_Missing_host);
                                AbstractDebugWebLaunchSettingsSection.this.testResultLabel.setData("info", (Object)Messages.AbstractDebugWebLaunchSettingsSection_Missing_host_address);
                            } else {
                                AbstractDebugWebLaunchSettingsSection.this.testResultLabel.setText(Messages.AbstractDebugWebLaunchSettingsSection_Error);
                                AbstractDebugWebLaunchSettingsSection.this.testResultLabel.setData("info", (Object)Messages.AbstractDebugWebLaunchSettingsSection_Could_not_determine_port);
                            }
                        }
                        AbstractDebugWebLaunchSettingsSection.this.testResultLabel.setCursor(Display.getDefault().getSystemCursor(1));
                        IStatus connectionStatus = TunnelTester.test((String)remoteHost, (String)AbstractDebugWebLaunchSettingsSection.this.userName.getText().trim(), (String)AbstractDebugWebLaunchSettingsSection.this.password.getText().trim(), (int)port, (int)port);
                        AbstractDebugWebLaunchSettingsSection.this.testButton.setEnabled(true);
                        AbstractDebugWebLaunchSettingsSection.this.testResultLabel.setCursor(null);
                        if (connectionStatus.isOK()) {
                            AbstractDebugWebLaunchSettingsSection.this.testResultLabel.setForeground(Display.getDefault().getSystemColor(6));
                            AbstractDebugWebLaunchSettingsSection.this.testResultLabel.setText(Messages.AbstractDebugWebLaunchSettingsSection_Successfully_connected);
                            break block15;
                        }
                        if (connectionStatus.isMultiStatus()) {
                            AbstractDebugWebLaunchSettingsSection.this.testResultLabel.setCursor(Display.getDefault().getSystemCursor(21));
                            AbstractDebugWebLaunchSettingsSection.this.testResultLabel.setForeground(Display.getDefault().getSystemColor(8));
                            AbstractDebugWebLaunchSettingsSection.this.testResultLabel.setText(Messages.AbstractDebugWebLaunchSettingsSection_Undetermined);
                            AbstractDebugWebLaunchSettingsSection.this.testResultLabel.setData("info", (Object)connectionStatus.getMessage());
                            IStatus[] children = connectionStatus.getChildren();
                            if (children == null) break block15;
                            IStatus[] iStatusArray = children;
                            int n = children.length;
                            int n2 = 0;
                            while (n2 < n) {
                                IStatus child = iStatusArray[n2];
                                if (child.getSeverity() == 1 && child.getCode() == 300) {
                                    AbstractDebugWebLaunchSettingsSection.this.password.setText(child.getMessage());
                                    break block15;
                                }
                                ++n2;
                            }
                            break block15;
                        }
                        if (connectionStatus.getSeverity() == 2) {
                            AbstractDebugWebLaunchSettingsSection.this.testResultLabel.setCursor(Display.getDefault().getSystemCursor(21));
                            AbstractDebugWebLaunchSettingsSection.this.testResultLabel.setForeground(Display.getDefault().getSystemColor(6));
                            AbstractDebugWebLaunchSettingsSection.this.testResultLabel.setText(Messages.AbstractDebugWebLaunchSettingsSection_Connected_with_warnings);
                            AbstractDebugWebLaunchSettingsSection.this.testResultLabel.setData("info", (Object)connectionStatus.getMessage());
                        } else if (connectionStatus.getSeverity() == 1) {
                            AbstractDebugWebLaunchSettingsSection.this.testResultLabel.setForeground(Display.getDefault().getSystemColor(6));
                            AbstractDebugWebLaunchSettingsSection.this.testResultLabel.setText(Messages.AbstractDebugWebLaunchSettingsSection_Connected_with_warnings);
                            if (connectionStatus.getCode() == 300) {
                                AbstractDebugWebLaunchSettingsSection.this.password.setText(connectionStatus.getMessage());
                            }
                        } else if (connectionStatus.getSeverity() == 4) {
                            AbstractDebugWebLaunchSettingsSection.this.testResultLabel.setCursor(Display.getDefault().getSystemCursor(21));
                            AbstractDebugWebLaunchSettingsSection.this.testResultLabel.setForeground(Display.getDefault().getSystemColor(4));
                            AbstractDebugWebLaunchSettingsSection.this.testResultLabel.setText(Messages.AbstractDebugWebLaunchSettingsSection_Failed_to_connect);
                            AbstractDebugWebLaunchSettingsSection.this.testResultLabel.setData("info", (Object)connectionStatus.getMessage());
                        }
                    }
                    catch (OperationCanceledException oce) {
                        AbstractDebugWebLaunchSettingsSection.this.testButton.setEnabled(true);
                        AbstractDebugWebLaunchSettingsSection.this.testResultLabel.setCursor(null);
                        AbstractDebugWebLaunchSettingsSection.this.testResultLabel.setForeground(null);
                        AbstractDebugWebLaunchSettingsSection.this.testResultLabel.setText(Messages.AbstractDebugWebLaunchSettingsSection_Canceled);
                    }
                }
                return Status.OK_STATUS;
            }
        };
        connectionTest.setUser(true);
        connectionTest.setPriority(30);
        connectionTest.schedule();
    }

    protected static class Digester {
        protected Digester() {
        }

        public static String digest(String content) {
            if (content == null) {
                return null;
            }
            if (content.length() == 0) {
                return "";
            }
            String passwordDigest = null;
            try {
                MessageDigest md = MessageDigest.getInstance("MD5");
                md.reset();
                md.update(content.getBytes());
                byte[] digest = md.digest();
                StringBuilder buffer = new StringBuilder();
                int i = 0;
                while (i < digest.length) {
                    String hex = Integer.toHexString(0xFF & digest[i]);
                    if (hex.length() == 1) {
                        buffer.append('0');
                    }
                    buffer.append(hex);
                    ++i;
                }
                passwordDigest = buffer.toString();
            }
            catch (Exception e) {
                Logger.logException("Message digest error", e);
            }
            if (passwordDigest == null) {
                return null;
            }
            return passwordDigest;
        }
    }
}

