/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.editor;

import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.dltk.core.environment.EnvironmentPathUtils;
import org.eclipse.dltk.internal.ui.editor.SourceModuleDocumentProvider;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.IAnnotationPresentation;
import org.eclipse.php.internal.ui.Logger;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.MarkerAnnotation;
import org.eclipse.ui.texteditor.MarkerUtilities;

public class PHPResourceMarkerAnnotationModel
extends SourceModuleDocumentProvider.SourceModuleAnnotationModel {
    public static final String SECONDARY_ID_KEY = "org.eclipse.wst.sse.ui.extensions.breakpoint.path";
    protected IResource fMarkerResource;
    protected String fSecondaryMarkerAttributeValue;

    public PHPResourceMarkerAnnotationModel(IResource resource) {
        super(resource);
        this.fMarkerResource = resource;
    }

    public PHPResourceMarkerAnnotationModel(IResource resource, String secondaryID) {
        super(resource);
        this.fMarkerResource = resource;
        this.fSecondaryMarkerAttributeValue = secondaryID;
    }

    protected boolean isAcceptable(IMarker marker) {
        if (marker == null) {
            return false;
        }
        try {
            Object attr = marker.getAttribute("hidden");
            if (attr != null && ((Boolean)attr).equals(Boolean.TRUE)) {
                return false;
            }
        }
        catch (CoreException attr) {
            // empty catch block
        }
        if (this.fSecondaryMarkerAttributeValue == null) {
            return super.isAcceptable(marker);
        }
        String secondaryId = marker.getAttribute(SECONDARY_ID_KEY, "");
        IPath path = Path.fromPortableString((String)secondaryId);
        path = EnvironmentPathUtils.getLocalPath((IPath)path);
        boolean isSameFile = Path.fromPortableString((String)this.fSecondaryMarkerAttributeValue).equals((Object)path);
        return this.getResource().equals((Object)marker.getResource()) && isSameFile;
    }

    protected MarkerAnnotation createMarkerAnnotation(IMarker marker) {
        if (MarkerUtilities.isMarkerType((IMarker)marker, (String)"org.eclipse.core.resources.problemmarker")) {
            return new StructuredMarkerAnnotation(marker);
        }
        return super.createMarkerAnnotation(marker);
    }

    public Position getMarkerPosition(IMarker marker) {
        Position pos = super.getMarkerPosition(marker);
        if (pos == null || pos.getLength() == 0) {
            pos = this.createPositionFromMarker(marker);
        }
        return pos;
    }

    public class StructuredMarkerAnnotation
    extends MarkerAnnotation
    implements IAnnotationPresentation {
        private boolean fIsGrayed;
        String fAnnotationType;

        StructuredMarkerAnnotation(IMarker marker) {
            super(marker);
            this.fIsGrayed = false;
            this.fAnnotationType = null;
        }

        public final String getAnnotationType() {
            return this.fAnnotationType;
        }

        protected Image getImage(Display display) {
            Image image = null;
            if (this.fAnnotationType == "org.eclipse.wst.sse.ui.temp.error") {
                image = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_ERROR_TSK");
            } else if (this.fAnnotationType == "org.eclipse.wst.sse.ui.temp.warning") {
                image = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_WARN_TSK");
            } else if (this.fAnnotationType == "org.eclipse.wst.sse.ui.temp.info") {
                image = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_INFO_TSK");
            }
            if (image != null && this.isGrayed()) {
                this.setImage(this.getGrayImage(display, image));
            } else {
                this.setImage(image);
            }
            return super.getImage(display);
        }

        private Image getGrayImage(Display display, Image image) {
            if (image != null) {
                String key = Integer.toString(image.hashCode());
                Image grayImage = JFaceResources.getImageRegistry().get(key);
                if (grayImage == null) {
                    grayImage = new Image((Device)display, image, 2);
                    JFaceResources.getImageRegistry().put(key, grayImage);
                }
                image = grayImage;
            }
            return image;
        }

        public final boolean isGrayed() {
            return this.fIsGrayed;
        }

        public final void setGrayed(boolean grayed) {
            this.fIsGrayed = grayed;
        }

        protected void initAnnotationType() {
            IMarker marker = this.getMarker();
            this.fAnnotationType = "org.eclipse.text.annotation.unknown";
            try {
                if (marker.isSubtypeOf("org.eclipse.core.resources.problemmarker")) {
                    int severity = marker.getAttribute("severity", -1);
                    switch (severity) {
                        case 2: {
                            this.fAnnotationType = "org.eclipse.wst.sse.ui.temp.error";
                            break;
                        }
                        case 1: {
                            this.fAnnotationType = "org.eclipse.wst.sse.ui.temp.warning";
                            break;
                        }
                        case 0: {
                            this.fAnnotationType = "org.eclipse.wst.sse.ui.temp.info";
                        }
                        default: {
                            break;
                        }
                    }
                }
            }
            catch (CoreException e) {
                Logger.logException(e);
            }
        }
    }
}

