/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.etfw.feedback.perfsuite.xml;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.ptp.internal.etfw.feedback.perfsuite.xml.CPUTime;
import org.xml.sax.Attributes;

public class ExecutionInfo {
    private static final String DATETAG = "date";
    private static final String HOSTTAG = "hostname";
    private static final String DOMAINTAG = "domainname";
    private static final String PIDTAG = "pid";
    private static final String THREADTAG = "thread";
    private static final String USERTAG = "username";
    private static final String COMMANDTAG = "command";
    private static final String COMMANDMD5ATT = "md5sum";
    private static final String ANNOTATIONTAG = "annotation";
    private static final String WALLCLOCKTAG = "wallclock";
    private static final String WALLCLOCKUNITSATT = "units";
    private static final String CPUTIMETAG = "cputime";
    private static final String USERTIMETAG = "usertime";
    private static final String SYSTEMTIMETAG = "systemtime";
    private static final String WALLCLOCKUNITSTICKS = "ticks";
    private static final String WALLCLOCKUNITSSECONDS = "seconds";
    private static final String DATEFORMAT = "EEE MMM dd HH:mm:ss yyyy";
    private Date date;
    private String hostname;
    private String domainname;
    private long pid;
    private long thread;
    private String username;
    private String command;
    private String md5sum;
    private String annotation;
    private long wallticks;
    private float wallsecs;
    private String wallclockunits;
    private CPUTime cputime;
    private float usertime;
    private float systemtime;
    private String tmpValue = "";
    private static final Set<String> keySet = new TreeSet<String>();

    static {
        keySet.add(DATETAG);
        keySet.add(HOSTTAG);
        keySet.add(DOMAINTAG);
        keySet.add(PIDTAG);
        keySet.add(THREADTAG);
        keySet.add(USERTAG);
        keySet.add(COMMANDTAG);
        keySet.add(ANNOTATIONTAG);
        keySet.add(WALLCLOCKTAG);
        keySet.add(CPUTIMETAG);
        keySet.add(USERTIMETAG);
        keySet.add(SYSTEMTIMETAG);
    }

    ExecutionInfo() {
    }

    static boolean containsKey(String str) {
        return keySet.contains(str);
    }

    void startElement(String uri, String localName, String qName, Attributes atts) {
        if (qName.equals(COMMANDTAG)) {
            this.md5sum = atts.getValue(COMMANDMD5ATT);
        } else if (qName.equals(WALLCLOCKTAG)) {
            this.wallclockunits = atts.getValue(WALLCLOCKUNITSATT);
        }
        this.tmpValue = "";
    }

    void characters(char[] ch, int start, int length) {
        String tmpString = new String(ch, start, length);
        if (tmpString.length() != 0) {
            this.tmpValue = this.tmpValue.length() == 0 ? tmpString : this.tmpValue.concat(tmpString);
        }
    }

    void endElement(String uri, String localName, String qName) {
        this.tmpValue = this.tmpValue.trim();
        if (qName.equals(DATETAG)) {
            Locale savedDefaultLocale = Locale.getDefault();
            if (!savedDefaultLocale.equals(Locale.US)) {
                Locale.setDefault(Locale.US);
            }
            SimpleDateFormat df = new SimpleDateFormat(DATEFORMAT);
            try {
                this.date = df.parse(this.tmpValue);
            }
            catch (ParseException pe) {
                System.err.println("Error in parsing date in ExecutionInfo.endElement: date = \"" + this.tmpValue + "\".");
                throw new RuntimeException(pe);
            }
            if (!savedDefaultLocale.equals(Locale.US)) {
                Locale.setDefault(savedDefaultLocale);
            }
        } else if (qName.equals(HOSTTAG)) {
            this.hostname = this.tmpValue;
        } else if (qName.equals(DOMAINTAG)) {
            this.domainname = this.tmpValue;
        } else if (qName.equals(PIDTAG)) {
            this.pid = Long.parseLong(this.tmpValue);
        } else if (qName.equals(THREADTAG)) {
            this.thread = Long.parseLong(this.tmpValue);
        } else if (qName.equals(USERTAG)) {
            this.username = this.tmpValue;
        } else if (qName.equals(COMMANDTAG)) {
            this.command = this.tmpValue;
        } else if (qName.equals(ANNOTATIONTAG)) {
            this.annotation = this.tmpValue;
        } else if (qName.equals(WALLCLOCKTAG)) {
            if (this.wallclockunits.equals(WALLCLOCKUNITSTICKS)) {
                this.wallticks = Long.parseLong(this.tmpValue);
                this.wallsecs = 0.0f;
            } else {
                this.wallticks = 0L;
                this.wallsecs = Float.parseFloat(this.tmpValue);
            }
        } else if (qName.equals(USERTIMETAG)) {
            this.usertime = Float.parseFloat(this.tmpValue);
        } else if (qName.equals(SYSTEMTIMETAG)) {
            this.systemtime = Float.parseFloat(this.tmpValue);
        } else if (qName.equals(CPUTIMETAG)) {
            this.cputime = new CPUTime(this.usertime, this.systemtime);
        }
        this.tmpValue = "";
    }

    public String toString() {
        StringBuilder res = new StringBuilder();
        res.append("Execution information:\n");
        res.append("  [Date:        " + this.date.toString() + "]\n");
        res.append("  [Hostname:    " + this.hostname + "]\n");
        if (this.pid != 0L) {
            res.append("  [PID:         " + this.pid + "]\n");
        }
        if (this.thread != 0L) {
            res.append("  [Thread ID (0-based): " + this.thread + "]\n");
        }
        res.append("  [User:        " + this.username + "]\n");
        res.append("  [Command:     " + this.command + "]\n");
        if (this.md5sum != null) {
            res.append("  [Checksum:    " + this.md5sum + "]\n");
        }
        if (this.annotation != null) {
            res.append("  [Annotation:  " + this.annotation + "]\n");
        }
        if (this.cputime != null) {
            res.append(this.cputime.toString());
        }
        return res.toString();
    }

    public Date getDate() {
        return this.date;
    }

    public String getHostName() {
        return this.hostname;
    }

    public String getDomainName() {
        return this.domainname;
    }

    public long getPid() {
        return this.pid;
    }

    public long getThreadId() {
        return this.thread;
    }

    public String getUserName() {
        return this.username;
    }

    public String getCommand() {
        return this.command;
    }

    public String getMD5Sum() {
        return this.md5sum;
    }

    public String getAnnotation() {
        return this.annotation;
    }

    public long getWallTicks() {
        return this.wallticks;
    }

    public float getWallSecs() {
        return this.wallsecs;
    }

    public CPUTime getCPUTime() {
        return this.cputime;
    }
}

