/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.ui.views.internal;

import java.util.EventObject;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.tcf.te.runtime.events.EventManager;
import org.eclipse.tcf.te.ui.views.events.ViewerContentChangeEvent;
import org.eclipse.tcf.te.ui.views.internal.AltDoubleClickEvent;
import org.eclipse.tcf.te.ui.views.internal.ViewViewerDecoratingLabelProvider;
import org.eclipse.ui.navigator.CommonViewer;
import org.eclipse.ui.navigator.INavigatorContentService;

public class ViewViewer
extends CommonViewer {
    private boolean silent = false;
    private int lastDoubleClickSelectionEventStateMask = 0;

    public ViewViewer(String viewerId, Composite parent, int style) {
        super(viewerId, parent, style);
    }

    private void fireEvent(EventObject event) {
        if (!this.silent && event != null) {
            EventManager.getInstance().fireEvent(event);
        }
    }

    protected void init() {
        this.setUseHashlookup(true);
        INavigatorContentService contentService = this.getNavigatorContentService();
        this.setContentProvider((IContentProvider)contentService.createCommonContentProvider());
        this.setLabelProvider((IBaseLabelProvider)new ViewViewerDecoratingLabelProvider((TreeViewer)this, contentService.createCommonLabelProvider()));
        this.initDragAndDrop();
    }

    public boolean setSilentMode(boolean silent) {
        boolean changed = this.silent ^ silent;
        this.silent = silent;
        return changed;
    }

    public void add(Object parentElement, Object[] childElements) {
        super.add(parentElement, childElements);
        ViewerContentChangeEvent event = new ViewerContentChangeEvent((Object)this, "add");
        this.fireEvent(event);
    }

    public void remove(Object[] elements) {
        super.remove(elements);
        ViewerContentChangeEvent event = new ViewerContentChangeEvent((Object)this, "remove");
        this.fireEvent(event);
    }

    public void remove(Object parent, Object[] elements) {
        super.remove(parent, elements);
        ViewerContentChangeEvent event = new ViewerContentChangeEvent((Object)this, "remove");
        this.fireEvent(event);
    }

    public void refresh(Object element, boolean updateLabels) {
        super.refresh(element, updateLabels);
        ViewerContentChangeEvent event = new ViewerContentChangeEvent((Object)this, "refresh");
        this.fireEvent(event);
    }

    protected void handleDoubleSelect(SelectionEvent event) {
        this.lastDoubleClickSelectionEventStateMask = event != null ? event.stateMask : 0;
        super.handleDoubleSelect(event);
    }

    protected void fireDoubleClick(DoubleClickEvent event) {
        boolean altPressed;
        boolean bl = altPressed = (this.lastDoubleClickSelectionEventStateMask & 0x10000) != 0;
        if (altPressed) {
            event = new AltDoubleClickEvent((Viewer)event.getSource(), event.getSelection());
        }
        super.fireDoubleClick(event);
    }
}

