/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm4e.ui.text;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.CursorLinePainter;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IPainter;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextInputListener;
import org.eclipse.jface.text.ITextListener;
import org.eclipse.jface.text.ITextOperationTarget;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITextViewerExtension5;
import org.eclipse.jface.text.PaintManager;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.TextEvent;
import org.eclipse.jface.text.TextPresentation;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Color;
import org.eclipse.tm4e.core.TMException;
import org.eclipse.tm4e.core.grammar.IGrammar;
import org.eclipse.tm4e.core.model.IModelTokensChangedListener;
import org.eclipse.tm4e.core.model.ITMModel;
import org.eclipse.tm4e.core.model.ModelTokensChangedEvent;
import org.eclipse.tm4e.core.model.Range;
import org.eclipse.tm4e.core.model.TMToken;
import org.eclipse.tm4e.registry.TMEclipseRegistryPlugin;
import org.eclipse.tm4e.ui.TMUIPlugin;
import org.eclipse.tm4e.ui.internal.model.TMDocumentModel;
import org.eclipse.tm4e.ui.internal.text.TMPresentationReconcilerTestGenerator;
import org.eclipse.tm4e.ui.internal.themes.ThemeManager;
import org.eclipse.tm4e.ui.model.ITMModelManager;
import org.eclipse.tm4e.ui.text.ITMPresentationReconcilerListener;
import org.eclipse.tm4e.ui.themes.ITheme;
import org.eclipse.tm4e.ui.themes.IThemeManager;
import org.eclipse.tm4e.ui.themes.ITokenProvider;
import org.eclipse.tm4e.ui.utils.ClassHelper;
import org.eclipse.tm4e.ui.utils.ContentTypeHelper;
import org.eclipse.tm4e.ui.utils.ContentTypeInfo;
import org.eclipse.tm4e.ui.utils.PreferenceUtils;
import org.eclipse.ui.IEditorPart;
import org.osgi.framework.Bundle;

public class TMPresentationReconciler
implements IPresentationReconciler {
    private final Token defaultToken = new Token(null);
    private ITextViewer viewer;
    private final InternalListener internalListener = new InternalListener();
    private IGrammar grammar;
    private boolean forcedGrammar;
    private ITokenProvider tokenProvider;
    private final TextAttribute fDefaultTextAttribute = new TextAttribute(null);
    private IEclipsePreferences.IPreferenceChangeListener themeChangeListener;
    private List<ITMPresentationReconcilerListener> listeners = null;
    private boolean initializeViewerColors;
    private boolean updateTextDecorations;
    private boolean enabled;
    private boolean throwError;

    public TMPresentationReconciler() {
        if (TMEclipseRegistryPlugin.isDebugOptionEnabled((String)"org.eclipse.tm4e.ui/debug/log/GenerateTest")) {
            this.addTMPresentationReconcilerListener(new TMPresentationReconcilerTestGenerator());
        }
        this.setThrowError(TMEclipseRegistryPlugin.isDebugOptionEnabled((String)"org.eclipse.tm4e.ui/debug/log/ThrowError"));
    }

    public void setGrammar(IGrammar grammar) {
        boolean changed = this.viewer != null && (this.grammar == null || !this.grammar.equals(grammar));
        this.grammar = grammar;
        this.forcedGrammar = true;
        if (changed) {
            IDocument document = this.viewer.getDocument();
            if (document == null) {
                return;
            }
            this.internalListener.inputDocumentAboutToBeChanged(this.viewer.getDocument(), null);
            this.internalListener.inputDocumentChanged(null, document);
        }
    }

    public IGrammar getGrammar() {
        return this.grammar;
    }

    public ITokenProvider getTokenProvider() {
        return this.tokenProvider;
    }

    public void setTheme(ITokenProvider newTheme) {
        ITokenProvider oldTheme = this.tokenProvider;
        if (!Objects.equals(oldTheme, newTheme) && this.grammar != null) {
            this.tokenProvider = newTheme;
            this.applyThemeEditor();
            IDocument document = this.viewer.getDocument();
            ITMModel model = this.getTMModelManager().connect(document);
            if (!(model instanceof TMDocumentModel)) {
                return;
            }
            TMDocumentModel docModel = (TMDocumentModel)model;
            try {
                this.colorize((IRegion)new Region(0, document.getLength()), docModel);
            }
            catch (BadLocationException e) {
                TMUIPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.tm4e.ui", e.getMessage(), (Throwable)e));
            }
        }
    }

    public void setThemeId(String themeId) {
        this.setTheme(TMUIPlugin.getThemeManager().getThemeById(themeId));
    }

    public void install(ITextViewer viewer) {
        Assert.isNotNull((Object)viewer);
        this.viewer = viewer;
        viewer.addTextInputListener((ITextInputListener)this.internalListener);
        IDocument document = viewer.getDocument();
        if (document != null) {
            this.internalListener.inputDocumentChanged(null, document);
        }
        this.themeChangeListener = new ThemeChangeListener();
        ThemeManager.getInstance().addPreferenceChangeListener(this.themeChangeListener);
    }

    public void uninstall() {
        this.viewer.removeTextInputListener((ITextInputListener)this.internalListener);
        this.internalListener.inputDocumentAboutToBeChanged(this.viewer.getDocument(), null);
        if (this.themeChangeListener != null) {
            ThemeManager.getInstance().removePreferenceChangeListener(this.themeChangeListener);
        }
        this.themeChangeListener = null;
    }

    public IPresentationDamager getDamager(String contentType) {
        return null;
    }

    public IPresentationRepairer getRepairer(String contentType) {
        return null;
    }

    private ITMModelManager getTMModelManager() {
        return TMUIPlugin.getTMModelManager();
    }

    void colorize(@NonNull IRegion damage, @NonNull TMDocumentModel model) throws BadLocationException {
        block11: {
            IDocument document = model.getDocument();
            int fromLineNumber = document.getLineOfOffset(damage.getOffset());
            int toLineNumber = document.getLineOfOffset(damage.getOffset() + damage.getLength());
            this.applyThemeEditorIfNeeded();
            TMUIPlugin.getDefault().trace("Render from: " + fromLineNumber + " to: " + toLineNumber);
            TextPresentation presentation = null;
            Throwable error = null;
            try {
                try {
                    presentation = new TextPresentation(damage, 1000);
                    int lastStart = presentation.getExtent().getOffset();
                    int length = 0;
                    boolean firstToken = true;
                    IToken lastToken = Token.UNDEFINED;
                    TextAttribute lastAttribute = this.getTokenTextAttribute(lastToken);
                    List tokens = null;
                    int line = fromLineNumber;
                    while (line <= toLineNumber) {
                        tokens = model.getLineTokens(line);
                        if (tokens == null) {
                            TMUIPlugin.getDefault().trace("TextMate tokens not available for line " + line);
                            break;
                        }
                        int startLineOffset = document.getLineOffset(line);
                        int i = 0;
                        while (i < tokens.size()) {
                            block14: {
                                IToken token;
                                int tokenStartIndex;
                                TMToken nextToken;
                                TMToken currentToken;
                                block15: {
                                    block12: {
                                        block13: {
                                            currentToken = (TMToken)tokens.get(i);
                                            nextToken = i + 1 < tokens.size() ? (TMToken)tokens.get(i + 1) : null;
                                            tokenStartIndex = currentToken.startIndex;
                                            if (!this.isBeforeRegion(currentToken, startLineOffset, damage)) break block12;
                                            if (nextToken == null) break block13;
                                            if (this.isBeforeRegion(nextToken, startLineOffset, damage)) break block14;
                                            tokenStartIndex = damage.getOffset() - startLineOffset;
                                            break block15;
                                        }
                                        tokenStartIndex = damage.getOffset() - startLineOffset;
                                        token = this.toToken(currentToken);
                                        lastAttribute = this.getTokenTextAttribute(token);
                                        length += this.getTokenLengh(tokenStartIndex, nextToken, line, document);
                                        firstToken = false;
                                        break block14;
                                    }
                                    if (this.isAfterRegion(currentToken, startLineOffset, damage)) break;
                                }
                                token = this.toToken(currentToken);
                                TextAttribute attribute = this.getTokenTextAttribute(token);
                                if (lastAttribute != null && lastAttribute.equals((Object)attribute)) {
                                    length += this.getTokenLengh(tokenStartIndex, nextToken, line, document);
                                    firstToken = false;
                                } else {
                                    if (!firstToken) {
                                        this.addRange(presentation, lastStart, length, lastAttribute);
                                    }
                                    firstToken = false;
                                    lastToken = token;
                                    lastAttribute = attribute;
                                    lastStart = tokenStartIndex + startLineOffset;
                                    length = this.getTokenLengh(tokenStartIndex, nextToken, line, document);
                                }
                            }
                            ++i;
                        }
                        ++line;
                    }
                    length = Math.min(length, damage.getOffset() + damage.getLength() - lastStart);
                    this.addRange(presentation, lastStart, length, lastAttribute);
                    this.applyTextRegionCollection(presentation);
                }
                catch (Exception e) {
                    TMUIPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.tm4e.ui", e.getMessage(), (Throwable)e));
                    this.fireColorize(presentation, error);
                    break block11;
                }
            }
            catch (Throwable throwable) {
                this.fireColorize(presentation, error);
                throw throwable;
            }
            this.fireColorize(presentation, error);
        }
    }

    private boolean isBeforeRegion(TMToken token, int startLineOffset, IRegion damage) {
        return token.startIndex + startLineOffset < damage.getOffset();
    }

    private boolean isAfterRegion(TMToken t, int startLineOffset, IRegion damage) {
        return t.startIndex + startLineOffset >= damage.getOffset() + damage.getLength();
    }

    private IToken toToken(TMToken t) {
        IToken token = this.getTokenProvider().getToken(t.type);
        if (token != null) {
            return token;
        }
        return this.defaultToken;
    }

    private int getTokenLengh(int tokenStartIndex, TMToken nextToken, int line, IDocument document) throws BadLocationException {
        if (nextToken != null) {
            return nextToken.startIndex - tokenStartIndex;
        }
        return document.getLineLength(line) - tokenStartIndex;
    }

    protected TextAttribute getTokenTextAttribute(IToken token) {
        Object data = token.getData();
        if (data instanceof TextAttribute) {
            return (TextAttribute)data;
        }
        return this.fDefaultTextAttribute;
    }

    protected void addRange(TextPresentation presentation, int offset, int length, TextAttribute attr) {
        if (attr != null) {
            int style = attr.getStyle();
            int fontStyle = style & 3;
            StyleRange styleRange = new StyleRange(offset, length, attr.getForeground(), attr.getBackground(), fontStyle);
            styleRange.strikeout = (style & 0x20000000) != 0;
            styleRange.underline = (style & 0x40000000) != 0;
            styleRange.font = attr.getFont();
            presentation.addStyleRange(styleRange);
        }
    }

    private void applyTextRegionCollection(TextPresentation presentation) {
        this.viewer.changeTextPresentation(presentation, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTMPresentationReconcilerListener(ITMPresentationReconcilerListener listener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList<ITMPresentationReconcilerListener>();
        }
        List<ITMPresentationReconcilerListener> list = this.listeners;
        synchronized (list) {
            if (!this.listeners.contains(listener)) {
                this.listeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTMPresentationReconcilerListener(ITMPresentationReconcilerListener listener) {
        if (this.listeners == null) {
            return;
        }
        List<ITMPresentationReconcilerListener> list = this.listeners;
        synchronized (list) {
            this.listeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireColorize(TextPresentation presentation, Throwable error) {
        if (this.listeners == null) {
            return;
        }
        List<ITMPresentationReconcilerListener> list = this.listeners;
        synchronized (list) {
            for (ITMPresentationReconcilerListener listener : this.listeners) {
                listener.colorize(presentation, error);
            }
        }
    }

    public static TMPresentationReconciler getTMPresentationReconciler(IEditorPart editorPart) {
        if (editorPart == null) {
            return null;
        }
        @Nullable ITextOperationTarget target = (ITextOperationTarget)editorPart.getAdapter(ITextOperationTarget.class);
        if (target instanceof ITextViewer) {
            ITextViewer textViewer = (ITextViewer)target;
            return TMPresentationReconciler.getTMPresentationReconciler(textViewer);
        }
        return null;
    }

    public static TMPresentationReconciler getTMPresentationReconciler(ITextViewer textViewer) {
        try {
            Field field = SourceViewer.class.getDeclaredField("fPresentationReconciler");
            if (field != null) {
                field.setAccessible(true);
                IPresentationReconciler presentationReconciler = (IPresentationReconciler)field.get(textViewer);
                return presentationReconciler instanceof TMPresentationReconciler ? (TMPresentationReconciler)presentationReconciler : null;
            }
        }
        catch (Exception e) {
            TMUIPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.tm4e.ui", e.getMessage(), (Throwable)e));
        }
        return null;
    }

    private void applyThemeEditor() {
        this.initializeViewerColors = false;
        this.updateTextDecorations = false;
        this.applyThemeEditorIfNeeded();
    }

    private void applyThemeEditorIfNeeded() {
        if (!this.initializeViewerColors) {
            StyledText styledText = this.viewer.getTextWidget();
            ((ITheme)this.tokenProvider).initializeViewerColors(styledText);
            this.initializeViewerColors = true;
        }
        if (this.updateTextDecorations) {
            return;
        }
        try {
            PaintManager paintManager = (PaintManager)ClassHelper.getFieldValue(this.viewer, "fPaintManager", TextViewer.class);
            if (paintManager == null) {
                return;
            }
            List painters = (List)ClassHelper.getFieldValue(paintManager, "fPainters", PaintManager.class);
            if (painters == null) {
                return;
            }
            for (IPainter painter : painters) {
                if (!(painter instanceof CursorLinePainter)) continue;
                Color background = this.tokenProvider.getEditorCurrentLineHighlight();
                if (background != null) {
                    ((CursorLinePainter)painter).setHighlightColor(background);
                }
                this.updateTextDecorations = true;
            }
        }
        catch (Exception e) {
            TMUIPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.tm4e.ui", e.getMessage(), (Throwable)e));
        }
    }

    public void setThrowError(boolean throwError) {
        this.throwError = throwError;
    }

    public boolean isThrowError() {
        return this.throwError;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    class InternalListener
    implements ITextInputListener,
    IModelTokensChangedListener,
    ITextListener {
        InternalListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void fireInstall(ITextViewer viewer, IDocument document) {
            if (TMPresentationReconciler.this.listeners == null) {
                return;
            }
            List list = TMPresentationReconciler.this.listeners;
            synchronized (list) {
                for (ITMPresentationReconcilerListener listener : TMPresentationReconciler.this.listeners) {
                    listener.install(viewer, document);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void fireUninstall() {
            if (TMPresentationReconciler.this.listeners == null) {
                return;
            }
            List list = TMPresentationReconciler.this.listeners;
            synchronized (list) {
                for (ITMPresentationReconcilerListener listener : TMPresentationReconciler.this.listeners) {
                    listener.uninstall();
                }
            }
        }

        public void inputDocumentAboutToBeChanged(IDocument oldDocument, IDocument newDocument) {
            if (oldDocument != null) {
                TMPresentationReconciler.this.viewer.removeTextListener((ITextListener)this);
                TMPresentationReconciler.this.getTMModelManager().disconnect(oldDocument);
                this.fireUninstall();
            }
        }

        public void inputDocumentChanged(IDocument oldDocument, IDocument newDocument) {
            if (newDocument == null) {
                return;
            }
            this.fireInstall(TMPresentationReconciler.this.viewer, newDocument);
            try {
                TMPresentationReconciler.this.viewer.addTextListener((ITextListener)this);
                IGrammar localGrammar = this.findGrammar(newDocument);
                if (localGrammar != null) {
                    TMPresentationReconciler.this.grammar = localGrammar;
                } else if (TMPresentationReconciler.this.isThrowError()) {
                    throw new TMException("Cannot find TextMate grammar for the given document");
                }
                if (localGrammar != null) {
                    String scopeName = localGrammar.getScopeName();
                    if (TMPresentationReconciler.this.tokenProvider == null) {
                        TMPresentationReconciler.this.tokenProvider = TMUIPlugin.getThemeManager().getThemeForScope(scopeName);
                    }
                    if (TMPresentationReconciler.this.tokenProvider != null) {
                        TMPresentationReconciler.this.applyThemeEditor();
                    } else if (TMPresentationReconciler.this.isThrowError()) {
                        throw new TMException("Cannot find Theme for the given grammar '" + scopeName + "'");
                    }
                }
                boolean bl = localGrammar != null && TMPresentationReconciler.this.tokenProvider != null;
                TMPresentationReconciler.this.enabled = bl;
                boolean enable = bl;
                if (enable) {
                    ITMModel model = TMPresentationReconciler.this.getTMModelManager().connect(newDocument);
                    model.setGrammar(localGrammar);
                    model.addModelTokensChangedListener((IModelTokensChangedListener)this);
                }
            }
            catch (CoreException e) {
                Platform.getLog((Bundle)Platform.getBundle((String)"org.eclipse.tm4e.registry")).log((IStatus)new Status(4, "org.eclipse.tm4e.ui", "Error while initializing TextMate model.", (Throwable)e));
            }
        }

        protected IGrammar findGrammar(@NonNull IDocument newDocument) throws CoreException {
            IGrammar localGrammar;
            IGrammar iGrammar = localGrammar = TMPresentationReconciler.this.forcedGrammar ? TMPresentationReconciler.this.grammar : null;
            if (localGrammar != null) {
                return localGrammar;
            }
            ContentTypeInfo info = ContentTypeHelper.findContentTypes(newDocument);
            if (info == null) {
                return null;
            }
            return this.findGrammar(info);
        }

        public void textChanged(TextEvent e) {
            if (!e.getViewerRedrawState()) {
                return;
            }
            if (e.getDocumentEvent() != null) {
                int diff = e.getText().length() - e.getLength();
                if (diff == 0 || e.getOffset() <= 0) {
                    return;
                }
                StyleRange range = TMPresentationReconciler.this.viewer.getTextWidget().getStyleRangeAtOffset(e.getOffset() - 1);
                if (range == null) {
                    return;
                }
                range.length = Math.max(0, range.length + diff);
                TMPresentationReconciler.this.viewer.getTextWidget().setStyleRange(range);
                return;
            }
            IDocument document = TMPresentationReconciler.this.viewer.getDocument();
            if (document == null) {
                return;
            }
            IRegion region = this.computeRegionToRedraw(e, document);
            if (TMPresentationReconciler.this.enabled) {
                ITMModel model = TMPresentationReconciler.this.getTMModelManager().connect(document);
                if (model == null) {
                    return;
                }
                try {
                    TMPresentationReconciler.this.colorize(region, (TMDocumentModel)model);
                }
                catch (BadLocationException e1) {
                    TMUIPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.tm4e.ui", e1.getMessage(), (Throwable)e1));
                }
            } else {
                TextPresentation presentation = new TextPresentation(region, 100);
                presentation.setDefaultStyleRange(new StyleRange(region.getOffset(), region.getLength(), null, null));
                TMPresentationReconciler.this.applyTextRegionCollection(presentation);
            }
        }

        protected @NonNull IRegion computeRegionToRedraw(@NonNull TextEvent e, @NonNull IDocument document) {
            Object region = null;
            region = e.getOffset() == 0 && e.getLength() == 0 && e.getText() == null ? new Region(0, document.getLength()) : this.widgetRegion2ModelRegion(e);
            if (region == null || region.getLength() == 0) {
                return new Region(0, 0);
            }
            return region;
        }

        private IRegion widgetRegion2ModelRegion(TextEvent e) {
            int length;
            String text = e.getText();
            int n = length = text == null ? 0 : text.length();
            if (TMPresentationReconciler.this.viewer instanceof ITextViewerExtension5) {
                ITextViewerExtension5 extension = (ITextViewerExtension5)TMPresentationReconciler.this.viewer;
                return extension.widgetRange2ModelRange((IRegion)new Region(e.getOffset(), length));
            }
            IRegion visible = TMPresentationReconciler.this.viewer.getVisibleRegion();
            return new Region(e.getOffset() + visible.getOffset(), length);
        }

        public void modelTokensChanged(ModelTokensChangedEvent event) {
            StyledText control = TMPresentationReconciler.this.viewer.getTextWidget();
            if (control != null) {
                control.getDisplay().asyncExec(() -> {
                    if (TMPresentationReconciler.this.viewer != null) {
                        this.colorize(event);
                    }
                });
            }
        }

        private void colorize(ModelTokensChangedEvent event) {
            IDocument document = TMPresentationReconciler.this.viewer.getDocument();
            if (document == null) {
                return;
            }
            ITMModel model = event.model;
            if (!(model instanceof TMDocumentModel)) {
                return;
            }
            TMDocumentModel docModel = (TMDocumentModel)model;
            for (Range range : event.ranges) {
                try {
                    int length = document.getLineOffset(range.toLineNumber - 1) + document.getLineLength(range.toLineNumber - 1) - document.getLineOffset(range.fromLineNumber - 1);
                    Region region = new Region(document.getLineOffset(range.fromLineNumber - 1), length);
                    TMPresentationReconciler.this.colorize((IRegion)region, docModel);
                }
                catch (BadLocationException ex) {
                    TMUIPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.tm4e.ui", ex.getMessage(), (Throwable)ex));
                }
            }
        }

        private IGrammar findGrammar(ContentTypeInfo info) {
            String fileName;
            if (info == null) {
                return null;
            }
            IContentType[] contentTypes = info.getContentTypes();
            IGrammar res = TMEclipseRegistryPlugin.getGrammarRegistryManager().getGrammarFor(contentTypes);
            if (res == null && (fileName = info.getFileName()) != null) {
                String fileType = new Path(fileName).getFileExtension();
                res = TMEclipseRegistryPlugin.getGrammarRegistryManager().getGrammarForFileType(fileType);
            }
            return res;
        }
    }

    private class ThemeChangeListener
    implements IEclipsePreferences.IPreferenceChangeListener {
        private ThemeChangeListener() {
        }

        public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
            IThemeManager themeManager = TMUIPlugin.getThemeManager();
            if ("themeid".equals(event.getKey())) {
                this.preferenceThemeChange((String)event.getNewValue(), themeManager);
            } else if ("org.eclipse.tm4e.ui.themeAssociations".equals(event.getKey())) {
                this.preferenceThemeChange(PreferenceUtils.getE4PreferenceCSSThemeId(), themeManager);
            }
        }

        private void preferenceThemeChange(String eclipseThemeId, IThemeManager themeManager) {
            IDocument document = TMPresentationReconciler.this.viewer.getDocument();
            if (document == null) {
                return;
            }
            if (TMPresentationReconciler.this.grammar == null) {
                return;
            }
            boolean dark = themeManager.isDarkEclipseTheme(eclipseThemeId);
            ITheme newTheme = themeManager.getThemeForScope(TMPresentationReconciler.this.grammar.getScopeName(), dark);
            TMPresentationReconciler.this.setTheme(newTheme);
        }
    }
}

