/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.localsearch.operations.check;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.viatra.query.runtime.localsearch.MatchingFrame;
import org.eclipse.viatra.query.runtime.localsearch.exceptions.LocalSearchException;
import org.eclipse.viatra.query.runtime.localsearch.matcher.ISearchContext;
import org.eclipse.viatra.query.runtime.localsearch.operations.CheckOperationExecutor;
import org.eclipse.viatra.query.runtime.localsearch.operations.ISearchOperation;

public class StructuralFeatureCheck
implements ISearchOperation {
    int sourcePosition;
    int targetPosition;
    EStructuralFeature feature;

    public StructuralFeatureCheck(int sourcePosition, int targetPosition, EStructuralFeature feature) {
        this.sourcePosition = sourcePosition;
        this.targetPosition = targetPosition;
        this.feature = feature;
    }

    @Override
    public ISearchOperation.ISearchOperationExecutor createExecutor() {
        return new Executor();
    }

    public String toString() {
        return this.toString(Object::toString);
    }

    @Override
    public String toString(Function<Integer, String> variableMapping) {
        return "check     " + this.feature.getContainerClass().getSimpleName() + "." + this.feature.getName() + "(+" + variableMapping.apply(this.sourcePosition) + ", +" + variableMapping.apply(this.targetPosition) + ")";
    }

    @Override
    public List<Integer> getVariablePositions() {
        return Arrays.asList(this.sourcePosition, this.targetPosition);
    }

    private class Executor
    extends CheckOperationExecutor {
        private Executor() {
        }

        @Override
        protected boolean check(MatchingFrame frame, ISearchContext context) {
            EObject source;
            block4: {
                Objects.requireNonNull(frame.getValue(StructuralFeatureCheck.this.sourcePosition), () -> String.format("Invalid plan, variable %s unbound", StructuralFeatureCheck.this.sourcePosition));
                Objects.requireNonNull(frame.getValue(StructuralFeatureCheck.this.targetPosition), () -> String.format("Invalid plan, variable %s unbound", StructuralFeatureCheck.this.targetPosition));
                try {
                    source = (EObject)frame.getValue(StructuralFeatureCheck.this.sourcePosition);
                    if (StructuralFeatureCheck.this.feature.getEContainingClass().isSuperTypeOf(source.eClass())) break block4;
                    return false;
                }
                catch (ClassCastException e) {
                    throw new LocalSearchException("Invalid type of variable", e);
                }
            }
            Object target = frame.getValue(StructuralFeatureCheck.this.targetPosition);
            if (StructuralFeatureCheck.this.feature.isMany()) {
                return ((Collection)source.eGet(StructuralFeatureCheck.this.feature)).contains(target);
            }
            return target.equals(source.eGet(StructuralFeatureCheck.this.feature));
        }

        @Override
        public ISearchOperation getOperation() {
            return StructuralFeatureCheck.this;
        }
    }
}

