/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.swing.databinding;

import java.util.List;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IImportDeclaration;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.wb.core.editor.IDesignerEditor;
import org.eclipse.wb.core.editor.IEditorPage;
import org.eclipse.wb.core.editor.IEditorPageFactory;
import org.eclipse.wb.internal.core.databinding.ui.BindingDesignPage;
import org.eclipse.wb.internal.swing.databinding.model.DataBindingsCodeUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DesignPageFactory
implements IEditorPageFactory {
    public void createPages(IDesignerEditor editor, List<IEditorPage> pages) {
        if (DesignPageFactory.isSwingDB(editor.getCompilationUnit())) {
            BindingDesignPage.addPage(pages);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isSwingDB(ICompilationUnit compilationUnit) {
        IJavaProject javaProject = compilationUnit.getJavaProject();
        if (!DataBindingsCodeUtils.isDBAvailable(javaProject)) return false;
        try {
            IImportDeclaration[] imports;
            IImportDeclaration[] iImportDeclarationArray = imports = compilationUnit.getImports();
            int n = imports.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return false;
                }
                IImportDeclaration importDeclaration = iImportDeclarationArray[n2];
                String elementName = importDeclaration.getElementName();
                if (elementName.startsWith("java.awt")) return true;
                if (elementName.startsWith("javax.swing")) {
                    return true;
                }
                ++n2;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }
}

