/*
 * Decompiled with CFR 0.152.
 */
package org.mandas.docker.client.messages.swarm;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;
import org.mandas.docker.Nullable;
import org.mandas.docker.client.messages.swarm.RaftConfig;

final class ImmutableRaftConfig
implements RaftConfig {
    @Nullable
    private final Integer snapshotInterval;
    @Nullable
    private final Integer keepOldSnapshots;
    @Nullable
    private final Integer logEntriesForSlowFollowers;
    @Nullable
    private final Integer electionTick;
    @Nullable
    private final Integer heartbeatTick;

    private ImmutableRaftConfig(@Nullable Integer snapshotInterval, @Nullable Integer keepOldSnapshots, @Nullable Integer logEntriesForSlowFollowers, @Nullable Integer electionTick, @Nullable Integer heartbeatTick) {
        this.snapshotInterval = snapshotInterval;
        this.keepOldSnapshots = keepOldSnapshots;
        this.logEntriesForSlowFollowers = logEntriesForSlowFollowers;
        this.electionTick = electionTick;
        this.heartbeatTick = heartbeatTick;
    }

    @Override
    @JsonProperty(value="SnapshotInterval")
    @Nullable
    public Integer snapshotInterval() {
        return this.snapshotInterval;
    }

    @Override
    @JsonProperty(value="KeepOldSnapshots")
    @Nullable
    public Integer keepOldSnapshots() {
        return this.keepOldSnapshots;
    }

    @Override
    @JsonProperty(value="LogEntriesForSlowFollowers")
    @Nullable
    public Integer logEntriesForSlowFollowers() {
        return this.logEntriesForSlowFollowers;
    }

    @Override
    @JsonProperty(value="ElectionTick")
    @Nullable
    public Integer electionTick() {
        return this.electionTick;
    }

    @Override
    @JsonProperty(value="HeartbeatTick")
    @Nullable
    public Integer heartbeatTick() {
        return this.heartbeatTick;
    }

    public final ImmutableRaftConfig withSnapshotInterval(@Nullable Integer value) {
        if (Objects.equals(this.snapshotInterval, value)) {
            return this;
        }
        return new ImmutableRaftConfig(value, this.keepOldSnapshots, this.logEntriesForSlowFollowers, this.electionTick, this.heartbeatTick);
    }

    public final ImmutableRaftConfig withKeepOldSnapshots(@Nullable Integer value) {
        if (Objects.equals(this.keepOldSnapshots, value)) {
            return this;
        }
        return new ImmutableRaftConfig(this.snapshotInterval, value, this.logEntriesForSlowFollowers, this.electionTick, this.heartbeatTick);
    }

    public final ImmutableRaftConfig withLogEntriesForSlowFollowers(@Nullable Integer value) {
        if (Objects.equals(this.logEntriesForSlowFollowers, value)) {
            return this;
        }
        return new ImmutableRaftConfig(this.snapshotInterval, this.keepOldSnapshots, value, this.electionTick, this.heartbeatTick);
    }

    public final ImmutableRaftConfig withElectionTick(@Nullable Integer value) {
        if (Objects.equals(this.electionTick, value)) {
            return this;
        }
        return new ImmutableRaftConfig(this.snapshotInterval, this.keepOldSnapshots, this.logEntriesForSlowFollowers, value, this.heartbeatTick);
    }

    public final ImmutableRaftConfig withHeartbeatTick(@Nullable Integer value) {
        if (Objects.equals(this.heartbeatTick, value)) {
            return this;
        }
        return new ImmutableRaftConfig(this.snapshotInterval, this.keepOldSnapshots, this.logEntriesForSlowFollowers, this.electionTick, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableRaftConfig && this.equalTo((ImmutableRaftConfig)another);
    }

    private boolean equalTo(ImmutableRaftConfig another) {
        return Objects.equals(this.snapshotInterval, another.snapshotInterval) && Objects.equals(this.keepOldSnapshots, another.keepOldSnapshots) && Objects.equals(this.logEntriesForSlowFollowers, another.logEntriesForSlowFollowers) && Objects.equals(this.electionTick, another.electionTick) && Objects.equals(this.heartbeatTick, another.heartbeatTick);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.snapshotInterval);
        h += (h << 5) + Objects.hashCode(this.keepOldSnapshots);
        h += (h << 5) + Objects.hashCode(this.logEntriesForSlowFollowers);
        h += (h << 5) + Objects.hashCode(this.electionTick);
        h += (h << 5) + Objects.hashCode(this.heartbeatTick);
        return h;
    }

    public String toString() {
        return "RaftConfig{snapshotInterval=" + this.snapshotInterval + ", keepOldSnapshots=" + this.keepOldSnapshots + ", logEntriesForSlowFollowers=" + this.logEntriesForSlowFollowers + ", electionTick=" + this.electionTick + ", heartbeatTick=" + this.heartbeatTick + "}";
    }

    public static ImmutableRaftConfig copyOf(RaftConfig instance) {
        if (instance instanceof ImmutableRaftConfig) {
            return (ImmutableRaftConfig)instance;
        }
        return ImmutableRaftConfig.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    static final class Builder
    implements RaftConfig.Builder {
        private Integer snapshotInterval;
        private Integer keepOldSnapshots;
        private Integer logEntriesForSlowFollowers;
        private Integer electionTick;
        private Integer heartbeatTick;

        private Builder() {
        }

        public final Builder from(RaftConfig instance) {
            Integer heartbeatTickValue;
            Integer electionTickValue;
            Integer logEntriesForSlowFollowersValue;
            Integer keepOldSnapshotsValue;
            Objects.requireNonNull(instance, "instance");
            Integer snapshotIntervalValue = instance.snapshotInterval();
            if (snapshotIntervalValue != null) {
                this.snapshotInterval(snapshotIntervalValue);
            }
            if ((keepOldSnapshotsValue = instance.keepOldSnapshots()) != null) {
                this.keepOldSnapshots(keepOldSnapshotsValue);
            }
            if ((logEntriesForSlowFollowersValue = instance.logEntriesForSlowFollowers()) != null) {
                this.logEntriesForSlowFollowers(logEntriesForSlowFollowersValue);
            }
            if ((electionTickValue = instance.electionTick()) != null) {
                this.electionTick(electionTickValue);
            }
            if ((heartbeatTickValue = instance.heartbeatTick()) != null) {
                this.heartbeatTick(heartbeatTickValue);
            }
            return this;
        }

        @Override
        @JsonProperty(value="SnapshotInterval")
        public final Builder snapshotInterval(@Nullable Integer snapshotInterval) {
            this.snapshotInterval = snapshotInterval;
            return this;
        }

        @Override
        @JsonProperty(value="KeepOldSnapshots")
        public final Builder keepOldSnapshots(@Nullable Integer keepOldSnapshots) {
            this.keepOldSnapshots = keepOldSnapshots;
            return this;
        }

        @Override
        @JsonProperty(value="LogEntriesForSlowFollowers")
        public final Builder logEntriesForSlowFollowers(@Nullable Integer logEntriesForSlowFollowers) {
            this.logEntriesForSlowFollowers = logEntriesForSlowFollowers;
            return this;
        }

        @Override
        @JsonProperty(value="ElectionTick")
        public final Builder electionTick(@Nullable Integer electionTick) {
            this.electionTick = electionTick;
            return this;
        }

        @Override
        @JsonProperty(value="HeartbeatTick")
        public final Builder heartbeatTick(@Nullable Integer heartbeatTick) {
            this.heartbeatTick = heartbeatTick;
            return this;
        }

        @Override
        public ImmutableRaftConfig build() {
            return new ImmutableRaftConfig(this.snapshotInterval, this.keepOldSnapshots, this.logEntriesForSlowFollowers, this.electionTick, this.heartbeatTick);
        }
    }
}

