/*
 * Decompiled with CFR 0.152.
 */
package org.mandas.docker.client.messages.swarm;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;
import org.mandas.docker.Nullable;
import org.mandas.docker.client.messages.swarm.GlobalService;
import org.mandas.docker.client.messages.swarm.ReplicatedService;
import org.mandas.docker.client.messages.swarm.ServiceMode;

final class ImmutableServiceMode
implements ServiceMode {
    @Nullable
    private final ReplicatedService replicated;
    @Nullable
    private final GlobalService global;

    private ImmutableServiceMode(@Nullable ReplicatedService replicated, @Nullable GlobalService global) {
        this.replicated = replicated;
        this.global = global;
    }

    @Override
    @JsonProperty(value="Replicated")
    @Nullable
    public ReplicatedService replicated() {
        return this.replicated;
    }

    @Override
    @JsonProperty(value="Global")
    @Nullable
    public GlobalService global() {
        return this.global;
    }

    public final ImmutableServiceMode withReplicated(@Nullable ReplicatedService value) {
        if (this.replicated == value) {
            return this;
        }
        return new ImmutableServiceMode(value, this.global);
    }

    public final ImmutableServiceMode withGlobal(@Nullable GlobalService value) {
        if (this.global == value) {
            return this;
        }
        return new ImmutableServiceMode(this.replicated, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableServiceMode && this.equalTo((ImmutableServiceMode)another);
    }

    private boolean equalTo(ImmutableServiceMode another) {
        return Objects.equals(this.replicated, another.replicated) && Objects.equals(this.global, another.global);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.replicated);
        h += (h << 5) + Objects.hashCode(this.global);
        return h;
    }

    public String toString() {
        return "ServiceMode{replicated=" + this.replicated + ", global=" + this.global + "}";
    }

    public static ImmutableServiceMode copyOf(ServiceMode instance) {
        if (instance instanceof ImmutableServiceMode) {
            return (ImmutableServiceMode)instance;
        }
        return ImmutableServiceMode.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    static final class Builder
    implements ServiceMode.Builder {
        private ReplicatedService replicated;
        private GlobalService global;

        private Builder() {
        }

        public final Builder from(ServiceMode instance) {
            GlobalService globalValue;
            Objects.requireNonNull(instance, "instance");
            ReplicatedService replicatedValue = instance.replicated();
            if (replicatedValue != null) {
                this.replicated(replicatedValue);
            }
            if ((globalValue = instance.global()) != null) {
                this.global(globalValue);
            }
            return this;
        }

        @Override
        @JsonProperty(value="Replicated")
        public final Builder replicated(@Nullable ReplicatedService replicated) {
            this.replicated = replicated;
            return this;
        }

        @Override
        @JsonProperty(value="Global")
        public final Builder global(@Nullable GlobalService global) {
            this.global = global;
            return this;
        }

        @Override
        public ImmutableServiceMode build() {
            return new ImmutableServiceMode(this.replicated, this.global);
        }
    }
}

