/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.ui.util;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.xml.namespace.QName;
import org.eclipse.bpel.common.extension.model.ExtensionMap;
import org.eclipse.bpel.common.ui.ImageUtils;
import org.eclipse.bpel.common.ui.details.viewers.ComboViewer;
import org.eclipse.bpel.common.ui.details.widgets.DecoratedLabel;
import org.eclipse.bpel.common.ui.markers.ModelMarkerUtil;
import org.eclipse.bpel.model.BPELFactory;
import org.eclipse.bpel.model.BPELPackage;
import org.eclipse.bpel.model.Catch;
import org.eclipse.bpel.model.CompensateScope;
import org.eclipse.bpel.model.CorrelationSet;
import org.eclipse.bpel.model.CorrelationSets;
import org.eclipse.bpel.model.Flow;
import org.eclipse.bpel.model.ForEach;
import org.eclipse.bpel.model.Invoke;
import org.eclipse.bpel.model.OnEvent;
import org.eclipse.bpel.model.PartnerLink;
import org.eclipse.bpel.model.PartnerLinks;
import org.eclipse.bpel.model.Process;
import org.eclipse.bpel.model.Scope;
import org.eclipse.bpel.model.Sequence;
import org.eclipse.bpel.model.Variable;
import org.eclipse.bpel.model.Variables;
import org.eclipse.bpel.model.adapters.AdapterRegistry;
import org.eclipse.bpel.model.messageproperties.MessagepropertiesPackage;
import org.eclipse.bpel.model.messageproperties.PropertyAlias;
import org.eclipse.bpel.model.partnerlinktype.PartnerlinktypePackage;
import org.eclipse.bpel.model.util.BPELUtils;
import org.eclipse.bpel.names.NCNameWordDetector;
import org.eclipse.bpel.ui.BPELEditor;
import org.eclipse.bpel.ui.BPELUIPlugin;
import org.eclipse.bpel.ui.Messages;
import org.eclipse.bpel.ui.Policy;
import org.eclipse.bpel.ui.adapters.BPELUIAdapterFactory;
import org.eclipse.bpel.ui.adapters.BPELUIExtensionAdapterFactory;
import org.eclipse.bpel.ui.adapters.BPELUIMessagePropertiesAdapterFactory;
import org.eclipse.bpel.ui.adapters.BPELUIPartnerLinkTypeAdapterFactory;
import org.eclipse.bpel.ui.adapters.BPELUIWSDLAdapterFactory;
import org.eclipse.bpel.ui.adapters.BPELUIWSILAdapterFactory;
import org.eclipse.bpel.ui.adapters.BPELUIXSDAdapterFactory;
import org.eclipse.bpel.ui.adapters.IContainer;
import org.eclipse.bpel.ui.adapters.ILabeledElement;
import org.eclipse.bpel.ui.adapters.INamedElement;
import org.eclipse.bpel.ui.bpelactions.AbstractBPELAction;
import org.eclipse.bpel.ui.dialogs.NamespaceMappingDialog;
import org.eclipse.bpel.ui.editparts.BPELEditPart;
import org.eclipse.bpel.ui.editparts.FlowEditPart;
import org.eclipse.bpel.ui.editparts.InvokeEditPart;
import org.eclipse.bpel.ui.editparts.LinkEditPart;
import org.eclipse.bpel.ui.editparts.ScopeEditPart;
import org.eclipse.bpel.ui.editparts.StartNodeEditPart;
import org.eclipse.bpel.ui.editparts.borders.GradientBorder;
import org.eclipse.bpel.ui.editparts.util.OverlayCompositeImageDescriptor;
import org.eclipse.bpel.ui.extensions.ActionDescriptor;
import org.eclipse.bpel.ui.extensions.BPELUIRegistry;
import org.eclipse.bpel.ui.uiextensionmodel.ActivityExtension;
import org.eclipse.bpel.ui.uiextensionmodel.UiextensionmodelPackage;
import org.eclipse.bpel.ui.util.FlowLinkUtil;
import org.eclipse.bpel.ui.util.IHilightControllingTool;
import org.eclipse.bpel.ui.util.IModelVisitor;
import org.eclipse.bpel.ui.util.ModelHelper;
import org.eclipse.bpel.ui.util.TableCursor;
import org.eclipse.bpel.validator.EmfModelQuery;
import org.eclipse.bpel.wsil.model.inspection.InspectionPackage;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.gef.AccessibleEditPart;
import org.eclipse.gef.EditDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.Tool;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.accessibility.AccessibleControlEvent;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.ModuleCoreNature;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.wsdl.Definition;
import org.eclipse.wst.wsdl.Fault;
import org.eclipse.wst.wsdl.Input;
import org.eclipse.wst.wsdl.Message;
import org.eclipse.wst.wsdl.Operation;
import org.eclipse.wst.wsdl.Output;
import org.eclipse.wst.wsdl.PortType;
import org.eclipse.wst.wsdl.WSDLPackage;
import org.eclipse.wst.wsdl.util.WSDLResourceImpl;
import org.eclipse.xsd.XSDAttributeDeclaration;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDPackage;
import org.w3c.dom.Node;

public class BPELUtil {
    private static final Variable[] EMPTY_VARIABLE_ARRAY = new Variable[0];
    private static final PartnerLink[] EMPTY_PARTNERLINK_ARRAY = new PartnerLink[0];
    private static final CorrelationSet[] EMPTY_CORRELATIONSET_ARRAY = new CorrelationSet[0];
    public static IPath lastWSDLFilePath = null;
    public static IPath lastBPELFilePath = null;
    public static IPath lastXSDFilePath;
    static final NCNameWordDetector NCNAME_DETECTOR;

    static {
        AdapterRegistry.INSTANCE.registerAdapterFactory((EPackage)BPELPackage.eINSTANCE, (AdapterFactory)BPELUIAdapterFactory.getInstance());
        AdapterRegistry.INSTANCE.registerAdapterFactory((EPackage)WSDLPackage.eINSTANCE, (AdapterFactory)BPELUIWSDLAdapterFactory.getInstance());
        AdapterRegistry.INSTANCE.registerAdapterFactory((EPackage)PartnerlinktypePackage.eINSTANCE, (AdapterFactory)BPELUIPartnerLinkTypeAdapterFactory.getInstance());
        AdapterRegistry.INSTANCE.registerAdapterFactory((EPackage)XSDPackage.eINSTANCE, (AdapterFactory)BPELUIXSDAdapterFactory.getInstance());
        AdapterRegistry.INSTANCE.registerAdapterFactory((EPackage)MessagepropertiesPackage.eINSTANCE, (AdapterFactory)BPELUIMessagePropertiesAdapterFactory.getInstance());
        AdapterRegistry.INSTANCE.registerAdapterFactory((EPackage)UiextensionmodelPackage.eINSTANCE, (AdapterFactory)BPELUIExtensionAdapterFactory.getInstance());
        AdapterRegistry.INSTANCE.registerAdapterFactory((EPackage)InspectionPackage.eINSTANCE, (AdapterFactory)BPELUIWSILAdapterFactory.getInstance());
        NCNAME_DETECTOR = new NCNameWordDetector();
    }

    public static void registerAdapterFactory(EClass key, AdapterFactory factory) {
        AdapterRegistry.INSTANCE.registerAdapterFactory(key, factory);
    }

    public static void registerAdapterFactory(EPackage key, AdapterFactory factory) {
        AdapterRegistry.INSTANCE.registerAdapterFactory(key, factory);
    }

    static Class<?> adapterInterface(Object type) {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof String) {
            try {
                return Class.forName((String)type);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
        throw new RuntimeException("Adapter type " + type + " is not understood.");
    }

    public static <T> T adapt(Object target, Class<T> clazz) {
        return (T)AdapterRegistry.INSTANCE.adapt(target, clazz);
    }

    public static Object adapt(Object target, Object type) {
        return AdapterRegistry.INSTANCE.adapt(target, type);
    }

    public static Object adapt(Object target, Object type, Object context) {
        return AdapterRegistry.INSTANCE.adapt(target, type, context);
    }

    public static EClass getEClassFor(Object target) {
        if (target instanceof Invoke) {
            ActionDescriptor[] descriptors;
            ActionDescriptor[] actionDescriptorArray = descriptors = BPELUIRegistry.getInstance().getActionDescriptors();
            int n = descriptors.length;
            int n2 = 0;
            while (n2 < n) {
                ActionDescriptor descriptor = actionDescriptorArray[n2];
                AbstractBPELAction action = descriptor.getAction();
                if (action.isInstanceOf(target)) {
                    return action.getModelType();
                }
                ++n2;
            }
        }
        if (!(target instanceof EObject)) {
            return null;
        }
        return ((EObject)target).eClass();
    }

    public static boolean isCustomActivity(Object target) {
        if (target instanceof Invoke) {
            ActionDescriptor[] descriptors;
            ActionDescriptor[] actionDescriptorArray = descriptors = BPELUIRegistry.getInstance().getActionDescriptors();
            int n = descriptors.length;
            int n2 = 0;
            while (n2 < n) {
                ActionDescriptor descriptor = actionDescriptorArray[n2];
                AbstractBPELAction action = descriptor.getAction();
                if (action.getModelType() != BPELPackage.eINSTANCE.getInvoke() && action.isInstanceOf(target)) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    public static boolean isBPELAction(EClass target) {
        ActionDescriptor[] descriptors;
        ActionDescriptor[] actionDescriptorArray = descriptors = BPELUIRegistry.getInstance().getActionDescriptors();
        int n = descriptors.length;
        int n2 = 0;
        while (n2 < n) {
            ActionDescriptor descriptor = actionDescriptorArray[n2];
            AbstractBPELAction action = descriptor.getAction();
            if (action.getModelType() == target) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static EObject createEObject(EClass clazz) {
        return clazz.getEPackage().getEFactoryInstance().create(clazz);
    }

    protected static void cloneSubtreeHelper(EObject source, Map<EObject, EObject> sourceMap, Map<EObject, EObject> targetMap, Map<EObject, EObject> copyMap, CloneResult result) {
        EObject targetObject = BPELUtil.createEObject(source.eClass());
        copyMap.put(source, targetObject);
        if (sourceMap != null && sourceMap.containsKey(source)) {
            EObject sourceExtension = sourceMap.get(source);
            EObject targetExtension = BPELUtil.createEObject(sourceExtension.eClass());
            copyMap.put(sourceExtension, targetExtension);
            TreeIterator it2 = sourceExtension.eAllContents();
            while (it2.hasNext()) {
                EObject source2 = (EObject)it2.next();
                EObject target2 = BPELUtil.createEObject(source2.eClass());
                copyMap.put(source2, target2);
            }
            targetMap.put(targetObject, targetExtension);
            result.targetMapAdditions.put(targetObject, targetExtension);
        }
    }

    public static CloneResult cloneSubtree(EObject source, Map<EObject, EObject> sourceMap, Map<EObject, EObject> targetMap) {
        HashMap<EObject, EObject> copyMap = new HashMap<EObject, EObject>();
        CloneResult result = new CloneResult();
        result.targetMap = targetMap;
        BPELUtil.cloneSubtreeHelper(source, sourceMap, targetMap, copyMap, result);
        TreeIterator it = source.eAllContents();
        while (it.hasNext()) {
            EObject sourceObject = (EObject)it.next();
            BPELUtil.cloneSubtreeHelper(sourceObject, sourceMap, targetMap, copyMap, result);
        }
        for (Map.Entry<EObject, EObject> entry : copyMap.entrySet()) {
            EObject sourceObject = entry.getKey();
            EObject targetObject = entry.getValue();
            if (sourceObject.eClass() != targetObject.eClass()) {
                throw new IllegalStateException("Source and target objects are not of the same class after cloning.");
            }
            if (Policy.DEBUG) {
                System.out.println("copying a " + sourceObject.eClass().getName());
            }
            for (EStructuralFeature feature : sourceObject.eClass().getEAllStructuralFeatures()) {
                if (!feature.isChangeable()) {
                    if (!Policy.DEBUG) continue;
                    System.out.println("  *** skipping unchangeable feature " + feature);
                    continue;
                }
                if (feature.isUnsettable() && !targetObject.eIsSet(feature)) {
                    if (Policy.DEBUG) {
                        System.out.println("  unsetting feature " + feature.getName());
                    }
                    targetObject.eUnset(feature);
                    continue;
                }
                Object value = sourceObject.eGet(feature);
                boolean treatAsReference = feature instanceof EReference;
                if (treatAsReference) {
                    Object newValue;
                    if (feature.isMany()) {
                        BasicEList newValues = new BasicEList();
                        if (Policy.DEBUG) {
                            System.out.println("  copying multi-reference feature " + feature.getName() + ":");
                        }
                        for (Object oldValue : (Collection)value) {
                            Object newValue2;
                            EObject eObject = newValue2 = oldValue == null ? null : copyMap.get(oldValue);
                            if (newValue2 == null) {
                                newValue2 = oldValue;
                            }
                            if (Policy.DEBUG) {
                                System.out.println("+ (oldValue=" + oldValue + " newValue=" + newValue2 + ")");
                            }
                            newValues.add(newValue2);
                        }
                        targetObject.eSet(feature, (Object)newValues);
                        continue;
                    }
                    EObject eObject = newValue = value == null ? null : copyMap.get(value);
                    if (newValue == null) {
                        newValue = value;
                    }
                    if (Policy.DEBUG) {
                        System.out.println("  copying reference feature " + feature.getName() + " (value=" + value + " newValue=" + newValue + ")");
                    }
                    targetObject.eSet(feature, newValue);
                    continue;
                }
                if (value instanceof Node && "element".equals(feature.getName())) {
                    Node e = (Node)value;
                    value = e.cloneNode(true);
                }
                if (Policy.DEBUG) {
                    System.out.println("  copying attr feature " + feature.getName() + " (value=" + value + ")");
                }
                targetObject.eSet(feature, value);
            }
        }
        result.targetRoot = copyMap.get(source);
        return result;
    }

    public static String formatString(String format, String arg1) {
        return MessageFormat.format(format, arg1);
    }

    public static String formatString(String format, String arg1, String arg2) {
        return MessageFormat.format(format, arg1, arg2);
    }

    public static String generateValidName(String str) {
        StringBuilder result = new StringBuilder("");
        if (str != null) {
            char[] cArray = str.trim().toCharArray();
            int n = cArray.length;
            int n2 = 0;
            while (n2 < n) {
                char ch = cArray[n2];
                int destLength = result.length();
                if (destLength == 0 && (Character.isLetter(ch) || ch == '_') || destLength > 0 && Character.isJavaIdentifierPart(ch)) {
                    result.append(ch);
                }
                ++n2;
            }
        }
        if (result.length() == 0) {
            result.append("bpel");
        }
        return result.toString();
    }

    public static void visitModelDepthFirst(Object modelObject, IModelVisitor visitor) {
        if (visitor.visit(modelObject)) {
            IContainer container = BPELUtil.adapt(modelObject, IContainer.class);
            if (container != null) {
                Iterator<Object> it = container.getChildren(modelObject).iterator();
                while (it.hasNext()) {
                    BPELUtil.visitModelDepthFirst(it.next(), visitor);
                }
            }
            if (modelObject instanceof Flow) {
                Flow flow = (Flow)modelObject;
                Iterator it = FlowLinkUtil.getFlowLinks(flow).iterator();
                while (it.hasNext()) {
                    BPELUtil.visitModelDepthFirst(it.next(), visitor);
                }
            }
        }
    }

    public static boolean isNameUnused(EObject modelRoot, String candidateName, Collection ignoreObjects) {
        NameUnusedVisitor visitor = new NameUnusedVisitor(candidateName, ignoreObjects);
        TreeIterator it = modelRoot.eAllContents();
        while (it.hasNext()) {
            visitor.visit(it.next());
            if (visitor.isUnused()) continue;
            return false;
        }
        return true;
    }

    public static String getUniqueModelName(EObject context, String hint, Collection ignoreObjects) {
        return BPELUtil.getUniqueModelName2(context, hint, ignoreObjects);
    }

    public static String getUniqueModelName(Definition definition, String hint, Collection ignoreObjects) {
        return BPELUtil.getUniqueModelName2((EObject)definition, hint, ignoreObjects);
    }

    protected static String getUniqueModelName2(EObject modelRoot, String hint, Collection ignoreObjects) {
        String result = BPELUtil.generateValidName(hint == null ? "" : hint.trim());
        if (BPELUtil.isNameUnused(modelRoot, result, ignoreObjects)) {
            return result;
        }
        int digitPos = result.length() - 1;
        while (digitPos >= 0 && Character.isDigit(result.charAt(digitPos))) {
            --digitPos;
        }
        String nameWithoutNum = result.substring(0, ++digitPos);
        int num = 1;
        while (!BPELUtil.isNameUnused(modelRoot, result = String.valueOf(nameWithoutNum) + String.valueOf(num), ignoreObjects)) {
            ++num;
        }
        return result;
    }

    public static String generateUniqueModelName(EObject context, String hint, EObject model) {
        if (hint == null || "".equals(hint)) {
            ILabeledElement element = BPELUtil.adapt((Object)model, ILabeledElement.class);
            hint = element != null ? element.getTypeLabel(model) : "";
        }
        return BPELUtil.getUniqueModelName(context, hint, Collections.singletonList(model));
    }

    public static String getFilenameFromUri(String uri) {
        if (uri == null) {
            return Messages.BPELUtil__unknown_URI__54;
        }
        int idx = Math.max(uri.lastIndexOf("/"), uri.lastIndexOf("\\"));
        return idx >= 0 ? uri.substring(idx + 1) : uri;
    }

    public static String upperCaseFirstLetter(String target) {
        if (target.length() < 1) {
            return target;
        }
        StringBuilder buf = new StringBuilder(target.length());
        buf.append(target.substring(0, 1).toUpperCase());
        buf.append(target.substring(1, target.length()));
        return buf.toString();
    }

    public static String lowerCaseFirstLetter(String target) {
        if (target.length() < 1) {
            return target;
        }
        StringBuffer buf = new StringBuffer(target.length());
        buf.append(target.substring(0, 1).toLowerCase());
        buf.append(target.substring(1, target.length()));
        return buf.toString();
    }

    public static List<PropertyAlias> getPropertyAliasesForMessageType(Message messageType) {
        ArrayList<PropertyAlias> aliases = new ArrayList<PropertyAlias>();
        Resource resource2 = messageType.eResource();
        if (resource2 == null) {
            return aliases;
        }
        ResourceSet resourceSet = resource2.getResourceSet();
        for (Resource resource2 : resourceSet.getResources()) {
            if (!(resource2 instanceof WSDLResourceImpl)) continue;
            TreeIterator treeIt = resource2.getAllContents();
            while (treeIt.hasNext()) {
                PropertyAlias alias;
                EObject object = (EObject)treeIt.next();
                if (!(object instanceof PropertyAlias) || !messageType.equals((alias = (PropertyAlias)object).getMessageType())) continue;
                aliases.add(alias);
            }
        }
        return aliases;
    }

    public static Sequence createImplicitSequence(Process process, ExtensionMap extensionMap) {
        Sequence impSeq = BPELFactory.eINSTANCE.createSequence();
        ModelHelper.createExtensionIfNecessary(extensionMap, (EObject)impSeq);
        List<Sequence> ignoreObjects = Collections.singletonList(impSeq);
        if (ModelHelper.isSpecCompliant((EObject)process)) {
            impSeq.setName(BPELUtil.getUniqueModelName((EObject)process, Messages.BPELUtil_Sequence_1, ignoreObjects));
        } else {
            impSeq.setName(BPELUtil.getUniqueModelName((EObject)process, Messages.BPELUtil_HiddenSequence_2, ignoreObjects));
            ((ActivityExtension)ModelHelper.getExtension((EObject)impSeq)).setImplicit(true);
        }
        return impSeq;
    }

    public static TreeIterator nodeAndAllContents(final EObject node) {
        final TreeIterator allContents = node.eAllContents();
        return new TreeIterator(){
            boolean didNode = false;

            public void prune() {
                if (!this.didNode) {
                    throw new IllegalStateException();
                }
                allContents.prune();
            }

            public boolean hasNext() {
                if (this.didNode) {
                    return allContents.hasNext();
                }
                return node != null;
            }

            public Object next() {
                if (this.didNode) {
                    return allContents.next();
                }
                this.didNode = true;
                return node;
            }

            public void remove() {
                if (!this.didNode) {
                    throw new IllegalStateException();
                }
                allContents.remove();
            }
        };
    }

    public static void regenerateVisuals(Process process, GraphicalViewer viewer) {
        RefreshActionVisitor visitor = new RefreshActionVisitor(viewer);
        BPELUtil.visitModelDepthFirst(process, visitor);
    }

    public static boolean shouldHilightEdges(EditDomain domain, EObject modelObject) {
        Tool tool = domain.getActiveTool();
        if (tool instanceof IHilightControllingTool) {
            return ((IHilightControllingTool)tool).hilightModelTarget(modelObject);
        }
        return false;
    }

    public static int getRepaintFillType(IFigure fig) {
        int depth = 0;
        IFigure parent = fig.getParent();
        while (parent != null) {
            if (parent != null && parent.getBorder() != null && parent.getBorder() instanceof GradientBorder) {
                ++depth;
            }
            parent = parent.getParent();
        }
        return depth % 4;
    }

    public static void sortFlowList(List<FlowEditPart> listOfFlowEditParts) {
        List<FlowEditPart> result = listOfFlowEditParts;
        int resultSize = result.size();
        int i = 0;
        while (i < resultSize) {
            int j = i + 1;
            while (j < resultSize) {
                Flow[] parents;
                Flow flow1 = (Flow)result.get(i).getModel();
                Flow flow2 = (Flow)result.get(j).getModel();
                Flow[] flowArray = parents = FlowLinkUtil.getParentFlows((EObject)flow2);
                int n = parents.length;
                int n2 = 0;
                while (n2 < n) {
                    Flow parent = flowArray[n2];
                    if (parent == flow1) {
                        FlowEditPart temp = result.get(i);
                        result.set(i, result.get(j));
                        result.set(j, temp);
                    }
                    ++n2;
                }
                ++j;
            }
            ++i;
        }
    }

    public static void refreshCombo(ComboViewer viewer, Object selectedObject) {
        viewer.refresh();
        String s = ((ILabelProvider)viewer.getLabelProvider()).getText(selectedObject);
        viewer.getCombo().setText(s);
    }

    public static int calculateButtonWidth(Widget widget, int defaultSize) {
        int width = 0;
        if (widget instanceof Button) {
            Button w = (Button)widget;
            GC gc = new GC((Drawable)w);
            gc.setFont(w.getFont());
            width = gc.textExtent((String)w.getText()).x + 17;
            gc.dispose();
            return Math.max(width, defaultSize);
        }
        return defaultSize;
    }

    public static String getMaxLengthString(String[] strings) {
        int max = -1;
        int index = -1;
        int i = 0;
        while (i < strings.length) {
            if (strings[i].length() > max) {
                max = strings[i].length();
                index = i;
            }
            ++i;
        }
        if (index >= 0) {
            return strings[index];
        }
        return "";
    }

    public static int calculateLabelWidth(Widget widget, int defaultSize) {
        int width = 0;
        if (widget instanceof CLabel) {
            CLabel w = (CLabel)widget;
            GC gc = new GC((Drawable)w);
            gc.setFont(w.getFont());
            width = gc.textExtent((String)w.getText()).x + 17;
            gc.dispose();
            return Math.max(width, defaultSize);
        }
        if (widget instanceof DecoratedLabel) {
            DecoratedLabel w = (DecoratedLabel)widget;
            GC gc = new GC((Drawable)w);
            gc.setFont(w.getFont());
            width = gc.textExtent((String)w.getText()).x + 17;
            gc.dispose();
            return Math.max(width, defaultSize);
        }
        if (widget instanceof Label) {
            Label w = (Label)widget;
            GC gc = new GC((Drawable)w);
            gc.setFont(w.getFont());
            width = gc.textExtent((String)w.getText()).x + 5;
            gc.dispose();
            return Math.max(width, defaultSize);
        }
        return defaultSize;
    }

    public static IFile getFileFromURI(URI uri) {
        if (uri.isFile()) {
            return BPELUtil.getFileFromDeviceURI(uri);
        }
        return BPELUtil.getFileFromPlatformURI(uri);
    }

    public static IFile getFileFromDeviceURI(URI uri) {
        String device = uri.device();
        Iterator pathIt = uri.segmentsList().iterator();
        StringBuffer path = new StringBuffer();
        while (pathIt.hasNext()) {
            path.append("/" + pathIt.next());
        }
        return ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)new Path(device, path.toString()));
    }

    public static IFile getFileFromPlatformURI(URI uri) {
        String[] segs = uri.segments();
        Object path = null;
        int i = 1;
        while (i < segs.length) {
            path = path == null ? new Path(segs[i]) : path.append(segs[i]);
            ++i;
        }
        return ResourcesPlugin.getWorkspace().getRoot().getFile(path);
    }

    public static URI getPlatformURI(URI uri) {
        String str = uri.toString();
        if (str.startsWith("platform:")) {
            return uri;
        }
        return URI.createPlatformResourceURI((String)uri.toString());
    }

    public static boolean getShowFaultHandler(EditPart part) {
        if (part instanceof ScopeEditPart) {
            return ((ScopeEditPart)part).getShowFaultHandler();
        }
        if (part instanceof InvokeEditPart) {
            return ((InvokeEditPart)part).getShowFaultHandler();
        }
        if (part instanceof StartNodeEditPart) {
            return ((StartNodeEditPart)part).getShowFaultHandler();
        }
        return false;
    }

    public static void setShowFaultHandler(EditPart part, boolean show) {
        if (part instanceof ScopeEditPart) {
            ((ScopeEditPart)part).setShowFaultHandler(show);
        } else if (part instanceof InvokeEditPart) {
            ((InvokeEditPart)part).setShowFaultHandler(show);
        } else if (part instanceof StartNodeEditPart) {
            ((StartNodeEditPart)part).setShowFaultHandler(show);
        }
    }

    public static boolean getShowCompensationHandler(EditPart part) {
        if (part instanceof ScopeEditPart) {
            return ((ScopeEditPart)part).getShowCompensationHandler();
        }
        if (part instanceof InvokeEditPart) {
            return ((InvokeEditPart)part).getShowCompensationHandler();
        }
        return false;
    }

    public static boolean getShowTerminationHandler(EditPart part) {
        if (part instanceof ScopeEditPart) {
            return ((ScopeEditPart)part).getShowTerminationHandler();
        }
        return false;
    }

    public static void setShowCompensationHandler(EditPart part, boolean show) {
        if (part instanceof ScopeEditPart) {
            ((ScopeEditPart)part).setShowCompensationHandler(show);
        } else if (part instanceof InvokeEditPart) {
            ((InvokeEditPart)part).setShowCompensationHandler(show);
        }
    }

    public static void setShowTerminationHandler(EditPart part, boolean show) {
        if (part instanceof ScopeEditPart) {
            ((ScopeEditPart)part).setShowTerminationHandler(show);
        }
    }

    public static boolean getShowEventHandler(EditPart part) {
        if (part instanceof ScopeEditPart) {
            return ((ScopeEditPart)part).getShowEventHandler();
        }
        if (part instanceof StartNodeEditPart) {
            return ((StartNodeEditPart)part).getShowEventHandler();
        }
        return false;
    }

    public static void setShowEventHandler(EditPart part, boolean show) {
        if (part instanceof ScopeEditPart) {
            ((ScopeEditPart)part).setShowEventHandler(show);
        } else if (part instanceof StartNodeEditPart) {
            ((StartNodeEditPart)part).setShowEventHandler(show);
        }
    }

    public static IFile getBPELEXFile(IFile bpelFile) {
        IPath path = bpelFile.getFullPath().removeFileExtension().addFileExtension("bpelex");
        return ResourcesPlugin.getWorkspace().getRoot().getFile(path);
    }

    public static IFile getArtifactsWSDLFile(IFile bpelFile) {
        IPath wsdlPath = bpelFile.getFullPath().removeFileExtension();
        String fileName = String.valueOf(wsdlPath.lastSegment()) + "Artifacts";
        wsdlPath = wsdlPath.removeLastSegments(1).append(fileName);
        wsdlPath = wsdlPath.addFileExtension("wsdl");
        return ResourcesPlugin.getWorkspace().getRoot().getFile(wsdlPath);
    }

    public static Image getImage(IMarker marker) {
        Image img = ModelMarkerUtil.getImage((IMarker)marker);
        ImageData background = null;
        if (img != null) {
            background = img.getImageData();
        }
        if (background == null) {
            try {
                if (marker.isSubtypeOf("org.eclipse.core.resources.problemmarker")) {
                    background = ImageUtils.getImage((IMarker)marker).getImageData();
                }
            }
            catch (CoreException e) {
                BPELUIPlugin.log(e);
                return null;
            }
        }
        if (background == null) {
            return null;
        }
        String uri = marker.getAttribute("overlayImageTopLeft", "");
        ImageData topLeft = BPELUtil.getImageData(uri);
        uri = marker.getAttribute("overlayImageTopRight", "");
        ImageData topRight = BPELUtil.getImageData(uri);
        uri = marker.getAttribute("overlayImageBottomLeft", "");
        ImageData bottomLeft = BPELUtil.getImageData(uri);
        uri = marker.getAttribute("overlayImageBottomRight", "");
        ImageData bottomRight = BPELUtil.getImageData(uri);
        OverlayCompositeImageDescriptor descriptor = new OverlayCompositeImageDescriptor(background, topLeft, topRight, bottomLeft, bottomRight);
        return descriptor.createImage();
    }

    private static ImageData getImageData(String uri) {
        if (uri.length() == 0) {
            return null;
        }
        URL url = null;
        try {
            url = new URL(uri);
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
        ImageDescriptor desc = ImageDescriptor.createFromURL((URL)url);
        return desc.getImageData();
    }

    public static EditPart mapFigure2EditPart(EditPartViewer viewer, IFigure figure) {
        Map visualPartMap = viewer.getVisualPartMap();
        EditPart part = null;
        while (part == null && figure != null) {
            part = (EditPart)visualPartMap.get(figure);
            figure = figure.getParent();
        }
        return part;
    }

    public static Process getProcess(IResource bpelFile, ResourceSet resourceSet) throws IOException {
        URI uri = URI.createPlatformResourceURI((String)bpelFile.getFullPath().toString());
        Resource processResource = resourceSet.getResource(uri, true);
        EList contents = processResource.getContents();
        if (!contents.isEmpty()) {
            return (Process)contents.get(0);
        }
        return null;
    }

    public static AccessibleEditPart getAccessibleEditPart(GraphicalEditPart part) {
        final GraphicalEditPart thisPart = part;
        return new AccessibleEditPart(){

            public void getName(AccessibleEvent e) {
                String childType = null;
                String displayName = null;
                ILabeledElement labeledElement = BPELUtil.adapt(thisPart.getModel(), ILabeledElement.class);
                if (labeledElement != null) {
                    childType = labeledElement.getTypeLabel(thisPart.getModel());
                    displayName = labeledElement.getLabel(thisPart.getModel());
                    if (childType != null && displayName.equals(childType)) {
                        childType = null;
                    }
                } else {
                    e.result = null;
                    return;
                }
                StringBuffer concat = new StringBuffer();
                if (childType != null && childType.length() > 0) {
                    concat.append(childType);
                }
                if (concat.length() > 0) {
                    concat.append(" ");
                }
                if (displayName != null && displayName.length() > 0) {
                    concat.append(displayName);
                }
                e.result = concat.length() > 0 ? concat.toString() : null;
            }

            public void getChildCount(AccessibleControlEvent e) {
                List list = thisPart.getChildren();
                int count = 0;
                for (EditPart part : list) {
                    AccessibleEditPart access = (AccessibleEditPart)part.getAdapter(AccessibleEditPart.class);
                    if (access == null) continue;
                    ++count;
                }
                e.detail = count;
            }

            public void getChildren(AccessibleControlEvent e) {
                List list = thisPart.getChildren();
                Vector<Integer> childList = new Vector<Integer>();
                for (EditPart part : list) {
                    AccessibleEditPart access = (AccessibleEditPart)part.getAdapter(AccessibleEditPart.class);
                    if (access == null) continue;
                    childList.add(access.getAccessibleID());
                }
                e.children = childList.toArray();
            }

            public void getLocation(AccessibleControlEvent e) {
                Rectangle bounds = thisPart.getFigure().getBounds().getCopy();
                thisPart.getFigure().translateToAbsolute((Translatable)bounds);
                Point p = new Point(0, 0);
                p = thisPart.getViewer().getControl().toDisplay(p);
                e.x = bounds.x + p.x;
                e.y = bounds.y + p.y;
                e.width = bounds.width;
                e.height = bounds.height;
            }

            public void getState(AccessibleControlEvent e) {
                e.detail = 0x300000;
                if (thisPart.getSelected() != 0) {
                    e.detail |= 2;
                }
                if (thisPart.getViewer().getFocusEditPart() == thisPart) {
                    e.detail = 4;
                }
            }
        };
    }

    public static TableCursor createTableCursor(final Table table, final TableViewer tableViewer) {
        final TableCursor cursor = new TableCursor(table, 0);
        cursor.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (cursor.getRow() != null) {
                    table.setSelection(new TableItem[]{cursor.getRow()});
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                TableItem row = cursor.getRow();
                if (row != null) {
                    int nRow = table.indexOf(row);
                    int column = cursor.getColumn();
                    Object obj = tableViewer.getElementAt(nRow);
                    tableViewer.editElement(obj, column);
                }
            }
        });
        cursor.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 262144 || e.keyCode == 131072 || (e.stateMask & 0x40000) != 0 || (e.stateMask & 0x20000) != 0) {
                    cursor.setVisible(false);
                }
            }
        });
        cursor.addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
                TableItem row = cursor.getRow();
                if (row != null) {
                    int nRow = table.indexOf(row);
                    int column = cursor.getColumn();
                    Object obj = tableViewer.getElementAt(nRow);
                    tableViewer.editElement(obj, column);
                }
            }

            public void mouseUp(MouseEvent e) {
            }
        });
        table.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                if (e.keyCode == 262144 && (e.stateMask & 0x20000) != 0) {
                    return;
                }
                if (e.keyCode == 131072 && (e.stateMask & 0x40000) != 0) {
                    return;
                }
                if (e.keyCode != 262144 && (e.stateMask & 0x40000) != 0) {
                    return;
                }
                if (e.keyCode != 131072 && (e.stateMask & 0x20000) != 0) {
                    return;
                }
                if (table.getItemCount() == 0) {
                    return;
                }
                TableItem[] selection = table.getSelection();
                TableItem row = selection.length == 0 ? table.getItem(table.getTopIndex()) : selection[0];
                table.showItem(row);
                cursor.setSelection(row, 0);
                cursor.setVisible(true);
                cursor.setFocus();
            }
        });
        return cursor;
    }

    public static ResourceSet createResourceSetImpl() {
        return new ResourceSetImpl();
    }

    public static IInputValidator getNCNameValidator() {
        return new IInputValidator(){

            public String isValid(String newText) {
                if (!NCNAME_DETECTOR.isValid((CharSequence)newText)) {
                    return Messages.BPELUtil_NCName;
                }
                return null;
            }
        };
    }

    public static void deleteNonContainmentRefs(EObject modelObject, Collection referents) {
        if (modelObject == null) {
            return;
        }
        block0: for (EReference feature : modelObject.eClass().getEAllReferences()) {
            if (feature.isMany()) {
                EList list = (EList)modelObject.eGet((EStructuralFeature)feature, true);
                for (Object referent : referents) {
                    if (!list.contains(referent)) continue;
                    list.remove(referent);
                }
                continue;
            }
            Object oldValue = modelObject.eGet((EStructuralFeature)feature, true);
            for (Object referent : referents) {
                if (oldValue != referent) continue;
                if (feature.isUnsettable()) {
                    modelObject.eUnset((EStructuralFeature)feature);
                    continue block0;
                }
                modelObject.eSet((EStructuralFeature)feature, null);
                continue block0;
            }
        }
    }

    public static ArrayList getCompensableActivities(Object context) {
        final ArrayList returnObjects = new ArrayList();
        if (context instanceof CompensateScope) {
            CompensateScope compensateScope;
            CompensateScope enclosingContainer = compensateScope = (CompensateScope)context;
            if (compensateScope.eContainer() != null) {
                enclosingContainer = enclosingContainer.eContainer();
                while (!(enclosingContainer instanceof Scope) && enclosingContainer.eContainer() != null) {
                    enclosingContainer = enclosingContainer.eContainer();
                }
            }
            BPELUtil.visitModelDepthFirst(enclosingContainer, new IModelVisitor(){

                @Override
                public boolean visit(Object modelObject) {
                    if (modelObject instanceof Scope) {
                        returnObjects.add(modelObject);
                    } else if (modelObject instanceof Invoke) {
                        returnObjects.add(modelObject);
                    }
                    return true;
                }
            });
            if (!returnObjects.isEmpty()) {
                returnObjects.remove(0);
            }
            return returnObjects;
        }
        throw new IllegalArgumentException();
    }

    public static Object resolveXSDObject(Object xsdObject) {
        XSDAttributeDeclaration resolvedAttribute;
        if (xsdObject instanceof XSDElementDeclaration) {
            XSDElementDeclaration resolvedElement = ((XSDElementDeclaration)xsdObject).getResolvedElementDeclaration();
            if (resolvedElement != null) {
                xsdObject = resolvedElement;
            }
        } else if (xsdObject instanceof XSDAttributeDeclaration && (resolvedAttribute = ((XSDAttributeDeclaration)xsdObject).getResolvedAttributeDeclaration()) != null) {
            xsdObject = resolvedAttribute;
        }
        return xsdObject;
    }

    public static String debugObject(Object object) {
        boolean proxy;
        if (object == null) {
            return "null";
        }
        if (object instanceof String) {
            return "\"" + (String)object + "\"";
        }
        if (object.getClass().getName().startsWith("java.lang")) {
            return object.toString();
        }
        if (object instanceof List) {
            StringBuffer b = new StringBuffer("(");
            Iterator it = ((List)object).iterator();
            while (it.hasNext()) {
                b.append(BPELUtil.debugObject(it.next()));
                if (!it.hasNext()) continue;
                b.append(", ");
            }
            b.append(")");
            return b.toString();
        }
        if (object instanceof QName) {
            QName qname = (QName)object;
            return "QName(\"" + qname.getNamespaceURI() + "\", \"" + qname.getLocalPart() + "\")";
        }
        StringBuffer b = new StringBuffer(BPELUtil.shortClassName(object.getClass()));
        boolean bl = proxy = object instanceof EObject && ((EObject)object).eIsProxy();
        if (proxy) {
            b.append("-proxy");
        }
        boolean isEObject = object instanceof EObject;
        INamedElement namedElement = null;
        if (isEObject && (namedElement = BPELUtil.adapt(object, INamedElement.class)) != null) {
            try {
                String s = namedElement.getName(object);
                b.append(s == null ? "<null>" : "<\"" + s + "\">");
            }
            catch (Exception exception) {
                b.append("<???>");
            }
        }
        if (namedElement == null) {
            b.append("{");
            b.append(String.valueOf(object.hashCode()));
            b.append("}");
        }
        return b.toString();
    }

    public static String debug(Notification n) {
        StringBuffer b = new StringBuffer(BPELUtil.shortClassName(n.getClass()));
        b.append("(");
        b.append(BPELUtil.debugObject(n.getNotifier()));
        b.append(", ");
        switch (n.getEventType()) {
            case 0: {
                b.append("CREATE");
                break;
            }
            case 1: {
                b.append("SET");
                break;
            }
            case 2: {
                b.append("UNSET");
                break;
            }
            case 3: {
                b.append("ADD");
                break;
            }
            case 4: {
                b.append("REMOVE");
                break;
            }
            case 5: {
                b.append("ADD_MANY");
                break;
            }
            case 7: {
                b.append("MOVE");
                break;
            }
            case 8: {
                b.append("REMOVING_ADAPTER");
                break;
            }
            case 9: {
                b.append("RESOLVE");
                break;
            }
            default: {
                b.append("??? (" + String.valueOf(n.getEventType()) + ")");
            }
        }
        b.append(" ");
        EStructuralFeature feature = (EStructuralFeature)n.getFeature();
        if (feature == null) {
            b.append("???");
        } else {
            b.append(feature.getName());
        }
        if (n.getPosition() >= 0) {
            b.append("[");
            b.append(String.valueOf(n.getPosition()));
            b.append("]");
        } else if (feature != null && feature.isMany()) {
            b.append("{***}");
        }
        b.append(": ");
        b.append(BPELUtil.debugObject(n.getOldValue()));
        b.append(" --> ");
        b.append(BPELUtil.debugObject(n.getNewValue()));
        b.append(")");
        return b.toString();
    }

    protected static String shortClassName(Class clazz) {
        StringBuffer b = new StringBuffer(clazz.getName());
        int i = b.indexOf(".");
        while (i >= 0) {
            b.delete(0, i + 1);
            i = b.indexOf(".");
        }
        return b.toString();
    }

    public static Composite createBorderComposite(Composite parent, TabbedPropertySheetWidgetFactory wf) {
        final Composite result = wf.createComposite(parent);
        FillLayout layout = new FillLayout();
        layout.marginHeight = 1;
        layout.marginWidth = 1;
        result.setLayout((Layout)layout);
        result.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                org.eclipse.swt.graphics.Rectangle bounds = result.getBounds();
                bounds.x = 0;
                bounds.y = 0;
                bounds.width = bounds.width - 2 + 1;
                bounds.height = bounds.height - 2 + 1;
                e.gc.drawRectangle(bounds);
            }
        });
        return result;
    }

    static void addVariablesToMap(Map<String, Variable> targetMap, Variables vars, Variable refVar) {
        if (vars == null) {
            return;
        }
        for (Variable v : vars.getChildren()) {
            if (v == refVar) break;
            if (v.getName() == null) continue;
            targetMap.put(v.getName(), v);
        }
    }

    static void addVisibleVariables(Map<String, Variable> targetMap, EObject target, Variable refVariable) {
        Variable v;
        if (target == null) {
            return;
        }
        if (target instanceof Resource) {
            return;
        }
        if (target instanceof Process) {
            BPELUtil.addVariablesToMap(targetMap, ((Process)target).getVariables(), refVariable);
            return;
        }
        BPELUtil.addVisibleVariables(targetMap, target.eContainer(), refVariable);
        if (target instanceof Scope) {
            BPELUtil.addVariablesToMap(targetMap, ((Scope)target).getVariables(), refVariable);
        }
        if (target instanceof Catch && (v = ((Catch)target).getFaultVariable()) != null && v.getName() != null) {
            targetMap.put(v.getName(), v);
        }
        if (target instanceof OnEvent && (v = ((OnEvent)target).getVariable()) != null && v.getName() != null) {
            targetMap.put(v.getName(), v);
        }
        if (target instanceof ForEach && (v = ((ForEach)target).getCounterName()) != null && v.getName() != null) {
            targetMap.put(v.getName(), v);
        }
    }

    private static void addPartnerLinksToMap(Map<String, PartnerLink> targetMap, PartnerLinks plinks) {
        if (plinks == null) {
            return;
        }
        for (PartnerLink p : plinks.getChildren()) {
            if (p.getName() == null) continue;
            targetMap.put(p.getName(), p);
        }
    }

    private static void addVisiblePartnerLinks(Map<String, PartnerLink> targetMap, EObject target) {
        if (target == null) {
            return;
        }
        if (target instanceof Resource) {
            return;
        }
        if (target instanceof Process) {
            BPELUtil.addPartnerLinksToMap(targetMap, ((Process)target).getPartnerLinks());
        } else {
            BPELUtil.addVisiblePartnerLinks(targetMap, target.eContainer());
            if (target instanceof Scope) {
                BPELUtil.addPartnerLinksToMap(targetMap, ((Scope)target).getPartnerLinks());
            }
        }
    }

    private static void addCorrelationSetsToMap(Map<String, CorrelationSet> targetMap, CorrelationSets csets) {
        if (csets == null) {
            return;
        }
        for (CorrelationSet c : csets.getChildren()) {
            if (c.getName() == null) continue;
            targetMap.put(c.getName(), c);
        }
    }

    private static void addVisibleCorrelationSets(Map<String, CorrelationSet> targetMap, EObject target) {
        if (target == null) {
            return;
        }
        if (target instanceof Resource) {
            return;
        }
        if (target instanceof Process) {
            BPELUtil.addCorrelationSetsToMap(targetMap, ((Process)target).getCorrelationSets());
        } else {
            BPELUtil.addVisibleCorrelationSets(targetMap, target.eContainer());
            if (target instanceof Scope) {
                BPELUtil.addCorrelationSetsToMap(targetMap, ((Scope)target).getCorrelationSets());
            }
        }
    }

    public static Variable[] getVisibleVariables(EObject target) {
        HashMap<String, Variable> name2Variable = new HashMap<String, Variable>();
        BPELUtil.addVisibleVariables(name2Variable, target, target instanceof Variable ? (Variable)target : null);
        if (name2Variable.isEmpty()) {
            return EMPTY_VARIABLE_ARRAY;
        }
        Collection variables = name2Variable.values();
        if (variables.size() == 1) {
            return variables.toArray(EMPTY_VARIABLE_ARRAY);
        }
        ArrayList list = new ArrayList(variables);
        Collections.sort(list, new Comparator<Variable>(){

            @Override
            public int compare(Variable o1, Variable o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        return list.toArray(EMPTY_VARIABLE_ARRAY);
    }

    public static PartnerLink[] getVisiblePartnerLinks(EObject target) {
        HashMap<String, PartnerLink> name2PartnerLink = new HashMap<String, PartnerLink>();
        BPELUtil.addVisiblePartnerLinks(name2PartnerLink, target);
        if (name2PartnerLink.isEmpty()) {
            return EMPTY_PARTNERLINK_ARRAY;
        }
        PartnerLink[] result = new PartnerLink[name2PartnerLink.size()];
        name2PartnerLink.values().toArray(result);
        return result;
    }

    public static CorrelationSet[] getVisibleCorrelationSets(EObject target) {
        HashMap<String, CorrelationSet> name2CorrelationSet = new HashMap<String, CorrelationSet>();
        BPELUtil.addVisibleCorrelationSets(name2CorrelationSet, target);
        if (name2CorrelationSet.isEmpty()) {
            return EMPTY_CORRELATIONSET_ARRAY;
        }
        CorrelationSet[] result = new CorrelationSet[name2CorrelationSet.size()];
        name2CorrelationSet.values().toArray(result);
        return result;
    }

    public static Operation getOperationFromMessage(Message message) {
        if (message == null) {
            return null;
        }
        Definition def = message.getEnclosingDefinition();
        if (def == null) {
            return null;
        }
        for (PortType pt : def.getEPortTypes()) {
            for (Operation op : pt.getOperations()) {
                Input input = op.getEInput();
                if (input != null && input.getMessage().getQName().equals(message.getQName())) {
                    return op;
                }
                Output output = op.getEOutput();
                if (output != null && output.getMessage().getQName().equals(message.getQName())) {
                    return op;
                }
                for (Fault fault : op.getEFaults()) {
                    Message faultMessage = fault.getEMessage();
                    if (faultMessage == null || faultMessage.getQName() == null || !faultMessage.getQName().equals(message.getQName())) continue;
                    return op;
                }
            }
        }
        return null;
    }

    public static void openEditor(EObject modelObject, BPELEditor editor) {
        try {
            if (modelObject == null) {
                MessageDialog.openError((Shell)editor.getEditorSite().getShell(), (String)Messages.BPELUtil__Error, (String)Messages.BPELUtil_NoEditorForNullObject);
                return;
            }
            EObject resolvedObject = null;
            if (modelObject.eResource() == null) {
                if (modelObject.eIsProxy()) {
                    resolvedObject = EmfModelQuery.resolveProxy((Process)editor.getProcess(), (EObject)modelObject);
                }
            } else {
                resolvedObject = modelObject;
            }
            if (resolvedObject == null) {
                MessageDialog.openError((Shell)editor.getEditorSite().getShell(), (String)Messages.BPELUtil__Error, (String)NLS.bind((String)Messages.BPELUtil_NoEditorForObject, (Object[])new Object[]{modelObject.getClass().getSimpleName()}));
                return;
            }
            IFile file = BPELUtil.getFileFromURI(resolvedObject.eResource().getURI());
            IDE.openEditor((IWorkbenchPage)editor.getSite().getWorkbenchWindow().getActivePage(), (IFile)file);
        }
        catch (PartInitException ex) {
            BPELUIPlugin.log(ex, 2);
        }
    }

    public static IFile getBPELFile(Process process) {
        return BPELUtil.getFileFromURI(process.eResource().getURI());
    }

    public static String lookupOrCreateNamespacePrefix(EObject context, String namespace, String prefix, Shell shell) {
        String nsPrefix = BPELUtils.getNamespacePrefix((EObject)context, (String)namespace);
        if (nsPrefix != null && nsPrefix.length() > 0) {
            return nsPrefix;
        }
        NamespaceMappingDialog dialog = new NamespaceMappingDialog(shell, context);
        dialog.setNamespace(namespace);
        if (prefix != null) {
            dialog.setPrefix(prefix);
        }
        if (dialog.open() == 1) {
            return nsPrefix;
        }
        nsPrefix = dialog.getPrefix();
        BPELUtils.setNamespacePrefix((EObject)context, (String)namespace, (String)nsPrefix);
        return nsPrefix;
    }

    public static List<EObject> getAllEObjectsOfType(EObject root, EClass eClass) {
        ArrayList<EObject> allElems = new ArrayList<EObject>();
        TreeIterator iter = root.eAllContents();
        while (iter.hasNext()) {
            EObject element = (EObject)iter.next();
            if (!eClass.isSuperTypeOf(element.eClass()) && element.eClass() != eClass) continue;
            allElems.add(element);
        }
        return allElems;
    }

    public static boolean isBPELProject(IProject project) {
        if (project == null) {
            return false;
        }
        if (ModuleCoreNature.isFlexibleProject((IProject)project)) {
            IFacetedProject fproj = null;
            try {
                fproj = ProjectFacetsManager.create((IProject)project);
            }
            catch (CoreException coreException) {
                return false;
            }
            if (fproj.hasProjectFacet(BPELUtil.getBPELFacetVersion())) {
                return true;
            }
        }
        return false;
    }

    public static IProjectFacetVersion getBPELFacetVersion() {
        IProjectFacet bpelFacet = ProjectFacetsManager.getProjectFacet((String)"bpel.facet.core");
        IProjectFacetVersion bpelFacetVersion = bpelFacet.getVersion("2.0");
        return bpelFacetVersion;
    }

    public static org.eclipse.core.resources.IContainer getBPELContentFolder(IProject project) {
        IPath rootPath;
        IFolder bpelContent = null;
        if (BPELUtil.isBPELProject(project) && (rootPath = BPELUtil.getWebContentRootPath(project)) != null && !rootPath.isEmpty()) {
            bpelContent = project.getFolder(rootPath);
        }
        return bpelContent;
    }

    public static IPath getWebContentRootPath(IProject project) {
        IPath path = null;
        IVirtualComponent component = ComponentCore.createComponent((IProject)project);
        if (component != null && component.exists()) {
            path = component.getRootFolder().getProjectRelativePath();
        }
        return path;
    }

    public static class CloneResult {
        public EObject targetRoot;
        Map<EObject, EObject> targetMap;
        Map<EObject, EObject> targetMapAdditions = new HashMap<EObject, EObject>();

        public void undo() {
            for (EObject next : this.targetMapAdditions.keySet()) {
                this.targetMap.remove(next);
            }
        }

        public void redo() {
            for (EObject key : this.targetMapAdditions.keySet()) {
                this.targetMap.put(key, this.targetMapAdditions.get(key));
            }
        }
    }

    private static class NameUnusedVisitor
    implements IModelVisitor {
        private boolean unused = true;
        private final String candidateName;
        private final Collection<EObject> ignoreObjects;

        NameUnusedVisitor(String candidateName, Collection<EObject> ignoreObjects) {
            this.candidateName = candidateName;
            if (ignoreObjects == null) {
                ignoreObjects = Collections.emptySet();
            }
            this.ignoreObjects = ignoreObjects;
        }

        @Override
        public boolean visit(Object child) {
            String name;
            INamedElement namedElement;
            if (!this.ignoreObjects.contains(child) && (namedElement = BPELUtil.adapt(child, INamedElement.class)) != null && (name = namedElement.getName(child)) != null && name.compareToIgnoreCase(this.candidateName) == 0) {
                this.unused = false;
            }
            return true;
        }

        public boolean isUnused() {
            return this.unused;
        }
    }

    private static class RefreshActionVisitor
    implements IModelVisitor {
        private final GraphicalViewer viewer;

        public RefreshActionVisitor(GraphicalViewer viewer) {
            this.viewer = viewer;
        }

        @Override
        public boolean visit(Object child) {
            IFigure fig;
            EditPart ep = (EditPart)this.viewer.getEditPartRegistry().get(child);
            if (ep != null && ep instanceof BPELEditPart && (fig = ((BPELEditPart)ep).getContentPane()) != null) {
                ((BPELEditPart)ep).regenerateVisuals();
                ep.refresh();
            }
            if (ep instanceof LinkEditPart) {
                ep.refresh();
            }
            return true;
        }
    }
}

