/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.core.memory.transport;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.math.BigInteger;
import java.util.function.Consumer;
import org.eclipse.cdt.debug.core.memory.transport.ImportRequest;
import org.eclipse.cdt.debug.core.memory.transport.WriteMemory;
import org.eclipse.cdt.debug.internal.core.memory.transport.Messages;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ICoreRunnable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public abstract class FileImport<I extends AutoCloseable>
implements ICoreRunnable {
    protected final BigInteger base;
    protected final BigInteger start;
    protected final WriteMemory write;
    protected final Consumer<BigInteger> scroll;
    private final File file;

    protected FileImport(File input, ImportRequest request, Consumer<BigInteger> scroll) {
        this.file = input;
        this.base = request.base();
        this.start = request.start();
        this.write = request.write();
        this.scroll = scroll;
    }

    /*
     * Loose catch block
     */
    public void run(IProgressMonitor monitor) throws CoreException {
        try {
            try {
                Throwable throwable = null;
                Object var3_7 = null;
                try (I reader = this.input(this.file);){
                    BigInteger jobs = BigInteger.valueOf(this.file.length());
                    BigInteger factor = BigInteger.ONE;
                    if (jobs.compareTo(BigInteger.valueOf(Integer.MAX_VALUE)) > 0) {
                        factor = jobs.divide(BigInteger.valueOf(Integer.MAX_VALUE));
                        jobs = jobs.divide(factor);
                    }
                    monitor.beginTask(Messages.FileImport_task_transferring, jobs.intValue());
                    this.transfer(reader, factor, monitor);
                    if (!monitor.isCanceled()) {
                        this.write.flush();
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException ex) {
                this.requestFailed(Messages.FileImport_e_read_file, ex);
                monitor.done();
            }
            catch (DebugException ex) {
                this.requestFailed(Messages.FileImport_e_write_target, ex);
                monitor.done();
            }
            catch (Exception ex) {
                this.internalError(Messages.FileImport_e_import_file, ex);
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
                monitor.done();
            }
        }
        finally {
            monitor.done();
        }
    }

    protected abstract I input(File var1) throws FileNotFoundException;

    protected abstract void transfer(I var1, BigInteger var2, IProgressMonitor var3) throws IOException, DebugException;

    protected void requestFailed(String message, Throwable exception) throws DebugException {
        this.failed(5012, message, exception);
    }

    protected void internalError(String message, Throwable exception) throws DebugException {
        this.failed(5013, message, exception);
    }

    protected void failed(int code, String message, Throwable exception) throws DebugException {
        Status status = new Status(4, this.getClass(), code, message, exception);
        this.failed(new DebugException((IStatus)status));
    }

    protected void failed(DebugException exception) throws DebugException {
        if (Platform.isRunning()) {
            Platform.getLog((Bundle)FrameworkUtil.getBundle(this.getClass())).log(exception.getStatus());
        }
        throw exception;
    }
}

