/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.history;

import java.io.IOException;
import java.text.MessageFormat;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.JobFamilies;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.history.GitHistoryPage;
import org.eclipse.egit.ui.internal.history.SWTCommit;
import org.eclipse.egit.ui.internal.history.SWTCommitList;
import org.eclipse.egit.ui.internal.trace.GitTraceLocation;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jgit.annotations.NonNull;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevFlag;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.osgi.util.NLS;

class GenerateHistoryJob
extends Job {
    private static final int BATCH_SIZE = 256;
    private final GitHistoryPage page;
    private final SWTCommitList loadedCommits;
    private int itemToLoad = 1;
    private RevCommit commitToLoad;
    private RevCommit commitToShow;
    private int lastUpdateCnt;
    private boolean trace;
    private final RevWalk walk;
    private RevFlag highlightFlag;
    private int forcedRedrawsAfterListIsCompleted = 0;

    GenerateHistoryJob(GitHistoryPage ghp, @NonNull RevWalk walk, ResourceManager resources) {
        super(NLS.bind((String)UIText.HistoryPage_refreshJob, (Object)Activator.getDefault().getRepositoryUtil().getRepositoryName(ghp.getInputInternal().getRepository())));
        this.page = ghp;
        this.walk = walk;
        this.highlightFlag = walk.newFlag("highlight");
        this.loadedCommits = new SWTCommitList(resources);
        this.loadedCommits.source(walk);
        this.trace = GitTraceLocation.HISTORYVIEW.isActive();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected IStatus run(IProgressMonitor monitor) {
        status = Status.OK_STATUS;
        maxCommits = Activator.getDefault().getPreferenceStore().getInt("HistoryView_MaxNumberOfCommmits");
        incomplete = false;
        commitNotFound = false;
        try {
            block20: {
                if (this.trace) {
                    GitTraceLocation.getTrace().traceEntry(GitTraceLocation.HISTORYVIEW.getLocation());
                }
                loadIncrementally = Activator.getDefault().getPreferenceStore().getBoolean("resourcehistory_show_findtoolbar") == false;
                initialSize = this.loadedCommits.size();
                try {
                    oldsz = initialSize;
lbl12:
                    // 2 sources

                    while (true) {
                        if (this.trace) {
                            GitTraceLocation.getTrace().trace(GitTraceLocation.HISTORYVIEW.getLocation(), "Filling commit list");
                        }
                        if (this.commitToLoad != null) {
                            this.loadedCommits.fillTo(this.commitToLoad, maxCommits);
                            this.commitToShow = this.commitToLoad;
                            this.commitToLoad = null;
                            commitFound = false;
                            var11_12 = this.loadedCommits.iterator();
                            while (var11_12.hasNext()) {
                                commit = (RevCommit)var11_12.next();
                                if (!commit.getId().equals((AnyObjectId)this.commitToShow.getId())) continue;
                                commitFound = true;
                                break;
                            }
                            commitNotFound = commitFound == false;
                        } else {
                            this.loadedCommits.fillTo(oldsz + 256 - 1);
                            if (oldsz == this.loadedCommits.size()) {
                                ++this.forcedRedrawsAfterListIsCompleted;
                                break block20;
                            }
                        }
                        if (monitor.isCanceled()) {
                            var13_13 = Status.CANCEL_STATUS;
                            return var13_13;
                        }
                        break;
                    }
                }
                catch (IOException e) {
                    status = new Status(4, "org.eclipse.egit.ui", UIText.GenerateHistoryJob_errorComputingHistory, (Throwable)e);
                    break block20;
                }
                {
                    if (this.loadedCommits.size() > this.itemToLoad + 128 + 1 && loadIncrementally) break block20;
                    if (maxCommits > 0 && this.loadedCommits.size() > maxCommits) {
                        incomplete = true;
                        break block20;
                    }
                    oldsz = this.loadedCommits.size();
                    monitor.setTaskName(MessageFormat.format(UIText.GenerateHistoryJob_taskFoundCommits, new Object[]{oldsz}));
                    ** continue;
                }
            }
            if (this.trace) {
                GitTraceLocation.getTrace().trace(GitTraceLocation.HISTORYVIEW.getLocation(), "Loaded " + this.loadedCommits.size() + " commits");
            }
            if (commitNotFound && !this.loadedCommits.isEmpty()) {
                if (this.forcedRedrawsAfterListIsCompleted < 1 && !loadIncrementally) {
                    this.page.setWarningTextInUIThread(this);
                }
                if (initialSize == this.loadedCommits.size()) return status;
                this.updateUI(incomplete);
                return status;
            }
            this.updateUI(incomplete);
            return status;
        }
        finally {
            monitor.done();
            if (this.trace) {
                GitTraceLocation.getTrace().traceExit(GitTraceLocation.HISTORYVIEW.getLocation());
            }
        }
    }

    private void updateUI(boolean incomplete) {
        if (this.trace) {
            GitTraceLocation.getTrace().traceEntry(GitTraceLocation.HISTORYVIEW.getLocation());
        }
        try {
            if (this.forcedRedrawsAfterListIsCompleted != 1 && !incomplete && this.loadedCommits.size() == this.lastUpdateCnt) {
                return;
            }
            if (this.forcedRedrawsAfterListIsCompleted == 1) {
                ++this.forcedRedrawsAfterListIsCompleted;
            }
            SWTCommit[] asArray = new SWTCommit[this.loadedCommits.size()];
            this.loadedCommits.toArray((Object[])asArray);
            this.page.showCommitList(this, this.loadedCommits, asArray, this.commitToShow, incomplete, this.highlightFlag);
            this.commitToShow = null;
            this.lastUpdateCnt = this.loadedCommits.size();
        }
        finally {
            if (this.trace) {
                GitTraceLocation.getTrace().traceExit(GitTraceLocation.HISTORYVIEW.getLocation());
            }
        }
    }

    void release() {
        if (this.getState() == 0) {
            this.dispose();
        } else {
            this.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                public void done(IJobChangeEvent event) {
                    GenerateHistoryJob.this.dispose();
                }
            });
        }
    }

    private void dispose() {
        this.loadedCommits.clear();
        this.walk.close();
    }

    public boolean belongsTo(Object family) {
        if (JobFamilies.GENERATE_HISTORY.equals(family)) {
            return true;
        }
        return super.belongsTo(family);
    }

    void setLoadHint(int index) {
        this.itemToLoad = index;
    }

    void setLoadHint(RevCommit c) {
        this.commitToLoad = c;
    }

    void setShowHint(RevCommit c) {
        this.commitToShow = c;
    }

    int loadMoreItemsThreshold() {
        return this.loadedCommits.size() - 128;
    }
}

