/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.repository;

import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.core.commands.IStateListener;
import org.eclipse.core.commands.State;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Adapters;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.egit.core.AdapterUtils;
import org.eclipse.egit.core.RepositoryCache;
import org.eclipse.egit.core.RepositoryUtil;
import org.eclipse.egit.core.internal.Utils;
import org.eclipse.egit.core.internal.util.ResourceUtil;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.JobFamilies;
import org.eclipse.egit.ui.UIUtils;
import org.eclipse.egit.ui.internal.CommonUtils;
import org.eclipse.egit.ui.internal.EgitUiEditorUtils;
import org.eclipse.egit.ui.internal.UIIcons;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.branch.BranchOperationUI;
import org.eclipse.egit.ui.internal.components.MessagePopupTextCellEditor;
import org.eclipse.egit.ui.internal.groups.RepositoryGroup;
import org.eclipse.egit.ui.internal.groups.RepositoryGroups;
import org.eclipse.egit.ui.internal.history.HistoryPageInput;
import org.eclipse.egit.ui.internal.properties.GitPropertySheetPage;
import org.eclipse.egit.ui.internal.repository.FilterCache;
import org.eclipse.egit.ui.internal.repository.RefCache;
import org.eclipse.egit.ui.internal.repository.RepositoryPropertySourceProvider;
import org.eclipse.egit.ui.internal.repository.RepositoryTreeNodeLabelProvider;
import org.eclipse.egit.ui.internal.repository.tree.FetchNode;
import org.eclipse.egit.ui.internal.repository.tree.FileNode;
import org.eclipse.egit.ui.internal.repository.tree.FilterableNode;
import org.eclipse.egit.ui.internal.repository.tree.FolderNode;
import org.eclipse.egit.ui.internal.repository.tree.PushNode;
import org.eclipse.egit.ui.internal.repository.tree.RefNode;
import org.eclipse.egit.ui.internal.repository.tree.RemoteNode;
import org.eclipse.egit.ui.internal.repository.tree.RepositoryGroupNode;
import org.eclipse.egit.ui.internal.repository.tree.RepositoryNode;
import org.eclipse.egit.ui.internal.repository.tree.RepositoryTreeNode;
import org.eclipse.egit.ui.internal.repository.tree.RepositoryTreeNodeType;
import org.eclipse.egit.ui.internal.repository.tree.StashedCommitNode;
import org.eclipse.egit.ui.internal.repository.tree.TagNode;
import org.eclipse.egit.ui.internal.repository.tree.WorkingDirNode;
import org.eclipse.egit.ui.internal.selection.RepositoryVirtualNode;
import org.eclipse.egit.ui.internal.selection.SelectionUtils;
import org.eclipse.egit.ui.internal.trace.GitTraceLocation;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.bindings.keys.SWTKeySupport;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.JFaceColors;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationEvent;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationStrategy;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jgit.annotations.NonNull;
import org.eclipse.jgit.events.ConfigChangedListener;
import org.eclipse.jgit.events.IndexChangedListener;
import org.eclipse.jgit.events.ListenerHandle;
import org.eclipse.jgit.events.RefsChangedListener;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.ControlEditor;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.IURIEditorInput;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.contexts.IContextActivation;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.internal.navigator.NavigatorDecoratingLabelProvider;
import org.eclipse.ui.navigator.CommonNavigator;
import org.eclipse.ui.navigator.CommonViewer;
import org.eclipse.ui.part.IPage;
import org.eclipse.ui.part.IShowInSource;
import org.eclipse.ui.part.IShowInTargetList;
import org.eclipse.ui.part.MultiPageEditorPart;
import org.eclipse.ui.part.ShowInContext;
import org.eclipse.ui.progress.IWorkbenchSiteProgressService;
import org.eclipse.ui.progress.WorkbenchJob;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.eclipse.ui.views.properties.PropertySheet;
import org.eclipse.ui.views.properties.PropertySheetPage;

public class RepositoriesView
extends CommonNavigator
implements IShowInSource,
IShowInTargetList {
    public static final String VIEW_ID = "org.eclipse.egit.ui.RepositoriesView";
    private static final String SINGLE_REPO_CONTEXT_ID = "org.eclipse.egit.ui.RepositoriesView.SingleRepository";
    public static final String LINK_WITH_SELECTION_ID = "org.eclipse.egit.ui.RepositoriesLinkWithSelection";
    private static final long DEFAULT_REFRESH_DELAY = 300L;
    private final Set<Repository> repositories = new HashSet<Repository>();
    private final RefsChangedListener myRefsChangedListener = event -> this.scheduleRefresh();
    private final IndexChangedListener myIndexChangedListener = event -> this.scheduleRefresh();
    private final ConfigChangedListener myConfigChangeListener = event -> this.scheduleRefresh();
    private final List<ListenerHandle> myListeners = new LinkedList<ListenerHandle>();
    private RefreshUiJob refreshUiJob;
    private final RepositoryUtil repositoryUtil;
    private final RepositoryCache repositoryCache;
    private RefCache.Cache refCache = RefCache.get();
    private Composite emptyArea;
    private StackLayout layout;
    private State reactOnSelection;
    private IWorkbenchPart lastSelectionPart;
    private File lastSelectedRepository;
    private boolean filterCacheLoaded;
    private final ISelectionListener selectionChangedListener = (part, selection) -> {
        if (part == this) {
            if (!selection.isEmpty() && selection instanceof IStructuredSelection) {
                Repository repo = SelectionUtils.getRepository((IStructuredSelection)selection);
                this.lastSelectedRepository = repo != null ? repo.getDirectory() : null;
            }
            return;
        }
        IWorkbenchPart currentPart = this.determinePart(part);
        if (!((Boolean)this.reactOnSelection.getValue()).booleanValue()) {
            this.lastSelectionPart = currentPart;
        } else {
            this.lastSelectionPart = null;
            this.reactOnSelection(this.convertSelection(currentPart, selection));
        }
    };
    private final IStateListener reactOnSelectionListener = (state, oldValue) -> {
        if (((Boolean)state.getValue()).booleanValue() && this.lastSelectionPart != null) {
            PlatformUI.getWorkbench().getDisplay().asyncExec(() -> {
                if (this.lastSelectionPart == null) {
                    return;
                }
                IWorkbenchPartSite site = this.lastSelectionPart.getSite();
                if (site == null) {
                    return;
                }
                ISelectionProvider provider = site.getSelectionProvider();
                if (provider == null) {
                    return;
                }
                this.reactOnSelection(this.convertSelection(this.lastSelectionPart, provider.getSelection()));
            });
        }
    };
    private State branchHierarchy;
    private final IStateListener stateChangeListener = (state, oldValue) -> this.refresh();
    private final IEclipsePreferences.IPreferenceChangeListener configurationListener = event -> {
        if ("GitRepositoriesView.GitDirectories.relative".equals(event.getKey())) {
            this.refresh();
        }
    };
    private IContextActivation renameContext;
    private IContextService ctxSrv;
    private TextCellEditor textCellEditor;
    private Text filterField;

    public RepositoriesView() {
        this.refreshUiJob = new RefreshUiJob();
        this.repositoryUtil = Activator.getDefault().getRepositoryUtil();
        this.repositoryCache = org.eclipse.egit.core.Activator.getDefault().getRepositoryCache();
    }

    protected void createEmptyArea(Composite parent) {
        this.emptyArea = new Composite(parent, 0);
        this.emptyArea.setBackgroundMode(2);
        MenuManager manager = new MenuManager();
        manager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager m) {
                RepositoriesView.this.getNavigatorActionService().fillContextMenu(m);
            }
        });
        this.getSite().registerContextMenu(manager, (ISelectionProvider)this.getCommonViewer());
        Menu menu = manager.createContextMenu((Control)this.emptyArea);
        this.emptyArea.setMenu(menu);
        GridLayoutFactory.fillDefaults().applyTo(this.emptyArea);
        Composite infoArea = new Composite(this.emptyArea, 0);
        infoArea.setMenu(menu);
        GridDataFactory.swtDefaults().align(16384, 128).grab(true, true).applyTo((Control)infoArea);
        GridLayoutFactory.swtDefaults().applyTo(infoArea);
        Label messageLabel = new Label(infoArea, 64);
        messageLabel.setText(UIText.RepositoriesView_messageEmpty);
        messageLabel.setMenu(menu);
        GridDataFactory.swtDefaults().align(4, 4).grab(true, false).applyTo((Control)messageLabel);
        Composite optionsArea = new Composite(infoArea, 0);
        optionsArea.setMenu(menu);
        GridLayoutFactory.swtDefaults().numColumns(2).applyTo(optionsArea);
        GridDataFactory.swtDefaults().indent(5, 0).grab(true, true).applyTo((Control)optionsArea);
        final FormToolkit toolkit = new FormToolkit(this.emptyArea.getDisplay());
        this.emptyArea.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                toolkit.dispose();
            }
        });
        Color linkColor = JFaceColors.getHyperlinkText((Display)this.emptyArea.getDisplay());
        Label addLabel = new Label(optionsArea, 0);
        Image addImage = UIIcons.NEW_REPOSITORY.createImage();
        UIUtils.hookDisposal((Widget)addLabel, (Resource)addImage);
        addLabel.setImage(addImage);
        Hyperlink addLink = toolkit.createHyperlink(optionsArea, UIText.RepositoriesView_linkAdd, 64);
        addLink.setForeground(linkColor);
        addLink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                IHandlerService service = (IHandlerService)RepositoriesView.this.getViewSite().getService(IHandlerService.class);
                UIUtils.executeCommand(service, "org.eclipse.egit.ui.RepositoriesViewAddRepository");
            }
        });
        GridDataFactory.swtDefaults().align(4, 4).grab(true, false).applyTo((Control)addLink);
        Label cloneLabel = new Label(optionsArea, 0);
        Image cloneImage = UIIcons.CLONEGIT.createImage();
        UIUtils.hookDisposal((Widget)cloneLabel, (Resource)cloneImage);
        cloneLabel.setImage(cloneImage);
        Hyperlink cloneLink = toolkit.createHyperlink(optionsArea, UIText.RepositoriesView_linkClone, 64);
        cloneLink.setForeground(linkColor);
        cloneLink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                IHandlerService service = (IHandlerService)RepositoriesView.this.getViewSite().getService(IHandlerService.class);
                UIUtils.executeCommand(service, "org.eclipse.egit.ui.RepositoriesViewClone");
            }
        });
        GridDataFactory.swtDefaults().align(4, 4).grab(true, false).applyTo((Control)cloneLink);
        Label createLabel = new Label(optionsArea, 0);
        Image createImage = UIIcons.CREATE_REPOSITORY.createImage();
        UIUtils.hookDisposal((Widget)createLabel, (Resource)createImage);
        createLabel.setImage(createImage);
        Hyperlink createLink = toolkit.createHyperlink(optionsArea, UIText.RepositoriesView_linkCreate, 64);
        createLink.setForeground(linkColor);
        createLink.setText(UIText.RepositoriesView_linkCreate);
        createLink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                IHandlerService service = (IHandlerService)RepositoriesView.this.getViewSite().getService(IHandlerService.class);
                UIUtils.executeCommand(service, "org.eclipse.egit.ui.RepositoriesViewCreateRepository");
            }
        });
        GridDataFactory.swtDefaults().align(4, 4).grab(true, false).applyTo((Control)createLink);
    }

    public void createPartControl(Composite aParent) {
        FilterCache.INSTANCE.load();
        this.filterCacheLoaded = true;
        Composite displayArea = new Composite(aParent, 0);
        this.layout = new StackLayout();
        displayArea.setLayout((Layout)this.layout);
        this.createEmptyArea(displayArea);
        super.createPartControl(displayArea);
        IWorkbenchWindow w = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        ICommandService csrv = (ICommandService)w.getService(ICommandService.class);
        this.reactOnSelection = csrv.getCommand(LINK_WITH_SELECTION_ID).getState("org.eclipse.ui.commands.toggleState");
        this.reactOnSelection.addListener(this.reactOnSelectionListener);
        this.branchHierarchy = csrv.getCommand("org.eclipse.egit.ui.RepositoriesToggleBranchHierarchy").getState("org.eclipse.ui.commands.toggleState");
        this.branchHierarchy.addListener(this.stateChangeListener);
        IWorkbenchSiteProgressService service = (IWorkbenchSiteProgressService)this.getSite().getService(IWorkbenchSiteProgressService.class);
        if (service != null) {
            service.showBusyForFamily(JobFamilies.REPO_VIEW_REFRESH);
            service.showBusyForFamily(JobFamilies.CLONE);
        }
    }

    protected CommonViewer createCommonViewerObject(Composite aParent) {
        return new RepositoriesCommonViewer(this.getViewSite().getId(), aParent, 770);
    }

    private void setTopControl(CommonViewer viewer) {
        this.layout.topControl = !this.repositories.isEmpty() || RepositoryGroups.getInstance().hasGroups() ? viewer.getControl() : this.emptyArea;
    }

    private void afterRefresh(CommonViewer viewer) {
        Control currentTop = this.layout.topControl;
        this.setTopControl(viewer);
        if (currentTop != this.layout.topControl) {
            this.emptyArea.getParent().layout(true, true);
        }
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (adapter == IPropertySheetPage.class) {
            GitPropertySheetPage page = new GitPropertySheetPage();
            page.setPropertySourceProvider(new RepositoryPropertySourceProvider(page));
            return adapter.cast((Object)page);
        }
        return (T)super.getAdapter(adapter);
    }

    protected CommonViewer createCommonViewer(Composite aParent) {
        final CommonViewer viewer = super.createCommonViewer(aParent);
        viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                TreeSelection sel = (TreeSelection)event.getSelection();
                RepositoryTreeNode element = (RepositoryTreeNode)sel.getFirstElement();
                if (element == null) {
                    return;
                }
                if (element instanceof RepositoryGroupNode) {
                    return;
                }
                if (element.getRepository().isBare()) {
                    return;
                }
                if (element instanceof RefNode) {
                    RepositoriesView.this.executeOpenCommandWithConfirmation(element, ((Ref)((RefNode)element).getObject()).getName());
                } else if (element instanceof TagNode) {
                    RepositoriesView.this.executeOpenCommandWithConfirmation(element, ((Ref)((TagNode)element).getObject()).getName());
                } else if (element instanceof FetchNode) {
                    RepositoriesView.this.executeFetchCommand((FetchNode)element);
                }
            }
        });
        viewer.addOpenListener(new IOpenListener(){

            public void open(OpenEvent event) {
                TreeSelection sel = (TreeSelection)event.getSelection();
                RepositoryTreeNode element = (RepositoryTreeNode)sel.getFirstElement();
                if (element instanceof FileNode || element instanceof StashedCommitNode) {
                    RepositoriesView.this.executeOpenCommand(element);
                }
            }
        });
        this.ctxSrv = (IContextService)this.getSite().getService(IContextService.class);
        viewer.addSelectionChangedListener(event -> this.handleSingleRepositoryContext(event.getSelection(), viewer));
        viewer.getTree().addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
                RepositoriesView.this.handleSingleRepositoryContext(null, viewer);
            }

            public void focusGained(FocusEvent e) {
                RepositoriesView.this.handleSingleRepositoryContext(viewer.getSelection(), viewer);
            }
        });
        this.setupInlineEditing(viewer);
        ISelectionService srv = (ISelectionService)this.getSite().getService(ISelectionService.class);
        srv.addPostSelectionListener(this.selectionChangedListener);
        this.repositoryUtil.getPreferences().addPreferenceChangeListener(this.configurationListener);
        this.initRepositoriesAndListeners();
        this.ctxSrv.activateContext(VIEW_ID);
        viewer.addPostSelectionChangedListener(event -> {
            if (!((Boolean)this.reactOnSelection.getValue()).booleanValue()) {
                return;
            }
            ISelection selection = event.getSelection();
            if (selection.isEmpty() || !(selection instanceof IStructuredSelection)) {
                return;
            }
            IStructuredSelection sel = (IStructuredSelection)selection;
            if (sel.size() > 1) {
                return;
            }
            Object selected = sel.getFirstElement();
            if (selected instanceof FileNode) {
                this.showEditor((FileNode)selected);
            }
        });
        this.emptyArea.setBackground(viewer.getControl().getBackground());
        this.setTopControl(viewer);
        return viewer;
    }

    private void handleSingleRepositoryContext(ISelection selection, CommonViewer viewer) {
        boolean activate = false;
        if (selection != null && !selection.isEmpty() && selection instanceof StructuredSelection) {
            StructuredSelection sel = (StructuredSelection)selection;
            Object item = sel.getFirstElement();
            boolean bl = activate = sel.size() == 1 && item instanceof RepositoryNode;
        }
        if (!activate) {
            if (this.renameContext != null) {
                this.ctxSrv.deactivateContext(this.renameContext);
                this.renameContext = null;
            }
        } else if (viewer.getTree().isFocusControl() && this.renameContext == null) {
            this.renameContext = this.ctxSrv.activateContext(SINGLE_REPO_CONTEXT_ID);
        }
    }

    private void setupInlineEditing(final CommonViewer viewer) {
        ColumnViewerEditorActivationStrategy editorActivation = new ColumnViewerEditorActivationStrategy((ColumnViewer)viewer){

            protected boolean isEditorActivationEvent(ColumnViewerEditorActivationEvent event) {
                return event.eventType == 4;
            }
        };
        TreeViewerEditor.create((TreeViewer)viewer, (ColumnViewerEditorActivationStrategy)editorActivation, (int)16);
        final String[] initialValue = new String[1];
        this.textCellEditor = new MessagePopupTextCellEditor((Composite)viewer.getTree(), true){

            @Override
            protected boolean withBorder() {
                return true;
            }
        };
        this.textCellEditor.setValidator(value -> {
            String currentText = value.toString().trim();
            if (currentText.isEmpty()) {
                return UIText.RepositoriesView_RepoGroup_EmptyNameError;
            }
            if (!currentText.equals(initialValue[0]) && RepositoryGroups.getInstance().groupExists(currentText)) {
                return MessageFormat.format(UIText.RepositoryGroups_DuplicateGroupNameError, currentText);
            }
            return null;
        });
        viewer.setColumnProperties(new String[]{"Name"});
        viewer.setCellEditors(new CellEditor[]{this.textCellEditor});
        viewer.setCellModifier(new ICellModifier(){

            public boolean canModify(Object element, String property) {
                return element instanceof RepositoryGroupNode;
            }

            private String doGetValue(Object element) {
                if (element instanceof RepositoryGroupNode) {
                    return ((RepositoryGroup)((RepositoryGroupNode)element).getObject()).getName();
                }
                return null;
            }

            public Object getValue(Object element, String property) {
                String result;
                initialValue[0] = result = this.doGetValue(element);
                return result;
            }

            public void modify(Object element, String property, Object value) {
                if (element instanceof Item) {
                    element = ((Item)element).getData();
                }
                if (element instanceof RepositoryGroupNode && value instanceof CharSequence) {
                    RepositoryGroup group = (RepositoryGroup)((RepositoryGroupNode)element).getObject();
                    String newName = value.toString().trim();
                    if (!newName.equals(group.getName())) {
                        RepositoryGroups.getInstance().renameGroup(group, newName);
                        viewer.refresh();
                        viewer.setSelection((ISelection)new StructuredSelection(element), true);
                    }
                }
            }
        });
    }

    public boolean pasteInEditor() {
        if (this.filterField != null && !this.filterField.isDisposed()) {
            this.filterField.paste();
            return true;
        }
        if (this.textCellEditor != null && this.textCellEditor.isActivated()) {
            this.textCellEditor.performPaste();
            return true;
        }
        return false;
    }

    public void filter(final @NonNull FilterableNode node) {
        if (this.filterField != null) {
            return;
        }
        CommonViewer rawViewer = this.getCommonViewer();
        if (!(rawViewer instanceof RepositoriesCommonViewer)) {
            return;
        }
        final RepositoriesCommonViewer viewer = (RepositoriesCommonViewer)rawViewer;
        IContentProvider rawProvider = viewer.getContentProvider();
        if (!(rawProvider instanceof ITreeContentProvider)) {
            return;
        }
        ITreeContentProvider provider = (ITreeContentProvider)rawProvider;
        if (!provider.hasChildren((Object)node)) {
            return;
        }
        TreeItem treeItem = viewer.getItem(node);
        if (treeItem == null) {
            return;
        }
        if (!viewer.getExpandedState(node)) {
            try {
                viewer.getTree().setRedraw(false);
                viewer.setExpandedState(node, true);
            }
            finally {
                viewer.getTree().setRedraw(true);
            }
        }
        final AtomicReference currentPattern = new AtomicReference();
        final WorkbenchJob refresher = new WorkbenchJob(UIText.RepositoriesView_FilterJob){

            public boolean belongsTo(Object family) {
                return JobFamilies.REPO_VIEW_REFRESH.equals(family) || super.belongsTo(family);
            }

            public IStatus runInUIThread(IProgressMonitor monitor) {
                if (!monitor.isCanceled()) {
                    RepositoriesView.this.filter(viewer, node, (String)currentPattern.get());
                    return Status.OK_STATUS;
                }
                return Status.CANCEL_STATUS;
            }
        };
        refresher.setUser(false);
        final Composite container = new Composite((Composite)viewer.getTree(), 0);
        container.setVisible(false);
        GridLayoutFactory.fillDefaults().applyTo(container);
        final Text field = new Text(container, 128);
        GridData textData = GridDataFactory.fillDefaults().grab(true, false).create();
        textData.minimumWidth = 150;
        field.setLayoutData((Object)textData);
        field.setMessage(UIText.RepositoriesView_FilterMessage);
        final String pattern = node.getFilter();
        if (pattern != null) {
            field.setText(pattern);
            field.selectAll();
        }
        final TreeFilterEditor filterEditor = new TreeFilterEditor((Composite)viewer.getTree(), treeItem, 0, (Control)container);
        field.addVerifyListener(e -> {
            String string = e.text = Utils.firstLine((String)e.text);
        });
        field.addModifyListener(e -> {
            refresher.cancel();
            currentPattern.set(field.getText());
            refresher.schedule(200L);
        });
        final FocusAdapter closeOnFocusLost = new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                RepositoriesView.this.filterField = null;
                filterEditor.dispose();
                if (!container.isDisposed()) {
                    container.setVisible(false);
                    container.dispose();
                }
            }
        };
        field.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                int key = SWTKeySupport.convertEventToUnmodifiedAccelerator((KeyEvent)e);
                if (key == 27) {
                    refresher.cancel();
                    currentPattern.set(pattern);
                    refresher.schedule();
                }
                if (key == 27 || key == 13 || key == 10 || e.character == '\r' || e.character == '\n') {
                    RepositoriesView.this.filterField = null;
                    filterEditor.dispose();
                    field.removeFocusListener((FocusListener)closeOnFocusLost);
                    container.setVisible(false);
                    container.dispose();
                    viewer.getTree().setFocus();
                }
            }
        });
        container.getDisplay().asyncExec(() -> {
            if (!container.isDisposed()) {
                container.setVisible(true);
                this.filterField = field;
                field.setFocus();
                field.addFocusListener((FocusListener)closeOnFocusLost);
            }
        });
    }

    private void filter(RepositoriesCommonViewer viewer, FilterableNode filterNode, String filter) {
        FilterCache.INSTANCE.set(filterNode, filter);
        Tree tree = viewer.getTree();
        if (tree == null || tree.isDisposed()) {
            return;
        }
        try {
            tree.setRedraw(false);
            TreeItem item = viewer.getItem(filterNode);
            Object currentNode = item.getData();
            if (filterNode != currentNode && filterNode.equals(currentNode)) {
                ((FilterableNode)currentNode).setFilter(filterNode.getFilter());
                viewer.update(currentNode, null);
            }
            viewer.refresh(filterNode);
        }
        finally {
            tree.setRedraw(true);
        }
        viewer.setSelection(viewer.getSelection());
    }

    private void executeOpenCommandWithConfirmation(RepositoryTreeNode element, String refName) {
        IPreferenceStore store;
        if (!BranchOperationUI.checkoutWillShowQuestionDialog(refName) && (store = Activator.getDefault().getPreferenceStore()).getBoolean("show_checkout_confirmation")) {
            MessageDialogWithToggle dialog = new MessageDialogWithToggle(this.getViewSite().getShell(), UIText.RepositoriesView_CheckoutConfirmationTitle, null, MessageFormat.format(UIText.RepositoriesView_CheckoutConfirmationMessage, Repository.shortenRefName((String)refName)), 3, new String[]{UIText.RepositoriesView_CheckoutConfirmationDefaultButtonLabel, IDialogConstants.CANCEL_LABEL}, 0, UIText.RepositoriesView_CheckoutConfirmationToggleMessage, false);
            int result = dialog.open();
            if (result != 0 && result != 256) {
                return;
            }
            if (dialog.getToggleState()) {
                store.setValue("show_checkout_confirmation", false);
            }
        }
        this.executeOpenCommand(element);
    }

    private void executeOpenCommand(RepositoryTreeNode element) {
        CommonUtils.runCommand("org.eclipse.egit.ui.RepositoriesViewOpen", (IStructuredSelection)new StructuredSelection((Object)element));
    }

    private void executeFetchCommand(FetchNode node) {
        CommonUtils.runCommand("org.eclipse.egit.ui.team.SimpleFetch", (IStructuredSelection)new StructuredSelection((Object)node));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initRepositoriesAndListeners() {
        Set<Repository> set = this.repositories;
        synchronized (set) {
            this.refCache.remove(this.repositories);
            this.repositories.clear();
            this.unregisterRepositoryListeners();
            HashSet<File> dirs = new HashSet<File>();
            for (String dir : this.repositoryUtil.getConfiguredRepositories()) {
                File repoDir = new File(dir);
                try {
                    Repository repo = this.repositoryCache.lookupRepository(repoDir);
                    this.listenToRepository(repo);
                    dirs.add(repo.getDirectory());
                    this.repositories.add(repo);
                }
                catch (IOException e) {
                    String message = NLS.bind((String)UIText.RepositoriesView_ExceptionLookingUpRepoMessage, (Object)repoDir.getPath());
                    Activator.handleError(message, e, false);
                    this.repositoryUtil.removeDir(repoDir);
                }
            }
            Repository[] repositoryArray = org.eclipse.egit.core.Activator.getDefault().getRepositoryCache().getAllRepositories();
            int n = repositoryArray.length;
            int n2 = 0;
            while (n2 < n) {
                Repository repo = repositoryArray[n2];
                if (!dirs.contains(repo.getDirectory())) {
                    this.listenToRepository(repo);
                    dirs.add(repo.getDirectory());
                }
                ++n2;
            }
        }
    }

    private void listenToRepository(Repository repo) {
        this.myListeners.add(repo.getListenerList().addIndexChangedListener(this.myIndexChangedListener));
        this.myListeners.add(repo.getListenerList().addRefsChangedListener(this.myRefsChangedListener));
        this.myListeners.add(repo.getListenerList().addConfigChangedListener(this.myConfigChangeListener));
    }

    public void dispose() {
        if (this.filterCacheLoaded) {
            this.filterCacheLoaded = false;
            FilterCache.INSTANCE.save();
        }
        if (this.textCellEditor != null) {
            this.textCellEditor.dispose();
            this.textCellEditor = null;
        }
        if (this.reactOnSelection != null) {
            this.reactOnSelection.removeListener(this.reactOnSelectionListener);
        }
        if (this.branchHierarchy != null) {
            this.branchHierarchy.removeListener(this.stateChangeListener);
        }
        this.refreshUiJob.cancel();
        this.repositoryUtil.getPreferences().removePreferenceChangeListener(this.configurationListener);
        ISelectionService srv = (ISelectionService)this.getSite().getService(ISelectionService.class);
        srv.removePostSelectionListener(this.selectionChangedListener);
        this.unregisterRepositoryListeners();
        this.refCache.remove(this.repositories);
        this.refCache.dispose();
        this.repositories.clear();
        super.dispose();
    }

    private void showResource(IResource resource) {
        IPath location = resource.getLocation();
        if (location != null) {
            this.showPaths(Arrays.asList(location));
        }
    }

    private void showPaths(List<IPath> paths) {
        Map pathsByRepo = ResourceUtil.splitPathsByRepository(paths);
        boolean added = this.checkNotConfiguredRepositories(pathsByRepo);
        if (added) {
            this.scheduleRefresh(0L, () -> {
                if (UIUtils.isUsable((Viewer)this.getCommonViewer())) {
                    this.selectAndReveal(pathsByRepo);
                }
            });
        } else {
            this.selectAndReveal(pathsByRepo);
        }
    }

    private boolean checkNotConfiguredRepositories(Map<Repository, Collection<String>> pathsByRepo) {
        boolean added = false;
        for (Repository repository : pathsByRepo.keySet()) {
            try {
                RepositoryTreeNode node = this.getRepositoryChildNode(repository, RepositoryTreeNodeType.WORKINGDIR);
                if (node != null) continue;
                added |= this.repositoryUtil.addConfiguredRepository(repository.getDirectory());
            }
            catch (IllegalArgumentException iae) {
                Activator.handleError(iae.getMessage(), iae, false);
            }
        }
        return added;
    }

    private void selectAndReveal(Map<Repository, Collection<String>> pathsByRepo) {
        ArrayList<RepositoryTreeNode> nodesToShow = new ArrayList<RepositoryTreeNode>();
        Repository repository = null;
        for (Map.Entry<Repository, Collection<String>> entry : pathsByRepo.entrySet()) {
            repository = entry.getKey();
            for (String repoPath : entry.getValue()) {
                RepositoryTreeNode node = this.getNodeForPath(repository, repoPath);
                if (node == null) continue;
                nodesToShow.add(node);
            }
        }
        this.lastSelectedRepository = repository != null && !nodesToShow.isEmpty() && pathsByRepo.size() == 1 ? repository.getDirectory() : null;
        List current = this.getCommonViewer().getStructuredSelection().toList();
        HashSet currentlySelected = new HashSet(current);
        if (currentlySelected.containsAll(nodesToShow)) {
            this.getCommonViewer().getTree().showSelection();
        } else {
            this.selectReveal((ISelection)new StructuredSelection(nodesToShow));
        }
    }

    public void expandNodeForGroup(RepositoryGroup group) {
        if (group != null) {
            this.getCommonViewer().expandToLevel((Object)new RepositoryGroupNode(group), 1);
        }
    }

    public void showRepository(Repository repositoryToShow) {
        ITreeContentProvider cp = (ITreeContentProvider)this.getCommonViewer().getContentProvider();
        RepositoryTreeNode node = this.findRepositoryNode(cp, cp.getElements(this.getCommonViewer().getInput()), repositoryToShow);
        if (node != null) {
            this.lastSelectedRepository = repositoryToShow.getDirectory();
            this.selectReveal((ISelection)new StructuredSelection((Object)node));
        }
    }

    public void refresh() {
        this.initRepositoriesAndListeners();
        this.scheduleRefresh(0L, null);
    }

    private void trace(String message) {
        GitTraceLocation.getTrace().trace(GitTraceLocation.REPOSITORIESVIEW.getLocation(), message);
    }

    private void scheduleRefresh() {
        this.scheduleRefresh(300L, null);
    }

    private synchronized void scheduleRefresh(long delay, Runnable uiTask) {
        this.refreshUiJob.uiTask.compareAndSet(null, uiTask);
        this.refreshUiJob.schedule(delay);
    }

    private void unregisterRepositoryListeners() {
        this.myListeners.forEach(ListenerHandle::remove);
        this.myListeners.clear();
    }

    public boolean show(ShowInContext context) {
        ISelection selection = context.getSelection();
        if (selection instanceof IStructuredSelection && !selection.isEmpty()) {
            IStructuredSelection ss = (IStructuredSelection)selection;
            ArrayList<IPath> paths = new ArrayList<IPath>();
            for (Object element : ss) {
                IResource resource = AdapterUtils.adaptToAnyResource(element);
                if (resource != null) {
                    IPath location = resource.getLocation();
                    if (location == null) continue;
                    paths.add(location);
                    continue;
                }
                if (!(element instanceof IPath)) continue;
                paths.add((IPath)element);
            }
            if (!paths.isEmpty()) {
                this.showPaths(paths);
                return true;
            }
            Repository repository = SelectionUtils.getRepository(ss);
            if (repository != null) {
                this.showRepository(repository);
                return true;
            }
        }
        if (context.getInput() instanceof IFileEditorInput) {
            IFileEditorInput input = (IFileEditorInput)context.getInput();
            this.showResource((IResource)input.getFile());
            return true;
        }
        Repository repository = (Repository)Adapters.adapt((Object)context.getInput(), Repository.class);
        if (repository != null) {
            this.showRepository(repository);
            return true;
        }
        return false;
    }

    public ShowInContext getShowInContext() {
        IStructuredSelection selection = (IStructuredSelection)this.getCommonViewer().getSelection();
        List<Object> elements = RepositoriesView.getShowInElements(selection);
        HistoryPageInput historyPageInput = RepositoriesView.getHistoryPageInput(selection);
        return new ShowInContext((Object)historyPageInput, (ISelection)new StructuredSelection(elements));
    }

    public String[] getShowInTargetIds() {
        IStructuredSelection selection = (IStructuredSelection)this.getCommonViewer().getSelection();
        for (Object element : selection.toList()) {
            if (element instanceof RepositoryNode) {
                return new String[]{"org.eclipse.team.ui.GenericHistoryView", "org.eclipse.egit.ui.ReflogView", "org.eclipse.egit.ui.StagingView"};
            }
            if (!(element instanceof RefNode)) continue;
            return new String[]{"org.eclipse.team.ui.GenericHistoryView", "org.eclipse.egit.ui.ReflogView"};
        }
        return new String[]{"org.eclipse.team.ui.GenericHistoryView"};
    }

    private static List<Object> getShowInElements(IStructuredSelection selection) {
        ArrayList<Object> elements = new ArrayList<Object>();
        for (Object element : selection.toList()) {
            if (element instanceof FileNode || element instanceof FolderNode || element instanceof WorkingDirNode) {
                RepositoryTreeNode treeNode = (RepositoryTreeNode)element;
                IPath path = treeNode.getPath();
                IResource resource = ResourceUtil.getResourceForLocation((IPath)path, (boolean)false);
                if (resource == null) continue;
                elements.add(resource);
                continue;
            }
            if (element instanceof RepositoryNode) {
                elements.add(element);
                continue;
            }
            if (!(element instanceof RepositoryNode) && !(element instanceof RemoteNode) && !(element instanceof FetchNode) && !(element instanceof PushNode) && !(element instanceof TagNode) && !(element instanceof RefNode)) continue;
            elements.add(element);
        }
        return elements;
    }

    private static HistoryPageInput getHistoryPageInput(IStructuredSelection selection) {
        ArrayList<File> files = new ArrayList<File>();
        Repository repo = null;
        for (Object element : selection.toList()) {
            Repository nodeRepository;
            if (element instanceof FileNode) {
                FileNode fileNode = (FileNode)element;
                files.add((File)fileNode.getObject());
                nodeRepository = fileNode.getRepository();
            } else if (element instanceof FolderNode) {
                FolderNode folderNode = (FolderNode)element;
                files.add((File)folderNode.getObject());
                nodeRepository = folderNode.getRepository();
            } else {
                return null;
            }
            if (repo == null) {
                repo = nodeRepository;
            }
            if (repo == nodeRepository) continue;
            return null;
        }
        if (repo != null) {
            return new HistoryPageInput(repo, files.toArray(new File[0]));
        }
        return null;
    }

    private IWorkbenchPart determinePart(IWorkbenchPart part) {
        Object nestedEditor;
        IWorkbenchPart currentPart = part;
        if (currentPart instanceof IEditorPart && currentPart instanceof MultiPageEditorPart && (nestedEditor = ((MultiPageEditorPart)part).getSelectedPage()) instanceof IEditorPart) {
            currentPart = (IEditorPart)nestedEditor;
        }
        return currentPart;
    }

    private ISelection convertSelection(IWorkbenchPart part, ISelection selection) {
        if (part instanceof IEditorPart) {
            IEditorInput input = ((IEditorPart)part).getEditorInput();
            if (input instanceof IFileEditorInput) {
                return new StructuredSelection((Object)((IFileEditorInput)input).getFile());
            }
            if (input instanceof IURIEditorInput) {
                return new StructuredSelection((Object)input);
            }
        }
        return selection;
    }

    private void reactOnSelection(ISelection selection) {
        if (this.layout.topControl != this.emptyArea && selection instanceof StructuredSelection) {
            File file;
            StructuredSelection ssel = (StructuredSelection)selection;
            if (ssel.size() != 1) {
                return;
            }
            Object selected = ssel.getFirstElement();
            IResource adapted = AdapterUtils.adaptToAnyResource((Object)selected);
            if (adapted != null) {
                this.showResource(adapted);
                return;
            }
            if (!(selected instanceof RepositoryNode) && !(selected instanceof RepositoryVirtualNode) && (file = (File)Adapters.adapt((Object)selected, File.class)) != null) {
                Path path = new Path(file.getAbsolutePath());
                this.showPaths(Arrays.asList(path));
                return;
            }
            Repository repository = (Repository)Adapters.adapt((Object)selected, Repository.class);
            if (repository != null && !repository.getDirectory().equals(this.lastSelectedRepository)) {
                this.showRepository(repository);
                return;
            }
        }
    }

    private void showEditor(FileNode node) {
        File file = (File)node.getObject();
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window != null) {
            IWorkbenchPage page = window.getActivePage();
            IEditorPart editor = EgitUiEditorUtils.findEditor(file, page);
            IEditorPart active = page.getActiveEditor();
            if (editor != null && editor != active) {
                window.getWorkbench().getDisplay().asyncExec(() -> page.bringToTop((IWorkbenchPart)editor));
            }
        }
    }

    private RepositoryTreeNode getRepositoryChildNode(Repository repository, RepositoryTreeNodeType type) {
        ITreeContentProvider cp = (ITreeContentProvider)this.getCommonViewer().getContentProvider();
        RepositoryTreeNode repoNode = this.findRepositoryNode(cp, cp.getElements(this.getCommonViewer().getInput()), repository);
        return repoNode == null ? null : this.findChild(cp, repoNode, type);
    }

    private RepositoryTreeNode findChild(ITreeContentProvider cp, RepositoryTreeNode root, RepositoryTreeNodeType type) {
        Object[] objectArray = cp.getChildren((Object)root);
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object child = objectArray[n2];
            RepositoryTreeNode childNode = (RepositoryTreeNode)child;
            if (childNode.getType() == type) {
                return childNode;
            }
            ++n2;
        }
        return null;
    }

    private RepositoryTreeNode findRepositoryNode(ITreeContentProvider cp, Object[] roots, Repository repository) {
        RepositoryTreeNode node;
        Object repo;
        Object[] objectArray = roots;
        int n = roots.length;
        int n2 = 0;
        while (n2 < n) {
            repo = objectArray[n2];
            node = (RepositoryTreeNode)repo;
            if (node instanceof RepositoryGroupNode) {
                RepositoryTreeNode candidate = this.findRepositoryNode(cp, cp.getChildren((Object)node), repository);
                if (candidate != null) {
                    return candidate;
                }
            } else if (repository.getDirectory().equals(((Repository)node.getObject()).getDirectory())) {
                return node;
            }
            ++n2;
        }
        objectArray = roots;
        n = roots.length;
        n2 = 0;
        while (n2 < n) {
            RepositoryTreeNode submoduleNode;
            repo = objectArray[n2];
            node = (RepositoryTreeNode)repo;
            RepositoryTreeNode submodules = this.findChild(cp, node, RepositoryTreeNodeType.SUBMODULES);
            if (submodules != null && (submoduleNode = this.findRepositoryNode(cp, cp.getChildren((Object)submodules), repository)) != null) {
                return submoduleNode;
            }
            ++n2;
        }
        return null;
    }

    private RepositoryTreeNode getNodeForPath(Repository repository, String repoRelativePath) {
        RepositoryTreeNode currentNode = this.getRepositoryChildNode(repository, RepositoryTreeNodeType.WORKINGDIR);
        CommonViewer viewer = this.getCommonViewer();
        if (currentNode == null) {
            return null;
        }
        RepositoryTreeNode workingDir = currentNode;
        if (Arrays.stream(viewer.getFilters()).anyMatch(filter -> !filter.select((Viewer)viewer, (Object)workingDir.getParent(), (Object)workingDir))) {
            return currentNode.getParent();
        }
        ITreeContentProvider cp = (ITreeContentProvider)viewer.getContentProvider();
        Path relPath = new Path(repoRelativePath);
        String[] stringArray = relPath.segments();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String segment = stringArray[n2];
            Object[] objectArray = cp.getChildren((Object)currentNode);
            int n3 = objectArray.length;
            int n4 = 0;
            while (n4 < n3) {
                Object child = objectArray[n4];
                RepositoryTreeNode childNode = (RepositoryTreeNode)child;
                if (((File)childNode.getObject()).getName().equals(segment)) {
                    currentNode = childNode;
                    break;
                }
                ++n4;
            }
            ++n2;
        }
        return currentNode;
    }

    private static class PathAddingLabelProvider
    extends NavigatorDecoratingLabelProvider {
        public PathAddingLabelProvider(ILabelProvider commonLabelProvider) {
            super(commonLabelProvider);
        }

        public void update(ViewerCell cell) {
            RepositoryTreeNodeLabelProvider.update(cell, viewerCell -> super.update(viewerCell));
        }
    }

    class RefreshUiJob
    extends WorkbenchJob {
        final AtomicReference<Runnable> uiTask;

        RefreshUiJob() {
            super(PlatformUI.getWorkbench().getDisplay(), "Refreshing Git Repositories View");
            this.uiTask = new AtomicReference();
            this.setSystem(true);
            this.setUser(false);
        }

        public boolean belongsTo(Object family) {
            return JobFamilies.REPO_VIEW_REFRESH.equals(family);
        }

        public IStatus runInUIThread(IProgressMonitor monitor) {
            PropertySheet sheet;
            IPage page;
            IViewPart part;
            boolean trace = GitTraceLocation.REPOSITORIESVIEW.isActive();
            long start = 0L;
            if (trace) {
                start = System.currentTimeMillis();
                RepositoriesView.this.trace("Starting async update job");
            }
            CommonViewer tv = RepositoriesView.this.getCommonViewer();
            if (monitor.isCanceled() || !UIUtils.isUsable((Viewer)tv)) {
                return Status.CANCEL_STATUS;
            }
            tv.refresh(true);
            if (monitor.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            IWorkbenchWindow ww = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            IViewPart iViewPart = part = ww == null ? null : ww.getActivePage().findView("org.eclipse.ui.views.PropertySheet");
            if (part instanceof PropertySheet && (page = (sheet = (PropertySheet)part).getCurrentPage()) instanceof PropertySheetPage) {
                ((PropertySheetPage)page).refresh();
            }
            if (monitor.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            Runnable task = this.uiTask.getAndSet(null);
            if (task != null) {
                task.run();
            }
            if (trace) {
                RepositoriesView.this.trace("Ending async update job after " + (System.currentTimeMillis() - start) + " ms");
            }
            return monitor.isCanceled() ? Status.CANCEL_STATUS : Status.OK_STATUS;
        }
    }

    private class RepositoriesCommonViewer
    extends CommonViewer {
        public RepositoriesCommonViewer(String viewId, Composite parent, int style) {
            super(viewId, parent, style);
        }

        protected void init() {
            super.init();
            this.setLabelProvider((IBaseLabelProvider)new PathAddingLabelProvider(this.getNavigatorContentService().createCommonLabelProvider()));
        }

        public void refresh() {
            super.refresh();
            RepositoriesView.this.afterRefresh(this);
        }

        public void refresh(boolean updateLabels) {
            super.refresh(updateLabels);
            RepositoriesView.this.afterRefresh(this);
        }

        public TreeItem getItem(Object element) {
            Widget item = this.findItem(element);
            if (item instanceof TreeItem) {
                return (TreeItem)item;
            }
            return null;
        }
    }

    private static class TreeFilterEditor
    extends ControlEditor {
        private Composite parent;
        private TreeItem item;
        private int columnIndex;
        private Point editorSize;

        public TreeFilterEditor(Composite parent, TreeItem item, int columnIndex, Control editor) {
            super(parent);
            this.parent = parent;
            this.item = item;
            this.columnIndex = columnIndex;
            this.editorSize = editor.computeSize(-1, -1);
            this.setEditor(editor);
        }

        public void layout() {
            Point textSize = null;
            GC gc = null;
            try {
                gc = new GC((Drawable)this.parent.getDisplay());
                gc.setFont(this.item.getFont(this.columnIndex));
                textSize = gc.stringExtent(this.item.getText(this.columnIndex));
            }
            finally {
                if (gc != null) {
                    gc.dispose();
                }
            }
            Rectangle cell = this.item.getBounds(this.columnIndex);
            Rectangle text = this.item.getTextBounds(this.columnIndex);
            Rectangle area = this.parent.getClientArea();
            area.y = cell.y;
            area.x = Math.max(area.x, Math.min(text.x + textSize.x + 5, area.x + area.width - this.editorSize.x));
            area.width = this.editorSize.x;
            area.height = this.editorSize.y;
            this.getEditor().setBounds(area);
        }

        public void dispose() {
            super.dispose();
            this.parent = null;
            this.item = null;
            this.editorSize = null;
        }
    }
}

