/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.net4j.protocol;

import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import org.eclipse.emf.cdo.CDOObject;
import org.eclipse.emf.cdo.common.CDOCommonSession;
import org.eclipse.emf.cdo.common.branch.CDOBranch;
import org.eclipse.emf.cdo.common.branch.CDOBranchHandler;
import org.eclipse.emf.cdo.common.branch.CDOBranchPoint;
import org.eclipse.emf.cdo.common.branch.CDOBranchPointRange;
import org.eclipse.emf.cdo.common.branch.CDOBranchVersion;
import org.eclipse.emf.cdo.common.commit.CDOChangeSetData;
import org.eclipse.emf.cdo.common.commit.CDOCommitData;
import org.eclipse.emf.cdo.common.commit.CDOCommitInfo;
import org.eclipse.emf.cdo.common.commit.CDOCommitInfoHandler;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.id.CDOIDProvider;
import org.eclipse.emf.cdo.common.lob.CDOLob;
import org.eclipse.emf.cdo.common.lob.CDOLobInfo;
import org.eclipse.emf.cdo.common.lock.CDOLockState;
import org.eclipse.emf.cdo.common.model.CDOPackageUnit;
import org.eclipse.emf.cdo.common.protocol.CDOProtocolConstants;
import org.eclipse.emf.cdo.common.revision.CDOIDAndVersion;
import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.common.revision.CDORevisionHandler;
import org.eclipse.emf.cdo.common.revision.CDORevisionKey;
import org.eclipse.emf.cdo.common.security.CDOPermission;
import org.eclipse.emf.cdo.common.util.TransportException;
import org.eclipse.emf.cdo.internal.net4j.bundle.OM;
import org.eclipse.emf.cdo.internal.net4j.protocol.BranchNotificationIndication;
import org.eclipse.emf.cdo.internal.net4j.protocol.ChangeCredentialsRequest;
import org.eclipse.emf.cdo.internal.net4j.protocol.ChangeSubscriptionRequest;
import org.eclipse.emf.cdo.internal.net4j.protocol.ChangeTagRequest;
import org.eclipse.emf.cdo.internal.net4j.protocol.CloseViewRequest;
import org.eclipse.emf.cdo.internal.net4j.protocol.CommitDelegationRequest;
import org.eclipse.emf.cdo.internal.net4j.protocol.CommitNotificationIndication;
import org.eclipse.emf.cdo.internal.net4j.protocol.CommitTransactionRequest;
import org.eclipse.emf.cdo.internal.net4j.protocol.CommitXATransactionCancelRequest;
import org.eclipse.emf.cdo.internal.net4j.protocol.CommitXATransactionPhase1Request;
import org.eclipse.emf.cdo.internal.net4j.protocol.CommitXATransactionPhase2Request;
import org.eclipse.emf.cdo.internal.net4j.protocol.CommitXATransactionPhase3Request;
import org.eclipse.emf.cdo.internal.net4j.protocol.CreateBranchRequest;
import org.eclipse.emf.cdo.internal.net4j.protocol.CredentialsChallengeIndication;
import org.eclipse.emf.cdo.internal.net4j.protocol.DisablePassiveUpdateRequest;
import org.eclipse.emf.cdo.internal.net4j.protocol.EnableLockNotificationRequest;
import org.eclipse.emf.cdo.internal.net4j.protocol.GetRemoteSessionsRequest;
import org.eclipse.emf.cdo.internal.net4j.protocol.HandleRevisionsRequest;
import org.eclipse.emf.cdo.internal.net4j.protocol.LoadBranchRequest;
import org.eclipse.emf.cdo.internal.net4j.protocol.LoadBranchesRequest;
import org.eclipse.emf.cdo.internal.net4j.protocol.LoadChangeSetsRequest;
import org.eclipse.emf.cdo.internal.net4j.protocol.LoadChunkRequest;
import org.eclipse.emf.cdo.internal.net4j.protocol.LoadCommitDataRequest;
import org.eclipse.emf.cdo.internal.net4j.protocol.LoadCommitInfosRequest;
import org.eclipse.emf.cdo.internal.net4j.protocol.LoadLobRequest;
import org.eclipse.emf.cdo.internal.net4j.protocol.LoadMergeDataRequest;
import org.eclipse.emf.cdo.internal.net4j.protocol.LoadObjectLifetimeRequest;
import org.eclipse.emf.cdo.internal.net4j.protocol.LoadPackagesRequest;
import org.eclipse.emf.cdo.internal.net4j.protocol.LoadPermissionsRequest;
import org.eclipse.emf.cdo.internal.net4j.protocol.LoadRevisionByVersionRequest;
import org.eclipse.emf.cdo.internal.net4j.protocol.LoadRevisionsRequest;
import org.eclipse.emf.cdo.internal.net4j.protocol.LoadSubBranchesRequest;
import org.eclipse.emf.cdo.internal.net4j.protocol.LoadTagsRequest;
import org.eclipse.emf.cdo.internal.net4j.protocol.LockAreaRequest;
import org.eclipse.emf.cdo.internal.net4j.protocol.LockDelegationRequest;
import org.eclipse.emf.cdo.internal.net4j.protocol.LockNotificationIndication;
import org.eclipse.emf.cdo.internal.net4j.protocol.LockObjectsRequest;
import org.eclipse.emf.cdo.internal.net4j.protocol.LockStateRequest;
import org.eclipse.emf.cdo.internal.net4j.protocol.ObjectLockedRequest;
import org.eclipse.emf.cdo.internal.net4j.protocol.OpenSessionRequest;
import org.eclipse.emf.cdo.internal.net4j.protocol.OpenViewRequest;
import org.eclipse.emf.cdo.internal.net4j.protocol.OpenedSessionRequest;
import org.eclipse.emf.cdo.internal.net4j.protocol.QueryCancelRequest;
import org.eclipse.emf.cdo.internal.net4j.protocol.QueryLobsRequest;
import org.eclipse.emf.cdo.internal.net4j.protocol.QueryRequest;
import org.eclipse.emf.cdo.internal.net4j.protocol.RefreshSessionRequest;
import org.eclipse.emf.cdo.internal.net4j.protocol.RemoteMessageNotificationIndication;
import org.eclipse.emf.cdo.internal.net4j.protocol.RemoteMessageRequest;
import org.eclipse.emf.cdo.internal.net4j.protocol.RemoteSessionNotificationIndication;
import org.eclipse.emf.cdo.internal.net4j.protocol.RenameBranchRequest;
import org.eclipse.emf.cdo.internal.net4j.protocol.ReplicateRepositoryRawRequest;
import org.eclipse.emf.cdo.internal.net4j.protocol.ReplicateRepositoryRequest;
import org.eclipse.emf.cdo.internal.net4j.protocol.RepositoryStateNotificationIndication;
import org.eclipse.emf.cdo.internal.net4j.protocol.RepositoryTimeRequest;
import org.eclipse.emf.cdo.internal.net4j.protocol.RepositoryTypeNotificationIndication;
import org.eclipse.emf.cdo.internal.net4j.protocol.ResetTransactionRequest;
import org.eclipse.emf.cdo.internal.net4j.protocol.SetLockNotificationModeRequest;
import org.eclipse.emf.cdo.internal.net4j.protocol.SetPassiveUpdateModeRequest;
import org.eclipse.emf.cdo.internal.net4j.protocol.SwitchTargetRequest;
import org.eclipse.emf.cdo.internal.net4j.protocol.TagNotificationIndication;
import org.eclipse.emf.cdo.internal.net4j.protocol.UnitRequest;
import org.eclipse.emf.cdo.internal.net4j.protocol.UnlockDelegationRequest;
import org.eclipse.emf.cdo.internal.net4j.protocol.UnlockObjectsRequest;
import org.eclipse.emf.cdo.internal.net4j.protocol.UnsubscribeRemoteSessionsRequest;
import org.eclipse.emf.cdo.session.CDOSession;
import org.eclipse.emf.cdo.session.remote.CDORemoteSession;
import org.eclipse.emf.cdo.session.remote.CDORemoteSessionMessage;
import org.eclipse.emf.cdo.spi.common.CDORawReplicationContext;
import org.eclipse.emf.cdo.spi.common.CDOReplicationContext;
import org.eclipse.emf.cdo.spi.common.branch.InternalCDOBranchManager;
import org.eclipse.emf.cdo.spi.common.commit.CDORevisionAvailabilityInfo;
import org.eclipse.emf.cdo.spi.common.model.InternalCDOPackageUnit;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevision;
import org.eclipse.emf.cdo.spi.common.revision.RevisionInfo;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.internal.cdo.session.CDOSessionImpl;
import org.eclipse.emf.spi.cdo.AbstractQueryIterator;
import org.eclipse.emf.spi.cdo.CDOSessionProtocol;
import org.eclipse.emf.spi.cdo.InternalCDOObject;
import org.eclipse.emf.spi.cdo.InternalCDORemoteSessionManager;
import org.eclipse.emf.spi.cdo.InternalCDOTransaction;
import org.eclipse.emf.spi.cdo.InternalCDOXATransaction;
import org.eclipse.net4j.signal.RemoteException;
import org.eclipse.net4j.signal.Request;
import org.eclipse.net4j.signal.RequestWithConfirmation;
import org.eclipse.net4j.signal.RequestWithMonitoring;
import org.eclipse.net4j.signal.SignalProtocol;
import org.eclipse.net4j.signal.SignalReactor;
import org.eclipse.net4j.signal.security.AuthenticatingSignalProtocol;
import org.eclipse.net4j.signal.security.AuthenticationIndication;
import org.eclipse.net4j.util.WrappedException;
import org.eclipse.net4j.util.collection.Pair;
import org.eclipse.net4j.util.concurrent.IRWLockManager;
import org.eclipse.net4j.util.io.StringCompressor;
import org.eclipse.net4j.util.io.StringIO;
import org.eclipse.net4j.util.om.OMPlatform;
import org.eclipse.net4j.util.om.monitor.Monitor;
import org.eclipse.net4j.util.om.monitor.OMMonitor;
import org.eclipse.net4j.util.om.trace.PerfTracer;

public class CDOClientProtocol
extends AuthenticatingSignalProtocol<CDOSessionImpl>
implements CDOSessionProtocol {
    private static final PerfTracer REVISION_LOADING = new PerfTracer(OM.PERF_REVISION_LOADING, CDOClientProtocol.class);
    private static final boolean COMPRESS_PACKAGE_URIS = OMPlatform.INSTANCE.isProperty("org.eclipse.emf.cdo.protocol.compressPackageURIs", !StringCompressor.BYPASS);
    private StringIO packageURICompressor = COMPRESS_PACKAGE_URIS ? new StringCompressor(true) : StringIO.DIRECT;

    public CDOClientProtocol() {
        super("cdo");
    }

    public int getVersion() {
        return 38;
    }

    public CDOSession getSession() {
        return (CDOSession)this.getInfraStructure();
    }

    public StringIO getPackageURICompressor() {
        return this.packageURICompressor;
    }

    public CDOSessionProtocol.OpenSessionResult openSession(String repositoryName, String userID, boolean passiveUpdateEnabled, CDOCommonSession.Options.PassiveUpdateMode passiveUpdateMode, CDOCommonSession.Options.LockNotificationMode lockNotificationMode) {
        return this.send(new OpenSessionRequest(this, repositoryName, userID, passiveUpdateEnabled, passiveUpdateMode, lockNotificationMode), (OMMonitor)new Monitor());
    }

    public void disablePassiveUpdate() {
        this.send(new DisablePassiveUpdateRequest(this));
    }

    public void setPassiveUpdateMode(CDOCommonSession.Options.PassiveUpdateMode mode) {
        this.send(new SetPassiveUpdateModeRequest(this, mode));
    }

    public CDOSessionProtocol.RepositoryTimeResult getRepositoryTime() {
        return this.send(new RepositoryTimeRequest(this));
    }

    public void openedSession() {
        this.send(new OpenedSessionRequest(this));
    }

    public EPackage[] loadPackages(CDOPackageUnit packageUnit) {
        return this.send(new LoadPackagesRequest(this, (InternalCDOPackageUnit)packageUnit));
    }

    public Pair<Integer, Long> createBranch(int branchID, InternalCDOBranchManager.BranchLoader.BranchInfo branchInfo) {
        return this.send(new CreateBranchRequest(this, branchID, branchInfo));
    }

    public InternalCDOBranchManager.BranchLoader.BranchInfo loadBranch(int branchID) {
        return this.send(new LoadBranchRequest(this, branchID));
    }

    public InternalCDOBranchManager.BranchLoader.SubBranchInfo[] loadSubBranches(int branchID) {
        return this.send(new LoadSubBranchesRequest(this, branchID));
    }

    public int loadBranches(int startID, int endID, CDOBranchHandler handler) {
        return this.send(new LoadBranchesRequest(this, startID, endID, handler));
    }

    @Deprecated
    public void deleteBranch(int branchID) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public void renameBranch(int branchID, String newName) {
        throw new UnsupportedOperationException();
    }

    public void renameBranch(int branchID, String oldName, String newName) {
        this.send(new RenameBranchRequest(this, branchID, oldName, newName));
    }

    public CDOBranchPoint changeTag(AtomicInteger modCount, String oldName, String newName, CDOBranchPoint branchPoint) {
        return this.send(new ChangeTagRequest(this, modCount, oldName, newName, branchPoint));
    }

    public void loadTags(String name, Consumer<InternalCDOBranchManager.BranchLoader.BranchInfo> handler) {
        this.send(new LoadTagsRequest(this, name, handler));
    }

    public void loadCommitInfos(CDOBranch branch, long startTime, long endTime, CDOCommitInfoHandler handler) {
        this.send(new LoadCommitInfosRequest(this, branch, startTime, endTime, handler));
    }

    public CDOCommitData loadCommitData(long timeStamp) {
        return this.send(new LoadCommitDataRequest(this, timeStamp));
    }

    public Object loadChunk(InternalCDORevision revision, EStructuralFeature feature, int accessIndex, int fetchIndex, int fromIndex, int toIndex) {
        return this.send(new LoadChunkRequest(this, revision, feature, accessIndex, fetchIndex, fromIndex, toIndex));
    }

    public List<RevisionInfo> loadRevisions(List<RevisionInfo> infos, CDOBranchPoint branchPoint, int referenceChunk, int prefetchDepth) {
        return this.send(new LoadRevisionsRequest(this, infos, branchPoint, referenceChunk, prefetchDepth));
    }

    public InternalCDORevision loadRevisionByVersion(CDOID id, CDOBranchVersion branchVersion, int referenceChunk) {
        return this.send(new LoadRevisionByVersionRequest(this, id, branchVersion, referenceChunk));
    }

    public CDOBranchPointRange loadObjectLifetime(CDOID id, CDOBranchPoint branchPoint) {
        return this.send(new LoadObjectLifetimeRequest(this, id, branchPoint));
    }

    public CDOSessionProtocol.RefreshSessionResult refresh(long lastUpdateTime, Map<CDOBranch, Map<CDOID, InternalCDORevision>> viewedRevisions, int initialChunkSize, boolean enablePassiveUpdates) {
        return this.send(new RefreshSessionRequest(this, lastUpdateTime, viewedRevisions, initialChunkSize, enablePassiveUpdates));
    }

    public void openView(int viewID, boolean readOnly, CDOBranchPoint branchPoint) {
        this.send(new OpenViewRequest(this, viewID, readOnly, branchPoint));
    }

    public CDOBranchPoint openView(int viewID, boolean readOnly, String durableLockingID) {
        return this.send(new OpenViewRequest(this, viewID, readOnly, durableLockingID));
    }

    public void switchTarget(int viewID, CDOBranchPoint branchPoint, List<InternalCDOObject> invalidObjects, List<CDORevisionKey> allChangedObjects, List<CDOIDAndVersion> allDetachedObjects, OMMonitor monitor) {
        this.send(new SwitchTargetRequest(this, viewID, branchPoint, invalidObjects, allChangedObjects, allDetachedObjects), monitor);
    }

    public void closeView(int viewID) {
        this.send(new CloseViewRequest(this, viewID));
    }

    public void changeSubscription(int viewID, List<CDOID> ids, boolean subscribeMode, boolean clear) {
        this.send(new ChangeSubscriptionRequest(this, viewID, ids, subscribeMode, clear));
    }

    public void query(CDOView view, AbstractQueryIterator<?> queryResult) {
        this.send(new QueryRequest(this, view, queryResult));
    }

    public boolean cancelQuery(int queryId) {
        try {
            return (Boolean)new QueryCancelRequest(this, queryId).send();
        }
        catch (Exception ignore) {
            return false;
        }
    }

    @Deprecated
    public CDOSessionProtocol.LockObjectsResult lockObjects(List<InternalCDORevision> revisions, int viewID, CDOBranch viewedBranch, IRWLockManager.LockType lockType, long timeout) throws InterruptedException {
        throw new UnsupportedOperationException();
    }

    public CDOSessionProtocol.LockObjectsResult lockObjects2(List<CDORevisionKey> revisionKeys, int viewID, CDOBranch viewedBranch, IRWLockManager.LockType lockType, boolean recursive, long timeout) throws InterruptedException {
        InterruptedException interruptedException = null;
        RuntimeException runtimeException = null;
        try {
            return (CDOSessionProtocol.LockObjectsResult)new LockObjectsRequest(this, revisionKeys, viewID, lockType, recursive, timeout).send();
        }
        catch (RemoteException ex) {
            if (ex.getCause() instanceof RuntimeException) {
                runtimeException = (RuntimeException)ex.getCause();
            } else if (ex.getCause() instanceof InterruptedException) {
                interruptedException = (InterruptedException)ex.getCause();
            } else {
                runtimeException = WrappedException.wrap((Exception)((Object)ex));
            }
        }
        catch (Exception ex) {
            throw WrappedException.wrap((Exception)ex);
        }
        if (interruptedException != null) {
            throw interruptedException;
        }
        throw runtimeException;
    }

    public CDOSessionProtocol.LockObjectsResult delegateLockObjects(String lockAreaID, List<CDORevisionKey> revisionKeys, CDOBranch viewedBranch, IRWLockManager.LockType lockType, boolean recursive, long timeout) throws InterruptedException {
        InterruptedException interruptedException = null;
        RuntimeException runtimeException = null;
        try {
            return (CDOSessionProtocol.LockObjectsResult)new LockDelegationRequest(this, lockAreaID, revisionKeys, viewedBranch, lockType, recursive, timeout).send();
        }
        catch (RemoteException ex) {
            if (ex.getCause() instanceof RuntimeException) {
                runtimeException = (RuntimeException)ex.getCause();
            } else if (ex.getCause() instanceof InterruptedException) {
                interruptedException = (InterruptedException)ex.getCause();
            } else {
                runtimeException = WrappedException.wrap((Exception)((Object)ex));
            }
        }
        catch (Exception ex) {
            throw WrappedException.wrap((Exception)ex);
        }
        if (interruptedException != null) {
            throw interruptedException;
        }
        throw runtimeException;
    }

    @Deprecated
    public void unlockObjects(CDOView view, Collection<CDOID> objectIDs, IRWLockManager.LockType lockType) {
        throw new UnsupportedOperationException();
    }

    public CDOSessionProtocol.UnlockObjectsResult unlockObjects2(CDOView view, Collection<CDOID> objectIDs, IRWLockManager.LockType lockType, boolean recursive) {
        return this.send(new UnlockObjectsRequest(this, view.getViewID(), objectIDs, lockType, recursive));
    }

    public CDOSessionProtocol.UnlockObjectsResult delegateUnlockObjects(String lockAreaID, Collection<CDOID> objectIDs, IRWLockManager.LockType lockType, boolean recursive) {
        return this.send(new UnlockDelegationRequest(this, lockAreaID, objectIDs, lockType, recursive));
    }

    public boolean isObjectLocked(CDOView view, CDOObject object, IRWLockManager.LockType lockType, boolean byOthers) {
        return this.send(new ObjectLockedRequest(this, view, object, lockType, byOthers));
    }

    public String changeLockArea(CDOView view, boolean create) {
        return this.send(new LockAreaRequest(this, view, create));
    }

    public List<byte[]> queryLobs(Set<byte[]> ids) {
        return this.send(new QueryLobsRequest(this, ids));
    }

    public void loadLob(CDOLobInfo info, Object outputStreamOrWriter) throws IOException {
        try {
            new LoadLobRequest(this, info, outputStreamOrWriter).send();
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (IOException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new TransportException((Throwable)ex);
        }
    }

    public void handleRevisions(EClass eClass, CDOBranch branch, boolean exactBranch, long timeStamp, boolean exactTime, CDORevisionHandler handler) {
        this.send(new HandleRevisionsRequest(this, eClass, branch, exactBranch, timeStamp, exactTime, handler));
    }

    @Deprecated
    public CDOSessionProtocol.CommitTransactionResult commitTransaction(int transactionID, String comment, boolean releaseLocks, CDOIDProvider idProvider, CDOCommitData commitData, Collection<CDOLob<?>> lobs, OMMonitor monitor) {
        throw new UnsupportedOperationException();
    }

    public CDOSessionProtocol.CommitTransactionResult commitTransaction(InternalCDOTransaction.InternalCDOCommitContext context, OMMonitor monitor) {
        return this.send(new CommitTransactionRequest(this, context), monitor);
    }

    @Deprecated
    public CDOSessionProtocol.CommitTransactionResult commitDelegation(CDOBranch branch, String userID, String comment, CDOCommitData commitData, Map<CDOID, EClass> detachedObjectTypes, Collection<CDOLob<?>> lobs, OMMonitor monitor) {
        throw new UnsupportedOperationException();
    }

    public CDOSessionProtocol.CommitTransactionResult commitDelegation(InternalCDOTransaction.InternalCDOCommitContext context, OMMonitor monitor) {
        return this.send(new CommitDelegationRequest(this, context), monitor);
    }

    public CDOSessionProtocol.CommitTransactionResult commitXATransactionPhase1(InternalCDOXATransaction.InternalCDOXACommitContext xaContext, OMMonitor monitor) {
        return this.send(new CommitXATransactionPhase1Request(this, xaContext), monitor);
    }

    public CDOSessionProtocol.CommitTransactionResult commitXATransactionPhase2(InternalCDOXATransaction.InternalCDOXACommitContext xaContext, OMMonitor monitor) {
        return this.send(new CommitXATransactionPhase2Request(this, xaContext), monitor);
    }

    public CDOSessionProtocol.CommitTransactionResult commitXATransactionPhase3(InternalCDOXATransaction.InternalCDOXACommitContext xaContext, OMMonitor monitor) {
        return this.send(new CommitXATransactionPhase3Request(this, xaContext), monitor);
    }

    public CDOSessionProtocol.CommitTransactionResult commitXATransactionCancel(InternalCDOXATransaction.InternalCDOXACommitContext xaContext, OMMonitor monitor) {
        return this.send(new CommitXATransactionCancelRequest(this, xaContext), monitor);
    }

    public CDOCommitInfo resetTransaction(int transactionID, int commitNumber) {
        return this.send(new ResetTransactionRequest(this, transactionID, commitNumber));
    }

    public List<CDORemoteSession> getRemoteSessions(InternalCDORemoteSessionManager manager, boolean subscribe) {
        return this.send(new GetRemoteSessionsRequest(this, subscribe));
    }

    public Set<Integer> sendRemoteMessage(CDORemoteSessionMessage message, List<CDORemoteSession> recipients) {
        return this.send(new RemoteMessageRequest(this, message, recipients));
    }

    public boolean unsubscribeRemoteSessions() {
        return this.send(new UnsubscribeRemoteSessionsRequest(this));
    }

    public void replicateRepository(CDOReplicationContext context, OMMonitor monitor) {
        this.send(new ReplicateRepositoryRequest(this, context, monitor));
    }

    public void replicateRepositoryRaw(CDORawReplicationContext context, OMMonitor monitor) {
        this.send(new ReplicateRepositoryRawRequest(this, context), monitor);
    }

    public CDOChangeSetData[] loadChangeSets(CDOBranchPointRange ... ranges) {
        return this.send(new LoadChangeSetsRequest(this, ranges));
    }

    @Deprecated
    public Set<CDOID> loadMergeData(CDORevisionAvailabilityInfo targetInfo, CDORevisionAvailabilityInfo sourceInfo, CDORevisionAvailabilityInfo targetBaseInfo, CDORevisionAvailabilityInfo sourceBaseInfo) {
        throw new UnsupportedOperationException();
    }

    public CDOSessionProtocol.MergeDataResult loadMergeData2(CDORevisionAvailabilityInfo targetInfo, CDORevisionAvailabilityInfo sourceInfo, CDORevisionAvailabilityInfo targetBaseInfo, CDORevisionAvailabilityInfo sourceBaseInfo) {
        return (CDOSessionProtocol.MergeDataResult)this.send((RequestWithConfirmation)new LoadMergeDataRequest(this, targetInfo, sourceInfo, targetBaseInfo, sourceBaseInfo));
    }

    @Deprecated
    public CDOLockState[] getLockStates(int viewID, Collection<CDOID> ids) {
        return this.getLockStates(viewID, ids, 0);
    }

    public CDOLockState[] getLockStates(int viewID, Collection<CDOID> ids, int depth) {
        return this.send(new LockStateRequest(this, viewID, ids, depth));
    }

    public void enableLockNotifications(int viewID, boolean on) {
        this.send(new EnableLockNotificationRequest(this, viewID, on));
    }

    public void setLockNotificationMode(CDOCommonSession.Options.LockNotificationMode mode) {
        this.send(new SetLockNotificationModeRequest(this, mode));
    }

    public Map<CDORevision, CDOPermission> loadPermissions(InternalCDORevision[] revisions) {
        return this.send(new LoadPermissionsRequest(this, revisions));
    }

    @Deprecated
    public void requestChangeCredentials() {
        this.requestChangeServerPassword(null);
    }

    public void requestChangeServerPassword(AtomicReference<char[]> receiver) {
        this.send(new ChangeCredentialsRequest(this, receiver), (OMMonitor)new Monitor());
    }

    public void requestResetCredentials(String userID) {
        this.send(new ChangeCredentialsRequest(this, userID), (OMMonitor)new Monitor());
    }

    public boolean requestUnit(int viewID, CDOID rootID, CDOProtocolConstants.UnitOpcode opcode, CDORevisionHandler revisionHandler, OMMonitor monitor) {
        return this.send(new UnitRequest(this, viewID, rootID, opcode, revisionHandler), monitor);
    }

    protected StringCompressor getStringCompressor() {
        if (COMPRESS_PACKAGE_URIS) {
            return (StringCompressor)this.packageURICompressor;
        }
        return super.getStringCompressor();
    }

    protected SignalReactor createSignalReactor(short signalID) {
        switch (signalID) {
            case 2: {
                return new AuthenticationIndication((AuthenticatingSignalProtocol)this, 2);
            }
            case 39: {
                return new BranchNotificationIndication(this);
            }
            case 37: {
                return new RepositoryTypeNotificationIndication(this);
            }
            case 38: {
                return new RepositoryStateNotificationIndication(this);
            }
            case 10: {
                return new CommitNotificationIndication(this);
            }
            case 32: {
                return new RemoteSessionNotificationIndication(this);
            }
            case 30: {
                return new RemoteMessageNotificationIndication(this);
            }
            case 51: {
                return new LockNotificationIndication(this);
            }
            case 57: {
                return new CredentialsChallengeIndication((SignalProtocol<?>)this);
            }
            case 65: {
                return new TagNotificationIndication(this);
            }
        }
        return super.createSignalReactor(signalID);
    }

    private void send(Request request) {
        try {
            request.sendAsync();
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new TransportException((Throwable)ex);
        }
    }

    private <RESULT> RESULT send(RequestWithConfirmation<RESULT> request) {
        try {
            return (RESULT)request.send();
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new TransportException((Throwable)ex);
        }
    }

    private <RESULT> RESULT send(RequestWithMonitoring<RESULT> request, OMMonitor monitor) {
        try {
            return (RESULT)request.send(monitor);
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new TransportException((Throwable)ex);
        }
    }

    private List<RevisionInfo> send(LoadRevisionsRequest request) {
        try {
            REVISION_LOADING.start((Object)request);
            List<RevisionInfo> list = this.send((RequestWithConfirmation)request);
            return list;
        }
        finally {
            REVISION_LOADING.stop((Object)request);
        }
    }
}

