/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.view;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.emf.cdo.util.CDOURIUtil;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.emf.cdo.view.CDOViewProvider;
import org.eclipse.emf.common.util.URI;
import org.eclipse.net4j.util.ReflectUtil;

public abstract class AbstractCDOViewProvider
implements CDOViewProvider.CDOViewProvider2 {
    private String regex;
    private int priority = 500;
    @ReflectUtil.ExcludeFromDump
    private transient Pattern pattern;

    public AbstractCDOViewProvider() {
    }

    public AbstractCDOViewProvider(String regex, int priority) {
        this.regex = regex;
        this.priority = priority;
    }

    public AbstractCDOViewProvider(String regex) {
        this(regex, 500);
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    @Override
    public String getRegex() {
        return this.regex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRegex(String regex) {
        String string = regex;
        synchronized (string) {
            this.regex = regex;
            this.pattern = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean matchesRegex(URI uri) {
        String string = this.regex;
        synchronized (string) {
            if (this.pattern == null) {
                this.pattern = Pattern.compile(this.regex);
            }
        }
        Matcher matcher = this.pattern.matcher(uri.toString());
        return matcher.matches();
    }

    @Override
    public URI getResourceURI(CDOView view, String path) {
        throw new UnsupportedOperationException("Must be overridden in subclasses!");
    }

    @Override
    public URI getViewURI(CDOView view) {
        URI uri = this.getResourceURI(view, null);
        if (uri != null) {
            return this.getViewURI(uri);
        }
        return null;
    }

    @Override
    public URI getViewURI(URI uri) {
        return CDOURIUtil.trimResourceInfos(uri);
    }

    @Override
    public String getPath(URI uri) {
        return uri.path();
    }

    public String toString() {
        return String.valueOf(this.getDeclaredName()) + "[" + this.getRegex() + " --> " + this.getActualName() + ", " + this.getPriority() + "]";
    }

    protected String getDeclaredName() {
        return "CDOViewProvider";
    }

    protected String getActualName() {
        return ReflectUtil.getSimpleClassName((Object)this);
    }
}

