/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.internal.cdo.view;

import java.lang.reflect.Array;
import java.text.MessageFormat;
import java.util.List;
import org.eclipse.emf.cdo.common.branch.CDOBranchPoint;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.model.CDOModelUtil;
import org.eclipse.emf.cdo.common.model.CDOType;
import org.eclipse.emf.cdo.common.revision.CDOElementProxy;
import org.eclipse.emf.cdo.common.revision.CDOList;
import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.common.revision.CDORevisionManager;
import org.eclipse.emf.cdo.common.revision.delta.CDOFeatureDelta;
import org.eclipse.emf.cdo.eresource.CDOResource;
import org.eclipse.emf.cdo.internal.common.revision.delta.CDOAddFeatureDeltaImpl;
import org.eclipse.emf.cdo.internal.common.revision.delta.CDOClearFeatureDeltaImpl;
import org.eclipse.emf.cdo.internal.common.revision.delta.CDOContainerFeatureDeltaImpl;
import org.eclipse.emf.cdo.internal.common.revision.delta.CDOMoveFeatureDeltaImpl;
import org.eclipse.emf.cdo.internal.common.revision.delta.CDORemoveFeatureDeltaImpl;
import org.eclipse.emf.cdo.internal.common.revision.delta.CDOSetFeatureDeltaImpl;
import org.eclipse.emf.cdo.internal.common.revision.delta.CDOUnsetFeatureDeltaImpl;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevision;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevisionManager;
import org.eclipse.emf.cdo.util.CDOUtil;
import org.eclipse.emf.cdo.util.ObjectNotFoundException;
import org.eclipse.emf.cdo.view.CDOFeatureAnalyzer;
import org.eclipse.emf.cdo.view.CDORevisionPrefetchingPolicy;
import org.eclipse.emf.cdo.view.CDOStaleReferencePolicy;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.internal.cdo.bundle.OM;
import org.eclipse.emf.internal.cdo.view.CDOStateMachine;
import org.eclipse.emf.spi.cdo.CDOStore;
import org.eclipse.emf.spi.cdo.FSMUtil;
import org.eclipse.emf.spi.cdo.InternalCDOObject;
import org.eclipse.emf.spi.cdo.InternalCDOView;
import org.eclipse.net4j.util.ObjectUtil;
import org.eclipse.net4j.util.om.trace.ContextTracer;

public final class CDOStoreImpl
implements CDOStore {
    private final ContextTracer TRACER = new ContextTracer(OM.DEBUG_STORE, CDOStoreImpl.class);
    private final InternalCDOView view;

    public CDOStoreImpl(InternalCDOView view) {
        this.view = view;
    }

    @Override
    public InternalCDOView getView() {
        return this.view;
    }

    public InternalEObject getContainer(InternalEObject eObject) {
        Object object = this.view.getViewMonitor();
        synchronized (object) {
            InternalEObject internalEObject;
            this.view.lockView();
            try {
                InternalCDOObject cdoObject = this.getCDOObject(eObject);
                if (this.TRACER.isEnabled()) {
                    this.TRACER.format("getContainer({0})", new Object[]{cdoObject});
                }
                InternalCDORevision revision = CDOStoreImpl.readRevision(cdoObject);
                internalEObject = (InternalEObject)this.convertIDToObject(this.view, cdoObject, null, -1, revision.getContainerID());
                this.view.unlockView();
            }
            catch (Throwable throwable) {
                this.view.unlockView();
                throw throwable;
            }
            return internalEObject;
        }
    }

    @Override
    public int getContainingFeatureID(InternalEObject eObject) {
        Object object = this.view.getViewMonitor();
        synchronized (object) {
            int n;
            this.view.lockView();
            try {
                InternalCDOObject cdoObject = this.getCDOObject(eObject);
                if (this.TRACER.isEnabled()) {
                    this.TRACER.format("getContainingFeatureID({0})", new Object[]{cdoObject});
                }
                InternalCDORevision revision = CDOStoreImpl.readRevision(cdoObject);
                n = revision.getContainingFeatureID();
                this.view.unlockView();
            }
            catch (Throwable throwable) {
                this.view.unlockView();
                throw throwable;
            }
            return n;
        }
    }

    @Override
    public InternalEObject getResource(InternalEObject eObject) {
        Object object = this.view.getViewMonitor();
        synchronized (object) {
            InternalEObject internalEObject;
            this.view.lockView();
            try {
                InternalCDOObject cdoObject = this.getCDOObject(eObject);
                if (this.TRACER.isEnabled()) {
                    this.TRACER.format("getResource({0})", new Object[]{cdoObject});
                }
                InternalCDORevision revision = CDOStoreImpl.readRevision(cdoObject);
                internalEObject = (InternalEObject)this.convertIDToObject(this.view, cdoObject, null, -1, revision.getResourceID());
                this.view.unlockView();
            }
            catch (Throwable throwable) {
                this.view.unlockView();
                throw throwable;
            }
            return internalEObject;
        }
    }

    public EStructuralFeature getContainingFeature(InternalEObject eObject) {
        throw new UnsupportedOperationException("Use getContainingFeatureID() instead");
    }

    public Object get(InternalEObject eObject, EStructuralFeature feature, int index) {
        Object object = this.view.getViewMonitor();
        synchronized (object) {
            Object object2;
            this.view.lockView();
            try {
                InternalCDOObject cdoObject = this.getCDOObject(eObject);
                if (this.TRACER.isEnabled()) {
                    this.TRACER.format("get({0}, {1}, {2})", new Object[]{cdoObject, feature, index});
                }
                CDOFeatureAnalyzer featureAnalyzer = this.view.options().getFeatureAnalyzer();
                featureAnalyzer.preTraverseFeature(cdoObject, feature, index);
                InternalCDORevision revision = CDOStoreImpl.readRevision(cdoObject);
                Object value = revision.get(feature, index);
                value = this.convertToEMF((EObject)eObject, revision, feature, index, value);
                featureAnalyzer.postTraverseFeature(cdoObject, feature, index, value);
                object2 = value;
                this.view.unlockView();
            }
            catch (Throwable throwable) {
                this.view.unlockView();
                throw throwable;
            }
            return object2;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isSet(InternalEObject eObject, EStructuralFeature feature) {
        Object object = this.view.getViewMonitor();
        synchronized (object) {
            this.view.lockView();
            try {
                Object defaultValue;
                InternalCDOObject cdoObject = this.getCDOObject(eObject);
                if (this.TRACER.isEnabled()) {
                    this.TRACER.format("isSet({0}, {1})", new Object[]{cdoObject, feature});
                }
                InternalCDORevision revision = CDOStoreImpl.readRevision(cdoObject);
                if (feature.isUnsettable()) {
                    Object value = revision.getValue(feature);
                    boolean bl = value != null;
                    return bl;
                }
                if (feature.isMany()) {
                    CDOList list = revision.getListOrNull(feature);
                    boolean bl = list != null && !list.isEmpty();
                    return bl;
                }
                Object value = revision.getValue(feature);
                if (value == null) {
                    return false;
                }
                boolean bl = !ObjectUtil.equals((Object)(value = this.convertToEMF((EObject)eObject, revision, feature, -1, value)), (Object)(defaultValue = feature.getDefaultValue()));
                return bl;
            }
            finally {
                this.view.unlockView();
            }
        }
    }

    public int size(InternalEObject eObject, EStructuralFeature feature) {
        Object object = this.view.getViewMonitor();
        synchronized (object) {
            int n;
            this.view.lockView();
            try {
                InternalCDOObject cdoObject = this.getCDOObject(eObject);
                if (this.TRACER.isEnabled()) {
                    this.TRACER.format("size({0}, {1})", new Object[]{cdoObject, feature});
                }
                InternalCDORevision revision = CDOStoreImpl.readRevision(cdoObject);
                n = revision.size(feature);
                this.view.unlockView();
            }
            catch (Throwable throwable) {
                this.view.unlockView();
                throw throwable;
            }
            return n;
        }
    }

    public boolean isEmpty(InternalEObject eObject, EStructuralFeature feature) {
        Object object = this.view.getViewMonitor();
        synchronized (object) {
            boolean bl;
            this.view.lockView();
            try {
                InternalCDOObject cdoObject = this.getCDOObject(eObject);
                if (this.TRACER.isEnabled()) {
                    this.TRACER.format("isEmpty({0}, {1})", new Object[]{cdoObject, feature});
                }
                InternalCDORevision revision = CDOStoreImpl.readRevision(cdoObject);
                bl = revision.isEmpty(feature);
                this.view.unlockView();
            }
            catch (Throwable throwable) {
                this.view.unlockView();
                throw throwable;
            }
            return bl;
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean contains(InternalEObject eObject, EStructuralFeature feature, Object value) {
        var4_4 = this.view.getViewMonitor();
        synchronized (var4_4) {
            this.view.lockView();
            try {
                block14: {
                    block13: {
                        cdoObject = this.getCDOObject(eObject);
                        if (this.TRACER.isEnabled()) {
                            this.TRACER.format("contains({0}, {1}, {2})", new Object[]{cdoObject, feature, value});
                        }
                        revision = CDOStoreImpl.readRevision(cdoObject);
                        size = revision.size(feature);
                        if (value != null) break block13;
                        i = 0;
                        if (true) ** GOTO lbl21
                    }
                    i = 0;
                    if (true) ** GOTO lbl27
                    do {
                        if ((emfElement = this.convertToEMF((EObject)eObject, revision, feature, i, element = revision.get(feature, i))) == null) {
                            return true;
                        }
                        ++i;
lbl21:
                        // 2 sources

                    } while (i < size);
                    break block14;
                    do {
                        if (value.equals(emfElement = this.convertToEMF((EObject)eObject, revision, feature, i, element = revision.get(feature, i)))) {
                            return true;
                        }
                        ++i;
lbl27:
                        // 2 sources

                    } while (i < size);
                }
                return false;
            }
            finally {
                this.view.unlockView();
            }
        }
    }

    public int indexOf(InternalEObject eObject, EStructuralFeature feature, Object value) {
        Object object = this.view.getViewMonitor();
        synchronized (object) {
            int n;
            this.view.lockView();
            try {
                InternalCDOObject cdoObject = this.getCDOObject(eObject);
                if (this.TRACER.isEnabled()) {
                    this.TRACER.format("indexOf({0}, {1}, {2})", new Object[]{cdoObject, feature, value});
                }
                value = this.convertToCDO(cdoObject, feature, value);
                InternalCDORevision revision = CDOStoreImpl.readRevision(cdoObject);
                n = revision.indexOf(feature, value);
                this.view.unlockView();
            }
            catch (Throwable throwable) {
                this.view.unlockView();
                throw throwable;
            }
            return n;
        }
    }

    public int lastIndexOf(InternalEObject eObject, EStructuralFeature feature, Object value) {
        Object object = this.view.getViewMonitor();
        synchronized (object) {
            int n;
            this.view.lockView();
            try {
                InternalCDOObject cdoObject = this.getCDOObject(eObject);
                if (this.TRACER.isEnabled()) {
                    this.TRACER.format("lastIndexOf({0}, {1}, {2})", new Object[]{cdoObject, feature, value});
                }
                value = this.convertToCDO(cdoObject, feature, value);
                InternalCDORevision revision = CDOStoreImpl.readRevision(cdoObject);
                n = revision.lastIndexOf(feature, value);
                this.view.unlockView();
            }
            catch (Throwable throwable) {
                this.view.unlockView();
                throw throwable;
            }
            return n;
        }
    }

    public int hashCode(InternalEObject eObject, EStructuralFeature feature) {
        Object object = this.view.getViewMonitor();
        synchronized (object) {
            int n;
            this.view.lockView();
            try {
                InternalCDOObject cdoObject = this.getCDOObject(eObject);
                if (this.TRACER.isEnabled()) {
                    this.TRACER.format("hashCode({0}, {1})", new Object[]{cdoObject, feature});
                }
                InternalCDORevision revision = CDOStoreImpl.readRevision(cdoObject);
                n = revision.hashCode(feature);
                this.view.unlockView();
            }
            catch (Throwable throwable) {
                this.view.unlockView();
                throw throwable;
            }
            return n;
        }
    }

    public Object[] toArray(InternalEObject eObject, EStructuralFeature feature) {
        Object object = this.view.getViewMonitor();
        synchronized (object) {
            Object[] objectArray;
            this.view.lockView();
            try {
                InternalCDOObject cdoObject = this.getCDOObject(eObject);
                if (this.TRACER.isEnabled()) {
                    this.TRACER.format("toArray({0}, {1})", new Object[]{cdoObject, feature});
                }
                InternalCDORevision revision = CDOStoreImpl.readRevision(cdoObject);
                Object[] result = revision.toArray(feature);
                int i = 0;
                while (i < result.length) {
                    result[i] = this.convertToEMF((EObject)eObject, revision, feature, i, result[i]);
                    ++i;
                }
                objectArray = result;
                this.view.unlockView();
            }
            catch (Throwable throwable) {
                this.view.unlockView();
                throw throwable;
            }
            return objectArray;
        }
    }

    public <T> T[] toArray(InternalEObject eObject, EStructuralFeature feature, T[] a) {
        Object object = this.view.getViewMonitor();
        synchronized (object) {
            Object[] objectArray;
            this.view.lockView();
            try {
                Object[] array = this.toArray(eObject, feature);
                int size = array.length;
                if (a.length < size) {
                    a = (Object[])Array.newInstance(a.getClass().getComponentType(), size);
                }
                System.arraycopy(array, 0, a, 0, size);
                if (a.length > size) {
                    a[size] = null;
                }
                objectArray = a;
                this.view.unlockView();
            }
            catch (Throwable throwable) {
                this.view.unlockView();
                throw throwable;
            }
            return objectArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setContainer(InternalEObject eObject, CDOResource newResource, InternalEObject newEContainer, int newContainerFeatureID) {
        Object object = this.view.getViewMonitor();
        synchronized (object) {
            this.view.lockView();
            try {
                InternalCDOObject cdoObject = this.getCDOObject(eObject);
                if (this.TRACER.isEnabled()) {
                    this.TRACER.format("setContainer({0}, {1}, {2}, {3})", new Object[]{cdoObject, newResource, newEContainer, newContainerFeatureID});
                }
                CDOID newContainerID = newEContainer == null ? CDOID.NULL : this.view.convertObjectToID(newEContainer, true);
                CDOID newResourceID = newResource == null ? CDOID.NULL : newResource.cdoID();
                CDOContainerFeatureDeltaImpl delta = new CDOContainerFeatureDeltaImpl(newResourceID, (Object)newContainerID, newContainerFeatureID);
                CDOStoreImpl.writeRevision(cdoObject, (CDOFeatureDelta)delta);
            }
            finally {
                this.view.unlockView();
            }
        }
    }

    public Object set(InternalEObject eObject, EStructuralFeature feature, int index, Object value) {
        Object object = this.view.getViewMonitor();
        synchronized (object) {
            Object object2;
            this.view.lockView();
            try {
                InternalCDOObject cdoObject = this.getCDOObject(eObject);
                if (this.TRACER.isEnabled()) {
                    this.TRACER.format("set({0}, {1}, {2}, {3})", new Object[]{cdoObject, feature, index, value});
                }
                value = this.convertToCDO(cdoObject, feature, value);
                InternalCDORevision oldRevision = CDOStoreImpl.readRevision(cdoObject);
                Object oldValue = oldRevision.get(feature, index);
                Object resultValue = this.convertToEMF((EObject)eObject, oldRevision, feature, index, oldValue);
                CDOSetFeatureDeltaImpl delta = new CDOSetFeatureDeltaImpl(feature, index, value, oldValue);
                CDOStoreImpl.writeRevision(cdoObject, (CDOFeatureDelta)delta);
                object2 = resultValue;
                this.view.unlockView();
            }
            catch (Throwable throwable) {
                this.view.unlockView();
                throw throwable;
            }
            return object2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unset(InternalEObject eObject, EStructuralFeature feature) {
        Object object = this.view.getViewMonitor();
        synchronized (object) {
            this.view.lockView();
            try {
                InternalCDOObject cdoObject = this.getCDOObject(eObject);
                if (this.TRACER.isEnabled()) {
                    this.TRACER.format("unset({0}, {1})", new Object[]{cdoObject, feature});
                }
                if (feature.isMany()) {
                    Object object2 = cdoObject.eGet(feature);
                    if (object2 instanceof List && !CDOUtil.isLegacyObject(cdoObject)) {
                        List list = (List)object2;
                        list.clear();
                    }
                    if (!feature.isUnsettable()) {
                        return;
                    }
                }
                CDOUnsetFeatureDeltaImpl delta = new CDOUnsetFeatureDeltaImpl(feature);
                CDOStoreImpl.writeRevision(cdoObject, (CDOFeatureDelta)delta);
            }
            finally {
                this.view.unlockView();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(InternalEObject eObject, EStructuralFeature feature, int index, Object value) {
        Object object = this.view.getViewMonitor();
        synchronized (object) {
            this.view.lockView();
            try {
                InternalCDOObject cdoObject = this.getCDOObject(eObject);
                if (this.TRACER.isEnabled()) {
                    this.TRACER.format("add({0}, {1}, {2}, {3})", new Object[]{cdoObject, feature, index, value});
                }
                value = this.convertToCDO(cdoObject, feature, value);
                CDOAddFeatureDeltaImpl delta = new CDOAddFeatureDeltaImpl(feature, index, value);
                CDOStoreImpl.writeRevision(cdoObject, (CDOFeatureDelta)delta);
            }
            finally {
                this.view.unlockView();
            }
        }
    }

    public Object remove(InternalEObject eObject, EStructuralFeature feature, int index) {
        Object object = this.view.getViewMonitor();
        synchronized (object) {
            Object object2;
            this.view.lockView();
            try {
                InternalCDOObject cdoObject = this.getCDOObject(eObject);
                if (this.TRACER.isEnabled()) {
                    this.TRACER.format("remove({0}, {1}, {2})", new Object[]{cdoObject, feature, index});
                }
                Object oldValue = this.getOldListValue(eObject, cdoObject, feature, index);
                CDOStoreImpl.removeElement(cdoObject, feature, index);
                object2 = oldValue;
                this.view.unlockView();
            }
            catch (Throwable throwable) {
                this.view.unlockView();
                throw throwable;
            }
            return object2;
        }
    }

    public Object move(InternalEObject eObject, EStructuralFeature feature, int target, int source) {
        Object object = this.view.getViewMonitor();
        synchronized (object) {
            Object object2;
            this.view.lockView();
            try {
                InternalCDOObject cdoObject = this.getCDOObject(eObject);
                if (this.TRACER.isEnabled()) {
                    this.TRACER.format("move({0}, {1}, {2}, {3})", new Object[]{cdoObject, feature, target, source});
                }
                Object oldValue = this.getOldListValue(eObject, cdoObject, feature, source);
                CDOMoveFeatureDeltaImpl delta = new CDOMoveFeatureDeltaImpl(feature, target, source);
                CDOStoreImpl.writeRevision(cdoObject, (CDOFeatureDelta)delta);
                object2 = oldValue;
                this.view.unlockView();
            }
            catch (Throwable throwable) {
                this.view.unlockView();
                throw throwable;
            }
            return object2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear(InternalEObject eObject, EStructuralFeature feature) {
        Object object = this.view.getViewMonitor();
        synchronized (object) {
            this.view.lockView();
            try {
                InternalCDOObject cdoObject = this.getCDOObject(eObject);
                if (this.TRACER.isEnabled()) {
                    this.TRACER.format("clear({0}, {1})", new Object[]{cdoObject, feature});
                }
                CDOClearFeatureDeltaImpl delta = new CDOClearFeatureDeltaImpl(feature);
                CDOStoreImpl.writeRevision(cdoObject, (CDOFeatureDelta)delta);
            }
            finally {
                this.view.unlockView();
            }
        }
    }

    public EObject create(EClass eClass) {
        throw new UnsupportedOperationException("Use the generated factory to create objects");
    }

    public String toString() {
        return MessageFormat.format("CDOStore[{0}]", this.view);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object resolveProxy(InternalCDORevision revision, EStructuralFeature feature, int index, Object value) {
        if (value instanceof CDOElementProxy) {
            Object object = this.view.getViewMonitor();
            synchronized (object) {
                this.view.lockView();
                try {
                    CDOElementProxy proxy = (CDOElementProxy)value;
                    value = this.view.getSession().resolveElementProxy((CDORevision)revision, feature, index, proxy.getIndex());
                }
                finally {
                    this.view.unlockView();
                }
            }
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object convertToCDO(InternalCDOObject object, EStructuralFeature feature, Object value) {
        if (value != null) {
            Object object2 = this.view.getViewMonitor();
            synchronized (object2) {
                this.view.lockView();
                try {
                    if (feature instanceof EReference) {
                        value = this.view.convertObjectToID(value, true);
                    } else {
                        CDOType type = CDOModelUtil.getType((EClassifier)feature.getEType());
                        if (type != null) {
                            value = type.convertToCDO(feature.getEType(), value);
                        }
                    }
                }
                finally {
                    this.view.unlockView();
                }
            }
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Object convertToEMF(EObject eObject, InternalCDORevision revision, EStructuralFeature feature, int index, Object value) {
        if (value == null) return value;
        Object object = this.view.getViewMonitor();
        synchronized (object) {
            this.view.lockView();
            try {
                if (feature.isMany()) {
                    if (index == -1) {
                        Object object2 = value;
                        return object2;
                    }
                    if ((value = this.resolveProxy(revision, feature, index, value)) instanceof CDOID) {
                        InternalCDORevisionManager revisionManager;
                        CDOID id = (CDOID)value;
                        CDOList list = revision.getOrCreateList(feature);
                        CDORevisionPrefetchingPolicy policy = this.view.options().getRevisionPrefetchingPolicy();
                        List<CDOID> listOfIDs = policy.loadAhead((CDORevisionManager)(revisionManager = this.view.getSession().getRevisionManager()), (CDOBranchPoint)this.view, eObject, feature, list, index, id);
                        if (!listOfIDs.isEmpty()) {
                            int initialChunkSize = this.view.getSession().options().getCollectionLoadingPolicy().getInitialChunkSize();
                            revisionManager.getRevisions(listOfIDs, (CDOBranchPoint)this.view, initialChunkSize, 0, true);
                        }
                    }
                }
                if (feature instanceof EReference) {
                    value = this.convertIDToObject(this.view, eObject, feature, index, value);
                } else {
                    CDOType type = CDOModelUtil.getType((EClassifier)feature.getEType());
                    if (type == null) return value;
                    value = type.convertToEMF(feature.getEType(), value);
                }
            }
            finally {
                this.view.unlockView();
            }
            return value;
        }
    }

    private Object convertIDToObject(InternalCDOView view, EObject eObject, EStructuralFeature feature, int index, Object value) {
        block3: {
            try {
                value = view.convertIDToObject(value);
            }
            catch (ObjectNotFoundException ex) {
                if (!(value instanceof CDOID)) break block3;
                if (feature != null) {
                    CDOStaleReferencePolicy staleReferencePolicy = view.options().getStaleReferencePolicy();
                    value = staleReferencePolicy.processStaleReference(eObject, feature, index, ex.getID());
                }
                value = null;
            }
        }
        return this.getInternalInstance(value);
    }

    private InternalCDOObject getCDOObject(Object object) {
        return FSMUtil.adapt(object, this.view);
    }

    private Object getInternalInstance(Object object) {
        if (object instanceof InternalCDOObject) {
            return ((InternalCDOObject)object).cdoInternalInstance();
        }
        return object;
    }

    private Object getOldListValue(InternalEObject eObject, InternalCDOObject cdoObject, EStructuralFeature feature, int index) {
        int size;
        if (!feature.isMany()) {
            throw new UnsupportedOperationException("Not supported for single-valued features");
        }
        InternalCDORevision revision = CDOStoreImpl.readRevision(cdoObject);
        CDOList list = revision.getListOrNull(feature);
        int n = size = list == null ? 0 : list.size();
        if (index < 0 || size <= index) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + size);
        }
        Object oldValue = revision.get(feature, index);
        return this.convertToEMF((EObject)eObject, revision, feature, index, oldValue);
    }

    private static InternalCDORevision readRevision(InternalCDOObject cdoObject) {
        InternalCDORevision revision = CDOStateMachine.INSTANCE.read(cdoObject);
        if (revision == null) {
            throw new IllegalStateException("revision == null");
        }
        return revision;
    }

    private static Object writeRevision(InternalCDOObject cdoObject, CDOFeatureDelta delta) {
        return CDOStateMachine.INSTANCE.write(cdoObject, delta);
    }

    public static void removeElement(InternalCDOObject cdoObject, EStructuralFeature feature, int index) {
        CDORemoveFeatureDeltaImpl delta = new CDORemoveFeatureDeltaImpl(feature, index);
        CDOStoreImpl.writeRevision(cdoObject, (CDOFeatureDelta)delta);
    }
}

