/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.common.editpolicies;

import org.eclipse.core.databinding.observable.ChangeEvent;
import org.eclipse.core.databinding.observable.IChangeListener;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.editpolicies.GraphicalEditPolicy;
import org.eclipse.gmf.runtime.notation.BooleanValueStyle;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.infra.gmfdiag.common.databinding.custom.CustomBooleanStyleObservableValue;

public class NameDisplayEditPolicy
extends GraphicalEditPolicy
implements IChangeListener {
    public static final String DISPLAY_NAME = "displayName";
    public static final String NAME_DISPLAY_EDITPOLICY = "NAME_DISPLAY_EDITPOLICY";
    protected IObservableValue styleObservable;

    public void activate() {
        View view = (View)this.getHost().getModel();
        if (view == null) {
            return;
        }
        this.styleObservable = new CustomBooleanStyleObservableValue(view, EMFHelper.resolveEditingDomain((EObject)view), DISPLAY_NAME);
        this.styleObservable.addChangeListener((IChangeListener)this);
    }

    protected BooleanValueStyle getMaintainSymbolRatioStyle(View currentView) {
        return (BooleanValueStyle)currentView.getNamedStyle(NotationPackage.eINSTANCE.getBooleanValueStyle(), DISPLAY_NAME);
    }

    public void deactivate() {
        if (this.styleObservable != null) {
            this.styleObservable.removeChangeListener((IChangeListener)this);
            this.styleObservable.dispose();
            this.styleObservable = null;
        }
    }

    public void handleChange(ChangeEvent event) {
        this.getHost().refresh();
    }
}

