/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.timing.custom.parts;

import org.eclipse.draw2d.ConnectionAnchorBase;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.papyrus.uml.diagram.timing.custom.utils.MessageUtils;

public class FloatingMessageAnchor
extends ConnectionAnchorBase {
    private final ConnectionEditPart connectionEditPart;
    private final Point defaultOffset;

    public FloatingMessageAnchor(ConnectionEditPart connEditPart, Point defaultOffset) {
        this.connectionEditPart = connEditPart;
        this.defaultOffset = defaultOffset;
    }

    public Point getReferencePoint() {
        return new Point(0, 0);
    }

    public IFigure getOwner() {
        return null;
    }

    public Point getLocation(Point reference) {
        Point point = MessageUtils.getMessageConnectorLocation(this.connectionEditPart);
        if (point != null) {
            return new Point(reference.x + point.x, reference.y + point.y);
        }
        return new Point(reference.x + this.defaultOffset.x, reference.y + this.defaultOffset.y);
    }
}

